/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.jboss.pool.PoolEvent;
import org.jboss.pool.PoolEventListener;
import org.jboss.pool.PooledObject;
import org.jboss.pool.cache.LeastRecentlyUsedCache;
import org.jboss.pool.cache.ObjectCache;
import org.jboss.pool.jdbc.ConnectionWrapper;
import org.jboss.pool.jdbc.PreparedStatementFactory;
import org.jboss.pool.jdbc.PreparedStatementInPool;
import org.jboss.pool.jdbc.StatementInPool;

public class ConnectionInPool
implements PooledObject,
ConnectionWrapper {
    private static final String CLOSED = "Connection has been closed!";
    public static final int PS_CACHE_UNLIMITED = 0;
    public static final int PS_CACHE_DISABLED = -1;
    public static final HashMap psCaches = new HashMap();
    private Connection con;
    private HashSet statements;
    private Vector listeners;
    private int preparedStatementCacheSize = 0;
    private ObjectCache preparedStatementCache;

    public ConnectionInPool(Connection con) {
        this.con = con;
        this.preparedStatementCache = (ObjectCache)psCaches.get(con);
        if (this.preparedStatementCache == null) {
            PreparedStatementFactory factory = new PreparedStatementFactory(con);
            this.preparedStatementCache = new LeastRecentlyUsedCache(factory, this.preparedStatementCacheSize);
            psCaches.put(con, this.preparedStatementCache);
        }
        this.statements = new HashSet();
        this.listeners = new Vector();
    }

    public ConnectionInPool(Connection con, int psCacheSize) {
        this.con = con;
        if (psCacheSize >= 0) {
            this.preparedStatementCache = (ObjectCache)psCaches.get(con);
            if (this.preparedStatementCache == null) {
                PreparedStatementFactory factory = new PreparedStatementFactory(con);
                this.preparedStatementCache = new LeastRecentlyUsedCache(factory, this.preparedStatementCacheSize);
                psCaches.put(con, this.preparedStatementCache);
            }
        }
        this.setPSCacheSize(psCacheSize);
        this.statements = new HashSet();
        this.listeners = new Vector();
    }

    public void addPoolEventListener(PoolEventListener listener) {
        this.listeners.addElement(listener);
    }

    public void clearWarnings() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.con.clearWarnings();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void close() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        this.firePoolEvent(new PoolEvent(this, -8986432));
        this.shutdown();
    }

    public void commit() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.con.commit();
        }
        catch (SQLException e) {
            this.setCatastrophicError(e);
            throw e;
        }
    }

    public Statement createStatement() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            StatementInPool st = new StatementInPool(this.con.createStatement(), this);
            this.statements.add(st);
            return st;
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            StatementInPool st = new StatementInPool(this.con.createStatement(resultSetType, resultSetConcurrency), this);
            this.statements.add(st);
            return st;
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    protected void firePoolEvent(PoolEvent evt) {
        Vector local = (Vector)this.listeners.clone();
        int i = local.size() - 1;
        while (i >= 0) {
            if (evt.getType() == -8986432) {
                ((PoolEventListener)local.elementAt(i)).objectClosed(evt);
            } else if (evt.getType() == -8986433) {
                ((PoolEventListener)local.elementAt(i)).objectError(evt);
            } else {
                ((PoolEventListener)local.elementAt(i)).objectUsed(evt);
            }
            --i;
        }
    }

    public boolean getAutoCommit() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.getAutoCommit();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public String getCatalog() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.getCatalog();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.getMetaData();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public int getPSCacheSize() {
        return this.preparedStatementCacheSize;
    }

    public int getTransactionIsolation() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.getTransactionIsolation();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public Map getTypeMap() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.getTypeMap();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public Connection getUnderlyingConnection() {
        return this.con;
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.getWarnings();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public boolean isClosed() throws SQLException {
        if (this.con == null) {
            return true;
        }
        try {
            return this.con.isClosed();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public boolean isReadOnly() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.isReadOnly();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public String nativeSQL(String sql) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.nativeSQL(sql);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.prepareCall(sql);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.con.prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            PreparedStatementInPool wrapper = null;
            if (this.preparedStatementCacheSize >= 0) {
                PreparedStatement ps = (PreparedStatement)this.preparedStatementCache.useObject(sql);
                if (ps == null) {
                    throw new SQLException("Unable to create PreparedStatement!");
                }
                wrapper = new PreparedStatementInPool(ps, this, sql);
            } else {
                wrapper = new PreparedStatementInPool(this.con.prepareStatement(sql, resultSetType, resultSetConcurrency), this, sql);
            }
            this.statements.add(wrapper);
            return wrapper;
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void removePoolEventListener(PoolEventListener listener) {
        this.listeners.remove(listener);
    }

    public void reset() throws SQLException {
        Collection copy = (Collection)this.statements.clone();
        Iterator it = copy.iterator();
        while (it.hasNext()) {
            try {
                ((Statement)it.next()).close();
            }
            catch (SQLException sQLException) {}
        }
        if (!this.con.getAutoCommit()) {
            this.con.rollback();
        }
        this.con = null;
    }

    public void rollback() throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.con.rollback();
        }
        catch (SQLException e) {
            this.setCatastrophicError(e);
            throw e;
        }
    }

    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.con.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setCatalog(String catalog) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.con.setCatalog(catalog);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setCatastrophicError(SQLException e) {
        PoolEvent pe = new PoolEvent(this, -8986433);
        pe.setCatastrophic();
        this.firePoolEvent(pe);
    }

    public void setError(SQLException e) {
        this.firePoolEvent(new PoolEvent(this, -8986433));
    }

    public void setLastUsed() {
        this.firePoolEvent(new PoolEvent(this, -8986434));
    }

    public void setPSCacheSize(int maxSize) {
        this.preparedStatementCacheSize = maxSize;
        if (maxSize >= 0 && this.preparedStatementCache != null) {
            this.preparedStatementCache.setSize(maxSize);
        }
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.con.setReadOnly(readOnly);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setTransactionIsolation(int level) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.con.setTransactionIsolation(level);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setTypeMap(Map map) throws SQLException {
        if (this.con == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.con.setTypeMap(map);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void shutdown() {
        this.con = null;
        this.statements = null;
        this.listeners = null;
    }

    public void statementClosed(Statement st) {
        block4: {
            this.statements.remove(st);
            if (this.con == null || !(st instanceof PreparedStatementInPool)) break block4;
            PreparedStatementInPool ps = (PreparedStatementInPool)st;
            PreparedStatement ups = ps.getUnderlyingPreparedStatement();
            if (this.preparedStatementCacheSize >= 0) {
                this.preparedStatementCache.returnObject(ps.getSql(), ups);
            } else {
                try {
                    ups.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

