/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.jboss.logging.Logger;
import org.jboss.pool.ObjectPool;
import org.jboss.pool.PoolObjectFactory;
import org.jboss.pool.cache.ObjectCache;
import org.jboss.pool.jdbc.ConnectionInPool;

public class JDBCConnectionFactory
extends PoolObjectFactory {
    private String url;
    private Properties props;
    private String userName;
    private String password;
    private int psCacheSize = 10;
    private ObjectPool pool;
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$pool$jdbc$JDBCConnectionFactory != null ? class$org$jboss$pool$jdbc$JDBCConnectionFactory : (class$org$jboss$pool$jdbc$JDBCConnectionFactory = JDBCConnectionFactory.class$("org.jboss.pool.jdbc.JDBCConnectionFactory"))));
    static /* synthetic */ Class class$org$jboss$pool$jdbc$JDBCConnectionFactory;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Object createObject(Object parameters) throws Exception {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Opening new connection");
        }
        try {
            if (this.userName != null && this.userName.length() > 0) {
                return DriverManager.getConnection(this.url, this.userName, this.password);
            }
            if (this.props != null) {
                return DriverManager.getConnection(this.url, this.props);
            }
            return DriverManager.getConnection(this.url);
        }
        catch (SQLException e) {
            log.error((Object)"SQL Error", (Throwable)e);
            throw e;
        }
    }

    public void deleteObject(Object pooledObject) {
        Connection con = (Connection)pooledObject;
        try {
            con.rollback();
        }
        catch (SQLException sQLException) {}
        ObjectCache cache = (ObjectCache)ConnectionInPool.psCaches.remove(con);
        if (cache != null) {
            cache.close();
        }
        try {
            con.close();
        }
        catch (SQLException sQLException) {}
    }

    public Properties getConnectProperties() {
        return this.props;
    }

    public String getConnectURL() {
        return this.url;
    }

    public int getPSCacheSize() {
        return this.psCacheSize;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUser() {
        return this.userName;
    }

    public void poolClosing(ObjectPool pool) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Stopping");
        }
        super.poolClosing(pool);
        this.pool = null;
    }

    public void poolStarted(ObjectPool pool) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Starting");
        }
        super.poolStarted(pool);
        if (this.url == null) {
            log.error((Object)"Must specify JDBC connection URL");
            throw new IllegalStateException("Must specify JDBC connection URL to " + this.getClass().getName());
        }
        this.pool = pool;
    }

    public Object prepareObject(Object pooledObject) {
        Connection con = (Connection)pooledObject;
        ConnectionInPool wrapper = new ConnectionInPool(con);
        wrapper.setPSCacheSize(this.psCacheSize);
        return wrapper;
    }

    public Object returnObject(Object clientObject) {
        ConnectionInPool wrapper = (ConnectionInPool)clientObject;
        Connection con = wrapper.getUnderlyingConnection();
        try {
            wrapper.reset();
        }
        catch (SQLException sQLException) {
            this.pool.markObjectAsInvalid(clientObject);
        }
        return con;
    }

    public void setConnectProperties(Properties props) {
        this.props = props;
    }

    public void setConnectURL(String url) {
        this.url = url;
    }

    public void setPSCacheSize(int size) {
        this.psCacheSize = size;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setUser(String userName) {
        this.userName = userName;
    }

    public Object translateObject(Object clientObject) {
        return ((ConnectionInPool)clientObject).getUnderlyingConnection();
    }
}

