/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import org.jboss.pool.jdbc.JDBCPoolDataSource;

public class PoolDriver
implements Driver {
    private static final String URL_START = "jdbc:minerva:";
    private static final PoolDriver instance = new PoolDriver();

    static {
        try {
            DriverManager.registerDriver(PoolDriver.instance());
        }
        catch (SQLException e) {
            System.out.println("Unable to register Minerva DB pool driver!");
            e.printStackTrace();
        }
    }

    private PoolDriver() {
    }

    public boolean acceptsURL(String url) throws SQLException {
        return url.startsWith(URL_START);
    }

    public Connection connect(String url, Properties props) throws SQLException {
        if (url.startsWith(URL_START)) {
            return this.getJDBCConnection(url.substring(URL_START.length()));
        }
        return null;
    }

    private Connection getJDBCConnection(String name) {
        Connection con = null;
        try {
            JDBCPoolDataSource source = JDBCPoolDataSource.getDataSource(name);
            if (source != null) {
                con = source.getConnection();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return con;
    }

    public int getMajorVersion() {
        return 2;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    public static PoolDriver instance() {
        return instance;
    }

    public boolean jdbcCompliant() {
        return false;
    }
}

