/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import org.jboss.pool.jdbc.ConnectionWrapper;
import org.jboss.pool.jdbc.ResultSetInPool;

public class StatementInPool
implements Statement {
    private static final String CLOSED = "Statement has been closed!";
    private Statement impl;
    private ConnectionWrapper con;

    public StatementInPool(Statement source, ConnectionWrapper owner) {
        if (source == null || owner == null) {
            throw new NullPointerException();
        }
        this.impl = source;
        this.con = owner;
    }

    public void addBatch(String arg0) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.addBatch(arg0);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void cancel() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.cancel();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void clearBatch() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.clearBatch();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    protected void clearFields() {
        this.con = null;
        this.impl = null;
    }

    public void clearWarnings() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.clearWarnings();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void close() throws SQLException {
        if (this.impl != null) {
            this.impl.close();
            this.con.statementClosed(this);
        }
        this.clearFields();
    }

    public boolean execute(String arg0) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.setLastUsed();
            return this.impl.execute(arg0);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public int[] executeBatch() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.setLastUsed();
            return this.impl.executeBatch();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public ResultSet executeQuery(String arg0) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.setLastUsed();
            return new ResultSetInPool(this.impl.executeQuery(arg0), this);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public int executeUpdate(String arg0) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.setLastUsed();
            return this.impl.executeUpdate(arg0);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public Connection getConnection() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        return this.con;
    }

    public int getFetchDirection() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.impl.getFetchDirection();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public int getFetchSize() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.impl.getFetchSize();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public int getMaxFieldSize() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.impl.getMaxFieldSize();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public int getMaxRows() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.impl.getMaxRows();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public boolean getMoreResults() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.impl.getMoreResults();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public int getQueryTimeout() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.impl.getQueryTimeout();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public ResultSet getResultSet() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            ResultSet rs = this.impl.getResultSet();
            return rs == null ? null : new ResultSetInPool(rs, this);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.impl.getResultSetConcurrency();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public int getResultSetType() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.impl.getResultSetType();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public Statement getUnderlyingStatement() {
        return this.impl;
    }

    public int getUpdateCount() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.impl.getUpdateCount();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            return this.impl.getWarnings();
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setCursorName(String arg0) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setCursorName(arg0);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setError(SQLException e) {
        if (this.con != null) {
            this.con.setError(e);
        }
    }

    public void setEscapeProcessing(boolean arg0) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setEscapeProcessing(arg0);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setFetchDirection(int arg0) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setFetchDirection(arg0);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setFetchSize(int arg0) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setFetchSize(arg0);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setLastUsed() {
        if (this.con != null) {
            this.con.setLastUsed();
        }
    }

    public void setMaxFieldSize(int arg0) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setMaxFieldSize(arg0);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setMaxRows(int arg0) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setMaxRows(arg0);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }

    public void setQueryTimeout(int arg0) throws SQLException {
        if (this.impl == null) {
            throw new SQLException(CLOSED);
        }
        try {
            this.impl.setQueryTimeout(arg0);
        }
        catch (SQLException e) {
            this.setError(e);
            throw e;
        }
    }
}

