/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.jdbc.xa.wrapper;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.jboss.logging.Logger;
import org.jboss.logging.log4j.CategoryWriter;
import org.jboss.pool.jdbc.xa.wrapper.XAConnectionImpl;
import org.jboss.pool.jdbc.xa.wrapper.XAResourceImpl;

public class XADataSourceImpl
implements XADataSource {
    private String url;
    private String user;
    private String password;
    private Properties properties;
    private int loginTimeout;
    private PrintWriter logWriter;
    private boolean saveStackTrace;
    private static Logger log = Logger.getLogger((Class)(class$org$jboss$pool$jdbc$xa$wrapper$XADataSourceImpl != null ? class$org$jboss$pool$jdbc$xa$wrapper$XADataSourceImpl : (class$org$jboss$pool$jdbc$xa$wrapper$XADataSourceImpl = XADataSourceImpl.class$("org.jboss.pool.jdbc.xa.wrapper.XADataSourceImpl"))));
    static /* synthetic */ Class class$org$jboss$pool$jdbc$xa$wrapper$XADataSourceImpl;

    public XADataSourceImpl() {
    }

    public XADataSourceImpl(String url, Properties properties) {
        this.url = url;
        this.properties = properties;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.logWriter;
    }

    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    public String getPassword() {
        return this.password;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean getSaveStackTrace() {
        return this.saveStackTrace;
    }

    public String getURL() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public XAConnection getXAConnection() throws SQLException {
        Connection con = this.user != null && this.user.length() > 0 ? DriverManager.getConnection(this.url, this.user, this.password) : (this.properties != null ? DriverManager.getConnection(this.url, this.properties) : DriverManager.getConnection(this.url));
        try {
            con.setAutoCommit(false);
        }
        catch (SQLException sQLException) {
            log.warn((Object)("Unable to disable auto-commit on " + con.getClass().getName()));
        }
        XAResourceImpl res = new XAResourceImpl(con);
        XAConnectionImpl xacon = new XAConnectionImpl(con, res, this.saveStackTrace);
        res.setXAConnection(xacon);
        if (log.isTraceEnabled()) {
            log.trace((Object)("created new Connection(" + con.getClass().getName() + ") with XAResource " + res.getClass().getName() + " and XAConnection " + xacon.getClass().getName() + "."));
        }
        return xacon;
    }

    public XAConnection getXAConnection(String user, String password) throws SQLException {
        Connection con;
        block3: {
            con = DriverManager.getConnection(this.url, user, password);
            try {
                con.setAutoCommit(false);
            }
            catch (SQLException sQLException) {
                if (this.logWriter == null) break block3;
                this.logWriter.println("XADataSource unable to disable auto-commit on " + con.getClass().getName());
            }
        }
        XAResourceImpl res = new XAResourceImpl(con);
        XAConnectionImpl xacon = new XAConnectionImpl(con, res, this.saveStackTrace);
        res.setXAConnection(xacon);
        xacon.setUser(user);
        xacon.setPassword(password);
        if (log.isTraceEnabled()) {
            log.trace((Object)(" created new Connection (" + con.getClass().getName() + ") with XAResource " + res.getClass().getName() + " and XAConnection with userid and password " + xacon.getClass().getName()));
        }
        return xacon;
    }

    public void setLogWriter(PrintWriter writer) throws SQLException {
        if (writer == null) {
            this.logWriter = null;
        } else if (this.logWriter == null) {
            this.logWriter = new CategoryWriter(log.getCategory());
        }
    }

    public void setLoginTimeout(int timeout) throws SQLException {
        this.loginTimeout = timeout;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setSaveStackTrace(boolean save) {
        this.saveStackTrace = save;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }
}

