/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pool.jdbc.xa.wrapper;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.jboss.pool.jdbc.xa.wrapper.XAConnectionImpl;

public class XAResourceImpl
implements XAResource {
    private Connection con;
    private XAConnectionImpl xaCon;
    private Xid current;
    private boolean active = false;
    private int timeout_ignored = 0;

    public XAResourceImpl(Connection con) {
        this.con = con;
    }

    public void close() {
        this.con = null;
        this.current = null;
        this.xaCon = null;
    }

    public void commit(Xid id, boolean twoPhase) throws XAException {
        if (this.active && !twoPhase) {
            System.err.println("WARNING: Connection not closed before transaction commit.\nConnection will not participate in any future transactions.\nAre you sure you want to be doing this?");
        }
        if (this.current == null || !id.equals(this.current)) {
            this.throwXAException(-4);
        }
        try {
            if (this.con.getAutoCommit()) {
                this.throwXAException(7);
            }
        }
        catch (SQLException sQLException) {}
        try {
            this.con.commit();
        }
        catch (SQLException sQLException) {
            try {
                this.con.rollback();
                if (!twoPhase) {
                    this.throwXAException(100);
                }
            }
            catch (SQLException sQLException2) {}
            if (twoPhase) {
                this.throwXAException(6);
            }
            this.throwXAException(104);
        }
        this.current = null;
        if (this.active) {
            this.active = false;
        } else {
            this.xaCon.transactionFinished();
        }
    }

    public void end(Xid id, int flags) throws XAException {
        if (!this.active) {
            this.throwXAException(-6);
        }
        if (this.current == null || !id.equals(this.current)) {
            this.throwXAException(-4);
        }
        this.active = false;
    }

    public void forget(Xid id) throws XAException {
        if (this.current == null || !id.equals(this.current)) {
            this.throwXAException(-4);
        }
        this.current = null;
        this.xaCon.transactionFailed();
        if (this.active) {
            System.err.println("WARNING: Connection not closed before transaction forget.\nConnection will not participate in any future transactions.\nAre you sure you want to be doing this?");
        }
    }

    public int getTransactionTimeout() throws XAException {
        return this.timeout_ignored;
    }

    public XAConnectionImpl getXAConnection() {
        return this.xaCon;
    }

    public boolean isSameRM(XAResource res) throws XAException {
        return res == this;
    }

    public boolean isTransaction() {
        return this.current != null;
    }

    public int prepare(Xid id) throws XAException {
        if (this.active) {
            System.err.println("WARNING: Connection not closed before transaction commit.\nConnection will not participate in any future transactions.\nAre you sure you want to be doing this?");
        }
        if (this.current == null || !id.equals(this.current)) {
            this.throwXAException(-4);
        }
        try {
            if (this.con.getAutoCommit()) {
                this.throwXAException(7);
            }
        }
        catch (SQLException sQLException) {}
        return 0;
    }

    public Xid[] recover(int flag) throws XAException {
        if (this.current == null) {
            return new Xid[0];
        }
        return new Xid[]{this.current};
    }

    public void rollback(Xid id) throws XAException {
        if (this.active) {
            System.err.println("WARNING: Connection not closed before transaction rollback.\nConnection will not participate in any future transactions.\nAre you sure you want to be doing this?");
        }
        if (this.current == null || !id.equals(this.current)) {
            this.throwXAException(-4);
        }
        try {
            if (this.con.getAutoCommit()) {
                this.throwXAException(7);
            }
        }
        catch (SQLException sQLException) {}
        try {
            this.con.rollback();
        }
        catch (SQLException e) {
            this.throwXAException("Rollback failed: " + e.getMessage());
        }
        this.current = null;
        if (this.active) {
            this.active = false;
        } else {
            this.xaCon.transactionFinished();
        }
    }

    public boolean setTransactionTimeout(int timeout) throws XAException {
        this.timeout_ignored = timeout;
        return true;
    }

    void setXAConnection(XAConnectionImpl xaCon) {
        if (this.xaCon != null) {
            throw new IllegalStateException();
        }
        this.xaCon = xaCon;
    }

    public void start(Xid id, int flags) throws XAException {
        if (this.active) {
            if (this.current != null && id.equals(this.current)) {
                this.throwXAException(-8);
            } else {
                this.throwXAException(-6);
            }
        }
        if (this.current != null && !id.equals(this.current)) {
            this.throwXAException(-4);
        }
        if (this.con == null) {
            this.throwXAException(104);
        }
        this.current = id;
        this.active = true;
    }

    protected void throwXAException(int code) throws XAException {
        this.xaCon.setConnectionError(new SQLException("XAException occured with code: " + code));
        throw new XAException(code);
    }

    protected void throwXAException(String msg) throws XAException {
        this.xaCon.setConnectionError(new SQLException("XAException occured: " + msg));
        throw new XAException(msg);
    }
}

