/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.deployment;

import java.io.IOException;
import java.net.URL;

/** The interface describing a J2EE module  installer. This is used by the
 InstallerFactory class to install a J2EE module from a URL.

 @author Scott.Stark@jboss.org
 @version: $Revision: 1.8.2.5 $
*/
public interface Installer
{
   // Constants -----------------------------------------------------

   /** The J2EE module deployment descriptors handled by the Installer.
    The order is the order of the XXX_MODULE constants defined in the
    Deployment class.
    */
   public static final String[] files = {
      "META-INF/ejb-jar.xml", // Deployment.EJB_MODULE
      "WEB-INF/web.xml", // Deployment.WAR_MODULE
      "META-INF/application.xml" // Deployment.EAR_MODULE
   };

   public Deployment execute(InstallerFactory factory, URL src)
      throws J2eeDeploymentException, IOException;
}

