/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.ejb;

/**
 *	Interface for bean instance Pools.
 *      
 *	@see <related>
 *	@author Rickard berg (rickard.oberg@telkel.com)
 *	@version $Revision: 1.3.6.4 $
 *
 * <p><b>Revisions:</b>
 * <p><b>20011208 Vincent Harcq:</b>
 * <ul>
 * <li> Added a Pool Feeder (Thread that pre-create bean instances to avoid
 *      setContext overhead.
 * </ul>
 */
public interface InstancePool
   extends ContainerPlugin
{
   // Constants -----------------------------------------------------
    
   // Attributes ----------------------------------------------------
    
   // Static --------------------------------------------------------
   
   // Constructors --------------------------------------------------
   
   // Public --------------------------------------------------------

   /**
    *  Add an instance in the Pool.
    *  Is used by the TimedInstancePoolFeeder thread to create instances ready for use by
    *  the interceptor.
    *
    * @exception Exception when an Instance can not be instantiated
    */
   public void add()
         throws Exception;

   /**
    *   Get an instance without identity.
    *   Can be used by finders and create-methods, or stateless beans
    *
    * @return     Context /w instance
    * @exception   RemoteException  
    */
   public EnterpriseContext get()
      throws Exception;
   
   /**
    *   Return an anonymous instance after invocation.
    *
    * @param   ctx  
    */
   public void free(EnterpriseContext ctx);
   
   /**
    *   Discard an anonymous instance after invocation.
    *   This is called if the instance should not be reused, perhaps due to some
    *   exception being thrown from it.
    *
    * @param   ctx  
    */
   public void discard(EnterpriseContext ctx);

   /**
    * Return the size of the pool.
    *
    * @return the size of the pool.
    */
   public int getCurrentSize();

   /**
    * Get the maximum size of the pool.
    *
    * @return the size of the pool.
    */
   public int getMaxSize();
}
