/*
* JBoss, the OpenSource EJB server
*
* Distributable under LGPL license.
* See terms of license at gnu.org.
*/
package org.jboss.ejb.plugins.jrmp.interfaces;

import java.io.Serializable;
import java.rmi.RemoteException;

import javax.ejb.HomeHandle;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBHome;
import javax.ejb.EJBException;

/**
 * An implementation of the EJBMetaData interface which allows a
 * client to obtain the enterprise Bean's meta-data information.
 *      
 * @author  Rickard berg (rickard.oberg@telkel.com)
 * @author  <a href="mailto:marc.fleury@telkel.com">Marc Fleury</a>
 * @author  Jason Dillon <a href="mailto:jason@planet57.com">&lt;jason@planet57.com&gt;</a>
 * @version $Revision: 1.8 $
 */
public class EJBMetaDataImpl
    implements EJBMetaData, Serializable
{
	// Constants -----------------------------------------------------

    /** Serial Version Identifier. */
    private static final long serialVersionUID = 2590026239352080415L;
    
	// Attributes ----------------------------------------------------
    
	private final Class remote;
	private final Class home;
	private final Class pkClass;
	
	private final boolean session;
	private final boolean statelessSession;
	
	private final HomeHandle homeHandle;
	
	// Constructors --------------------------------------------------

    /**
     * Construct an <tt>EJBMetaDataInput</tt>.
     */
    public EJBMetaDataImpl(final Class remote,
                           final Class home,
                           final Class pkClass,
                           final boolean session,
                           final boolean statelessSession,
                           final HomeHandle homeHandle)
	{
		this.remote = remote;
		this.home = home;
		this.pkClass = pkClass;
		this.session = session;
		this.statelessSession = statelessSession;
		this.homeHandle = homeHandle;
	}
	
	// EJBMetaData ---------------------------------------------------

    /**
     * Obtain the home interface of the enterprise Bean.
     *
     * @throws EJBException     Failed to get EJBHome object.
     */
    public EJBHome getEJBHome() {
		/* 
         * MF BUG?????? 
         * The java.ejb.HomeHandle says throws RemoteException 
         * but if I let it be propagated it doesn't compile
         * ???????????
         */
		try {
			return homeHandle.getEJBHome();
		}
		catch (RemoteException e) {
			e.printStackTrace();
            throw new EJBException(e);
		}
	
	}

    /**
     * Obtain the Class object for the enterprise Bean's home interface.
     */
	public Class getHomeInterfaceClass() { return home; }

    /**
     * Obtain the Class object for the enterprise Bean's remote interface.
     */
    public Class getRemoteInterfaceClass() { return remote; }

    /**
     * Obtain the Class object for the enterprise Bean's primary key class.
     */
    public Class getPrimaryKeyClass() { return pkClass; }

    /**
     * Test if the enterprise Bean's type is "session".
     *
     * @return True if the type of the enterprise Bean is session bean.
     */    
    public boolean isSession() { return session; }

    /**
     * Test if the enterprise Bean's type is "stateless session".
     *
     * @return True if the type of the enterprise Bean is stateless session.
     */
    public boolean isStatelessSession() { return statelessSession; }
}

