/*
 * JBoss, the OpenSource EJB server
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
 
package org.jboss.jmx.server;

import java.rmi.server.UnicastRemoteObject;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.util.ArrayList;
import java.util.Iterator;

import javax.management.Attribute;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ObjectInstance;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.naming.InitialContext;

import org.jboss.jmx.interfaces.JMXAdaptor;
import org.jboss.logging.Logger;
import org.jboss.util.ServiceMBeanSupport;

/**
*   <description> 
*      
*   @see <related>
*   @author Rickard berg (rickard.oberg@telkel.com)
*   @version $Revision: 1.3.6.4 $
*/
public class JMXAdaptorImpl
   extends UnicastRemoteObject
   implements JMXAdaptor
{
   private static Logger log = Logger.getLogger(JMXAdaptorImpl.class);

   // Constants -----------------------------------------------------
    
   // Attributes ----------------------------------------------------
	MBeanServer server;
   
   // Static --------------------------------------------------------

   // Constructors --------------------------------------------------
   public JMXAdaptorImpl(MBeanServer server)
		throws RemoteException
   {
		super();
		this.server = server;
   }
   
   // JMXAdaptor implementation -------------------------------------
   public java.lang.Object invoke(ObjectName name,
   	                            java.lang.String actionName,
      	                         java.lang.Object[] params,
         	                      java.lang.String[] signature)
   	throws InstanceNotFoundException,
             MBeanException,
             ReflectionException,
   			 RemoteException
	{
      Object value = null;
      Exception ex = null;
      try
      {
         value = server.invoke(name, actionName, params, signature);
      }
      catch(MBeanException e)
      {
         ex = e.getTargetException();
      }
      catch(RuntimeErrorException e)
      {
         Error err = e.getTargetError();
         ex = new ServerError("RuntimeErrorException", err);
      }
      catch(RuntimeMBeanException e)
      {
         ex = e.getTargetException();
         while( ex instanceof RuntimeMBeanException )
         {
            RuntimeMBeanException re = (RuntimeMBeanException) ex;
            ex = re.getTargetException();
         }
      }
      catch(RuntimeOperationsException e)
      {
         ex = e.getTargetException();
      }

      if( ex != null )
      {
         String msg = "invoke name="+name+", action="+actionName+" failed";
         log.debug(msg, ex);
         throw new ServerException(msg, ex);
      }

      return value;
   }

   public java.util.Set queryMBeans(ObjectName name,
                                 	QueryExp query)
   	throws RemoteException
	{
		return server.queryMBeans(name, query);
	}
   
   public java.util.Collection getMBeanInfos()
   	throws RemoteException
	{
		try
		{
			ArrayList infos = new ArrayList();
			Iterator mbeans = server.queryNames(null, null).iterator();
			while(mbeans.hasNext())
			{
				infos.add(server.getMBeanInfo((ObjectName)mbeans.next()));
			}
			return infos;
		} catch (Exception e)
		{
			throw new ServerException("Exception occurred", e);
		}
		
	}
   
   public void setAttribute(ObjectName name,
                         Attribute attribute)
      throws InstanceNotFoundException,
             AttributeNotFoundException,
             InvalidAttributeValueException,
             MBeanException,
             ReflectionException,
   			 RemoteException
	{
		server.setAttribute(name, attribute);
	}
   			 
   public java.lang.Object getAttribute(ObjectName name,
                                     java.lang.String attribute)
      throws MBeanException,
             AttributeNotFoundException,
             InstanceNotFoundException,
             ReflectionException,
   			 RemoteException
	{
		return server.getAttribute(name, attribute);
	}
	
   // Protected -----------------------------------------------------
}

