package org.jboss.verifier;

/*
 * Class org.jboss.verifier.Main;
 * Copyright (C) 2000  Juha Lindfors
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * This package and its source code is available at www.jboss.org
 * $Id: Main.java,v 1.5.6.1 2001/12/09 01:37:02 starksm Exp $
 *
 * You can reach the author by sending email to jplindfo@helsinki.fi.
 */


// standard imports
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

// non-standard class dependencies
import org.jboss.verifier.event.VerificationListener;
import org.jboss.verifier.event.VerificationEvent;

import org.jboss.metadata.XmlFileLoader;

/**
 * Main class for bean verifier.
 *
 * For more detailed documentation, refer to the
 * <a href="http://www.jboss.org">JBoss project</a>
 *
 * @see     << OTHER RELATED CLASSES >>
 *
 * @author 	Juha Lindfors
 * @version $Revision: 1.5.6.1 $
 * @since  	JDK 1.3
 */
public class Main
{
   
   public final static int OK      = 0;
   public final static int WARNING = 1;
   
   static int returnCode = OK;
   
   /**
    * Starts the application.
    *
    * @param   args    argument strings
    */
   public static void main(String[] args)
   {
      
      try
      {
         if (args.length < 1)
            throw new IllegalArgumentException("Usage: beanverifier [-novalidate] mybeans.jar");

         boolean validate = true;
         String jar = null;
         for(int a = 0; a < args.length; a ++)
         {
            if( args[a].startsWith("-no") )
               validate = false;
            else
               jar = args[a];
         }
         URL url = new File(jar).toURL();
         URL[] urls = {url};
         ClassLoader parent = Thread.currentThread().getContextClassLoader();
         ClassLoader cl = new URLClassLoader(urls, parent);
         XmlFileLoader xfl     = new XmlFileLoader(validate);
         BeanVerifier verifier = new BeanVerifier();
         
         xfl.setClassLoader(cl);
         verifier.addVerificationListener(new Listener());
         
         verifier.verify(url, xfl.load());
      }
      catch (Exception e)
      {
         System.err.println("Problem starting the application:");
         System.err.println("Exception: " + e);
         System.err.println("Message:   " + e.getMessage());
         e.printStackTrace();
         
         System.exit(-1);
      }
      
      System.exit(returnCode);
   }
   
}

class Listener implements VerificationListener
{
   
   public void specViolation(VerificationEvent event)
   {
      System.out.println(event.getVerbose());
      
      Main.returnCode = Main.WARNING;
   }
   
   public void beanChecked(VerificationEvent event)
   {
      System.out.println(event.getMessage());
   }
}
