/****************************************************************************
*
*                            Open Watcom Project
*
*    Portions Copyright (c) 1983-2002 Sybase, Inc. All Rights Reserved.
*
*  ========================================================================
*
*    This file contains Original Code and/or Modifications of Original
*    Code as defined in and that are subject to the Sybase Open Watcom
*    Public License version 1.0 (the 'License'). You may not use this file
*    except in compliance with the License. BY USING THIS FILE YOU AGREE TO
*    ALL TERMS AND CONDITIONS OF THE LICENSE. A copy of the License is
*    provided with the Original Code and Modifications, and is also
*    available at www.sybase.com/developer/opensource.
*
*    The Original Code and all software distributed under the License are
*    distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
*    EXPRESS OR IMPLIED, AND SYBASE AND ALL CONTRIBUTORS HEREBY DISCLAIM
*    ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF
*    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR
*    NON-INFRINGEMENT. Please see the License for the specific language
*    governing rights and limitations under the License.
*
*  ========================================================================
*
* Description:  table of instructions. Other reserved words see special.h
*
****************************************************************************/

/* The order of items for an opcode (ins + insn) is IMPORTANT!
 * And op1 has a higher precedence than op2.
 * operands with type OP_A should be before OP_Rx & OP_R
 * operands with type OP_M should follow OP_Mx
 * operands with type OP_R should follow OP_Rx
 * operands with type OP_I should follow OP_Ix
 */

/* v1.96: the table needn't be sorted anymore, but
 * "additional" (=insn) entries must still be located after the
 * main (=ins) entry. These entries must have a <suffix> so that <tok> +
 * <suffix> gives a unique identifier.
 */

/*   tok   (suffix)            op1      byte1_info  op2            op3 opnd_dir rm_info opcode    rm_byte     cpu      prefix */

/* branch instructions */
/* there are some macros in codegen.h which rely on the order of the
 * branch tokens. To satisfy those make sure:
 * - the branch instructions are in order CALL, JMP, Jcc, JeCXZ, LOOPcc
 * - no other instruction between these
 */

ins (CALL, call, 4,             OP_I16,      0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE8,     0x00,       P_86,        0)
insn(CALL, 1,                   OP_I32,      0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE8,     0x00,       P_386,       0)
insn(CALL, 2,                   OP_RGT8,     0,      OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x10,       P_86,        0)
insn(CALL, 3,                   OP_M32,      F_32,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x10,       P_386,       0)
insn(CALL, 4,                   OP_M16,      F_16,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x10,       P_86,        0)
/* start entries for FAR call */
/* v1.96: disabled next line - it's an odd Wasm feature, a call with 2 ops (seg, offs)  */
//insn(CALL, 5,                   OP_I,        0,      OP_I,          OP3_NONE,0,  no_RM,  0x9A,     0x00,       P_86,        0)
insm(CALL, 6,                   OP_I32,      F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x9A,     0x00,       P_86,        0)
insn(CALL, 7,                   OP_J48,      F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x9A,     0x00,       P_386,       0)
insn(CALL, 8,                   OP_M32,      F_16,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x18,       P_86,        0)
insn(CALL, 9,                   OP_M48,      F_32,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x18,       P_386,       0)
ins (JMP, jmp, 3,               OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xEB,     0x00,       P_86,        0)
insn(JMP, 1,                    OP_I16,      0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE9,     0x00,       P_86,        0)
insn(JMP, 2,                    OP_I32,      0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE9,     0x00,       P_386,       0)
insn(JMP, 3,                    OP_RGT8,     0,      OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x20,       P_86,        0)
insn(JMP, 4,                    OP_M32,      F_32,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x20,       P_386,       0)
insn(JMP, 5,                    OP_M16,      F_16,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x20,       P_86,        0)
/* entries for FAR jmp */
/* v1.96: disabled next line - it's an odd Wasm feature, a jump with 2 ops (seg, offs) */
//insn(JMP, 6,                    OP_I,        0,      OP_I,          OP3_NONE,0,  no_RM,  0xEA,     0x00,       P_86,        0)
insm(JMP, 7,                    OP_I32,      F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xEA,     0x00,       P_86,        0)
insn(JMP, 8,                    OP_J48,      F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xEA,     0x00,       P_386,       0)
insn(JMP, 9,                    OP_M32,      F_16,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x28,       P_86,        0)
insn(JMP, 10,                   OP_M48,      F_32,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xFF,     0x28,       P_386,       0)

// for conditional jumps, the SHORT version must always be first!
#define jcc( cond, code, condlc, x )      \
ins (J##cond, j##condlc, 1+x,   OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM, 0x70+code, 0x00,       P_86,        0) \
insn(J##cond, 1,                OP_I,        F_0F,   OP_NONE,       OP3_NONE,0,  no_RM, 0x80+code, 0x00,       P_386,       0)

jcc( A,   0x7,   a, 1 )
jcc( AE,  0x3,  ae, 2 )
jcc( B,   0x2,   b, 1 )
jcc( BE,  0x6,  be, 2 )
jcc( C,   0x2,   c, 1 )
jcc( E,   0x4,   e, 1 )
jcc( G,   0xf,   g, 1 )
jcc( GE,  0xd,  ge, 2 )
jcc( L,   0xc,   l, 1 )
jcc( LE,  0xe,  le, 2 )
jcc( NA,  0x6,  na, 2 )
jcc( NAE, 0x2, nae, 3 )
jcc( NB,  0x3,  nb, 2 )
jcc( NBE, 0x7, nbe, 3 )
jcc( NC,  0x3,  nc, 2 )
jcc( NE,  0x5,  ne, 2 )
jcc( NG,  0xe,  ng, 2 )
jcc( NGE, 0xc, nge, 3 )
jcc( NL,  0xd,  nl, 2 )
jcc( NLE, 0xf, nle, 3 )
jcc( NO,  0x1,  no, 2 )
jcc( NP,  0xb,  np, 2 )
jcc( NS,  0x9,  ns, 2 )
jcc( NZ,  0x5,  nz, 2 )
jcc( O,   0x0,   o, 1 )
jcc( P,   0xa,   p, 1 )
jcc( PE,  0xa,  pe, 2 )
jcc( PO,  0xb,  po, 2 )
jcc( S,   0x8,   s, 1 )
jcc( Z,   0x4,   z, 1 )

#undef jcc

insx(JCXZ,   jcxz,   4,         OP_I8,       F_16A,  OP_NONE,       OP3_NONE,0,  no_RM,  0xE3,     0x00,       P_86,        0, RWF_IA32)
ins (JECXZ,  jecxz,  5,         OP_I8,       F_32A,  OP_NONE,       OP3_NONE,0,  no_RM,  0xE3,     0x00,       P_386,       0)
#if AMD64_SUPPORT
insx(JRCXZ,  jrcxz,  5,         OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE3,     0x00,       P_64,        0, RWF_X64)
#endif
ins (LOOP,   loop,   4,         OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE2,     0x00,       P_86,        0)
ins (LOOPE,  loope,  5,         OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE1,     0x00,       P_86,        0)
ins (LOOPZ,  loopz,  5,         OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE1,     0x00,       P_86,        0)
ins (LOOPNE, loopne, 6,         OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE0,     0x00,       P_86,        0)
ins (LOOPNZ, loopnz, 6,         OP_I8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xE0,     0x00,       P_86,        0)
ins (LOOPD,  loopd,  5,         OP_I8,       F_32A,  OP_NONE,       OP3_NONE,0,  no_RM,  0xE2,     0x00,       P_386,       0)
ins (LOOPED, looped, 6,         OP_I8,       F_32A,  OP_NONE,       OP3_NONE,0,  no_RM,  0xE1,     0x00,       P_386,       0)
ins (LOOPZD, loopzd, 6,         OP_I8,       F_32A,  OP_NONE,       OP3_NONE,0,  no_RM,  0xE1,     0x00,       P_386,       0)
ins (LOOPNED,loopned,7,         OP_I8,       F_32A,  OP_NONE,       OP3_NONE,0,  no_RM,  0xE0,     0x00,       P_386,       0)
ins (LOOPNZD,loopnzd,7,         OP_I8,       F_32A,  OP_NONE,       OP3_NONE,0,  no_RM,  0xE0,     0x00,       P_386,       0)
insx(LOOPW,  loopw,  5,         OP_I8,       F_16A,  OP_NONE,       OP3_NONE,0,  no_RM,  0xE2,     0x00,       P_86,        0, RWF_IA32)
insx(LOOPEW, loopew, 6,         OP_I8,       F_16A,  OP_NONE,       OP3_NONE,0,  no_RM,  0xE1,     0x00,       P_86,        0, RWF_IA32)
insx(LOOPZW, loopzw, 6,         OP_I8,       F_16A,  OP_NONE,       OP3_NONE,0,  no_RM,  0xE1,     0x00,       P_86,        0, RWF_IA32)
insx(LOOPNEW,loopnew,7,         OP_I8,       F_16A,  OP_NONE,       OP3_NONE,0,  no_RM,  0xE0,     0x00,       P_86,        0, RWF_IA32)
insx(LOOPNZW,loopnzw,7,         OP_I8,       F_16A,  OP_NONE,       OP3_NONE,0,  no_RM,  0xE0,     0x00,       P_86,        0, RWF_IA32)

/* arith instructions */

#define ari( name, namelc, code, len )      \
ins (name, namelc, len,         OP_RGT8,     0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     code,       P_86,        0) \
insn(name, 1,                   OP_R,        0,      OP_M,          OP3_NONE,1,  0,      code+2,   0x00,       P_86,        0) \
insn(name, 2,                   OP_R,        0,      OP_R,          OP3_NONE,1,  0,      code+2,   0x00,       P_86,        0) \
insn(name, 3,                   OP_A,        0,      OP_I,          OP3_NONE,0,  no_RM,  code+4,   0x00,       P_86,        0) \
insn(name, 4,                   OP_R,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     code,       P_86,        0) \
insn(name, 6,                   OP_MGT8,     0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     code,       P_86,        AP_LOCK) \
insn(name, 7,                   OP_M,        0,      OP_R,          OP3_NONE,0,  0,      code,     0x00,       P_86,        AP_LOCK) \
insn(name, 8,                   OP_M,        0,      OP_I,          OP3_NONE,0,  0,      0x80,     code,       P_86,        AP_LOCK)

//v2.02: entries 5+6 replaced by 6
//insn(name, 5,                   OP_MGT16,    0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     code,       P_386,       AP_LOCK)
//insn(name, 6,                   OP_M16,      0,      OP_I8,         OP3_NONE,0,  no_WDS, 0x83,     code,       P_86,        AP_LOCK)

ari( ADD, add, 0x00, 3 )
ari(  OR,  or, 0x08, 2 )
ari( ADC, adc, 0x10, 3 )
ari( SBB, sbb, 0x18, 3 )
ari( AND, and, 0x20, 3 )
ari( SUB, sub, 0x28, 3 )
ari( XOR, xor, 0x30, 3 )
ari( CMP, cmp, 0x38, 3 )

#undef ari

/* std bitshift instructions */
#define bsi( name, namelc, code )      \
ins (name, namelc, 3,           OP_R,        0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     code,       P_86,        0) \
insn(name, 1,                   OP_R,        0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     code,       P_86,        0) \
insn(name, 2,                   OP_R,        0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     code,       P_186,       0) \
insn(name, 3,                   OP_M8,       0,      OP_CL,         OP3_NONE,0,  0,      0xD2,     code,       P_86,        0) \
insn(name, 4,                   OP_M8,       0,      OP_I_1,        OP3_NONE,0,  0,      0xD0,     code,       P_86,        0) \
insn(name, 5,                   OP_M8,       0,      OP_I8_U,       OP3_NONE,0,  0,      0xC0,     code,       P_186,       0) \
insn(name, 6,                   OP_MGT16,    0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     code,       P_386,       0) \
insn(name, 7,                   OP_MGT16,    0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     code,       P_386,       0) \
insn(name, 8,                   OP_MGT16,    0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     code,       P_386,       0) \
insn(name, 9,                   OP_M16,      0,      OP_CL,         OP3_NONE,0,  0,      0xD3,     code,       P_86,        0) \
insn(name, 10,                  OP_M16,      0,      OP_I_1,        OP3_NONE,0,  0,      0xD1,     code,       P_86,        0) \
insn(name, 11,                  OP_M16,      0,      OP_I8_U,       OP3_NONE,0,  0,      0xC1,     code,       P_186,       0)

bsi( RCL, rcl, 0x10 )
bsi( RCR, rcr, 0x18 )
bsi( ROL, rol, 0x00 )
bsi( ROR, ror, 0x08 )
bsi( SAL, sal, 0x20 )
bsi( SAR, sar, 0x38 )
bsi( SHL, shl, 0x20 )
bsi( SHR, shr, 0x28 )

#undef bsi

/* string instructions */

ins (CMPS,  cmps,  4,           OP_M,        0,      OP_M,          OP3_NONE,0,  no_RM,  0xA6,     0x00,       P_86,        AP_REPxx)
ins (CMPSB, cmpsb, 5,           OP_M8,       0,      OP_M,          OP3_NONE,0,  no_RM,  0xA6,     0x00,       P_86,        AP_REPxx)
insn(CMPSB, 1,                  OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xA6,     0x00,       P_86,        AP_REPxx)
ins (CMPSD, cmpsd, 5,           OP_M32,      F_32,   OP_M,          OP3_NONE,0,  no_RM,  0xA7,     0x00,       P_386,       AP_REPxx)
insn(CMPSD, 1,                  OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xA7,     0x00,       P_386,       AP_REPxx)
insn(CMPSD, 2,                  OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_I8_U,1,  no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPSW, cmpsw, 5,           OP_M16,      F_16,   OP_M,          OP3_NONE,1,  no_RM,  0xA7,     0x00,       P_86,        AP_REPxx)
insn(CMPSW, 1,                  OP_NONE,     F_16,   OP_NONE,       OP3_NONE,1,  no_RM,  0xA7,     0x00,       P_86,        AP_REPxx)
ins (INS,   ins,   3,           OP_M,        0,      OP_DX,         OP3_NONE,0,  no_RM,  0x6C,     0x00,       P_186,       AP_REP)
ins (INSB,  insb,  4,           OP_M8,       0,      OP_DX,         OP3_NONE,0,  no_RM,  0x6C,     0x00,       P_186,       AP_REP)
insn(INSB,  1,                  OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x6C,     0x00,       P_186,       AP_REP)
ins (INSD,  insd,  4,           OP_M32,      F_32,   OP_DX,         OP3_NONE,0,  no_RM,  0x6D,     0x00,       P_386,       AP_REP)
insn(INSD,  1,                  OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x6D,     0x00,       P_386,       AP_REP)
ins (INSW,  insw,  4,           OP_M16,      F_16,   OP_DX,         OP3_NONE,0,  no_RM,  0x6D,     0x00,       P_186,       AP_REP)
insn(INSW,  1,                  OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x6D,     0x00,       P_186,       AP_REP)
ins (LODS,  lods,  4,           OP_M,        0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xAC,     0x00,       P_86,        AP_REP)
ins (LODSB, lodsb, 5,           OP_M8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xAC,     0x00,       P_86,        AP_REP)
insn(LODSB, 1,                  OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xAC,     0x00,       P_86,        AP_REP)
ins (LODSD, lodsd, 5,           OP_M32,      F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAD,     0x00,       P_386,       AP_REP)
insn(LODSD, 1,                  OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAD,     0x00,       P_386,       AP_REP)
ins (LODSW, lodsw, 5,           OP_M16,      F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAD,     0x00,       P_86,        AP_REP)
insn(LODSW, 1,                  OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAD,     0x00,       P_86,        AP_REP)
ins (MOVS,  movs,  4,           OP_M,        0,      OP_M,          OP3_NONE,0,  no_RM,  0xA4,     0x00,       P_86,        AP_REP)
ins (MOVSB, movsb, 5,           OP_M8,       0,      OP_M,          OP3_NONE,0,  no_RM,  0xA4,     0x00,       P_86,        AP_REP)
insn(MOVSB, 1,                  OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xA4,     0x00,       P_86,        AP_REP)
ins (MOVSD, movsd, 5,           OP_M32,      F_32,   OP_M,          OP3_NONE,0,  no_RM,  0xA5,     0x00,       P_386,       AP_REP)
insn(MOVSD, 1,                  OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xA5,     0x00,       P_386,       AP_REP)
insn(MOVSD, 2,                  OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x10,     0x00,       P_686|P_SSE2,0)
insn(MOVSD, 3,                  OP_M64,      F_F20F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x11,     0x00,       P_686|P_SSE2,0)
ins (MOVSW, movsw, 5,           OP_M16,      F_16,   OP_M,          OP3_NONE,0,  no_RM,  0xA5,     0x00,       P_86,        AP_REP)
insn(MOVSW, 1,                  OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xA5,     0x00,       P_86,        AP_REP)
ins (OUTS,  outs,  4,           OP_DX,       0,      OP_M,          OP3_NONE,0,  no_RM,  0x6E,     0x00,       P_186,       AP_REP)
ins (OUTSB, outsb, 5,           OP_DX,       0,      OP_M,          OP3_NONE,0,  no_RM,  0x6E,     0x00,       P_186,       AP_REP)
insn(OUTSB, 1,                  OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x6E,     0x00,       P_186,       AP_REP)
ins (OUTSD, outsd, 5,           OP_DX,       F_32,   OP_M,          OP3_NONE,0,  no_RM,  0x6F,     0x00,       P_386,       AP_REP)
insn(OUTSD, 1,                  OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x6F,     0x00,       P_386,       AP_REP)
ins (OUTSW, outsw, 5,           OP_DX,       F_16,   OP_M,          OP3_NONE,0,  no_RM,  0x6F,     0x00,       P_186,       AP_REP)
insn(OUTSW, 1,                  OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x6F,     0x00,       P_186,       AP_REP)
ins (SCAS,  scas,  4,           OP_M,        0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xAE,     0x00,       P_86,        AP_REPxx)
ins (SCASB, scasb, 5,           OP_M8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xAE,     0x00,       P_86,        AP_REPxx)
insn(SCASB, 1,                  OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xAE,     0x00,       P_86,        AP_REPxx)
ins (SCASD, scasd, 5,           OP_M32,      F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAF,     0x00,       P_386,       AP_REPxx)
insn(SCASD, 1,                  OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAF,     0x00,       P_386,       AP_REPxx)
ins (SCASW, scasw, 5,           OP_M16,      F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAF,     0x00,       P_86,        AP_REPxx)
insn(SCASW, 1,                  OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAF,     0x00,       P_86,        AP_REPxx)
ins (STOS,  stos,  4,           OP_M,        0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xAA,     0x00,       P_86,        AP_REP)
ins (STOSB, stosb, 5,           OP_M8,       0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xAA,     0x00,       P_86,        AP_REP)
insn(STOSB, 1,                  OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xAA,     0x00,       P_86,        AP_REP)
ins (STOSD, stosd, 5,           OP_M32,      F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAB,     0x00,       P_386,       AP_REP)
insn(STOSD, 1,                  OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAB,     0x00,       P_386,       AP_REP)
ins (STOSW, stosw, 5,           OP_M16,      F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAB,     0x00,       P_86,        AP_REP)
insn(STOSW, 1,                  OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAB,     0x00,       P_86,        AP_REP)

/* instructions invalid for IA32+ */

insx(AAA, aaa, 3,               OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x37,     0x00,       P_86,        0, RWF_IA32 )
insx(AAD, aad, 3,               OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD5,     0x0A,       P_86,        0, RWF_IA32 )
insx(AAM, aam, 3,               OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD4,     0x0A,       P_86,        0, RWF_IA32 )
insx(AAS, aas, 3,               OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x3F,     0x00,       P_86,        0, RWF_IA32 )
insx(DAA, daa, 3,               OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x27,     0x00,       P_86,        0, RWF_IA32 )
insx(DAS, das, 3,               OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x2F,     0x00,       P_86,        0, RWF_IA32 )
insx(LDS, lds, 3,               OP_RGT8,     0,      OP_MFPTR,      OP3_NONE,1,  no_WDS, 0xC5,     0x00,       P_86,        0, RWF_IA32 )
insx(LES, les, 3,               OP_RGT8,     0,      OP_MFPTR,      OP3_NONE,1,  no_WDS, 0xC4,     0x00,       P_86,        0, RWF_IA32 )
insx(POPA,  popa,  4,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x61,     0x00,       P_186,       0, RWF_IA32 )
insx(POPAD, popad, 5,           OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x61,     0x00,       P_386,       0, RWF_IA32 )
insx(POPAW, popaw, 5,           OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x61,     0x00,       P_186,       0, RWF_IA32 )
insx(POPFD, popfd, 5,           OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x9D,     0x00,       P_386,       0, RWF_IA32 )
insx(PUSHA,  pusha,  5,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x60,     0x00,       P_186,       0, RWF_IA32 )
insx(PUSHAD, pushad, 6,         OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x60,     0x00,       P_386,       0, RWF_IA32 )
insx(PUSHAW, pushaw, 6,         OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x60,     0x00,       P_186,       0, RWF_IA32 )
insx(PUSHFD, pushfd, 6,         OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x9C,     0x00,       P_386,       0, RWF_IA32 )
insx(PUSHD,  pushd,  5,         OP_I8,       F_32,   OP_NONE,       OP3_NONE,0,  R_in_OP,0x6A,     0x00,       P_386,       0, RWF_IA32 )
insn(PUSHD,  1,                 OP_I32,      F_32,   OP_NONE,       OP3_NONE,0,  R_in_OP,0x68,     0x00,       P_386,       0)
insn(PUSHD,  2,                 OP_R32,      0,      OP_NONE,       OP3_NONE,0,  R_in_OP,0x50,     0x00,       P_386,       0)
insn(PUSHD,  3,                 OP_SR86,     0,      OP_NONE,       OP3_NONE,1,  R_in_OP,0x06,     0x00,       P_86,        0)
insn(PUSHD,  4,                 OP_SR,       F_0F,   OP_NONE,       OP3_NONE,1,  R_in_OP,0x80,     0x00,       P_386,       0)
insn(PUSHD,  5,                 OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xFF,     0x30,       P_386,       0)
insx(RETD, retd, 4,             OP_I16,      F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xCA,     0x00,       P_386,       0, RWF_IA32 )
insn(RETD, 1,                   OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xCB,     0x00,       P_386,       0)
insx(RETW, retw, 4,             OP_I16,      F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xCA,     0x00,       P_86,        0, RWF_IA32 )
insn(RETW, 1,                   OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xCB,     0x00,       P_86,        0)

/* protected-mode instructions */
/* some (i.e. SMSW) also work with 32bit register as first operand, but Masm won't accept.
 * to make JWasm accept, change OP_R16 to OP_RGT8
 */

ins (ARPL, arpl, 4,             OP_R16,      0,      OP_R16,        OP3_NONE,0,  no_WDS, 0x63,     0x00,       P_286,       0)
insn(ARPL, 1,                   OP_M16,      0,      OP_R16,        OP3_NONE,0,  no_WDS, 0x63,     0x00,       P_286,       0)
ins (LLDT, lldt, 4,             OP_R16,      F_0FNO66,OP_NONE,      OP3_NONE,0,  no_WDS, 0x00,     0x10,       P_286p,      0)
insn(LLDT, 1,                   OP_M16,      F_0FNO66,OP_NONE,      OP3_NONE,0,  no_WDS, 0x00,     0x10,       P_286p,      0)
ins (LMSW, lmsw, 4,             OP_R16,      F_0FNO66,OP_NONE,      OP3_NONE,0,  no_WDS, 0x01,     0x30,       P_286p,      0)
insn(LMSW, 1,                   OP_M16,      F_0FNO66,OP_NONE,      OP3_NONE,0,  no_WDS, 0x01,     0x30,       P_286p,      0)
ins (LTR,  ltr,  3,             OP_R16,      F_0FNO66,OP_NONE,      OP3_NONE,0,  no_WDS, 0x00,     0x18,       P_286p,      0)
insn(LTR,  1,                   OP_M16,      F_0FNO66,OP_NONE,      OP3_NONE,0,  no_WDS, 0x00,     0x18,       P_286p,      0)
ins (SLDT, sldt, 4,             OP_R16,      F_0FNO66,OP_NONE,      OP3_NONE,0,  no_WDS, 0x00,     0x00,       P_286,       0)
insn(SLDT, 1,                   OP_M16,      F_0FNO66,OP_NONE,      OP3_NONE,0,  no_WDS, 0x00,     0x00,       P_286,       0)
ins (SMSW, smsw, 4,             OP_R16,      F_0FNO66,OP_NONE,      OP3_NONE,0,  no_WDS, 0x01,     0x20,       P_286,       0)
insn(SMSW, 1,                   OP_M16,      F_0FNO66,OP_NONE,      OP3_NONE,0,  no_WDS, 0x01,     0x20,       P_286,       0)
ins (STR,  str,  3,             OP_R16,      F_0FNO66,OP_NONE,      OP3_NONE,0,  no_WDS, 0x00,     0x08,       P_286,       0)
insn(STR,  1,                   OP_M16,      F_0FNO66,OP_NONE,      OP3_NONE,0,  no_WDS, 0x00,     0x08,       P_286,       0)
ins (VERR, verr, 4,             OP_R16,      F_0FNO66,OP_NONE,      OP3_NONE,0,  no_WDS, 0x00,     0x20,       P_286,       0)
insn(VERR, 1,                   OP_M16,      F_0FNO66,OP_NONE,      OP3_NONE,0,  no_WDS, 0x00,     0x20,       P_286,       0)
ins (VERW, verw, 4,             OP_R16,      F_0FNO66,OP_NONE,      OP3_NONE,0,  no_WDS, 0x00,     0x28,       P_286,       0)
insn(VERW, 1,                   OP_M16,      F_0FNO66,OP_NONE,      OP3_NONE,0,  no_WDS, 0x00,     0x28,       P_286,       0)

/* one-operand register/memory instructions */

ins (DIV, div, 3,               OP_R,        0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x30,       P_86,        0)
insn(DIV, 1,                    OP_M8,       0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x30,       P_86,        0)
insn(DIV, 2,                    OP_MGT16,    0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x30,       P_386,       0)
insn(DIV, 3,                    OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x30,       P_86,        0)
//insn(DIV, 4,                    OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x30,       P_86,        0)
ins (IDIV, idiv, 4,             OP_R,        0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x38,       P_86,        0)
insn(IDIV, 1,                   OP_M8,       0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x38,       P_86,        0)
insn(IDIV, 2,                   OP_MGT16,    0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x38,       P_386,       0)
insn(IDIV, 3,                   OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x38,       P_86,        0)
ins (MUL, mul, 3,               OP_R,        0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x20,       P_86,        0)
insn(MUL, 1,                    OP_M8,       0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x20,       P_86,        0)
insn(MUL, 2,                    OP_MGT16,    0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x20,       P_386,       0)
insn(MUL, 3,                    OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x20,       P_86,        0)
//insn(MUL, 4,                    OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x20,       P_86,        0)
ins (NEG, neg, 3,               OP_R,        0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x18,       P_86,        0)
insn(NEG, 1,                    OP_M8,       0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x18,       P_86,        AP_LOCK)
insn(NEG, 2,                    OP_MGT16,    0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x18,       P_386,       AP_LOCK)
insn(NEG, 3,                    OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x18,       P_86,        AP_LOCK)
ins (NOT, not, 3,               OP_R,        0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x10,       P_86,        0)
insn(NOT, 1,                    OP_M8,       0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x10,       P_86,        AP_LOCK)
insn(NOT, 2,                    OP_MGT16,    0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x10,       P_386,       AP_LOCK)
insn(NOT, 3,                    OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x10,       P_86,        AP_LOCK)

/* prefixes. must start with LOCK, end with REPZ and be consecutive */
ins (LOCK,  lock,  4,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF0,     AP_LOCK,    P_86,        0)
ins (REP,   rep,   3,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF3,     AP_REP,     P_86,        0)
ins (REPE,  repe,  4,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF3,     AP_REPxx,   P_86,        0)
ins (REPNE, repne, 5,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF2,     AP_REPxx,   P_86,        0)
ins (REPNZ, repnz, 5,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF2,     AP_REPxx,   P_86,        0)
ins (REPZ,  repz,  4,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF3,     AP_REPxx,   P_86,        0)

/* rest */

ins (BOUND_, bound, 5,          OP_RGT8,     0,      OP_M,          OP3_NONE,1,  no_WDS, 0x62,     0x00,       P_186,       0)
ins (BSF, bsf, 3,               OP_RGT8,     F_0F,   OP_RGT8,       OP3_NONE,1,  no_WDS, 0xBC,     0x00,       P_386,       0)
insn(BSF,  1,                   OP_RGT8,     F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0xBC,     0x00,       P_386,       0)
ins (BSR, bsr, 3,               OP_RGT8,     F_0F,   OP_RGT8,       OP3_NONE,1,  no_WDS, 0xBD,     0x00,       P_386,       0)
insn(BSR,  1,                   OP_RGT8,     F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0xBD,     0x00,       P_386,       0)
ins (BSWAP, bswap, 5,           OP_RGT16,    F_0F,   OP_NONE,       OP3_NONE,0,  R_in_OP,0xC8,     0x00,       P_486,       0)
ins (BT, bt, 2,                 OP_RGT8,     F_0F,   OP_RGT8,       OP3_NONE,0,  no_WDS, 0xA3,     0x00,       P_386,       0)
insn(BT,   1,                   OP_RGT8,     F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xBA,     0x20,       P_386,       0)
insn(BT,   2,                   OP_M,        F_0F,   OP_RGT8,       OP3_NONE,0,  no_WDS, 0xA3,     0x00,       P_386,       0)
insn(BT,   3,                   OP_M,        F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xBA,     0x20,       P_386,       0)
ins (BTC, btc, 3,               OP_RGT8,     F_0F,   OP_RGT8,       OP3_NONE,0,  no_WDS, 0xBB,     0x00,       P_386,       0)
insn(BTC,  1,                   OP_RGT8,     F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xBA,     0x38,       P_386,       0)
insn(BTC,  2,                   OP_M,        F_0F,   OP_RGT8,       OP3_NONE,0,  no_WDS, 0xBB,     0x00,       P_386,       AP_LOCK)
insn(BTC,  3,                   OP_M,        F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xBA,     0x38,       P_386,       AP_LOCK)
ins (BTR, btr, 3,               OP_RGT8,     F_0F,   OP_RGT8,       OP3_NONE,0,  no_WDS, 0xB3,     0x00,       P_386,       0)
insn(BTR,  1,                   OP_RGT8,     F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xBA,     0x30,       P_386,       0)
insn(BTR,  2,                   OP_M,        F_0F,   OP_RGT8,       OP3_NONE,0,  no_WDS, 0xB3,     0x00,       P_386,       AP_LOCK)
insn(BTR,  3,                   OP_M,        F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xBA,     0x30,       P_386,       AP_LOCK)
ins (BTS, bts, 3,               OP_RGT8,     F_0F,   OP_RGT8,       OP3_NONE,0,  no_WDS, 0xAB,     0x00,       P_386,       0)
insn(BTS,  1,                   OP_RGT8,     F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xBA,     0x28,       P_386,       0)
insn(BTS,  2,                   OP_M,        F_0F,   OP_RGT8,       OP3_NONE,0,  no_WDS, 0xAB,     0x00,       P_386,       AP_LOCK)
insn(BTS,  3,                   OP_M,        F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xBA,     0x28,       P_386,       AP_LOCK)
ins (CBW, cbw, 3,               OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x98,     0x00,       P_86,        0)
ins (CDQ, cdq, 3,               OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x99,     0x00,       P_386,       0)
ins (CLC, clc, 3,               OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF8,     0x00,       P_86,        0)
ins (CLD, cld, 3,               OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xFC,     0x00,       P_86,        0)
ins (CLI, cli, 3,               OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xFA,     0x00,       P_86,        0)
ins (CLTS, clts, 4,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0x0F,     0x06,       P_286p,      0)
ins (CMC, cmc, 3,               OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF5,     0x00,       P_86,        0)
ins (CMPXCHG, cmpxchg, 7,       OP_R,        F_0F,   OP_R,          OP3_NONE,0,  0,      0xB0,     0x00,       P_486,       0)
insn(CMPXCHG, 1,                OP_M,        F_0F,   OP_R,          OP3_NONE,0,  0,      0xB0,     0x00,       P_486,       AP_LOCK)
ins (CMPXCHG8B, cmpxchg8b, 9,   OP_M64,      F_0F,   OP_NONE,       OP3_NONE,0,  0,      0xC7,     0x08,       P_586,       AP_LOCK)
ins (CPUID, cpuid, 5,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0x0F,     0xA2,       P_586,       0)
ins (CWD, cwd, 3,               OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x99,     0x00,       P_86,        0)
ins (CWDE, cwde, 4,             OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0x98,     0x00,       P_386,       0)
ins (DEC, dec, 3,               OP_RGT8,     0,      OP_NONE,       OP3_NONE,0,  R_in_OP,0x48,     0x00,       P_86,        0)
insn(DEC, 1,                    OP_R,        0,      OP_NONE,       OP3_NONE,0,  0,      0xFE,     0x08,       P_86,        0)
insn(DEC, 2,                    OP_M8,       0,      OP_NONE,       OP3_NONE,0,  0,      0xFE,     0x08,       P_86,        AP_LOCK)
insn(DEC, 3,                    OP_MGT16,    0,      OP_NONE,       OP3_NONE,0,  0,      0xFF,     0x08,       P_386,       AP_LOCK)
insn(DEC, 4,                    OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xFF,     0x08,       P_86,        AP_LOCK)
ins (ENTER, enter, 5,           OP_I16,      0,      OP_I8_U,       OP3_NONE,0,  no_RM,  0xC8,     0x00,       P_186,       0)
ins (HLT, hlt, 3,               OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF4,     0x00,       P_86,        0)
ins (IMUL, imul, 4,             OP_R,        0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x28,       P_86,        0)
insn(IMUL, 1,                   OP_R,        F_0F,   OP_R,          OP3_NONE,1,  no_WDS, 0xAF,     0x00,       P_386,       0)
insn(IMUL, 2,                   OP_R,        F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0xAF,     0x00,       P_386,       0)
insn(IMUL, 3,                   OP_R,        0,      OP_I8,         OP3_NONE,1,  no_WDS, 0x6B,     0x00,       P_186,       0)
insn(IMUL, 4,                   OP_R,        0,      OP_I,          OP3_NONE,1,  no_WDS, 0x69,     0x00,       P_186,       0)
insn(IMUL, 5,                   OP_M8,       0,      OP_NONE,       OP3_NONE,0,  0,      0xF6,     0x28,       P_86,        0)
insn(IMUL, 6,                   OP_MGT16,    0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x28,       P_386,       0)
insn(IMUL, 7,                   OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xF7,     0x28,       P_86,        0)
insn(IMUL, 8,                   OP_M,        0,      OP_I8,         OP3_NONE,1,  no_WDS, 0x6B,     0x00,       P_186,       0)
insn(IMUL, 9,                   OP_M,        0,      OP_I,          OP3_NONE,1,  no_WDS, 0x69,     0x00,       P_186,       0)
ins (IN, in, 2,                 OP_A,        0,      OP_DX,         OP3_NONE,0,  no_RM,  0xEC,     0x00,       P_86,        0)
insn(IN, 1,                     OP_A,        0,      OP_I8_U,       OP3_NONE,0,  no_RM,  0xE4,     0x00,       P_86,        0)
ins (INC, inc, 3,               OP_RGT8,     0,      OP_NONE,       OP3_NONE,0,  R_in_OP,0x40,     0x00,       P_86,        0)
insn(INC, 1,                    OP_R,        0,      OP_NONE,       OP3_NONE,0,  0,      0xFE,     0x00,       P_86,        0)
insn(INC, 2,                    OP_M8,       0,      OP_NONE,       OP3_NONE,0,  0,      0xFE,     0x00,       P_86,        AP_LOCK)
insn(INC, 3,                    OP_MGT16,    0,      OP_NONE,       OP3_NONE,0,  0,      0xFF,     0x00,       P_386,       AP_LOCK)
insn(INC, 4,                    OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xFF,     0x00,       P_86,        AP_LOCK)
ins (INT, int, 3,               OP_I_3,      0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xCC,     0x00,       P_86,        0)
insn(INT, 1,                    OP_I8_U,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xCD,     0x00,       P_86,        0)
ins (INTO, into, 4,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xCE,     0x00,       P_86,        0)
ins (INVD, invd, 4,             OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x08,     0x00,       P_486,       0)
ins (INVLPG, invlpg, 6,         OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x01,     0x38,       P_486,       0)
ins (IRET, iret, 4,             OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xCF,     0x00,       P_86,        0)
ins (IRETD, iretd, 5,           OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xCF,     0x00,       P_386,       0)
ins (IRETDF, iretdf, 6,         OP_NONE,     F_32,   OP_NONE,       OP3_NONE,0,  no_RM,  0xCF,     0x00,       P_386,       0)
ins (IRETF, iretf, 5,           OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0xCF,     0x00,       P_86,        0)
ins (LAHF, lahf, 4,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x9F,     0x00,       P_86,        0)
ins (LAR, lar, 3,               OP_RGT8,     F_0F,   OP_RGT8,       OP3_NONE,1,  no_WDS, 0x02,     0x00,       P_286,       0)
insn(LAR, 1,                    OP_RGT8,     F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0x02,     0x00,       P_286,       0)
ins (LEA, lea, 3,               OP_RGT8,     0,      OP_M,          OP3_NONE,1,  no_WDS, 0x8D,     0x00,       P_86,        0)
ins (LEAVE, leave, 5,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xC9,     0x00,       P_186,       0)
ins (LFS, lfs, 3,               OP_RGT8,     F_0F,   OP_MFPTR,      OP3_NONE,1,  no_WDS, 0xB4,     0x00,       P_386,       0)
ins (LGDT, lgdt, 4,             OP_M48,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x01,     0x10,       P_286p,      0)
ins (LGS, lgs, 3,               OP_RGT8,     F_0F,   OP_MFPTR,      OP3_NONE,1,  no_WDS, 0xB5,     0x00,       P_386,       0)
ins (LIDT, lidt, 4,             OP_M48,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x01,     0x18,       P_286p,      0)
ins (LSL, lsl, 3,               OP_RGT8,     F_0F,   OP_RGT8,       OP3_NONE,1,  no_WDS, 0x03,     0x00,       P_286,       0)
insn(LSL, 1,                    OP_RGT8,     F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0x03,     0x00,       P_286,       0)
ins (LSS, lss, 3,               OP_RGT8,     F_0F,   OP_MFPTR,      OP3_NONE,1,  no_WDS, 0xB2,     0x00,       P_386,       0)
ins (MOV, mov, 3,               OP_A,        0,      OP_M,          OP3_NONE,1,  no_RM,  0xA0,     0x00,       P_86,        0)
insn(MOV, 1,                    OP_R,        0,      OP_R,          OP3_NONE,1,  0,      0x8A,     0x00,       P_86,        0)
#if AMD64_SUPPORT
insn(MOV, 18,                   OP_R64,      0,      OP_I,          OP3_NONE,0,  0,      0xC6,     0x00,       P_64,        0)
insn(MOV, 19,                   OP_R64,      0,      OP_I64,        OP3_NONE,0,  R_in_OP,0xB8,     0x00,       P_64,        0)
#endif
insn(MOV, 2,                    OP_RGT8,     0,      OP_I,          OP3_NONE,0,  R_in_OP,0xB8,     0x00,       P_86,        0)
insn(MOV, 3,                    OP_R,        0,      OP_I,          OP3_NONE,0,  R_in_OP,0xB0,     0x00,       P_86,        0)
insn(MOV, 4,                    OP_R,        0,      OP_M,          OP3_NONE,1,  0,      0x8A,     0x00,       P_86,        0)
insn(MOV, 5,                    OP_RGT8,     0,      OP_SR,         OP3_NONE,0,  no_WDS, 0x8C,     0xC0,       P_86,        0)
insn(MOV, 6,                    OP_RGT16,    F_0F,   OP_SPECREG,    OP3_NONE,0,  no_WDS, 0x20,     0xC0,       P_386,       0)
//insn(MOV, 6,                    OP_RGT16,    F_0F,   OP_CR,         OP3_NONE,0,  no_WDS, 0x20,     0xC0,       P_386,       0)
//insn(MOV, 7,                    OP_RGT16,    F_0F,   OP_DR,         OP3_NONE,0,  no_WDS, 0x21,     0xC0,       P_386,       0)
//insn(MOV, 8,                    OP_RGT16,    F_0F,   OP_TR,         OP3_NONE,0,  no_WDS, 0x24,     0xC0,       P_386,       0)
insn(MOV, 9,                    OP_SR,       0,      OP_RGT8,       OP3_NONE,1,  no_WDS, 0x8E,     0xC0,       P_86,        0)
insn(MOV, 10,                   OP_SR,       0,      OP_M,          OP3_NONE,1,  no_WDS, 0x8E,     0x00,       P_86,        0)
insn(MOV, 11,                   OP_M,        0,      OP_A,          OP3_NONE,0,  no_RM,  0xA2,     0x00,       P_86,        0)
insn(MOV, 12,                   OP_M,        0,      OP_R,          OP3_NONE,0,  0,      0x88,     0x00,       P_86,        0)
insn(MOV, 13,                   OP_M,        0,      OP_I,          OP3_NONE,0,  0,      0xC6,     0x00,       P_86,        0)
insn(MOV, 14,                   OP_M,        0,      OP_SR,         OP3_NONE,0,  no_WDS, 0x8C,     0x00,       P_86,        0)
insn(MOV, 15,                   OP_SPECREG,  F_0F,   OP_RGT16,      OP3_NONE,1,  no_WDS, 0x22,     0xC0,       P_386,       0)
//insn(MOV, 15,                   OP_CR,       F_0F,   OP_RGT16,      OP3_NONE,1,  no_WDS, 0x22,     0xC0,       P_386,       0)
//insn(MOV, 16,                   OP_DR,       F_0F,   OP_RGT16,      OP3_NONE,1,  no_WDS, 0x23,     0xC0,       P_386,       0)
//insn(MOV, 17,                   OP_TR,       F_0F,   OP_RGT16,      OP3_NONE,1,  no_WDS, 0x26,     0xC0,       P_386,       0)
ins (MOVSX, movsx, 5,           OP_RGT8,     F_0F,   OP_R,          OP3_NONE,1,  0,      0xBE,     0x00,       P_386,       0)
insn(MOVSX, 1,                  OP_RGT8,     F_0F,   OP_M,          OP3_NONE,1,  0,      0xBE,     0x00,       P_386,       0)
ins (MOVZX, movzx, 5,           OP_RGT8,     F_0F,   OP_R,          OP3_NONE,1,  0,      0xB6,     0x00,       P_386,       0)
insn(MOVZX, 1,                  OP_RGT8,     F_0F,   OP_M,          OP3_NONE,1,  0,      0xB6,     0x00,       P_386,       0)
ins (NOP, nop, 3,               OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x90,     0x00,       P_86,        0)
ins (OUT, out, 3,               OP_DX,       0,      OP_A,          OP3_NONE,0,  no_RM,  0xEE,     0x00,       P_86,        0)
insn(OUT, 1,                    OP_I8_U,     0,      OP_A,          OP3_NONE,0,  no_RM,  0xE6,     0x00,       P_86,        0)
ins (POP, pop, 3,               OP_RGT8,     0,      OP_NONE,       OP3_NONE,0,  R_in_OP,0x58,     0x00,       P_86,        0)
insn(POP, 1,                    OP_SR86,     0,      OP_NONE,       OP3_NONE,1,  R_in_OP,0x07,     0x00,       P_86,        0)
insn(POP, 2,                    OP_SR,       F_0F,   OP_NONE,       OP3_NONE,1,  R_in_OP,0x81,     0x00,       P_386,       0)
insn(POP, 3,                    OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0x8F,     0x00,       P_86,        0)
insn(POP, 4,                    OP_MGT16,    0,      OP_NONE,       OP3_NONE,0,  0,      0x8F,     0x00,       P_386,       0)
ins (POPF,  popf,  4,           OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x9D,     0x00,       P_86,        0)
ins (PUSH,  push,  4,           OP_RGT8,     0,      OP_NONE,       OP3_NONE,0,  R_in_OP,0x50,     0x00,       P_86,        0)
insn(PUSH, 1,                   OP_I8,       0,      OP_NONE,       OP3_NONE,0,  R_in_OP,0x6A,     0x00,       P_186,       0)
insn(PUSH, 2,                   OP_I,        0,      OP_NONE,       OP3_NONE,0,  R_in_OP,0x68,     0x00,       P_186,       0)
insn(PUSH, 3,                   OP_SR86,     0,      OP_NONE,       OP3_NONE,1,  R_in_OP,0x06,     0x00,       P_86,        0)
insn(PUSH, 4,                   OP_SR,       F_0F,   OP_NONE,       OP3_NONE,1,  R_in_OP,0x80,     0x00,       P_386,       0)
insn(PUSH, 5,                   OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xFF,     0x30,       P_86,        0)
insn(PUSH, 6,                   OP_MGT16,    0,      OP_NONE,       OP3_NONE,0,  0,      0xFF,     0x30,       P_386,       0)
ins (PUSHW,  pushw,  5,         OP_I8,       F_16,   OP_NONE,       OP3_NONE,0,  R_in_OP,0x6A,     0x00,       P_186,       0)
insn(PUSHW,  1,                 OP_I16,      F_16,   OP_NONE,       OP3_NONE,0,  R_in_OP,0x68,     0x00,       P_186,       0)
ins (PUSHF,  pushf,  5,         OP_NONE,     F_16,   OP_NONE,       OP3_NONE,0,  no_RM,  0x9C,     0x00,       P_86,        0)

ins (RDMSR, rdmsr, 5,           OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x32,     0x00,       P_586,       0)
ins (RDPMC, rdpmc, 5,           OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x33,     0x00,       P_686,       0)
ins (RDTSC, rdtsc, 5,           OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x31,     0x00,       P_586,       0)
ins (RDTSCP, rdtscp, 6,         OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x01,     0xF9,       P_686,       0)
ins (RET,  ret,  3,             OP_I16,      0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xC2,     0x00,       P_86,        0)
insn(RET,  1,                   OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xC3,     0x00,       P_86,        0)
ins (RETN, retn, 4,             OP_I16,      0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xC2,     0x00,       P_86,        0)
insn(RETN, 1,                   OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xC3,     0x00,       P_86,        0)
ins (RETF, retf, 4,             OP_I16,      0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xCA,     0x00,       P_86,        0)
insn(RETF, 1,                   OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xCB,     0x00,       P_86,        0)
ins (RSM, rsm, 3,               OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAA,     0x00,       P_586,       0)
ins (SAHF, sahf, 4,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x9E,     0x00,       P_86,        0)
ins (SGDT, sgdt, 4,             OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x01,     0x00,       P_286,       0)
ins (SHLD, shld, 4,             OP_RGT8,     F_0F,   OP_RGT8,       OP3_NONE,0,  no_WDS, 0xA5,     0x00,       P_386,       0)
insn(SHLD, 1,                   OP_RGT8,     F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xA4,     0x00,       P_386,       0)
insn(SHLD, 2,                   OP_M,        F_0F,   OP_RGT8,       OP3_NONE,0,  no_WDS, 0xA5,     0x00,       P_386,       0)
insn(SHLD, 3,                   OP_M,        F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xA4,     0x00,       P_386,       0)
ins (SHRD, shrd, 4,             OP_RGT8,     F_0F,   OP_RGT8,       OP3_NONE,0,  no_WDS, 0xAD,     0x00,       P_386,       0)
insn(SHRD, 1,                   OP_RGT8,     F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xAC,     0x00,       P_386,       0)
insn(SHRD, 2,                   OP_M,        F_0F,   OP_RGT8,       OP3_NONE,0,  no_WDS, 0xAD,     0x00,       P_386,       0)
insn(SHRD, 3,                   OP_M,        F_0F,   OP_I8,         OP3_NONE,0,  no_WDS, 0xAC,     0x00,       P_386,       0)
ins (SIDT, sidt, 4,             OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x01,     0x08,       P_286,       0)
ins (STC, stc, 3,               OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xF9,     0x00,       P_86,        0)
ins (STD, std, 3,               OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xFD,     0x00,       P_86,        0)
ins (STI, sti, 3,               OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xFB,     0x00,       P_86,        0)
ins (SYSENTER, sysenter, 8,     OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x34,     0x00,       P_686,       0)
ins (SYSEXIT, sysexit,7,        OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x35,     0x00,       P_686p,      0)
ins (TEST, test, 4,             OP_A,        0,      OP_I,          OP3_NONE,0,  no_RM,  0xA8,     0x00,       P_86,        0)
insn(TEST, 1,                   OP_R,        0,      OP_R,          OP3_NONE,1,  0,      0x84,     0x00,       P_86,        0)
insn(TEST, 2,                   OP_R,        0,      OP_M,          OP3_NONE,1,  0,      0x84,     0x00,       P_86,        0)
insn(TEST, 3,                   OP_R,        0,      OP_I,          OP3_NONE,0,  0,      0xF6,     0x00,       P_86,        0)
insn(TEST, 4,                   OP_M,        0,      OP_R,          OP3_NONE,0,  0,      0x84,     0x00,       P_86,        0)
insn(TEST, 5,                   OP_M,        0,      OP_I,          OP3_NONE,0,  0,      0xF6,     0x00,       P_86,        0)
ins (UD2, ud2, 3,               OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x0B,     0x00,       P_686,       0)
ins (WAIT, wait, 4,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x9B,     0x00,       P_86,        0)
ins (WBINVD, wbinvd, 6,         OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x09,     0x00,       P_486,       0)
ins (WRMSR, wrmsr, 5,           OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x30,     0x00,       P_586,       0)
ins (XADD, xadd, 4,             OP_R,        F_0F,   OP_R,          OP3_NONE,0,  0,      0xC0,     0x00,       P_486,       0)
insn(XADD, 1,                   OP_M,        F_0F,   OP_R,          OP3_NONE,0,  0,      0xC0,     0x00,       P_486,       AP_LOCK)
ins (XCHG, xchg, 4,             OP_A,        0,      OP_RGT8,       OP3_NONE,0,  R_in_OP,0x90,     0x00,       P_86,        0)
insn(XCHG, 1,                   OP_RGT8,     0,      OP_A,          OP3_NONE,0,  R_in_OP,0x90,     0x00,       P_86,        0)
insn(XCHG, 2,                   OP_R,        0,      OP_R,          OP3_NONE,1,  0,      0x86,     0x00,       P_86,        0)
insn(XCHG, 3,                   OP_R,        0,      OP_M,          OP3_NONE,1,  0,      0x86,     0x00,       P_86,        AP_LOCK)
insn(XCHG, 4,                   OP_M,        0,      OP_R,          OP3_NONE,0,  0,      0x86,     0x00,       P_86,        AP_LOCK)
ins (XLAT, xlat, 4,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xD7,     0x00,       P_86,        0)
insn(XLAT, 1,                   OP_M,        0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xD7,     0x00,       P_86,        0)
ins (XLATB, xlatb, 5,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xD7,     0x00,       P_86,        0)
insn(XLATB, 1,                  OP_M,        0,      OP_NONE,       OP3_NONE,0,  no_RM,  0xD7,     0x00,       P_86,        0)

ins (SETA,  seta,  4,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x97,     0x00,       P_386,       0)
ins (SETAE, setae, 5,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x93,     0x00,       P_386,       0)
ins (SETB,  setb,  4,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x92,     0x00,       P_386,       0)
ins (SETBE, setbe, 5,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x96,     0x00,       P_386,       0)
ins (SETC,  setc,  4,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x92,     0x00,       P_386,       0)
ins (SETE,  sete,  4,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x94,     0x00,       P_386,       0)
ins (SETG,  setg,  4,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9F,     0x00,       P_386,       0)
ins (SETGE, setge, 5,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9D,     0x00,       P_386,       0)
ins (SETL,  setl,  4,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9C,     0x00,       P_386,       0)
ins (SETLE, setle, 5,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9E,     0x00,       P_386,       0)
ins (SETNA, setna, 5,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x96,     0x00,       P_386,       0)
ins (SETNAE,setnae,6,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x92,     0x00,       P_386,       0)
ins (SETNB, setnb, 5,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x93,     0x00,       P_386,       0)
ins (SETNBE,setnbe,6,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x97,     0x00,       P_386,       0)
ins (SETNC, setnc, 5,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x93,     0x00,       P_386,       0)
ins (SETNE, setne, 5,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x95,     0x00,       P_386,       0)
ins (SETNG, setng, 5,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9E,     0x00,       P_386,       0)
ins (SETNGE,setnge,6,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9C,     0x00,       P_386,       0)
ins (SETNL, setnl, 5,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9D,     0x00,       P_386,       0)
ins (SETNLE,setnle,6,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9F,     0x00,       P_386,       0)
ins (SETNO, setno, 5,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x91,     0x00,       P_386,       0)
ins (SETNP, setnp, 5,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9B,     0x00,       P_386,       0)
ins (SETNS, setns, 5,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x99,     0x00,       P_386,       0)
ins (SETNZ, setnz, 5,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x95,     0x00,       P_386,       0)
ins (SETO,  seto,  4,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x90,     0x00,       P_386,       0)
ins (SETP,  setp,  4,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9A,     0x00,       P_386,       0)
ins (SETPE, setpe, 5,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9A,     0x00,       P_386,       0)
ins (SETPO, setpo, 5,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x9B,     0x00,       P_386,       0)
ins (SETS,  sets,  4,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x98,     0x00,       P_386,       0)
ins (SETZ,  setz,  4,           OP_M8|OP_R8, F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x94,     0x00,       P_386,       0)

#define cmov( cond, code, condlc, x )      \
ins (CMOV##cond, cmov##condlc, 4+x,      OP_R,        F_0F,   OP_R,          OP3_NONE,1,  no_WDS, 0x40+code,0x00,   P_686,   0) \
insn(CMOV##cond, 1,                      OP_R,        F_0F,   OP_M,          OP3_NONE,1,  no_WDS, 0x40+code,0x00,   P_686,   0)

cmov( A,   0x7,   a, 1 )
cmov( AE,  0x3,  ae, 2 )
cmov( B,   0x2,   b, 1 )
cmov( BE,  0x6,  be, 2 )
cmov( C,   0x2,   c, 1 )
cmov( E,   0x4,   e, 1 )
cmov( G,   0xf,   g, 1 )
cmov( GE,  0xd,  ge, 2 )
cmov( L,   0xc,   l, 1 )
cmov( LE,  0xe,  le, 2 )
cmov( NA,  0x6,  na, 2 )
cmov( NAE, 0x2, nae, 3 )
cmov( NB,  0x3,  nb, 2 )
cmov( NBE, 0x7, nbe, 3 )
cmov( NC,  0x3,  nc, 2 )
cmov( NE,  0x5,  ne, 2 )
cmov( NG,  0xe,  ng, 2 )
cmov( NGE, 0xc, nge, 3 )
cmov( NL,  0xd,  nl, 2 )
cmov( NLE, 0xf, nle, 3 )
cmov( NO,  0x1,  no, 2 )
cmov( NP,  0xb,  np, 2 )
cmov( NS,  0x9,  ns, 2 )
cmov( NZ,  0x5,  nz, 2 )
cmov( O,   0x0,   o, 1 )
cmov( P,   0xa,   p, 1 )
cmov( PE,  0xa,  pe, 2 )
cmov( PO,  0xb,  po, 2 )
cmov( S,   0x8,   s, 1 )
cmov( Z,   0x4,   z, 1 )

#undef cmov

/* FPU opcodes */

ins (F2XM1, f2xm1, 5,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF0,       P_87,        0)
ins (FABS, fabs, 4,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xE1,       P_87,        0)
ins (FADD, fadd, 4,             OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xD8,     0xC0,       P_87,        0)
insn(FADD, 1,                   OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDC,     0xC0,       P_87,        0)
insn(FADD, 2,                   OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0x00,       P_87,        0)
insn(FADD, 3,                   OP_M64,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDC,     0x00,       P_87,        0)
insn(FADD, 4,                   OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0xC1,       P_87,        0)
ins (FADDP, faddp, 5,           OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDE,     0xC0,       P_87,        0)
ins (FBLD, fbld, 4,             OP_M80,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDF,     0x20,       P_87,        0)
ins (FBSTP, fbstp, 5,           OP_M80,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDF,     0x30,       P_87,        0)
ins (FCHS, fchs, 4,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xE0,       P_87,        0)
ins (FCLEX, fclex, 5,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE2,       P_87,        AP_FWAIT)
ins (FCMOVB, fcmovb, 6,         OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDA,     0xC0,       P_686,       0)
ins (FCMOVBE, fcmovbe, 7,       OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDA,     0xD0,       P_686,       0)
ins (FCMOVE, fcmove, 6,         OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDA,     0xC8,       P_686,       0)
ins (FCMOVNB, fcmovnb, 7,       OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDB,     0xC0,       P_686,       0)
ins (FCMOVNBE, fcmovnbe, 8,     OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDB,     0xD0,       P_686,       0)
ins (FCMOVNE, fcmovne, 7,       OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDB,     0xC8,       P_686,       0)
ins (FCMOVNU, fcmovnu, 7,       OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDB,     0xD8,       P_686,       0)
ins (FCMOVU, fcmovu, 6,         OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDA,     0xD8,       P_686,       0)
ins (FCOM, fcom, 4,             OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0xD0,       P_87,        0)
insn(FCOM, 1,                   OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0x10,       P_87,        0)
insn(FCOM, 2,                   OP_M64,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDC,     0x10,       P_87,        0)
insn(FCOM, 3,                   OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0xD1,       P_87,        0)
ins (FCOMI, fcomi, 5,           OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDB,     0xF0,       P_686,       0)
ins (FCOMIP, fcomip, 6,         OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDF,     0xF0,       P_686,       0)
ins (FCOMP, fcomp, 5,           OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0xD8,       P_87,        0)
insn(FCOMP, 1,                  OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0x18,       P_87,        0)
insn(FCOMP, 2,                  OP_M64,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDC,     0x18,       P_87,        0)
insn(FCOMP, 3,                  OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0xD9,       P_87,        0)
ins (FCOMPP, fcompp, 6,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0xD9,       P_87,        0)
ins (FCOS, fcos, 4,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xFF,       P_387,       0)
ins (FDECSTP, fdecstp, 7,       OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF6,       P_87,        0)
ins (FDISI, fdisi, 5,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE1,       P_87,        AP_FWAIT)
ins (FDIV, fdiv, 4,             OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDC,     0xF8,       P_87,        0)
insn(FDIV, 1,                   OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xD8,     0xF0,       P_87,        0)
insn(FDIV, 2,                   OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0x30,       P_87,        0)
insn(FDIV, 3,                   OP_M64,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDC,     0x30,       P_87,        0)
insn(FDIV, 4,                   OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0xF9,       P_87,        0)
ins (FDIVP, fdivp, 5,           OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDE,     0xF8,       P_87,        0)
ins (FDIVR, fdivr, 5,           OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDC,     0xF0,       P_87,        0)
insn(FDIVR, 1,                  OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xD8,     0xF8,       P_87,        0)
insn(FDIVR, 2,                  OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0x38,       P_87,        0)
insn(FDIVR, 3,                  OP_M64,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDC,     0x38,       P_87,        0)
insn(FDIVR, 4,                  OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0xF1,       P_87,        0)
ins (FDIVRP, fdivrp, 6,         OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDE,     0xF0,       P_87,        0)
ins (FENI, feni, 4,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE0,       P_87,        AP_FWAIT)
ins (FFREE, ffree, 5,           OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0xC0,       P_87,        0)
ins (FFREEP, ffreep, 6,         OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDF,     0xC0,       P_87,        0)
ins (FIADD, fiadd, 5,           OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0x00,       P_87,        0)
insn(FIADD, 1,                  OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0x00,       P_87,        0)
ins (FICOM, ficom, 5,           OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0x10,       P_87,        0)
insn(FICOM, 1,                  OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0x10,       P_87,        0)
ins (FICOMP, ficomp, 6,         OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0x18,       P_87,        0)
insn(FICOMP, 1,                 OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0x18,       P_87,        0)
ins (FIDIV, fidiv, 5,           OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0x30,       P_87,        0)
insn(FIDIV, 1,                  OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0x30,       P_87,        0)
ins (FIDIVR, fidivr, 6,         OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0x38,       P_87,        0)
insn(FIDIVR, 1,                 OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0x38,       P_87,        0)
ins (FILD, fild, 4,             OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0x00,       P_87,        0)
insn(FILD, 1,                   OP_M64,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDF,     0x28,       P_87,        0)
insn(FILD, 2,                   OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDF,     0x00,       P_87,        0)
ins (FIMUL, fimul, 5,           OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0x08,       P_87,        0)
insn(FIMUL, 1,                  OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0x08,       P_87,        0)
ins (FINCSTP, fincstp, 7,       OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF7,       P_87,        0)
ins (FINIT, finit, 5,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE3,       P_87,        AP_FWAIT)
ins (FIST, fist, 4,             OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0x10,       P_87,        0)
insn(FIST, 1,                   OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDF,     0x10,       P_87,        0)
ins (FISTP, fistp, 5,           OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0x18,       P_87,        0)
insn(FISTP, 1,                  OP_M64,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDF,     0x38,       P_87,        0)
insn(FISTP, 2,                  OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDF,     0x18,       P_87,        0)
ins (FISUB, fisub, 5,           OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0x20,       P_87,        0)
insn(FISUB, 1,                  OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0x20,       P_87,        0)
ins (FISUBR, fisubr, 6,         OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0x28,       P_87,        0)
insn(FISUBR, 1,                 OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0x28,       P_87,        0)
ins (FLD, fld, 3,               OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xC0,       P_87,        0)
insn(FLD, 1,                    OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x00,       P_87,        0)
insn(FLD, 2,                    OP_M64,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x00,       P_87,        0)
insn(FLD, 3,                    OP_M80,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0x28,       P_87,        0)
ins (FLD1, fld1, 4,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xE8,       P_87,        0)
ins (FLDCW, fldcw, 5,           OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x28,       P_87,        0)
ins (FLDENV, fldenv, 6,         OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x20,       P_87,        0)
ins (FLDENVD, fldenvd, 7,       OP_M,        F_32,   OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x20,       P_387,       0)
ins (FLDENVW, fldenvw, 7,       OP_M,        F_16,   OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x20,       P_87,        0)
ins (FLDL2E, fldl2e, 6,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xEA,       P_87,        0)
ins (FLDL2T, fldl2t, 6,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xE9,       P_87,        0)
ins (FLDLG2, fldlg2, 6,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xEC,       P_87,        0)
ins (FLDLN2, fldln2, 6,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xED,       P_87,        0)
ins (FLDPI, fldpi, 5,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xEB,       P_87,        0)
ins (FLDZ, fldz, 4,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xEE,       P_87,        0)
ins (FMUL, fmul, 4,             OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDC,     0xC8,       P_87,        0)
insn(FMUL, 1,                   OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xD8,     0xC8,       P_87,        0)
insn(FMUL, 2,                   OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0x08,       P_87,        0)
insn(FMUL, 3,                   OP_M64,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDC,     0x08,       P_87,        0)
insn(FMUL, 4,                   OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0xC9,       P_87,        0)
ins (FMULP, fmulp, 5,           OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDE,     0xC8,       P_87,        0)
ins (FNCLEX, fnclex, 6,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE2,       P_87,        AP_NO_FWAIT)
ins (FNDISI, fndisi, 6,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE1,       P_87,        AP_NO_FWAIT)
ins (FNENI, fneni, 5,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE0,       P_87,        AP_NO_FWAIT)
ins (FNINIT, fninit, 6,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE3,       P_87,        AP_NO_FWAIT)
ins (FNOP, fnop, 4,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xD0,       P_87,        0)
ins (FNSAVE, fnsave, 6,         OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x30,       P_87,        AP_NO_FWAIT)
ins (FNSAVED, fnsaved, 7,       OP_M,        F_32,   OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x30,       P_387,       AP_NO_FWAIT)
ins (FNSAVEW, fnsavew, 7,       OP_M,        F_16,   OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x30,       P_87,        AP_NO_FWAIT)
ins (FNSTCW, fnstcw, 6,         OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x38,       P_87,        AP_NO_FWAIT)
ins (FNSTENV, fnstenv, 7,       OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x30,       P_87,        AP_NO_FWAIT)
ins (FNSTENVD, fnstenvd, 8,     OP_M,        F_32,   OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x30,       P_387,       AP_NO_FWAIT)
ins (FNSTENVW, fnstenvw, 8,     OP_M,        F_16,   OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x30,       P_87,        AP_NO_FWAIT)
ins (FNSTSW, fnstsw, 6,         OP_AX,       0,      OP_NONE,       OP3_NONE,0,  no_WDS, 0xDF,     0xE0,       P_287,       AP_NO_FWAIT)
insn(FNSTSW, 1,                 OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x38,       P_87,        AP_NO_FWAIT)
ins (FPATAN, fpatan, 6,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF3,       P_87,        0)
ins (FPREM, fprem, 5,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF8,       P_87,        0)
ins (FPREM1, fprem1, 6,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF5,       P_387,       0)
ins (FPTAN, fptan, 5,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF2,       P_87,        0)
ins (FRNDINT, frndint, 7,       OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xFC,       P_87,        0)
ins (FRSTOR, frstor, 6,         OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x20,       P_87,        0)
ins (FRSTORD, frstord, 7,       OP_M,        F_32,   OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x20,       P_387,       0)
ins (FRSTORW, frstorw, 7,       OP_M,        F_16,   OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x20,       P_87,        0)
ins (FSAVE, fsave, 5,           OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x30,       P_87,        AP_FWAIT)
ins (FSAVED, fsaved, 6,         OP_M,        F_32,   OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x30,       P_387,       AP_FWAIT)
ins (FSAVEW, fsavew, 6,         OP_M,        F_16,   OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x30,       P_87,        AP_FWAIT)
ins (FSCALE, fscale, 6,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xFD,       P_87,        0)
ins (FSETPM, fsetpm, 6,         OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0xE4,       P_287,       0)
ins (FSIN, fsin, 4,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xFE,       P_387,       0)
ins (FSINCOS, fsincos, 7,       OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xFB,       P_387,       0)
ins (FSQRT, fsqrt, 5,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xFA,       P_87,        0)
ins (FST, fst, 3,               OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0xD0,       P_87,        0)
insn(FST, 1,                    OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x10,       P_87,        0)
insn(FST, 2,                    OP_M64,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x10,       P_87,        0)
ins (FSTCW, fstcw, 5,           OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x38,       P_87,        AP_FWAIT)
ins (FSTENV, fstenv, 6,         OP_M,        0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x30,       P_87,        AP_FWAIT)
ins (FSTENVD, fstenvd, 7,       OP_M,        F_32,   OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x30,       P_387,       AP_FWAIT)
ins (FSTENVW, fstenvw, 7,       OP_M,        F_16,   OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x30,       P_87,        AP_FWAIT)
ins (FSTP, fstp, 4,             OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0xD8,       P_87,        0)
insn(FSTP, 1,                   OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0x18,       P_87,        0)
insn(FSTP, 2,                   OP_M64,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x18,       P_87,        0)
insn(FSTP, 3,                   OP_M80,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDB,     0x38,       P_87,        0)
ins (FSTSW, fstsw, 5,           OP_AX,       0,      OP_NONE,       OP3_NONE,0,  no_WDS, 0xDF,     0xE0,       P_287,       AP_FWAIT)
insn(FSTSW, 1,                  OP_M16,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0x38,       P_87,        AP_FWAIT)
ins (FSUB, fsub, 4,             OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDC,     0xE8,       P_87,        0)
insn(FSUB, 1,                   OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xD8,     0xE0,       P_87,        0)
insn(FSUB, 2,                   OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0x20,       P_87,        0)
insn(FSUB, 3,                   OP_M64,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDC,     0x20,       P_87,        0)
insn(FSUB, 4,                   OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0xE9,       P_87,        0)
ins (FSUBP, fsubp, 5,           OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDE,     0xE8,       P_87,        0)
ins (FSUBR, fsubr, 5,           OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDC,     0xE0,       P_87,        0)
insn(FSUBR, 1,                  OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xD8,     0xE8,       P_87,        0)
insn(FSUBR, 2,                  OP_M32,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD8,     0x28,       P_87,        0)
insn(FSUBR, 3,                  OP_M64,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDC,     0x28,       P_87,        0)
insn(FSUBR, 4,                  OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDE,     0xE1,       P_87,        0)
ins (FSUBRP, fsubrp, 6,         OP_STI,      0,      OP_ST,         OP3_NONE,0,  0,      0xDE,     0xE0,       P_87,        0)
ins (FTST, ftst, 4,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xE4,       P_87,        0)
ins (FUCOM, fucom, 5,           OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0xE0,       P_387,       0)
insn(FUCOM, 1,                  OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0xE1,       P_387,       0)
ins (FUCOMI, fucomi, 6,         OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDB,     0xE8,       P_686,       0)
ins (FUCOMIP, fucomip, 7,       OP_ST,       0,      OP_STI,        OP3_NONE,0,  0,      0xDF,     0xE8,       P_686,       0)
ins (FUCOMP, fucomp, 6,         OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0xE8,       P_387,       0)
insn(FUCOMP, 1,                 OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDD,     0xE9,       P_387,       0)
ins (FUCOMPP, fucompp, 7,       OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xDA,     0xE9,       P_387,       0)
ins (FWAIT, fwait, 5,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x9B,     0x00,       P_87,        0)
ins (FXAM, fxam, 4,             OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xE5,       P_87,        0)
ins (FXCH, fxch, 4,             OP_STI,      0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xC8,       P_87,        0)
insn(FXCH, 1,                   OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xC9,       P_87,        0)
ins (FXRSTOR, fxrstor, 7,       OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xAE,     0x08,       P_686|P_SSE1,0)
ins (FXSAVE, fxsave, 6,         OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xAE,     0x00,       P_686|P_SSE1,0)
ins (FXTRACT, fxtract, 7,       OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF4,       P_87,        0)
ins (FYL2X, fyl2x, 5,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF1,       P_87,        0)
ins (FYL2XP1, fyl2xp1, 7,       OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  0,      0xD9,     0xF9,       P_87,        0)

/* MMX/SSE related opcodes (except SSE instructions CMPSD and MOVSD) */

ins (ADDPD, addpd, 5,           OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x58,     0x00,       P_686|P_SSE2,0)
ins (ADDPS, addps, 5,           OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x58,     0x00,       P_686|P_SSE1,0)
ins (ADDSD, addsd, 5,           OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x58,     0x00,       P_686|P_SSE2,0)
ins (ADDSS, addss, 5,           OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_NONE,1,  no_WDS, 0x58,     0x00,       P_686|P_SSE1,0)
ins (ANDNPD, andnpd, 6,         OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x55,     0x00,       P_686|P_SSE2,0)
ins (ANDNPS, andnps, 6,         OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x55,     0x00,       P_686|P_SSE1,0)
ins (ANDPD, andpd, 5,           OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x54,     0x00,       P_686|P_SSE2,0)
ins (ANDPS, andps, 5,           OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x54,     0x00,       P_686|P_SSE1,0)
ins (CLFLUSH, clflush, 7,       OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xAE,     0x38,       P_686|P_SSE2,0)

ins (CMPPD, cmppd, 5,           OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPPS, cmpps, 5,           OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_I8_U,1,  no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
ins (CMPSS, cmpss, 5,           OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_I8_U,1,  no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)

/* CMPPD pseudo-ops */
ins (CMPEQPD, cmpeqpd, 7,       OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_HID|0,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPLTPD, cmpltpd, 7,       OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_HID|1,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPLEPD, cmplepd, 7,       OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_HID|2,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPUNORDPD, cmpunordpd, 10,OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_HID|3,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPNEQPD, cmpneqpd, 8,     OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_HID|4,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPNLTPD, cmpnltpd, 8,     OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_HID|5,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPNLEPD, cmpnlepd, 8,     OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_HID|6,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPORDPD, cmpordpd, 8,     OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_HID|7,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
/* CMPPS pseudo-ops */
ins (CMPEQPS, cmpeqps, 7,       OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_HID|0,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
ins (CMPLTPS, cmpltps, 7,       OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_HID|1,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
ins (CMPLEPS, cmpleps, 7,       OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_HID|2,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
ins (CMPUNORDPS, cmpunordps, 10,OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_HID|3,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
ins (CMPNEQPS, cmpneqps, 8,     OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_HID|4,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
ins (CMPNLTPS, cmpnltps, 8,     OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_HID|5,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
ins (CMPNLEPS, cmpnleps, 8,     OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_HID|6,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
ins (CMPORDPS, cmpordps, 8,     OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_HID|7,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
/* CMPSD pseudo-ops */
ins (CMPEQSD, cmpeqsd, 7,       OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_HID|0,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPLTSD, cmpltsd, 7,       OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_HID|1,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPLESD, cmplesd, 7,       OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_HID|2,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPUNORDSD, cmpunordsd, 10,OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_HID|3,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPNEQSD, cmpneqsd, 8,     OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_HID|4,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPNLTSD, cmpnltsd, 8,     OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_HID|5,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPNLESD, cmpnlesd, 8,     OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_HID|6,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPORDSD, cmpordsd, 8,     OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_HID|7,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
/* CMPSS pseudo-ops */
ins (CMPEQSS, cmpeqss, 7,       OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_HID|0,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
ins (CMPLTSS, cmpltss, 7,       OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_HID|1,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
ins (CMPLESS, cmpless, 7,       OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_HID|2,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
ins (CMPUNORDSS, cmpunordss, 10,OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_HID|3,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
ins (CMPNEQSS, cmpneqss, 8,     OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_HID|4,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
ins (CMPNLTSS, cmpnltss, 8,     OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_HID|5,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
ins (CMPNLESS, cmpnless, 8,     OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_HID|6,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
ins (CMPORDSS, cmpordss, 8,     OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_HID|7,1, no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)

ins (COMISD, comisd, 6,         OP_XMM,      F_660F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x2F,     0x00,       P_686|P_SSE2,0)
ins (COMISS, comiss, 6,         OP_XMM,      F_0F,   OP_XMM|OP_M32, OP3_NONE,1,  no_WDS, 0x2F,     0x00,       P_686|P_SSE1,0)
ins (CVTDQ2PD, cvtdq2pd, 8,     OP_XMM,      F_F30F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0xE6,     0x00,       P_686|P_SSE2,0)
ins (CVTDQ2PS, cvtdq2ps, 8,     OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x5B,     0x00,       P_686|P_SSE2,0)
ins (CVTPD2DQ, cvtpd2dq, 8,     OP_XMM,      F_F20F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xE6,     0x00,       P_686|P_SSE2,0)
ins (CVTPD2PI, cvtpd2pi, 8,     OP_MMX,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x2D,     0x00,       P_686|P_SSE2,0)
ins (CVTPD2PS, cvtpd2ps, 8,     OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x5A,     0x00,       P_686|P_SSE2,0)
ins (CVTPI2PD, cvtpi2pd, 8,     OP_XMM,      F_660F, OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x2A,     0x00,       P_686|P_SSE2,0)
ins (CVTPI2PS, cvtpi2ps, 8,     OP_XMM,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x2A,     0x00,       P_686|P_SSE1,0)
ins (CVTPS2DQ, cvtps2dq, 8,     OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x5B,     0x00,       P_686|P_SSE2,0)
ins (CVTPS2PD, cvtps2pd, 8,     OP_XMM,      F_0F,   OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x5A,     0x00,       P_686|P_SSE2,0)
ins (CVTPS2PI, cvtps2pi, 8,     OP_MMX,      F_0F,   OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x2D,     0x00,       P_686|P_SSE1,0)
ins (CVTSD2SI, cvtsd2si, 8,     OP_RGT16,    F_F20F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x2D,     0x00,       P_686|P_SSE2,0)
ins (CVTSD2SS, cvtsd2ss, 8,     OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x5A,     0x00,       P_686|P_SSE2,0)
ins (CVTSI2SD, cvtsi2sd, 8,     OP_XMM,      F_F20F, OP_RGT16,      OP3_NONE,1,  no_WDS, 0x2A,     0x00,       P_686|P_SSE2,0)
insn(CVTSI2SD, 1,               OP_XMM,      F_F20F, OP_M,          OP3_NONE,1,  no_WDS, 0x2A,     0x00,       P_686|P_SSE2,0)
ins (CVTSI2SS, cvtsi2ss, 8,     OP_XMM,      F_F30F, OP_RGT16,      OP3_NONE,1,  no_WDS, 0x2A,     0x00,       P_686|P_SSE1,0)
insn(CVTSI2SS, 1,               OP_XMM,      F_F30F, OP_M,          OP3_NONE,1,  no_WDS, 0x2A,     0x00,       P_686|P_SSE1,0)
ins (CVTSS2SD, cvtss2sd, 8,     OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_NONE,1,  no_WDS, 0x5A,     0x00,       P_686|P_SSE2,0)
ins (CVTSS2SI, cvtss2si, 8,     OP_RGT16,    F_F30F, OP_XMM|OP_M32, OP3_NONE,1,  no_WDS, 0x2D,     0x00,       P_686|P_SSE1,0)
ins (CVTTPD2DQ, cvttpd2dq, 9,   OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xE6,     0x00,       P_686|P_SSE2,0)
ins (CVTTPD2PI, cvttpd2pi, 9,   OP_MMX,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x2C,     0x00,       P_686|P_SSE2,0)
ins (CVTTPS2DQ, cvttps2dq, 9,   OP_XMM,      F_F30F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x5B,     0x00,       P_686|P_SSE2,0)
ins (CVTTPS2PI, cvttps2pi, 9,   OP_MMX,      F_0F,   OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x2C,     0x00,       P_686|P_SSE1,0)
ins (CVTTSD2SI, cvttsd2si, 9,   OP_RGT16,    F_F20F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x2C,     0x00,       P_686|P_SSE2,0)
ins (CVTTSS2SI, cvttss2si, 9,   OP_RGT16,    F_F30F, OP_XMM|OP_M32, OP3_NONE,1,  no_WDS, 0x2C,     0x00,       P_686|P_SSE1,0)
ins (DIVPD, divpd, 5,           OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x5E,     0x00,       P_686|P_SSE2,0)
ins (DIVPS, divps, 5,           OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x5E,     0x00,       P_686|P_SSE1,0)
ins (DIVSD, divsd, 5,           OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x5E,     0x00,       P_686|P_SSE2,0)
ins (DIVSS, divss, 5,           OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_NONE,1,  no_WDS, 0x5E,     0x00,       P_686|P_SSE1,0)
ins (EMMS, emms, 4,             OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x77,     0x00,       P_586|P_MMX, 0)
ins (LDMXCSR, ldmxcsr, 7,       OP_M32,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xAE,     0x10,       P_686|P_SSE1,0)
ins (LFENCE, lfence, 6,         OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xAE,     0xE8,       P_686|P_SSE2,0)
ins (MASKMOVDQU, maskmovdqu, 10,OP_XMM,      F_660F, OP_XMM,        OP3_NONE,1,  no_WDS, 0xF7,     0x00,       P_686|P_SSE2,0)
ins (MASKMOVQ, maskmovq, 8,     OP_MMX,      F_0F,   OP_MMX,        OP3_NONE,1,  no_WDS, 0xF7,     0x00,       P_686|P_SSE1,0)
ins (MAXPD, maxpd, 5,           OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x5F,     0x00,       P_686|P_SSE2,0)
ins (MAXPS, maxps, 5,           OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x5F,     0x00,       P_686|P_SSE1,0)
ins (MAXSD, maxsd, 5,           OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x5F,     0x00,       P_686|P_SSE2,0)
ins (MAXSS, maxss, 5,           OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_NONE,1,  no_WDS, 0x5F,     0x00,       P_686|P_SSE1,0)
ins (MFENCE, mfence, 6,         OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xAE,     0xF0,       P_686|P_SSE2,0)
ins (MINPD, minpd, 5,           OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x5D,     0x00,       P_686|P_SSE2,0)
ins (MINPS, minps, 5,           OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x5D,     0x00,       P_686|P_SSE1,0)
ins (MINSD, minsd, 5,           OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x5D,     0x00,       P_686|P_SSE2,0)
ins (MINSS, minss, 5,           OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_NONE,1,  no_WDS, 0x5D,     0x00,       P_686|P_SSE1,0)
ins (MOVAPD, movapd, 6,         OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x28,     0x00,       P_686|P_SSE2,0)
insn(MOVAPD, 1,                 OP_M128,     F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x29,     0x00,       P_686|P_SSE2,0)
ins (MOVAPS, movaps, 6,         OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x28,     0x00,       P_686|P_SSE1,0)
insn(MOVAPS, 1,                 OP_M128,     F_0F,   OP_XMM,        OP3_NONE,0,  no_WDS, 0x29,     0x00,       P_686|P_SSE1,0)
ins (MOVD, movd, 4,             OP_MMX,      F_0F,   OP_RGT16,      OP3_NONE,1,  no_WDS, 0x6E,     0x00,       P_586|P_MMX, 0)
insn(MOVD, 1,                   OP_MMX,      F_0F,   OP_M32,        OP3_NONE,1,  no_WDS, 0x6E,     0x00,       P_586|P_MMX, 0)
insn(MOVD, 2,                   OP_XMM,      F_660F, OP_RGT16,      OP3_NONE,1,  no_WDS, 0x6E,     0x00,       P_686|P_SSE2,0)
insn(MOVD, 3,                   OP_XMM,      F_660F, OP_M32,        OP3_NONE,1,  no_WDS, 0x6E,     0x00,       P_686|P_SSE2,0)
insn(MOVD, 4,                   OP_RGT16,    F_0F,   OP_MMX,        OP3_NONE,0,  no_WDS, 0x7E,     0x00,       P_586|P_MMX, 0)
insn(MOVD, 5,                   OP_RGT16,    F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x7E,     0x00,       P_686|P_SSE2,0)
insn(MOVD, 6,                   OP_M32,      F_0F,   OP_MMX,        OP3_NONE,0,  no_WDS, 0x7E,     0x00,       P_586|P_MMX, 0)
insn(MOVD, 7,                   OP_M32,      F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x7E,     0x00,       P_686|P_SSE2,0)
ins (MOVDQ2Q, movdq2q, 7,       OP_MMX,      F_F20F, OP_XMM,        OP3_NONE,1,  no_WDS, 0xD6,     0x00,       P_686|P_SSE2,0)
ins (MOVDQA, movdqa, 6,         OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x6F,     0x00,       P_686|P_SSE2,0)
insn(MOVDQA, 1,                 OP_M128,     F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x7F,     0x00,       P_686|P_SSE2,0)
ins (MOVDQU, movdqu, 6,         OP_XMM,      F_F30F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x6F,     0x00,       P_686|P_SSE2,0)
insn(MOVDQU, 1,                 OP_M128,     F_F30F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x7F,     0x00,       P_686|P_SSE2,0)
ins (MOVHLPS, movhlps, 7,       OP_XMM,      F_0F,   OP_XMM,        OP3_NONE,1,  no_WDS, 0x12,     0x00,       P_686|P_SSE1,0)
ins (MOVHPD, movhpd, 6,         OP_XMM,      F_660F, OP_M64,        OP3_NONE,1,  no_WDS, 0x16,     0x00,       P_686|P_SSE2,0)
insn(MOVHPD, 1,                 OP_M64,      F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x17,     0x00,       P_686|P_SSE2,0)
ins (MOVHPS, movhps, 6,         OP_XMM,      F_0F,   OP_M64,        OP3_NONE,1,  no_WDS, 0x16,     0x00,       P_686|P_SSE1,0)
insn(MOVHPS, 1,                 OP_M64,      F_0F,   OP_XMM,        OP3_NONE,0,  no_WDS, 0x17,     0x00,       P_686|P_SSE1,0)
ins (MOVLHPS, movlhps, 7,       OP_XMM,      F_0F,   OP_XMM,        OP3_NONE,1,  no_WDS, 0x16,     0x00,       P_686|P_SSE1,0)
ins (MOVLPD, movlpd, 6,         OP_XMM,      F_660F, OP_M64,        OP3_NONE,1,  no_WDS, 0x12,     0x00,       P_686|P_SSE2,0)
insn(MOVLPD, 1,                 OP_M64,      F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x13,     0x00,       P_686|P_SSE2,0)
ins (MOVLPS, movlps, 6,         OP_XMM,      F_0F,   OP_M64,        OP3_NONE,1,  no_WDS, 0x12,     0x00,       P_686|P_SSE1,0)
insn(MOVLPS, 1,                 OP_M64,      F_0F,   OP_XMM,        OP3_NONE,0,  no_WDS, 0x13,     0x00,       P_686|P_SSE1,0)
ins (MOVMSKPD, movmskpd, 8,     OP_RGT16,    F_660F, OP_XMM,        OP3_NONE,1,  no_WDS, 0x50,     0x00,       P_686|P_SSE2,0)
ins (MOVMSKPS, movmskps, 8,     OP_RGT16,    F_0F,   OP_XMM,        OP3_NONE,1,  no_WDS, 0x50,     0x00,       P_686|P_SSE1,0)
ins (MOVNTDQ, movntdq, 7,       OP_M128,     F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0xE7,     0x00,       P_686|P_SSE2,0)
ins (MOVNTI, movnti, 6,         OP_M,        F_0F,   OP_RGT16,      OP3_NONE,0,  no_WDS, 0xC3,     0x00,       P_686|P_SSE2,0)
ins (MOVNTPD, movntpd, 7,       OP_M128,     F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x2B,     0x00,       P_686|P_SSE2,0)
ins (MOVNTPS, movntps, 7,       OP_M128,     F_0F,   OP_XMM,        OP3_NONE,0,  no_WDS, 0x2B,     0x00,       P_686|P_SSE1,0)
ins (MOVNTQ, movntq, 6,         OP_M64,      F_0F,   OP_MMX,        OP3_NONE,0,  no_WDS, 0xE7,     0x00,       P_686|P_SSE1,0)
ins (MOVQ, movq, 4,             OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x6F,     0x00,       P_586|P_MMX, 0)
insn(MOVQ, 1,                   OP_XMM,      F_F30F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x7E,     0x00,       P_686|P_SSE2,0)
insn(MOVQ, 2,                   OP_M64,      F_0F,   OP_MMX,        OP3_NONE,0,  no_WDS, 0x7F,     0x00,       P_586|P_MMX, 0)
insn(MOVQ, 3,                   OP_M64,      F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0xD6,     0x00,       P_686|P_SSE2,0)
ins (MOVQ2DQ, movq2dq, 7,       OP_XMM,      F_F30F, OP_MMX,        OP3_NONE,1,  no_WDS, 0xD6,     0x00,       P_686|P_SSE2,0)
ins (MOVSS, movss, 5,           OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_NONE,1,  no_WDS, 0x10,     0x00,       P_686|P_SSE1,0)
insn(MOVSS, 1,                  OP_M32,      F_F30F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x11,     0x00,       P_686|P_SSE1,0)
ins (MOVUPD, movupd, 6,         OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x10,     0x00,       P_686|P_SSE2,0)
insn(MOVUPD, 1,                 OP_M128,     F_660F, OP_XMM,        OP3_NONE,0,  no_WDS, 0x11,     0x00,       P_686|P_SSE2,0)
ins (MOVUPS, movups, 6,         OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x10,     0x00,       P_686|P_SSE1,0)
insn(MOVUPS, 1,                 OP_M128,     F_0F,   OP_XMM,        OP3_NONE,0,  no_WDS, 0x11,     0x00,       P_686|P_SSE1,0)
ins (MULPD, mulpd, 5,           OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x59,     0x00,       P_686|P_SSE2,0)
ins (MULPS, mulps, 5,           OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x59,     0x00,       P_686|P_SSE1,0)
ins (MULSD, mulsd, 5,           OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x59,     0x00,       P_686|P_SSE2,0)
ins (MULSS, mulss, 5,           OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_NONE,1,  no_WDS, 0x59,     0x00,       P_686|P_SSE1,0)
ins (ORPD, orpd, 4,             OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x56,     0x00,       P_686|P_SSE2,0)
ins (ORPS, orps, 4,             OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x56,     0x00,       P_686|P_SSE1,0)
ins (PACKSSDW, packssdw, 8,     OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x6B,     0x00,       P_586|P_MMX, 0)
insn(PACKSSDW, 1,               OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x6B,     0x00,       P_686|P_SSE2,0)
ins (PACKSSWB, packsswb, 8,     OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x63,     0x00,       P_586|P_MMX, 0)
insn(PACKSSWB, 1,               OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x63,     0x00,       P_686|P_SSE2,0)
ins (PACKUSWB, packuswb, 8,     OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x67,     0x00,       P_586|P_MMX, 0)
insn(PACKUSWB, 1,               OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x67,     0x00,       P_686|P_SSE2,0)
ins (PADDB, paddb, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xFC,     0x00,       P_586|P_MMX, 0)
insn(PADDB, 1,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xFC,     0x00,       P_686|P_SSE2,0)
ins (PADDW, paddw, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xFD,     0x00,       P_586|P_MMX, 0)
insn(PADDW, 1,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xFD,     0x00,       P_686|P_SSE2,0)
ins (PADDD, paddd, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xFE,     0x00,       P_586|P_MMX, 0)
insn(PADDD, 1,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xFE,     0x00,       P_686|P_SSE2,0)
ins (PADDQ, paddq, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xD4,     0x00,       P_686|P_SSE2,0)
insn(PADDQ, 1,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xD4,     0x00,       P_686|P_SSE2,0)
ins (PADDSB, paddsb, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xEC,     0x00,       P_586|P_MMX, 0)
insn(PADDSB, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xEC,     0x00,       P_686|P_SSE2,0)
ins (PADDSW, paddsw, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xED,     0x00,       P_586|P_MMX, 0)
insn(PADDSW, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xED,     0x00,       P_686|P_SSE2,0)
ins (PADDUSB, paddusb, 7,       OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xDC,     0x00,       P_586|P_MMX, 0)
insn(PADDUSB, 1,                OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xDC,     0x00,       P_686|P_SSE2,0)
ins (PADDUSW, paddusw, 7,       OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xDD,     0x00,       P_586|P_MMX, 0)
insn(PADDUSW, 1,                OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xDD,     0x00,       P_686|P_SSE2,0)
ins (PAND, pand, 4,             OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xDB,     0x00,       P_586|P_MMX, 0)
insn(PAND, 1,                   OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xDB,     0x00,       P_686|P_SSE2,0)
ins (PANDN, pandn, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xDF,     0x00,       P_586|P_MMX, 0)
insn(PANDN, 1,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xDF,     0x00,       P_686|P_SSE2,0)
ins (PAUSE, pause, 5,           OP_NONE,     F_F3,   OP_NONE,       OP3_NONE,0,  no_RM,  0x90,     0x00,       P_686|P_SSE2,0)
ins (PAVGB, pavgb, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xE0,     0x00,       P_686|P_SSE1,0)
insn(PAVGB, 1,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xE0,     0x00,       P_686|P_SSE2,0)
ins (PAVGW, pavgw, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xE3,     0x00,       P_686|P_SSE1,0)
insn(PAVGW, 1,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xE3,     0x00,       P_686|P_SSE2,0)
ins (PCMPEQB, pcmpeqb, 7,       OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x74,     0x00,       P_586|P_MMX, 0)
insn(PCMPEQB, 1,                OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x74,     0x00,       P_686|P_SSE2,0)
ins (PCMPEQD, pcmpeqd, 7,       OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x76,     0x00,       P_586|P_MMX, 0)
insn(PCMPEQD, 1,                OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x76,     0x00,       P_686|P_SSE2,0)
ins (PCMPEQW, pcmpeqw, 7,       OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x75,     0x00,       P_586|P_MMX, 0)
insn(PCMPEQW, 1,                OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x75,     0x00,       P_686|P_SSE2,0)
ins (PCMPGTB, pcmpgtb, 7,       OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x64,     0x00,       P_586|P_MMX, 0)
insn(PCMPGTB, 1,                OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x64,     0x00,       P_686|P_SSE2,0)
ins (PCMPGTD, pcmpgtd, 7,       OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x66,     0x00,       P_586|P_MMX, 0)
insn(PCMPGTD, 1,                OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x66,     0x00,       P_686|P_SSE2,0)
ins (PCMPGTW, pcmpgtw, 7,       OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x65,     0x00,       P_586|P_MMX, 0)
insn(PCMPGTW, 1,                OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x65,     0x00,       P_686|P_SSE2,0)
ins (PEXTRW, pextrw, 6,         OP_RGT16,    F_0F,   OP_MMX,        OP3_I8_U,1,  no_WDS, 0xC5,     0x00,       P_686|P_SSE1,0)
insn(PEXTRW, 1,                 OP_RGT16,    F_660F, OP_XMM,        OP3_I8_U,1,  no_WDS, 0xC5,     0x00,       P_686|P_SSE1,0)
#if SSE4SUPP /* SSE 4.1 */
insn(PEXTRW, 2,                 OP_M16,      F_660F, OP_XMM,        OP3_I8_U,0,  no_WDSx,0x3A,     0x15,       P_686|P_SSE4,0)
#endif
ins (PINSRW, pinsrw, 6,         OP_MMX,      F_0F,   OP_R32,        OP3_I8_U,1,  no_WDS, 0xC4,     0x00,       P_686|P_SSE1,0)
insn(PINSRW, 1,                 OP_MMX,      F_0F,   OP_M,          OP3_I8_U,1,  no_WDS, 0xC4,     0x00,       P_686|P_SSE1,0)
insn(PINSRW, 2,                 OP_XMM,      F_660F, OP_R32,        OP3_I8_U,1,  no_WDS, 0xC4,     0x00,       P_686|P_SSE1,0)
insn(PINSRW, 3,                 OP_XMM,      F_660F, OP_M,          OP3_I8_U,1,  no_WDS, 0xC4,     0x00,       P_686|P_SSE1,0)
ins (PMADDWD, pmaddwd, 7,       OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xF5,     0x00,       P_586|P_MMX, 0)
insn(PMADDWD, 1,                OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xF5,     0x00,       P_686|P_SSE2,0)
ins (PMAXSW, pmaxsw, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xEE,     0x00,       P_686|P_SSE1,0)
insn(PMAXSW, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xEE,     0x00,       P_686|P_SSE2,0)
ins (PMAXUB, pmaxub, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xDE,     0x00,       P_686|P_SSE1,0)
insn(PMAXUB, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xDE,     0x00,       P_686|P_SSE2,0)
ins (PMINSW, pminsw, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xEA,     0x00,       P_686|P_SSE1,0)
insn(PMINSW, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xEA,     0x00,       P_686|P_SSE2,0)
ins (PMINUB, pminub, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xDA,     0x00,       P_686|P_SSE1,0)
insn(PMINUB, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xDA,     0x00,       P_686|P_SSE2,0)
ins (PMOVMSKB, pmovmskb, 8,     OP_RGT16,    F_0F,   OP_MMX,        OP3_NONE,1,  no_WDS, 0xD7,     0x00,       P_686|P_SSE1,0)
insn(PMOVMSKB, 1,               OP_RGT16,    F_660F, OP_XMM,        OP3_NONE,1,  no_WDS, 0xD7,     0x00,       P_686|P_SSE2,0)
ins (PMULHUW, pmulhuw, 7,       OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xE4,     0x00,       P_586|P_SSE1,0)
insn(PMULHUW, 1,                OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xE4,     0x00,       P_686|P_SSE2,0)
ins (PMULHW, pmulhw, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xE5,     0x00,       P_586|P_MMX, 0)
insn(PMULHW, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xE5,     0x00,       P_686|P_SSE2,0)
ins (PMULLW, pmullw, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xD5,     0x00,       P_586|P_MMX, 0)
insn(PMULLW, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xD5,     0x00,       P_686|P_SSE2,0)
ins (PMULUDQ, pmuludq, 7,       OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xF4,     0x00,       P_686|P_SSE2,0)
insn(PMULUDQ, 1,                OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xF4,     0x00,       P_686|P_SSE2,0)
ins (POR, por, 3,               OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xEB,     0x00,       P_586|P_MMX, 0)
insn(POR,  1,                   OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xEB,     0x00,       P_686|P_SSE2,0)
ins (PREFETCHNTA,prefetchnta,11,OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x18,     0x00,       P_686|P_SSE1,0)
ins (PREFETCHT0, prefetcht0, 10,OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x18,     0x08,       P_686|P_SSE1,0)
ins (PREFETCHT1, prefetcht1, 10,OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x18,     0x10,       P_686|P_SSE1,0)
ins (PREFETCHT2, prefetcht2, 10,OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x18,     0x18,       P_686|P_SSE1,0)
ins (PSADBW, psadbw, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xF6,     0x00,       P_686|P_SSE1,0)
insn(PSADBW, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xF6,     0x00,       P_686|P_SSE2,0)
ins (PSHUFD, pshufd, 6,         OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDS, 0x70,     0x00,       P_686|P_SSE2,0)
ins (PSHUFHW, pshufhw, 7,       OP_XMM,      F_F30F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDS, 0x70,     0x00,       P_686|P_SSE2,0)
ins (PSHUFLW, pshuflw, 7,       OP_XMM,      F_F20F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDS, 0x70,     0x00,       P_686|P_SSE2,0)
ins (PSHUFW, pshufw, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_I8_U,1,  no_WDS, 0x70,     0x00,       P_686|P_SSE1,0)
ins (PSLLD, pslld, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xF2,     0x00,       P_586|P_MMX, 0)
insn(PSLLD, 1,                  OP_MMX,      F_0F,   OP_I8_U,       OP3_NONE,0,  no_WDS, 0x72,     0x30,       P_586|P_MMX, 0)
insn(PSLLD, 2,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xF2,     0x00,       P_686|P_SSE2,0)
insn(PSLLD, 3,                  OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x72,     0x30,       P_686|P_SSE2,0)
ins (PSLLDQ, pslldq, 6,         OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x73,     0x38,       P_686|P_SSE2,0)
ins (PSLLQ, psllq, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xF3,     0x00,       P_586|P_MMX, 0)
insn(PSLLQ, 1,                  OP_MMX,      F_0F,   OP_I8_U,       OP3_NONE,0,  no_WDS, 0x73,     0x30,       P_586|P_MMX, 0)
insn(PSLLQ, 2,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xF3,     0x00,       P_686|P_SSE2,0)
insn(PSLLQ, 3,                  OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x73,     0x30,       P_686|P_SSE2,0)
ins (PSLLW, psllw, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xF1,     0x00,       P_586|P_MMX, 0)
insn(PSLLW, 1,                  OP_MMX,      F_0F,   OP_I8_U,       OP3_NONE,0,  no_WDS, 0x71,     0x30,       P_586|P_MMX, 0)
insn(PSLLW, 2,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xF1,     0x00,       P_686|P_SSE2,0)
insn(PSLLW, 3,                  OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x71,     0x30,       P_686|P_SSE2,0)
ins (PSRAD, psrad, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xE2,     0x00,       P_586|P_MMX, 0)
insn(PSRAD, 1,                  OP_MMX,      F_0F,   OP_I8_U,       OP3_NONE,0,  no_WDS, 0x72,     0x20,       P_586|P_MMX, 0)
insn(PSRAD, 2,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xE2,     0x00,       P_686|P_SSE2,0)
insn(PSRAD, 3,                  OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x72,     0x20,       P_686|P_SSE2,0)
ins (PSRAW, psraw, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xE1,     0x00,       P_586|P_MMX, 0)
insn(PSRAW, 1,                  OP_MMX,      F_0F,   OP_I8_U,       OP3_NONE,0,  no_WDS, 0x71,     0x20,       P_586|P_MMX, 0)
insn(PSRAW, 2,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xE1,     0x00,       P_586|P_SSE2,0)
insn(PSRAW, 3,                  OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x71,     0x20,       P_686|P_SSE2,0)
ins (PSRLD, psrld, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xD2,     0x00,       P_586|P_MMX, 0)
insn(PSRLD, 1,                  OP_MMX,      F_0F,   OP_I8_U,       OP3_NONE,0,  no_WDS, 0x72,     0x10,       P_586|P_MMX, 0)
insn(PSRLD, 2,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xD2,     0x00,       P_686|P_SSE2,0)
insn(PSRLD, 3,                  OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x72,     0x10,       P_686|P_SSE2,0)
ins (PSRLDQ, psrldq, 6,         OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x73,     0x18,       P_686|P_SSE2,0)
ins (PSRLQ, psrlq, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xD3,     0x00,       P_586|P_MMX, 0)
insn(PSRLQ, 1,                  OP_MMX,      F_0F,   OP_I8_U,       OP3_NONE,0,  no_WDS, 0x73,     0x10,       P_586|P_MMX, 0)
insn(PSRLQ, 2,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xD3,     0x00,       P_686|P_SSE2,0)
insn(PSRLQ, 3,                  OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x73,     0x10,       P_686|P_SSE2,0)
ins (PSRLW, psrlw, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xD1,     0x00,       P_586|P_MMX, 0)
insn(PSRLW, 1,                  OP_MMX,      F_0F,   OP_I8_U,       OP3_NONE,0,  no_WDS, 0x71,     0x10,       P_586|P_MMX, 0)
insn(PSRLW, 2,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xD1,     0x00,       P_686|P_SSE2,0)
insn(PSRLW, 3,                  OP_XMM,      F_660F, OP_I8_U,       OP3_NONE,0,  no_WDS, 0x71,     0x10,       P_686|P_SSE2,0)
ins (PSUBB, psubb, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xF8,     0x00,       P_586|P_MMX, 0)
insn(PSUBB, 1,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xF8,     0x00,       P_686|P_SSE2,0)
ins (PSUBD, psubd, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xFA,     0x00,       P_586|P_MMX, 0)
insn(PSUBD, 1,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xFA,     0x00,       P_686|P_SSE2,0)
ins (PSUBQ, psubq, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xFB,     0x00,       P_686|P_SSE2,0)
insn(PSUBQ, 1,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xFB,     0x00,       P_686|P_SSE2,0)
ins (PSUBSB, psubsb, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xE8,     0x00,       P_586|P_MMX, 0)
insn(PSUBSB, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xE8,     0x00,       P_686|P_SSE2,0)
ins (PSUBSW, psubsw, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xE9,     0x00,       P_586|P_MMX, 0)
insn(PSUBSW, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xE9,     0x00,       P_686|P_SSE2,0)
ins (PSUBUSB, psubusb, 7,       OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xD8,     0x00,       P_586|P_MMX, 0)
insn(PSUBUSB, 1,                OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xD8,     0x00,       P_686|P_SSE2,0)
ins (PSUBUSW, psubusw, 7,       OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xD9,     0x00,       P_586|P_MMX, 0)
insn(PSUBUSW, 1,                OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xD9,     0x00,       P_686|P_SSE2,0)
ins (PSUBW, psubw, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xF9,     0x00,       P_586|P_MMX, 0)
insn(PSUBW, 1,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xF9,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKHBW, punpckhbw, 9,   OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x68,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKHBW, 1,              OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x68,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKHDQ, punpckhdq, 9,   OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x6A,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKHDQ, 1,              OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x6A,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKHQDQ, punpckhqdq, 10,OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x6D,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKHWD, punpckhwd, 9,   OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x69,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKHWD, 1,              OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x69,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKLBW, punpcklbw, 9,   OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x60,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKLBW, 1,              OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x60,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKLDQ, punpckldq, 9,   OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x62,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKLDQ, 1,              OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x62,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKLQDQ, punpcklqdq, 10,OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x6C,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKLWD, punpcklwd, 9,   OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0x61,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKLWD, 1,              OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x61,     0x00,       P_686|P_SSE2,0)
ins (PXOR, pxor, 4,             OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDS, 0xEF,     0x00,       P_586|P_MMX, 0)
insn(PXOR, 1,                   OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xEF,     0x00,       P_686|P_SSE2,0)
ins (RCPPS, rcpps, 5,           OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x53,     0x00,       P_686|P_SSE1,0)
ins (RCPSS, rcpss, 5,           OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_NONE,1,  no_WDS, 0x53,     0x00,       P_686|P_SSE1,0)
ins (RSQRTPS, rsqrtps, 7,       OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x52,     0x00,       P_686|P_SSE1,0)
ins (RSQRTSS, rsqrtss, 7,       OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_NONE,1,  no_WDS, 0x52,     0x00,       P_686|P_SSE1,0)
ins (SFENCE, sfence, 6,         OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xAE,     0xF8,       P_686|P_SSE1,0)
ins (SHUFPD, shufpd, 6,         OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDS, 0xC6,     0x00,       P_686|P_SSE2,0)
ins (SHUFPS, shufps, 6,         OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_I8_U,1,  no_WDS, 0xC6,     0x00,       P_686|P_SSE1,0)
ins (SQRTPD, sqrtpd, 6,         OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x51,     0x00,       P_686|P_SSE2,0)
ins (SQRTPS, sqrtps, 6,         OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x51,     0x00,       P_686|P_SSE1,0)
ins (SQRTSD, sqrtsd, 6,         OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x51,     0x00,       P_686|P_SSE2,0)
ins (SQRTSS, sqrtss, 6,         OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_NONE,1,  no_WDS, 0x51,     0x00,       P_686|P_SSE1,0)
ins (STMXCSR, stmxcsr, 7,       OP_M32,      F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0xAE,     0x18,       P_686|P_SSE1,0)
ins (SUBPD, subpd, 5,           OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x5C,     0x00,       P_686|P_SSE2,0)
ins (SUBPS, subps, 5,           OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x5C,     0x00,       P_686|P_SSE1,0)
ins (SUBSD, subsd, 5,           OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x5C,     0x00,       P_686|P_SSE2,0)
ins (SUBSS, subss, 5,           OP_XMM,      F_F30F, OP_XMM|OP_M32, OP3_NONE,1,  no_WDS, 0x5C,     0x00,       P_686|P_SSE1,0)
ins (UCOMISD, ucomisd, 7,       OP_XMM,      F_660F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x2E,     0x00,       P_686|P_SSE2,0)
ins (UCOMISS, ucomiss, 7,       OP_XMM,      F_0F,   OP_XMM|OP_M32, OP3_NONE,1,  no_WDS, 0x2E,     0x00,       P_686|P_SSE1,0)
ins (UNPCKHPD, unpckhpd, 8,     OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x15,     0x00,       P_686|P_SSE2,0)
ins (UNPCKHPS, unpckhps, 8,     OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x15,     0x00,       P_686|P_SSE1,0)
ins (UNPCKLPD, unpcklpd, 8,     OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x14,     0x00,       P_686|P_SSE2,0)
ins (UNPCKLPS, unpcklps, 8,     OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x14,     0x00,       P_686|P_SSE1,0)
ins (XORPD, xorpd, 5,           OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x57,     0x00,       P_686|P_SSE2,0)
ins (XORPS, xorps, 5,           OP_XMM,      F_0F,   OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x57,     0x00,       P_686|P_SSE1,0)

/* K3D instructions */
#if K3DSUPP
ins (FEMMS, femms, 5,           OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x0E,     0x00,       P_586|P_K3D, 0)
ins (PAVGUSB, pavgusb, 7,       OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xBF,     0x00,       P_586|P_K3D, 0)
ins (PF2ID, pf2id, 5,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x1D,     0x00,       P_586|P_K3D, 0)
ins (PF2IW, pf2iw, 5,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x1C,     0x00,       P_586|P_K3D, 0)
ins (PFACC, pfacc, 5,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xAE,     0x00,       P_586|P_K3D, 0)
ins (PFADD, pfadd, 5,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x9E,     0x00,       P_586|P_K3D, 0)
ins (PFCMPEQ, pfcmpeq, 7,       OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xB0,     0x00,       P_586|P_K3D, 0)
ins (PFCMPGE, pfcmpge, 7,       OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x90,     0x00,       P_586|P_K3D, 0)
ins (PFCMPGT, pfcmpgt, 7,       OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xA0,     0x00,       P_586|P_K3D, 0)
ins (PFMAX, pfmax, 5,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xA4,     0x00,       P_586|P_K3D, 0)
ins (PFMIN, pfmin, 5,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x94,     0x00,       P_586|P_K3D, 0)
ins (PFMUL, pfmul, 5,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xB4,     0x00,       P_586|P_K3D, 0)
ins (PFNACC, pfnacc, 6,         OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x8A,     0x00,       P_586|P_K3D, 0)
ins (PFPNACC, pfpnacc, 7,       OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x8E,     0x00,       P_586|P_K3D, 0)
ins (PFRCP, pfrcp, 5,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x96,     0x00,       P_586|P_K3D, 0)
ins (PFRCPIT1, pfrcpit1, 8,     OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xA6,     0x00,       P_586|P_K3D, 0)
ins (PFRCPIT2, pfrcpit2, 8,     OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xB6,     0x00,       P_586|P_K3D, 0)
ins (PFRSQIT1, pfrsqit1, 8,     OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xA7,     0x00,       P_586|P_K3D, 0)
ins (PFRSQRT, pfrsqrt, 7,       OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x97,     0x00,       P_586|P_K3D, 0)
ins (PFSUB, pfsub, 5,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x9A,     0x00,       P_586|P_K3D, 0)
ins (PFSUBR, pfsubr, 6,         OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xAA,     0x00,       P_586|P_K3D, 0)
ins (PI2FD, pi2fd, 5,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x0D,     0x00,       P_586|P_K3D, 0)
ins (PI2FW, pi2fw, 5,           OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0x0C,     0x00,       P_586|P_K3D, 0)
ins (PMULHRW, pmulhrw, 7,       OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xB7,     0x00,       P_586|P_K3D, 0)
ins (PREFETCH, prefetch, 8,     OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x0D,     0x00,       P_586|P_K3D, 0)
ins (PREFETCHW, prefetchw, 9,   OP_M,        F_0F,   OP_NONE,       OP3_NONE,0,  no_WDS, 0x0D,     0x08,       P_586|P_K3D, 0)
ins (PSWAPD, pswapd, 6,         OP_MMX,      F_0F0F, OP_MMX|OP_M,   OP3_NONE,1,  no_WDS, 0xBB,     0x00,       P_586|P_K3D, 0)
#endif

#if SSE3SUPP
ins (ADDSUBPD, addsubpd, 8,     OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xD0,     0x00,       P_686|P_SSE3,0)
ins (ADDSUBPS, addsubps, 8,     OP_XMM,      F_F20F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0xD0,     0x00,       P_686|P_SSE3,0)
ins (FISTTP, fisttp, 6,         OP_M32,      0,      OP_NONE,       OP3_NONE,0,  no_WDS, 0xDB,     0x08,       P_686|P_SSE3,0)
insn(FISTTP, 1,                 OP_M64,      0,      OP_NONE,       OP3_NONE,0,  no_WDS, 0xDD,     0x08,       P_686|P_SSE3,0)
insn(FISTTP, 2,                 OP_M16,      0,      OP_NONE,       OP3_NONE,0,  no_WDS, 0xDF,     0x08,       P_686|P_SSE3,0)
ins (HADDPD, haddpd, 6,         OP_XMM,      F_660F, OP_XMM,        OP3_NONE,1,  no_WDS, 0x7C,     0x00,       P_686|P_SSE3,0)
ins (HADDPS, haddps, 6,         OP_XMM,      F_F20F, OP_XMM,        OP3_NONE,1,  no_WDS, 0x7C,     0x00,       P_686|P_SSE3,0)
ins (HSUBPD, hsubpd, 6,         OP_XMM,      F_660F, OP_XMM,        OP3_NONE,1,  no_WDS, 0x7D,     0x00,       P_686|P_SSE3,0)
ins (HSUBPS, hsubps, 6,         OP_XMM,      F_F20F, OP_XMM,        OP3_NONE,1,  no_WDS, 0x7D,     0x00,       P_686|P_SSE3,0)
ins (LDDQU, lddqu, 5,           OP_XMM,      F_F20F, OP_M,          OP3_NONE,1,  no_WDS, 0xF0,     0x00,       P_686|P_SSE3,0)
ins (MONITOR, monitor, 7,       OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  0,      0x01,     0xC8,       P_686|P_SSE3,0)
ins (MOVDDUP, movddup, 7,       OP_XMM,      F_F20F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDS, 0x12,     0x00,       P_686|P_SSE3,0)
ins (MOVSHDUP, movshdup, 8,     OP_XMM,      F_F30F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x16,     0x00,       P_686|P_SSE3,0)
ins (MOVSLDUP, movsldup, 8,     OP_XMM,      F_F30F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDS, 0x12,     0x00,       P_686|P_SSE3,0)
ins (MWAIT, mwait, 5,           OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  0,      0x01,     0xC9,       P_686|P_SSE3,0)
#endif

#if SSSE3SUPP
ins (PABSB, pabsb, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x1C,       P_686|P_SSSE3, 0)
insn(PABSB, 1,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x1C,       P_686|P_SSSE3, 0)
ins (PABSD, pabsd, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x1E,       P_686|P_SSSE3, 0)
insn(PABSD, 1,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x1E,       P_686|P_SSSE3, 0)
ins (PABSW, pabsw, 5,           OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x1D,       P_686|P_SSSE3, 0)
insn(PABSW, 1,                  OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x1D,       P_686|P_SSSE3, 0)
ins (PALIGNR, palignr, 7,       OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_I8_U,1,  no_WDSx,0x3A,     0x1F,       P_686|P_SSSE3, 0)
insn(PALIGNR, 1,                OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDSx,0x3A,     0x1F,       P_686|P_SSSE3, 0)
ins (PHADDD, phaddd, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x02,       P_686|P_SSSE3, 0)
insn(PHADDD, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x02,       P_686|P_SSSE3, 0)
ins (PHADDSW, phaddsw, 7,       OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x03,       P_686|P_SSSE3, 0)
insn(PHADDSW, 1,                OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x03,       P_686|P_SSSE3, 0)
ins (PHADDW, phaddw, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x01,       P_686|P_SSSE3, 0)
insn(PHADDW, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x01,       P_686|P_SSSE3, 0)
ins (PHSUBD, phsubd, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x06,       P_686|P_SSSE3, 0)
insn(PHSUBD, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x06,       P_686|P_SSSE3, 0)
ins (PHSUBSW, phsubsw, 7,       OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x07,       P_686|P_SSSE3, 0)
insn(PHSUBSW, 1,                OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x07,       P_686|P_SSSE3, 0)
ins (PHSUBW, phsubw, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x05,       P_686|P_SSSE3, 0)
insn(PHSUBW, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x05,       P_686|P_SSSE3, 0)
ins (PMADDUBSW, pmaddubsw, 9,   OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x04,       P_686|P_SSSE3, 0)
insn(PMADDUBSW, 1,              OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x04,       P_686|P_SSSE3, 0)
ins (PMULHRSW, pmulhrsw, 8,     OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x0B,       P_686|P_SSSE3, 0)
insn(PMULHRSW, 1,               OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x0B,       P_686|P_SSSE3, 0)
ins (PSHUFB, pshufb, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x00,       P_686|P_SSSE3, 0)
insn(PSHUFB, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x00,       P_686|P_SSSE3, 0)
ins (PSIGNB, psignb, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x08,       P_686|P_SSSE3, 0)
insn(PSIGNB, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x08,       P_686|P_SSSE3, 0)
ins (PSIGND, psignd, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x0A,       P_686|P_SSSE3, 0)
insn(PSIGND, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x0A,       P_686|P_SSSE3, 0)
ins (PSIGNW, psignw, 6,         OP_MMX,      F_0F,   OP_MMX|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x09,       P_686|P_SSSE3, 0)
insn(PSIGNW, 1,                 OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x09,       P_686|P_SSSE3, 0)
#endif
#if AMD64_SUPPORT
insx(CDQE, cdqe, 4,             OP_NONE,     F_48,   OP_NONE,       OP3_NONE,0,  no_RM,  0x98,     0x00,       P_64,       0,        RWF_X64)
insx(CQO, cqo, 3,               OP_NONE,     F_48,   OP_NONE,       OP3_NONE,0,  no_RM,  0x99,     0x00,       P_64,       0,        RWF_X64)
insx(PUSHFQ,pushfq, 6,          OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x9C,     0x00,       P_64,       0,        RWF_X64)
insx(POPFQ, popfq, 5,           OP_NONE,     0,      OP_NONE,       OP3_NONE,0,  no_RM,  0x9D,     0x00,       P_64,       0,        RWF_X64)
insx(IRETQ, iretq, 5,           OP_NONE,     F_48,   OP_NONE,       OP3_NONE,0,  no_RM,  0xCF,     0x00,       P_64,       0,        RWF_X64)
insx(CMPXCHG16B, cmpxchg16b, 10,OP_M128,     F_480F, OP_NONE,       OP3_NONE,0,  0,      0xC7,     0x08,       P_64,       AP_LOCK,  RWF_X64)
insx(MOVSXD,movsxd, 6,          OP_R64,      0,      OP_R32|OP_M32, OP3_NONE,1,  0,      0x63,     0x00,       P_64,       0,        RWF_X64)

insx(CMPSQ, cmpsq, 5,           OP_M64,      F_48,   OP_M,          OP3_NONE,0,  no_RM,  0xA7,     0x00,       P_64,       AP_REPxx, RWF_X64)
insn(CMPSQ, 1,                  OP_NONE,     F_48,   OP_NONE,       OP3_NONE,0,  no_RM,  0xA7,     0x00,       P_64,       AP_REPxx )
insx(LODSQ, lodsq, 5,           OP_M64,      F_48,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAD,     0x00,       P_64,       AP_REP,   RWF_X64)
insn(LODSQ, 1,                  OP_NONE,     F_48,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAD,     0x00,       P_64,       AP_REP   )
insx(MOVSQ, movsq, 5,           OP_M64,      F_48,   OP_M,          OP3_NONE,0,  no_RM,  0xA5,     0x00,       P_64,       AP_REP,   RWF_X64)
insn(MOVSQ, 1,                  OP_NONE,     F_48,   OP_NONE,       OP3_NONE,0,  no_RM,  0xA5,     0x00,       P_64,       AP_REP   )
#if SSE4SUPP
insx(PEXTRQ, pextrq, 6,         OP_R64|OP_M64,F_660F,OP_XMM,        OP3_I8_U,1,  no_WDSx,0x3A,     0x16,       P_64|P_SSE4,0,        RWF_X64)
insx(PINSRQ, pinsrq, 6,         OP_XMM,      F_660F, OP_R64|OP_M64, OP3_I8_U,1,  no_WDSx,0x3A,     0x22,       P_64|P_SSE4,0,        RWF_X64)
#endif
insx(SCASQ, scasq, 5,           OP_M64,      F_48,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAF,     0x00,       P_64,       AP_REPxx, RWF_X64)
insn(SCASQ, 1,                  OP_NONE,     F_48,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAF,     0x00,       P_64,       AP_REPxx)
insx(STOSQ, stosq, 5,           OP_M64,      F_48,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAB,     0x00,       P_64,       AP_REP,   RWF_X64)
insn(STOSQ, 1,                  OP_NONE,     F_48,   OP_NONE,       OP3_NONE,0,  no_RM,  0xAB,     0x00,       P_64,       AP_REP   )

insx(SWAPGS, swapgs, 6,         OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  0,      0x01,     0xF8,       P_64,       0,        RWF_X64)
insx(SYSCALL_, syscall, 7,      OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x05,     0x00,       P_64,       0,        RWF_X64)
insx(SYSRET, sysret, 6,         OP_NONE,     F_0F,   OP_NONE,       OP3_NONE,0,  no_RM,  0x07,     0x00,       P_64,       0,        RWF_X64)
#endif
#if SSE4SUPP
/* SSE4.1 */
ins (BLENDPD, blendpd, 7,       OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDSx,0x3A,     0x0D,       P_686|P_SSE4, 0)
ins (BLENDPS, blendps, 7,       OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDSx,0x3A,     0x0C,       P_686|P_SSE4, 0)
ins (BLENDVPD, blendvpd, 8,     OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_XMM0,1,  no_WDSx,0x38,     0x15,       P_686|P_SSE4, 0)
ins (BLENDVPS, blendvps, 8,     OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_XMM0,1,  no_WDSx,0x38,     0x14,       P_686|P_SSE4, 0)
ins (DPPD, dppd, 4,             OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDSx,0x3A,     0x41,       P_686|P_SSE4, 0)
ins (DPPS, dpps, 4,             OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDSx,0x3A,     0x40,       P_686|P_SSE4, 0)
ins (EXTRACTPS, extractps, 9,   OP_RGT16,    F_660F, OP_XMM,        OP3_I8_U,0,  no_WDSx,0x3A,     0x17,       P_686|P_SSE4, 0)
insn(EXTRACTPS, 1,              OP_M32,      F_660F, OP_XMM,        OP3_I8_U,0,  no_WDSx,0x3A,     0x17,       P_686|P_SSE4, 0)
ins (INSERTPS, insertps, 8,     OP_XMM,      F_660F, OP_XMM|OP_M32, OP3_I8_U,1,  no_WDSx,0x3A,     0x21,       P_686|P_SSE4, 0)
ins (MOVNTDQA, movntdqa, 8,     OP_XMM,      F_660F, OP_M128,       OP3_NONE,1,  no_WDSx,0x38,     0x2A,       P_686|P_SSE4, 0)
ins (MPSADBW, mpsadbw, 7,       OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDSx,0x3A,     0x42,       P_686|P_SSE4, 0)
ins (PACKUSDW, packusdw, 8,     OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x2B,       P_686|P_SSE4, 0)
ins (PBLENDVB, pblendvb, 8,     OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_XMM0,1,  no_WDSx,0x38,     0x10,       P_686|P_SSE4, 0)
ins (PBLENDW, pblendw, 7,       OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDSx,0x3A,     0x0E,       P_686|P_SSE4, 0)
ins (PCMPEQQ, pcmpeqq, 7,       OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x29,       P_686|P_SSE4, 0)
ins (PEXTRB, pextrb, 6,         OP_RGT16|OP_M8,F_660F,OP_XMM,       OP3_I8_U,0,  no_WDSx,0x3A,     0x14,       P_686|P_SSE4, 0)
ins (PEXTRD, pextrd, 6,         OP_R32|OP_M32,F_660F,OP_XMM,        OP3_I8_U,0,  no_WDSx,0x3A,     0x16,       P_686|P_SSE4, 0)
ins (PHMINPOSUW, phminposuw, 10,OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x41,       P_686|P_SSE4, 0)
ins (PINSRB, pinsrb, 6,         OP_XMM,      F_660F, OP_R32|OP_M8,  OP3_I8_U,1,  no_WDSx,0x3A,     0x20,       P_686|P_SSE4, 0)
ins (PINSRD, pinsrd, 6,         OP_XMM,      F_660F, OP_R32|OP_M32, OP3_I8_U,1,  no_WDSx,0x3A,     0x22,       P_686|P_SSE4, 0)
ins (PMAXSB, pmaxsb, 6,         OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x3C,       P_686|P_SSE4, 0)
ins (PMAXSD, pmaxsd, 6,         OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x3D,       P_686|P_SSE4, 0)
ins (PMAXUD, pmaxud, 6,         OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x3F,       P_686|P_SSE4, 0)
ins (PMAXUW, pmaxuw, 6,         OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x3E,       P_686|P_SSE4, 0)
ins (PMINSB, pminsb, 6,         OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x38,       P_686|P_SSE4, 0)
ins (PMINSD, pminsd, 6,         OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x39,       P_686|P_SSE4, 0)
ins (PMINUD, pminud, 6,         OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x3B,       P_686|P_SSE4, 0)
ins (PMINUW, pminuw, 6,         OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x3A,       P_686|P_SSE4, 0)
ins (PMOVSXBD, pmovsxbd, 8,     OP_XMM,      F_660F, OP_XMM|OP_M32, OP3_NONE,1,  no_WDSx,0x38,     0x21,       P_686|P_SSE4, 0)
ins (PMOVSXBQ, pmovsxbq, 8,     OP_XMM,      F_660F, OP_XMM|OP_M16, OP3_NONE,1,  no_WDSx,0x38,     0x22,       P_686|P_SSE4, 0)
ins (PMOVSXBW, pmovsxbw, 8,     OP_XMM,      F_660F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x20,       P_686|P_SSE4, 0)
ins (PMOVSXDQ, pmovsxdq, 8,     OP_XMM,      F_660F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x25,       P_686|P_SSE4, 0)
ins (PMOVSXWD, pmovsxwd, 8,     OP_XMM,      F_660F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x23,       P_686|P_SSE4, 0)
ins (PMOVSXWQ, pmovsxwq, 8,     OP_XMM,      F_660F, OP_XMM|OP_M32, OP3_NONE,1,  no_WDSx,0x38,     0x24,       P_686|P_SSE4, 0)
ins (PMOVZXBD, pmovzxbd, 8,     OP_XMM,      F_660F, OP_XMM|OP_M32, OP3_NONE,1,  no_WDSx,0x38,     0x31,       P_686|P_SSE4, 0)
ins (PMOVZXBQ, pmovzxbq, 8,     OP_XMM,      F_660F, OP_XMM|OP_M16, OP3_NONE,1,  no_WDSx,0x38,     0x32,       P_686|P_SSE4, 0)
ins (PMOVZXBW, pmovzxbw, 8,     OP_XMM,      F_660F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x30,       P_686|P_SSE4, 0)
ins (PMOVZXDQ, pmovzxdq, 8,     OP_XMM,      F_660F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x35,       P_686|P_SSE4, 0)
ins (PMOVZXWD, pmovzxwd, 8,     OP_XMM,      F_660F, OP_XMM|OP_M64, OP3_NONE,1,  no_WDSx,0x38,     0x33,       P_686|P_SSE4, 0)
ins (PMOVZXWQ, pmovzxwq, 8,     OP_XMM,      F_660F, OP_XMM|OP_M32, OP3_NONE,1,  no_WDSx,0x38,     0x34,       P_686|P_SSE4, 0)
ins (PMULDQ, pmuldq, 6,         OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x28,       P_686|P_SSE4, 0)
ins (PMULLD, pmulld, 6,         OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x40,       P_686|P_SSE4, 0)
ins (PTEST, ptest, 5,           OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x17,       P_686|P_SSE4, 0)
ins (ROUNDPD, roundpd, 7,       OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDSx,0x3A,     0x09,       P_686|P_SSE4, 0)
ins (ROUNDPS, roundps, 7,       OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDSx,0x3A,     0x08,       P_686|P_SSE4, 0)
ins (ROUNDSD, roundsd, 7,       OP_XMM,      F_660F, OP_XMM|OP_M64 ,OP3_I8_U,1,  no_WDSx,0x3A,     0x0B,       P_686|P_SSE4, 0)
ins (ROUNDSS, roundss, 7,       OP_XMM,      F_660F, OP_XMM|OP_M32 ,OP3_I8_U,1,  no_WDSx,0x3A,     0x0A,       P_686|P_SSE4, 0)
/* SSE4.2 */
ins (CRC32, crc32, 5,           OP_RGT16,    F_F20F, OP_M8|OP_R8   ,OP3_NONE,1,  no_WDSx,0x38,     0xF0,       P_686|P_SSE4, 0)
insn(CRC32, 1,                  OP_RGT16,    F_F20F, OP_M|OP_RGT8,  OP3_NONE,1,  no_WDSx,0x38,     0xF1,       P_686|P_SSE4, 0)
ins (PCMPESTRI, pcmpestri, 9,   OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDSx,0x3A,     0x61,       P_686|P_SSE4, 0)
ins (PCMPESTRM, pcmpestrm, 9,   OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDSx,0x3A,     0x60,       P_686|P_SSE4, 0)
ins (PCMPGTQ, pcmpgtq, 7,       OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_NONE,1,  no_WDSx,0x38,     0x37,       P_686|P_SSE4, 0)
ins (PCMPISTRI, pcmpistri, 9,   OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDSx,0x3A,     0x63,       P_686|P_SSE4, 0)
ins (PCMPISTRM, pcmpistrm, 9,   OP_XMM,      F_660F, OP_XMM|OP_M128,OP3_I8_U,1,  no_WDSx,0x3A,     0x62,       P_686|P_SSE4, 0)
ins (POPCNT, popcnt, 6,         OP_RGT8,     F_F30F, OP_M|OP_RGT8  ,OP3_NONE,1,  no_WDS ,0xB8,     0x00,       P_686|P_SSE4, 0)
#if 0
/* SSE4A. Disabled because INSERTQ has 4 arguments - which JWasm cannot support currently  */
ins (EXTRQ, extrq, 5,           OP_XMM,      F_660F, OP_I8_U       ,OP3_I8_U,0,  no_WDS ,0x78,     0x00,       P_686|P_SSE4, 0)
insn(EXTRQ, 1,                  OP_XMM,      F_660F, OP_XMM        ,OP3_NONE,0,  no_WDS ,0x??,     0x00,       P_686|P_SSE4, 0)
ins (INSERTQ, insertq, 7,       OP____,      F_____, OP____        ,OP3_NONE,1,  no_WDS?,0x??,     0x00,       P_686|P_SSE4, 0)
ins (LZCNT, lzcnt, 5,           OP_____,     F_____, OP____        ,OP3_NONE,1,  no_WDS?,0x??,     0x00,       P_686|P_SSE4, 0)
ins (MOVNTSD, movntsd, 7,       OP_M128,     F_660F, OP_XMM        ,OP3_NONE,0,  no_WDS?,0x??,     0x00,       P_686|P_SSE4, 0)
ins (MOVNTSS, movntss, 7,       OP_M128,     F_0F,   OP_XMM        ,OP3_NONE,0,  no_WDS?,0x??,     0x00,       P_686|P_SSE4, 0)
#endif
#endif
