
/* message texts
 * if a new id is inserted, a full rebuild is required.
 * This file is included by globals.h.
 * v2.06: Japanese texts removed.
 */
pick( MSG_USAGE,              "usage: JWasm [ options ] filelist [@env_var]\n" "Run \"JWasm -?\" or \"JWasm -h\" for more info\n" )
pick( MSG_ASSEMBLY_RESULTS,   "%s: %lu lines, %u passes, %u ms, %u warnings, %u errors" )
pick( MSG_ERROR_PREFIX,       "Error" )
pick( MSG_WARNING_PREFIX,     "Warning" )
pick( MSG_FATAL_PREFIX,       "Fatal error" )
pick( MSG_JWASM,              "JWasm v%s, %s" )
pick( MSG_BANNER,             "%s, Masm-compatible assembler.\n" "Portions Copyright (c) 1992-2002 Sybase, Inc. All Rights Reserved.\n" "Source code is available under the Sybase Open Watcom Public License.\n\n" )
/* text constants for listing */
pick( TXT_MACROS,             "Macros:" )
pick( TXT_MACROCAP,           "                N a m e                 Type" )
pick( TXT_STRUCTS,            "Structures and Unions:" )
pick( TXT_STRUCTCAP,          "                N a m e                 Size/Ofs   Type" )
pick( TXT_RECORDS,            "Records:" )
pick( TXT_RECORDCAP1,         "                N a m e                 Width   # fields" )
pick( TXT_RECORDCAP2,         "                                        Shift   Width    Mask   Initial" )
pick( TXT_TYPEDEFS,           "Types:" )
pick( TXT_TYPEDEFCAP,         "                N a m e                 Size    Attr" )
pick( TXT_SEGS,               "Segments and Groups:" )
pick( TXT_SEGCAP,             "                N a m e                 Size     Length   Align   Combine Class" )
pick( TXT_PROCS,              "Procedures, parameters and locals:" )
pick( TXT_PROCCAP,            "                N a m e                 Type     Value    Segment  Length" )
pick( TXT_SYMBOLS,            "Symbols:" )
pick( TXT_SYMCAP,             "                N a m e                 Type       Value     Attr")
/* other text constants */
pick( TXT_READONLY,           "readonly" )
pick( TXT_ALIGNMENT,          "alignment" )
pick( TXT_COMBINE,            "combine" )
pick( TXT_SEG_WORD_SIZE,      "segment word size" )
pick( TXT_CLASS,              "class" )
pick( TXT_CHARACTERISTICS,    "characteristics" )

/* error/warning message text constants */

pick( INSTRUCTION_PREFIX_NOT_ALLOWED, "Instruction prefix not allowed" )
pick( MULTIPLE_BASE_REGISTERS_NOT_ALLOWED, "Multiple base registers not allowed" )
pick( INSTRUCTION_OR_REGISTER_NOT_ACCEPTED_IN_CURRENT_CPU_MODE, "Instruction or register not accepted in current CPU mode" )
pick( INVALID_ADDRESSING_MODE_WITH_CURRENT_CPU_SETTING, "invalid addressing mode with current CPU setting" )
pick( CANNOT_USE_TRN_TO_TRM_WITH_CURRENT_CPU_SETTING, "Cannot use TR%u-TR%u with current CPU setting" )
pick( MUST_BE_INDEX_OR_BASE_REGISTER, "Must be index or base register" )
pick( MULTIPLE_INDEX_REGISTERS_NOT_ALLOWED, "Multiple index registers not allowed" )
pick( INVALID_INDEX_REGISTER, "Invalid index register" )
pick( SCALE_FACTOR_MUST_BE_1_2_4_OR_8, "Scale factor must be 1, 2, 4 or 8" )
pick( CANNOT_BE_USED_AS_INDEX_REGISTER, "Cannot be used as index register: %s" )
#if AMD64_SUPPORT
pick( CANNOT_MIX_16_AND_32_BIT_REGISTERS, "Base and index register differ in size" )
#else
pick( CANNOT_MIX_16_AND_32_BIT_REGISTERS, "Cannot mix 16 and 32-bit registers" )
#endif
pick( EXPECTING_COMMA, "Expecting comma" )
pick( ORG_NEEDS_A_CONSTANT_OR_LOCAL_OFFSET, "ORG needs a constant or local offset" )
pick( POP_CS_IS_NOT_ALLOWED, "POP CS is not allowed" )
pick( ONLY_MOV_CAN_USE_SPECIAL_REGISTER, "Only MOV can use special register"      )
pick( CANNOT_USE_SHORT_WITH_CALL,  "Cannot use SHORT with CALL"       )
pick( ONLY_SHORT_JUMP_DISTANCE_IS_ALLOWED,  "Only SHORT jump distance is allowed"      )
pick( SYNTAX_ERROR, "Syntax error"   )
pick( PREFIX_MUST_BE_FOLLOWED_BY_AN_INSTRUCTION, "Prefix must be followed by an instruction"    )
pick( SYNTAX_ERROR_UNEXPECTED_COLON, "Syntax error: Unexpected colon"  )
pick( OPERANDS_MUST_BE_THE_SAME_SIZE, "Operands must be the same size: %u - %u" )
pick( INVALID_INSTRUCTION_OPERANDS, "Invalid instruction operands"  )
#if 1 //obsolete
pick( IMMEDIATE_CONSTANT_TOO_LARGE, "Immediate constant too large"      )
#endif
pick( IMMEDIATE_DATA_OUT_OF_RANGE, "Immediate data out of range"      )
pick( CANNOT_USE_SHORT_OR_NEAR,    "Can not use short or near modifiers with this instruction"  )
pick( JUMP_OUT_OF_RANGE,           "Jump out of range by %d byte(s)" )
pick( DISPLACEMENT_OUT_OF_RANGE,   "Displacement out of range: 0x%I64X" )
pick( INITIALIZER_OUT_OF_RANGE,    "Initializer value too large"  )
pick( SYMBOL_ALREADY_DEFINED,      "Symbol already defined: %s" )
pick( OFFSET_MAGNITUDE_TOO_LARGE,  "Offset magnitude too large for specified size"  )
pick( MAGNITUDE_OF_OFFSET_EXCEEDS_16BIT, "Magnitude of offset exceeds 16 bit" )
pick( OP2_TOO_BIG,                 "Operand 2 too big"     )
pick( OP1_TOO_SMALL,               "Operand 1 too small"     )
pick( LINE_TOO_LONG,               "Line too long"      )
pick( TOO_MANY_TOKENS,             "Too many tokens in a line"  )
pick( OPERATOR_EXPECTED,           "Operator is expected"        )
pick( OPERAND_EXPECTED,            "Operand is expected"      )
pick( CONSTANT_EXPECTED,           "Constant expected" )
pick( CONSTANT_OPERAND_EXPECTED,   "Constant operand is expected"    )
pick( LABEL_EXPECTED,              "Label is expected"       )
#if 0 /* obsolete */
pick( LABEL_NOT_DEFINED,           "Label is not defined: %s"        )
#endif
pick( MULTIPLE_OVERRIDES,          "Multiple overrides, ignored: %s" )
pick( SEGMENT_GROUP_OR_SEGREG_EXPECTED, "Segment, group or segment register expected" )
pick( IDENTIFIER_TOO_LONG,         "Identifier too long" )
pick( INVALID_OPERAND_SIZE,        "Invalid operand size for instruction"        )
pick( NOT_SUPPORTED,               "Not supported: %s" )
pick( SIZE_NOT_SPECIFIED_ASSUMING, "Size not specified, assuming: %s" )
pick( FP_INITIALIZER_IGNORED,      "Floating-point initializer ignored" )
pick( ONLY_SHORT_AND_NEAR_JUMP_DISTANCE_IS_ALLOWED, "Only SHORT and NEAR jump distance is allowed" )
pick( MAGNITUDE_TOO_LARGE_FOR_SPECIFIED_SIZE, "Initializer magnitude too large for specified size" )
pick( SEGMENT_ATTRIBUTE_DEFINED_ALREADY, "Segment attribute is defined already: %s" )
pick( SEGDEF_CHANGED,              "Segment definition changed: %s, %s" )
pick( CLASS_NAME_TOO_LONG,         "Class name too long" )
pick( BLOCK_NESTING_ERROR,         "Block nesting error: %s" )
pick( UNKNOWN_SEGMENT_ATTRIBUTE,   "Segment attribute is unknown: %s" )
pick( MUST_BE_IN_SEGMENT_BLOCK,    "Must be in segment block"  )
pick( SEG_NOT_DEFINED,             "Segment not defined: %s" )
pick( COLON_EXPECTED,              "Colon is expected" )
pick( INVALID_QUALIFIED_TYPE,      "Invalid qualified type: %s" )
pick( QUALIFIED_TYPE_EXPECTED,     "Qualified type is expected" )
pick( CANNOT_OPEN_INCLUDE_FILE,    "Cannot open include file '%s'" )
pick( LIBRARY_NAME_MISSING,        "Library name is missing" )
pick( CANNOT_ACCESS_LABEL_THROUGH_SEGMENT_REGISTERS, "Cannot access label through segment registers: %s" )
pick( EXPANDED_LINE_TOO_LONG,      "Line too long after expansion: %40s" )
pick( LANG_MUST_BE_SPECIFIED,      "Language type must be specified" )
pick( PROC_MACRO_MUST_PRECEDE_LOCAL, "PROC, MACRO or macro loop directive must precede LOCAL" )
pick( CANNOT_NEST_PROCEDURES,      "Cannot nest procedures" )
pick( VARARG_REQUIRES_C_CALLING_CONVENTION, "VARARG requires C calling convention" )
pick( MODEL_DECLARED_ALREADY,      "Multiple .MODEL directives, .MODEL ignored" )
pick( MODEL_IS_NOT_DECLARED,       "Model is not declared" )
pick( BACKQUOTE_MISSING,           "Backquote missing: `%s" )
pick( COMMENT_DELIMITER_EXPECTED,  "COMMENT delimiter expected"       )
pick( END_DIRECTIVE_REQUIRED,      "END directive required at end of file"       )
pick( NESTING_LEVEL_TOO_DEEP,      "Nesting level too deep"       )
pick( MACRO_NESTING_LEVEL_TOO_DEEP,"Macro nesting level too deep" )
pick( SYMBOL_NOT_DEFINED,          "Symbol not defined : %s" )
pick( MSG_FATAL_ERROR,             "Fatal error"       )
pick( NO_FILENAME_SPECIFIED,       "No filename specified."        )
pick( OUT_OF_MEMORY,               "Out of Memory"    )
pick( CANNOT_OPEN_FILE,            "Cannot open file: \"%s\" [%u]" )
pick( CANNOT_CLOSE_FILE,           "Cannot close file: %s [%u]" )
pick( FILE_WRITE_ERROR,            "File write error: %s [%u]" )
pick( INVALID_CMDLINE_OPTION,      "Invalid command-line option: %s" )
pick( INTERNAL_ERROR,              "Internal error in %s(%u)\n" )
pick( EXPECTED_CL_SQ_BRACKET,      "Expecting closing square bracket"    )
pick( EXPECTED_FILE_NAME,          "Expecting file name"     )
pick( TOO_MANY_ERRORS,             "Too many errors"      )
pick( FORCED_ERR,                  "forced error%s")
pick( FORCED_NOT_ZERO,             "forced error: Value not equal to 0: %d%s" )
pick( FORCED_EQUAL,                "forced error: Value equal to 0: %d%s" )
pick( FORCED_DEF,                  "forced error: symbol defined: %s" )
pick( FORCED_NOT_DEF,              "forced error: symbol not defined: %s"  )
pick( FORCED_BLANK,                "forced error: string blank : <%s>%s" )
pick( FORCED_NOT_BLANK,            "forced error: string not blank : <%s>%s" )
pick( FORCED_DIF,                  "forced error: strings not equal : <%s> : <%s>%s" )
pick( FORCED_IDN,                  "forced error: strings equal : <%s> : <%s>%s" )
pick( NOTE_INCLUDED_BY,            "%*s%s(%u): Included by" )
pick( NOTE_MACRO_CALLED_FROM,      "%*s%s(%u)[%s]: Macro called from" )
pick( NOTE_ITERATION_MACRO_CALLED_FROM, "%*s%s(%u): iteration %u: Macro called from" )
pick( NOTE_MAIN_LINE_CODE,         "%*s%s(%u): Main line code" )
pick( EXTENDING_JUMP,              "Extending jump" )
pick( DIRECTIVE_IGNORED,           "Directive ignored: %s" )
#if MANGLERSUPP
pick( UNKNOWN_MANGLER,             "Unknown symbol class '%s'"  )
pick( CONFLICTING_MANGLER,         "Symbol class for '%s' already established"  )
#endif
pick( POWER_OF_2,                  "number must be a power of 2" )
pick( ALIGN_TOO_HIGH,              "Incompatible with segment alignment: %s" )
pick( SEGMENT_EXPECTED,            "Segment expected: %s" )
pick( INCOMPATIBLE_CPU_MODE_FOR_32BIT_SEGMENT, "Incompatible CPU mode for 32-bit segment")
pick( CALL_FAR_TO_NEAR,            "Far call is converted to near call." )
pick( CPU_OPTION_INVALID,          "CPU option %s is not valid for selected CPU.\n" )
pick( SEGMENT_IN_ANOTHER_GROUP,    "Segment '%s' is in another group already" )
pick( SYMBOL_TYPE_CONFLICT,        "Symbol type conflict: %s" )
pick( CONFLICTING_PARAMETER_DEFINITION, "Conflicting parameter definition: %s" )
pick( PROC_AND_PROTO_CALLING_CONV_CONFLICT, "PROC and PROTO calling convention conflict" )
pick( NON_BENIGN_XXX_REDEFINITION, "Non-benign %s redefinition: %s" )
pick( TOO_MANY_BITS_IN_RECORD,     "Too many bits in RECORD: %s" )
pick( STATEMENT_NOT_ALLOWED_INSIDE_STRUCTURE_DEFINITION, "Statement not allowed inside structure definition" )
pick( UNMATCHED_BLOCK_NESTING,     "Unmatched block nesting: %s" )
pick( SYMBOL_REDEFINITION,         "Symbol redefinition: %s" )
pick( TEXT_ITEM_REQUIRED,          "Text item required" )
pick( INVOKE_ARGUMENT_TYPE_MISMATCH, "INVOKE argument type mismatch: argument %u" )
pick( TOO_FEW_ARGUMENTS_TO_INVOKE, "Too few arguments to INVOKE: %s" )
pick( VARARG_PARAMETER_MUST_BE_LAST, "VARARG parameter must be last" )
#if MACROLABEL
pick( LABEL_PARAMETER_MUST_BE_FIRST, "LABEL parameter must be first" )
#endif
pick( TOO_MANY_ARGUMENTS_IN_MACRO_CALL, "Too many arguments in macro call: %s" )
pick( MISSING_OPERATOR_IN_EXPRESSION, "Missing operator in expression" )
pick( UNEXPECTED_LITERAL_FOUND_IN_EXPRESSION, "Unexpected literal found in expression: %s" )
pick( INITIALIZER_MUST_BE_A_STRING_OR_SINGLE_ITEM, "Initializer must be a string or single item: %s" )
pick( TOO_MANY_INITIAL_VALUES_FOR_STRUCTURE, "Too many initial values for structure: %s" )
pick( TOO_MANY_INITIAL_VALUES_FOR_ARRAY, "Too many initial values for array: %s" )
pick( STRING_OR_TEXT_LITERAL_TOO_LONG,   "String or text literal too long" )
pick( PROLOGUE_MUST_BE_MACRO_FUNC,       "PROLOGUE must be macro function" )
pick( EPILOGUE_MUST_BE_MACRO_PROC,       "EPILOGUE must be macro procedure: %s" )
pick( RESERVED_WORD_EXPECTED,            "Reserved word expected" )
pick( INVOKE_REQUIRES_PROTOTYPE,         "INVOKE requires prototype for procedure" )
pick( INVALID_TYPE_FOR_DATA_DECLARATION, "Invalid type for data declaration: %s" )
pick( OPERAND_MUST_BE_RECORD,            "Operand must be RECORD type or field" )
pick( UNMATCHED_MACRO_NESTING,           "Unmatched macro nesting" )
pick( EMPTY_STRING,                      "Empty (null) string" )
pick( SEGMENT_MISSING_FOR_FIXUP,         "No segment information to create fixup: %s" )
pick( REGISTER_VALUE_OVERWRITTEN_BY_INVOKE, "Register value overwritten by INVOKE" )
pick( MISSING_QUOTATION_MARK_IN_STRING,  "Missing quotation mark in string" )
pick( DIVIDE_BY_ZERO_IN_EXPR,            "Divide by zero in expression" )
pick( GENERAL_FAILURE,                   "General Failure" )
pick( CANNOT_HAVE_IMPLICIT_FAR_JUMP_OR_CALL_TO_NEAR_LABEL, "Cannot have implicit far jump or call to near label" )
pick( INVALID_USE_OF_REGISTER,           "Invalid use of register" )
pick( DISTANCE_INVALID,                  "Distance invalid for current segment" )
pick( INITIALIZER_MAGNITUDE_TOO_LARGE,   "Initializer magnitude too large" )
pick( CANNOT_ADD_TWO_RELOCATABLE_LABELS, "Cannot add two relocatable labels" )
pick( CANNOT_DEFINE_AS_PUBLIC_OR_EXTERNAL, "Cannot define as public or external: %s" )
pick( POSITIVE_VALUE_EXPECTED,           "Positive value expected" )
pick( FAR_NOT_ALLOWED_IN_FLAT_MODEL_COMM_VARIABLES, "FAR not allowed in FLAT model COMM variables" )
pick( TOO_MANY_ARGUMENTS_TO_INVOKE,      "Too many arguments to INVOKE" )
pick( DIRECTIVE_MUST_APPEAR_INSIDE_A_MACRO, "Directive must appear inside a macro" )
pick( INVALID_TYPE_EXPRESSION,           "Invalid type expression" )
pick( CANNOT_DECLARE_SCOPED_CODE_LABEL_AS_PUBLIC, "Cannot declare scoped code label as PUBLIC: %s" )
pick( INVALID_RADIX_TAG,                 "Invalid radix tag" )
pick( INSTRUCTION_OPERAND_MUST_HAVE_SIZE,"Instruction operand must have size" )
pick( USE_OF_REGISTER_ASSUMED_TO_ERROR,  "Use of register assumed to ERROR" )
pick( INITIALIZED_DATA_NOT_SUPPORTED_IN_SEGMENT, "Instructions and initialized data not supported in %s segments" )
pick( LITERAL_EXPECTED_AFTER_EQ,         "Literal expected after '='" )
#if 0
pick( FASTCALL_VARIANT_NOT_SUPPORTED,    "FASTCALL variant not supported by INVOKE" )
#endif
pick( NO_4KPAGE_ALIGNED_SEGMENTS,        "No 4k Page-aligned segments in MS386 OMF" )
pick( GROUP_DIRECTIVE_INVALID_FOR_COFF,  "GROUP directive invalid for COFF and ELF format" )
pick( OPERAND_MUST_BE_RELOCATABLE,       "Operand must be relocatable" )
pick( CONSTANT_OR_RELOCATABLE_LABEL_EXPECTED, "Constant or relocatable label expected" )
pick( IF2_NOT_ALLOWED,                   "[ELSE]IF2/.ERR2 not allowed, single-pass assembler" )
pick( EXPR_TOO_COMPLEX_FOR_UNTILCXZ,     "Expression too complex for UNTILCXZ" )
pick( OPERANDS_MUST_BE_IN_SAME_SEGMENT,  "Operands must be in same segment" )
pick( INVALID_USE_OF_EXTERNAL_SYMBOL,    "Invalid use of external symbol: %s" )
#if COFF_SUPPORT
pick( LEADING_UNDERSCORE_REQUIRED_FOR_START_LABEL, "For -coff leading underscore required for start label: %s" )
#endif
pick( INVALID_CMDLINE_VALUE,             "Invalid command-line value, default is used: %s" )
pick( UNKNOWN_FIXUP_TYPE,                "Unknown fixup type: %u at %s.%lX" )
pick( UNSUPPORTED_FIXUP_TYPE,            "Unsupported fixup type for %s: %s" )
pick( INVALID_FIXUP_TYPE,                "Invalid fixup type for %s: %u at location %s.%lX" )
pick( SYNTAX_ERROR_IN_CONTROL_FLOW_DIRECTIVE, "Syntax error in control-flow directive" )
pick( INVALID_MODEL_PARAM_FOR_FLAT,      "Invalid .model parameter for flat model" )
#if BIN_SUPPORT
pick( FORMAT_DOESNT_SUPPORT_EXTERNALS,   "Output format doesn't support externals: %s" )
pick( START_LABEL_INVALID,               "Invalid start label for -bin" )
#if MZ_SUPPORT
pick( NO_START_LABEL,                    "No start label defined" )
pick( NO_STACK,                          "No stack defined" )
pick( INVALID_HEADER_ALIGNMENT,          "Invalid alignment - value must be 2^n (n=4..15)" )
#endif
#endif
pick( INDEX_PAST_END_OF_STRING,          "Index %u is past end of string" )
pick( COUNT_VALUE_TOO_LARGE,             "Count value too large" )
pick( COUNT_MUST_BE_POSITIVE_OR_ZERO,    "Count must be positive or zero" )
pick( SYNTAX_ERROR_EX,                   "Syntax error: %s" )
pick( DIRECTIVE_IGNORED_FOR_COFF,        "Directive ignored for COFF and ELF format: %s" )
pick( EXPRESSION_NOT_A_CONSTANT,         "Value of expression is not a constant" )
pick( MUST_USE_FLOAT_INITIALIZER,        "Must use floating-point initializer" )
pick( ORG_NOT_ALLOWED_IN_UNIONS,         "ORG directive not allowed in unions" )
pick( STRUCT_ALIGN_TOO_HIGH,             "Struct alignment must be 1, 2, 4, 8, 16 or 32" )
pick( STRUCT_CANNOT_BE_INSTANCED,        "Structure cannot be instanced" )
pick( MISSING_ANGLE_BRACKET_OR_BRACE_IN_LITERAL, "Missing angle bracket or brace in literal" )
pick( NONDIGIT_IN_NUMBER,                "Nondigit in number: %s" )
pick( WORD_FIXUP_FOR_32BIT_LABEL,        "16bit fixup for 32bit label: %s" )
pick( TOO_MANY_MACRO_PLACEHOLDERS,       "Too many macro placeholders" )
pick( MISSING_MACRO_ARGUMENT,            "Missing macro argument: %s, parameter %u" )
pick( DOES_NOT_WORK_WITH_32BIT_SEGMENTS, "%s does not work with 32-bit segments" )
pick( SEGMENT_EXCEEDS_64K_LIMIT,         "Segment exceeds 64k limit: %s" )
pick( NOT_SUPPORTED_WITH_OMF_FORMAT,     "Not supported with OMF format: %s" )
pick( NOT_SUPPORTED_WITH_CURR_FORMAT,    "Not supported with current output format: %s" )
pick( UNKNOWN_DEFAULT_PROLOGUE_ARGUMENT, "Unknown default prologue argument: %s" )
pick( LOADDS_IGNORED_IN_FLAT_MODEL,      "LOADDS ignored in flat model" )
pick( MISSING_RIGHT_PARENTHESIS_IN_EXPRESSION, "Missing right parenthesis in expression" )
pick( INVALID_OPERAND_FOR_OPERATOR,      "Invalid operand for %s operator: %s" )
pick( STRUCTURE_IMPROPERLY_INITIALIZED,  "Structure improperly initialized: %s" )
pick( EXPECTED,                          "Expected: %s" )
pick( INVALID_DATA_INITIALIZER,          "Invalid data initializer" )
pick( EXPECTED_DATA_LABEL,               "Expected data label" )
pick( EXPRESSION_MUST_BE_A_CODE_ADDRESS, "Expression must be a code address" )
pick( N_OPTION_NEEDS_A_NAME_PARAMETER,   "-n Option needs a valid name parameter" )
pick( CONSTANT_VALUE_TOO_LARGE,          "Constant value too large: %I64Xh" )
pick( TEXT_MACRO_USED_PRIOR_TO_DEFINITION, "Text macro used prior to definition: %s" )
pick( OFFSET_SIZE_MISMATCH,              "Offset size incompatible with current segment" )
pick( INSTRUCTION_FORM_REQUIRES_80386,   "Instruction form requires 80386" )
pick( GROUP_SEGMENT_SIZE_CONFLICT,       "Group/Segment offset size conflict: %s - %s" )
pick( ASSEMBLY_PASSES,                   "Assembly passes reached: %u" )
pick( FILENAME_MUST_BE_ENCLOSED_IN_QUOTES_OR_BRACKETS, "Filename parameter must be enclosed in <> or quotes" )
pick( START_ADDRESS_IGNORED,             "Start address on END directive ignored with .STARTUP" )
pick( INVALID_SYMBOL_TYPE_IN_EXPRESSION, "Invalid symbol type in expression: %s" )
pick( MISSING_RIGHT_PARENTHESIS,         "Missing right parenthesis" )
pick( DIRECTIVE_MUST_BE_IN_CONTROL_BLOCK,"Directive must be in control block" )
pick( EXPECTED_MEMORY_MODEL,             "Expected: memory model" )
pick( TYPE_IS_WRONG_SIZE_FOR_REGISTER,   "Type is wrong size for register" )
pick( IFDEF_EXPECTS_SYMBOL_ARGUMENT,     "IF[n]DEF expects a plain symbol as argument: %s" )
pick( JUMP_DESTINATION_MUST_SPECIFY_A_LABEL, "Jump destination must specify a label" )
pick( TOKEN_IGNORED,                     "Ignored: %s" )
pick( MISSING_ARGUMENT_FOR_CMDLINE_OPTION, "Missing argument for cmdline option" )
pick( INVALID_COPROCESSOR_REGISTER,      "Invalid coprocessor register" )
#if AMD64_SUPPORT
pick( INVALID_USAGE_OF_AHBHCHDH,         "Registers AH-DH may not be used with SPL-DIL or R8-R15" )
pick( ENDPROLOG_FOUND_BEFORE_EH_DIRECTIVES, ".ENDPROLOG found before EH directives" )
pick( MISSING_FRAME_IN_PROC,             "Missing FRAME in PROC, no unwind code will be generated" )
pick( BAD_ALIGNMENT_FOR_OFFSET_IN_UNWIND_CODE, "Bad alignment for offset in unwind code" )
pick( NONZERO_VALUE_EXPECTED,            "Nonzero value expected" )
pick( SIZE_OF_PROLOG_TOO_BIG,            "Size of prolog too big, must be < 256 bytes" )
pick( MISSING_ENDPROLOG,                 "Missing .ENDPROLOG: %s" )
#endif
pick( SAFESEH_ARGUMENT_MUST_BE_A_PROC,   ".SAFESEH argument must be a PROC" )
pick( DIRECTIVE_IGNORED_WITHOUT_X,       "Directive ignored without -%s switch" )
#if ELF_SUPPORT
pick( ELF_GNU_EXTENSIONS_USED,           "ELF GNU extensions (8/16-bit relocations) used" )
#endif
pick( SYNTAX_ERROR_IN_EXPRESSION,        "Syntax error in expression" )
pick( MACRO_LABEL_NOT_DEFINED,           "Macro label not defined: %s" )
pick( PROCEDURE_ARGUMENT_OR_LOCAL_NOT_REFERENCED, "Procedure argument or local not referenced: %s" )
pick( GROUP_TOO_LARGE,                   "Group too large, truncated: %s" )
pick( COMM_VAR_EXCEEDS_64K,              "COMM variable exceeds 64K: %s" )
pick( MUST_BE_PUBLIC_OR_EXTERNAL,        "Must be public or external: %s" )
pick( PARAM_IS_RESERVED_WORD,            "parameter/local name is reserved word: %s" )
pick( REAL_OR_BCD_NUMBER_NOT_ALLOWED,    "real or BCD number not allowed" )
pick( STRUCTURE_FIELD_EXPECTED,          "structure field expected" )
pick( CONSTANT_VALUE_TOO_LARGE_EX,       "Constant value too large: %I64X%016I64Xh" )
pick( ELSE_CLAUSE_ALREADY_OCCURED_IN_THIS_IF_BLOCK, "ELSE clause already occured in this IF block" )
pick( ILLEGAL_USE_OF_SEGMENT_REGISTER,   "Illegal use of segment register" )
