/****************************************************************************
*
* Description:  table of instructions. Other reserved words see special.h
*
****************************************************************************/

/* The order of items for an opcode (ins + insn) is IMPORTANT!
 * And op1 has a higher precedence than op2.
 * operands with type OP_A should be before OP_Rx & OP_R
 * operands with type OP_M should follow OP_Mx
 * operands with type OP_R should follow OP_Rx
 * operands with type OP_I should follow OP_Ix
 */

/* v1.96: the table needn't be sorted anymore, but
 * "additional" (=insn) entries must still be located after the
 * main (=ins) entry. These entries must have a <suffix> so that <tok> +
 * <suffix> gives a unique identifier.
 */

/* branch instructions */
/* there are some macros in codegen.h which rely on the order of the
 * branch tokens. To satisfy those make sure:
 * - the branch instructions are in order CALL, JMP, Jcc, JeCXZ, LOOPcc
 * - no other instruction between these
 */

/*   tok   (suffix)             op1-3                       b1_inf  op_dir rm_inf opcode    rm_byte     cpu      prefix */

ins (CALL, call, 4,             OpCls( I16,  NONE,  NONE  ), 0,      0,  no_RM,  0xE8,     0x00,       P_86,        0)
insn(CALL, 1,                   OpCls( I32,  NONE,  NONE  ), 0,      0,  no_RM,  0xE8,     0x00,       P_386,       0)
insn(CALL, 2,                   OpCls( RGT8, NONE,  NONE  ), 0,      0,  no_WDS, 0xFF,     0x10,       P_86,        0)
insn(CALL, 3,                   OpCls( M32,  NONE,  NONE  ), F_32,   0,  no_WDS, 0xFF,     0x10,       P_386,       0)
insn(CALL, 4,                   OpCls( M16,  NONE,  NONE  ), F_16,   0,  no_WDS, 0xFF,     0x10,       P_86,        0)
/* start entries for FAR call */
insm(CALL, 6,                   OpCls( I32,  NONE,  NONE  ), F_16,   0,  no_RM,  0x9A,     0x00,       P_86,        0)
insn(CALL, 7,                   OpCls( I48,  NONE,  NONE  ), F_32,   0,  no_RM,  0x9A,     0x00,       P_386,       0)
insn(CALL, 8,                   OpCls( M32,  NONE,  NONE  ), F_16,   0,  no_WDS, 0xFF,     0x18,       P_86,        0)
insn(CALL, 9,                   OpCls( M48,  NONE,  NONE  ), F_32,   0,  no_WDS, 0xFF,     0x18,       P_386,       0)
ins (JMP, jmp, 3,               OpCls( I8,   NONE,  NONE  ), 0,      0,  no_RM,  0xEB,     0x00,       P_86,        0)
insn(JMP, 1,                    OpCls( I16,  NONE,  NONE  ), 0,      0,  no_RM,  0xE9,     0x00,       P_86,        0)
insn(JMP, 2,                    OpCls( I32,  NONE,  NONE  ), 0,      0,  no_RM,  0xE9,     0x00,       P_386,       0)
insn(JMP, 3,                    OpCls( RGT8, NONE,  NONE  ), 0,      0,  no_WDS, 0xFF,     0x20,       P_86,        0)
insn(JMP, 4,                    OpCls( M32,  NONE,  NONE  ), F_32,   0,  no_WDS, 0xFF,     0x20,       P_386,       0)
insn(JMP, 5,                    OpCls( M16,  NONE,  NONE  ), F_16,   0,  no_WDS, 0xFF,     0x20,       P_86,        0)
/* entries for FAR jmp */
insm(JMP, 7,                    OpCls( I32,  NONE,  NONE  ), F_16,   0,  no_RM,  0xEA,     0x00,       P_86,        0)
insn(JMP, 8,                    OpCls( I48,  NONE,  NONE  ), F_32,   0,  no_RM,  0xEA,     0x00,       P_386,       0)
insn(JMP, 9,                    OpCls( M32,  NONE,  NONE  ), F_16,   0,  no_WDS, 0xFF,     0x28,       P_86,        0)
insn(JMP, 10,                   OpCls( M48,  NONE,  NONE  ), F_32,   0,  no_WDS, 0xFF,     0x28,       P_386,       0)

// for conditional jumps, the SHORT version must always be first!
#define jcc( cond, code, condlc, x )      \
ins (J##cond, j##condlc, 1+x,   OpCls( I8,   NONE,  NONE  ), 0,      0,  no_RM, 0x70+code, 0x00,       P_86,        0) \
insn(J##cond, 1,                OpCls( I,    NONE,  NONE  ), F_0F,   0,  no_RM, 0x80+code, 0x00,       P_386,       0)

jcc( A,   0x7,   a, 1 )
jcc( AE,  0x3,  ae, 2 )
jcc( B,   0x2,   b, 1 )
jcc( BE,  0x6,  be, 2 )
jcc( C,   0x2,   c, 1 )
jcc( E,   0x4,   e, 1 )
jcc( G,   0xf,   g, 1 )
jcc( GE,  0xd,  ge, 2 )
jcc( L,   0xc,   l, 1 )
jcc( LE,  0xe,  le, 2 )
jcc( NA,  0x6,  na, 2 )
jcc( NAE, 0x2, nae, 3 )
jcc( NB,  0x3,  nb, 2 )
jcc( NBE, 0x7, nbe, 3 )
jcc( NC,  0x3,  nc, 2 )
jcc( NE,  0x5,  ne, 2 )
jcc( NG,  0xe,  ng, 2 )
jcc( NGE, 0xc, nge, 3 )
jcc( NL,  0xd,  nl, 2 )
jcc( NLE, 0xf, nle, 3 )
jcc( NO,  0x1,  no, 2 )
jcc( NP,  0xb,  np, 2 )
jcc( NS,  0x9,  ns, 2 )
jcc( NZ,  0x5,  nz, 2 )
jcc( O,   0x0,   o, 1 )
jcc( P,   0xa,   p, 1 )
jcc( PE,  0xa,  pe, 2 )
jcc( PO,  0xb,  po, 2 )
jcc( S,   0x8,   s, 1 )
jcc( Z,   0x4,   z, 1 )

#undef jcc

insx(JCXZ,   jcxz,   4,         OpCls( I8,   NONE,  NONE  ), F_16A,  0,  no_RM,  0xE3,     0x00,       P_86,        0, RWF_IA32)
ins (JECXZ,  jecxz,  5,         OpCls( I8,   NONE,  NONE  ), F_32A,  0,  no_RM,  0xE3,     0x00,       P_386,       0)
#if AMD64_SUPPORT
insx(JRCXZ,  jrcxz,  5,         OpCls( I8,   NONE,  NONE  ), 0,      0,  no_RM,  0xE3,     0x00,       P_64,        0, RWF_X64)
#endif
ins (LOOP,   loop,   4,         OpCls( I8,   NONE,  NONE  ), 0,      0,  no_RM,  0xE2,     0x00,       P_86,        0)
ins (LOOPE,  loope,  5,         OpCls( I8,   NONE,  NONE  ), 0,      0,  no_RM,  0xE1,     0x00,       P_86,        0)
ins (LOOPZ,  loopz,  5,         OpCls( I8,   NONE,  NONE  ), 0,      0,  no_RM,  0xE1,     0x00,       P_86,        0)
ins (LOOPNE, loopne, 6,         OpCls( I8,   NONE,  NONE  ), 0,      0,  no_RM,  0xE0,     0x00,       P_86,        0)
ins (LOOPNZ, loopnz, 6,         OpCls( I8,   NONE,  NONE  ), 0,      0,  no_RM,  0xE0,     0x00,       P_86,        0)
ins (LOOPD,  loopd,  5,         OpCls( I8,   NONE,  NONE  ), F_32A,  0,  no_RM,  0xE2,     0x00,       P_386,       0)
ins (LOOPED, looped, 6,         OpCls( I8,   NONE,  NONE  ), F_32A,  0,  no_RM,  0xE1,     0x00,       P_386,       0)
ins (LOOPZD, loopzd, 6,         OpCls( I8,   NONE,  NONE  ), F_32A,  0,  no_RM,  0xE1,     0x00,       P_386,       0)
ins (LOOPNED,loopned,7,         OpCls( I8,   NONE,  NONE  ), F_32A,  0,  no_RM,  0xE0,     0x00,       P_386,       0)
ins (LOOPNZD,loopnzd,7,         OpCls( I8,   NONE,  NONE  ), F_32A,  0,  no_RM,  0xE0,     0x00,       P_386,       0)
insx(LOOPW,  loopw,  5,         OpCls( I8,   NONE,  NONE  ), F_16A,  0,  no_RM,  0xE2,     0x00,       P_86,        0, RWF_IA32)
insx(LOOPEW, loopew, 6,         OpCls( I8,   NONE,  NONE  ), F_16A,  0,  no_RM,  0xE1,     0x00,       P_86,        0, RWF_IA32)
insx(LOOPZW, loopzw, 6,         OpCls( I8,   NONE,  NONE  ), F_16A,  0,  no_RM,  0xE1,     0x00,       P_86,        0, RWF_IA32)
insx(LOOPNEW,loopnew,7,         OpCls( I8,   NONE,  NONE  ), F_16A,  0,  no_RM,  0xE0,     0x00,       P_86,        0, RWF_IA32)
insx(LOOPNZW,loopnzw,7,         OpCls( I8,   NONE,  NONE  ), F_16A,  0,  no_RM,  0xE0,     0x00,       P_86,        0, RWF_IA32)

/* arith instructions. Masm v6 encodes operand types R,R differently
 * (direction bit is NOT set). JWasm does like Masm v8+.
 */

#define ari( name, namelc, code, len )      \
ins (name, namelc, len,         OpCls( RGT8, I8,    NONE  ), 0,      0,  no_WDS, 0x83,     code,       P_86,        0) \
insn(name, 1,                   OpCls( R,    R_MS,  NONE  ), 0,      1,  0,      code+2,   0x00,       P_86,        0) \
insn(name, 3,                   OpCls( A,    I,     NONE  ), 0,      0,  no_RM,  code+4,   0x00,       P_86,        0) \
insn(name, 4,                   OpCls( R,    I,     NONE  ), 0,      0,  0,      0x80,     code,       P_86,        0) \
insn(name, 6,                   OpCls( MGT8, I8,    NONE  ), 0,      0,  no_WDS, 0x83,     code,       P_86,        AP_LOCK) \
insn(name, 7,                   OpCls( MS,   R,     NONE  ), 0,      0,  0,      code,     0x00,       P_86,        AP_LOCK) \
insn(name, 8,                   OpCls( MS,   I,     NONE  ), 0,      0,  0,      0x80,     code,       P_86,        AP_LOCK)

/* v2.02: entries 5+6 replaced by 6 */
/* v2.06: entries 1+2 replaced by 1 */

ari( ADD, add, 0x00, 3 )
ari(  OR,  or, 0x08, 2 )
ari( ADC, adc, 0x10, 3 )
ari( SBB, sbb, 0x18, 3 )
ari( AND, and, 0x20, 3 )
ari( SUB, sub, 0x28, 3 )
ari( XOR, xor, 0x30, 3 )
ari( CMP, cmp, 0x38, 3 )

#undef ari

/* std bitshift instructions */
#define bsi( name, namelc, code )      \
ins (name, namelc, 3,           OpCls( R_MS,  CL_ONLY,    NONE  ), 0,      0,  0,      0xD2,     code,       P_86,        0) \
insn(name, 1,                   OpCls( R_MS,  I_1,        NONE  ), 0,      0,  0,      0xD0,     code,       P_86,        0) \
insn(name, 2,                   OpCls( R_MS,  I8_U,       NONE  ), 0,      0,  0,      0xC0,     code,       P_186,       0)

bsi( RCL, rcl, 0x10 )
bsi( RCR, rcr, 0x18 )
bsi( ROL, rol, 0x00 )
bsi( ROR, ror, 0x08 )
bsi( SAL, sal, 0x20 )
bsi( SAR, sar, 0x38 )
bsi( SHL, shl, 0x20 )
bsi( SHR, shr, 0x28 )

#undef bsi

/* string instructions */

ins (CMPS,  cmps,  4,           OpCls( MS,       MS,         NONE ), 0,      0,  no_RM,  0xA6,     0x00,       P_86,        AP_REPxx)
ins (CMPSB, cmpsb, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xA6,     0x00,       P_86,        AP_REPxx)
insn(CMPSB, 1,                  OpCls( M08,      M08,        NONE ), 0,      0,  no_RM,  0xA6,     0x00,       P_86,        AP_REPxx)
ins (CMPSW, cmpsw, 5,           OpCls( NONE,     NONE,       NONE ), F_16,   1,  no_RM,  0xA7,     0x00,       P_86,        AP_REPxx)
insn(CMPSW, 1,                  OpCls( M16,      M16,        NONE ), F_16,   1,  no_RM,  0xA7,     0x00,       P_86,        AP_REPxx)
ins (CMPSD, cmpsd, 5,           OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0xA7,     0x00,       P_386,       AP_REPxx)
insn(CMPSD, 1,                  OpCls( M32,      M32,        NONE ), F_32,   0,  no_RM,  0xA7,     0x00,       P_386,       AP_REPxx)
insn(CMPSD, 2,                  OpCls( XMM,      XMM_M64,    I8_U ), F_F20F, 1,  no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (INS,   ins,   3,           OpCls( MS,       DX_ONLY,    NONE ), 0,      0,  no_RM,  0x6C,     0x00,       P_186,       AP_REP)
ins (INSB,  insb,  4,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x6C,     0x00,       P_186,       AP_REP)
insn(INSB,  1,                  OpCls( M08,      DX_ONLY,    NONE ), 0,      0,  no_RM,  0x6C,     0x00,       P_186,       AP_REP)
ins (INSW,  insw,  4,           OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0x6D,     0x00,       P_186,       AP_REP)
insn(INSW,  1,                  OpCls( M16,      DX_ONLY,    NONE ), F_16,   0,  no_RM,  0x6D,     0x00,       P_186,       AP_REP)
ins (INSD,  insd,  4,           OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0x6D,     0x00,       P_386,       AP_REP)
insn(INSD,  1,                  OpCls( M32,      DX_ONLY,    NONE ), F_32,   0,  no_RM,  0x6D,     0x00,       P_386,       AP_REP)
ins (LODS,  lods,  4,           OpCls( MS,       NONE,       NONE ), 0,      0,  no_RM,  0xAC,     0x00,       P_86,        AP_REP)
ins (LODSB, lodsb, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xAC,     0x00,       P_86,        AP_REP)
insn(LODSB, 1,                  OpCls( M08,      NONE,       NONE ), 0,      0,  no_RM,  0xAC,     0x00,       P_86,        AP_REP)
ins (LODSW, lodsw, 5,           OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0xAD,     0x00,       P_86,        AP_REP)
insn(LODSW, 1,                  OpCls( M16,      NONE,       NONE ), F_16,   0,  no_RM,  0xAD,     0x00,       P_86,        AP_REP)
ins (LODSD, lodsd, 5,           OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0xAD,     0x00,       P_386,       AP_REP)
insn(LODSD, 1,                  OpCls( M32,      NONE,       NONE ), F_32,   0,  no_RM,  0xAD,     0x00,       P_386,       AP_REP)
ins (MOVS,  movs,  4,           OpCls( MS,       MS,         NONE ), 0,      0,  no_RM,  0xA4,     0x00,       P_86,        AP_REP)
ins (MOVSB, movsb, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xA4,     0x00,       P_86,        AP_REP)
insn(MOVSB, 1,                  OpCls( M08,      M08,        NONE ), 0,      0,  no_RM,  0xA4,     0x00,       P_86,        AP_REP)
ins (MOVSW, movsw, 5,           OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0xA5,     0x00,       P_86,        AP_REP)
insn(MOVSW, 1,                  OpCls( M16,      M16,        NONE ), F_16,   0,  no_RM,  0xA5,     0x00,       P_86,        AP_REP)
ins (MOVSD, movsd, 5,           OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0xA5,     0x00,       P_386,       AP_REP)
insn(MOVSD, 1,                  OpCls( M32,      M32,        NONE ), F_32,   0,  no_RM,  0xA5,     0x00,       P_386,       AP_REP)
insn(MOVSD, 2,                  OpCls( XMM,      XMM_M64,    NONE ), F_F20F, 1,  no_WDS, 0x10,     0x00,       P_686|P_SSE2,0)
insn(MOVSD, 3,                  OpCls( M64,      XMM,        NONE ), F_F20F, 0,  no_WDS, 0x11,     0x00,       P_686|P_SSE2,0)
ins (OUTS,  outs,  4,           OpCls( DX_ONLY,  MS,         NONE ), 0,      0,  no_RM,  0x6E,     0x00,       P_186,       AP_REP)
ins (OUTSB, outsb, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x6E,     0x00,       P_186,       AP_REP)
insn(OUTSB, 1,                  OpCls( DX_ONLY,  M08,        NONE ), 0,      0,  no_RM,  0x6E,     0x00,       P_186,       AP_REP)
ins (OUTSW, outsw, 5,           OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0x6F,     0x00,       P_186,       AP_REP)
insn(OUTSW, 1,                  OpCls( DX_ONLY,  M16,        NONE ), F_16,   0,  no_RM,  0x6F,     0x00,       P_186,       AP_REP)
ins (OUTSD, outsd, 5,           OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0x6F,     0x00,       P_386,       AP_REP)
insn(OUTSD, 1,                  OpCls( DX_ONLY,  M32,        NONE ), F_32,   0,  no_RM,  0x6F,     0x00,       P_386,       AP_REP)
ins (SCAS,  scas,  4,           OpCls( MS,       NONE,       NONE ), 0,      0,  no_RM,  0xAE,     0x00,       P_86,        AP_REPxx)
ins (SCASB, scasb, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xAE,     0x00,       P_86,        AP_REPxx)
insn(SCASB, 1,                  OpCls( M08,      NONE,       NONE ), 0,      0,  no_RM,  0xAE,     0x00,       P_86,        AP_REPxx)
ins (SCASW, scasw, 5,           OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0xAF,     0x00,       P_86,        AP_REPxx)
insn(SCASW, 1,                  OpCls( M16,      NONE,       NONE ), F_16,   0,  no_RM,  0xAF,     0x00,       P_86,        AP_REPxx)
ins (SCASD, scasd, 5,           OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0xAF,     0x00,       P_386,       AP_REPxx)
insn(SCASD, 1,                  OpCls( M32,      NONE,       NONE ), F_32,   0,  no_RM,  0xAF,     0x00,       P_386,       AP_REPxx)
ins (STOS,  stos,  4,           OpCls( MS,       NONE,       NONE ), 0,      0,  no_RM,  0xAA,     0x00,       P_86,        AP_REP)
ins (STOSB, stosb, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xAA,     0x00,       P_86,        AP_REP)
insn(STOSB, 1,                  OpCls( M08,      NONE,       NONE ), 0,      0,  no_RM,  0xAA,     0x00,       P_86,        AP_REP)
ins (STOSW, stosw, 5,           OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0xAB,     0x00,       P_86,        AP_REP)
insn(STOSW, 1,                  OpCls( M16,      NONE,       NONE ), F_16,   0,  no_RM,  0xAB,     0x00,       P_86,        AP_REP)
ins (STOSD, stosd, 5,           OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0xAB,     0x00,       P_386,       AP_REP)
insn(STOSD, 1,                  OpCls( M32,      NONE,       NONE ), F_32,   0,  no_RM,  0xAB,     0x00,       P_386,       AP_REP)

/* instructions invalid for IA32+ */

insx(AAA, aaa, 3,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x37,     0x00,       P_86,        0, RWF_IA32 )
insx(AAD, aad, 3,               OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD5,     0x0A,       P_86,        0, RWF_IA32 )
insx(AAM, aam, 3,               OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD4,     0x0A,       P_86,        0, RWF_IA32 )
insx(AAS, aas, 3,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x3F,     0x00,       P_86,        0, RWF_IA32 )
insx(DAA, daa, 3,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x27,     0x00,       P_86,        0, RWF_IA32 )
insx(DAS, das, 3,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x2F,     0x00,       P_86,        0, RWF_IA32 )
insx(LDS, lds, 3,               OpCls( RGT8,     MFPTR,      NONE ), 0,      1,  no_WDS, 0xC5,     0x00,       P_86,        0, RWF_IA32 )
insx(LES, les, 3,               OpCls( RGT8,     MFPTR,      NONE ), 0,      1,  no_WDS, 0xC4,     0x00,       P_86,        0, RWF_IA32 )
insx(POPA,  popa,  4,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x61,     0x00,       P_186,       0, RWF_IA32 )
insx(POPAD, popad, 5,           OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0x61,     0x00,       P_386,       0, RWF_IA32 )
insx(POPAW, popaw, 5,           OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0x61,     0x00,       P_186,       0, RWF_IA32 )
insx(POPFD, popfd, 5,           OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0x9D,     0x00,       P_386,       0, RWF_IA32 )
insx(PUSHA,  pusha,  5,         OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x60,     0x00,       P_186,       0, RWF_IA32 )
insx(PUSHAD, pushad, 6,         OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0x60,     0x00,       P_386,       0, RWF_IA32 )
insx(PUSHAW, pushaw, 6,         OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0x60,     0x00,       P_186,       0, RWF_IA32 )
insx(PUSHFD, pushfd, 6,         OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0x9C,     0x00,       P_386,       0, RWF_IA32 )
insx(PUSHD,  pushd,  5,         OpCls( I8,       NONE,       NONE ), F_32,   0,  R_in_OP,0x6A,     0x00,       P_386,       0, RWF_IA32 )
insn(PUSHD,  1,                 OpCls( I32,      NONE,       NONE ), F_32,   0,  R_in_OP,0x68,     0x00,       P_386,       0)
insn(PUSHD,  2,                 OpCls( R32,      NONE,       NONE ), 0,      0,  R_in_OP,0x50,     0x00,       P_386,       0)
insn(PUSHD,  3,                 OpCls( SR86,     NONE,       NONE ), 0,      1,  R_in_OP,0x06,     0x00,       P_86,        0)
insn(PUSHD,  4,                 OpCls( SR,       NONE,       NONE ), F_0F,   1,  R_in_OP,0x80,     0x00,       P_386,       0)
insn(PUSHD,  5,                 OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xFF,     0x30,       P_386,       0)
insx(RETD, retd, 4,             OpCls( I16,      NONE,       NONE ), F_32,   0,  no_RM,  0xCA,     0x00,       P_386,       0, RWF_IA32 )
insn(RETD, 1,                   OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0xCB,     0x00,       P_386,       0)
insx(RETW, retw, 4,             OpCls( I16,      NONE,       NONE ), F_16,   0,  no_RM,  0xCA,     0x00,       P_86,        0, RWF_IA32 )
insn(RETW, 1,                   OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0xCB,     0x00,       P_86,        0)

/* protected-mode instructions */
/* some (i.e. SMSW) also work with 32bit register as first operand, but Masm won't accept.
 * to make JWasm accept, change OP_R16 to OP_RGT8
 */

ins (ARPL, arpl, 4,             OpCls( R16_M16,  R16,      NONE ), 0,       0,  no_WDS, 0x63,     0x00,       P_286,       0)
ins (LLDT, lldt, 4,             OpCls( R16_M16,  NONE,     NONE ), F_0FNO66,0,  no_WDS, 0x00,     0x10,       P_286p,      0)
ins (LMSW, lmsw, 4,             OpCls( R16_M16,  NONE,     NONE ), F_0FNO66,0,  no_WDS, 0x01,     0x30,       P_286p,      0)
ins (LTR,  ltr,  3,             OpCls( R16_M16,  NONE,     NONE ), F_0FNO66,0,  no_WDS, 0x00,     0x18,       P_286p,      0)
ins (SLDT, sldt, 4,             OpCls( R16_M16,  NONE,     NONE ), F_0FNO66,0,  no_WDS, 0x00,     0x00,       P_286,       0)
ins (SMSW, smsw, 4,             OpCls( R16_M16,  NONE,     NONE ), F_0FNO66,0,  no_WDS, 0x01,     0x20,       P_286,       0)
ins (STR,  str,  3,             OpCls( R16_M16,  NONE,     NONE ), F_0FNO66,0,  no_WDS, 0x00,     0x08,       P_286,       0)
ins (VERR, verr, 4,             OpCls( R16_M16,  NONE,     NONE ), F_0FNO66,0,  no_WDS, 0x00,     0x20,       P_286,       0)
ins (VERW, verw, 4,             OpCls( R16_M16,  NONE,     NONE ), F_0FNO66,0,  no_WDS, 0x00,     0x28,       P_286,       0)
/* v2.06: obsolete */
//insn(ARPL, 1,                   OP_M16,      OP_R16,       OP_NONE, 0,       0,  no_WDS, 0x63,     0x00,       P_286,       0)
//insn(LLDT, 1,                   OP_M16,      OP_NONE,      OP_NONE, F_0FNO66,0,  no_WDS, 0x00,     0x10,       P_286p,      0)
//insn(LMSW, 1,                   OP_M16,      OP_NONE,      OP_NONE, F_0FNO66,0,  no_WDS, 0x01,     0x30,       P_286p,      0)
//insn(LTR,  1,                   OP_M16,      OP_NONE,      OP_NONE, F_0FNO66,0,  no_WDS, 0x00,     0x18,       P_286p,      0)
//insn(SLDT, 1,                   OP_M16,      OP_NONE,      OP_NONE, F_0FNO66,0,  no_WDS, 0x00,     0x00,       P_286,       0)
//insn(SMSW, 1,                   OP_M16,      OP_NONE,      OP_NONE, F_0FNO66,0,  no_WDS, 0x01,     0x20,       P_286,       0)
//insn(STR,  1,                   OP_M16,      OP_NONE,      OP_NONE, F_0FNO66,0,  no_WDS, 0x00,     0x08,       P_286,       0)
//insn(VERR, 1,                   OP_M16,      OP_NONE,      OP_NONE, F_0FNO66,0,  no_WDS, 0x00,     0x20,       P_286,       0)
//insn(VERW, 1,                   OP_M16,      OP_NONE,      OP_NONE, F_0FNO66,0,  no_WDS, 0x00,     0x28,       P_286,       0)

/* one-operand register/memory instructions */

ins (DIV, div, 3,               OpCls( R,        NONE,       NONE ), 0,      0,  0,      0xF6,     0x30,       P_86,        0)
insn(DIV, 1,                    OpCls( M08,      NONE,       NONE ), 0,      0,  0,      0xF6,     0x30,       P_86,        0)
insn(DIV, 2,                    OpCls( MGT8,     NONE,       NONE ), 0,      0,  0,      0xF7,     0x30,       P_86,        0)
ins (IDIV, idiv, 4,             OpCls( R,        NONE,       NONE ), 0,      0,  0,      0xF6,     0x38,       P_86,        0)
insn(IDIV, 1,                   OpCls( M08,      NONE,       NONE ), 0,      0,  0,      0xF6,     0x38,       P_86,        0)
insn(IDIV, 2,                   OpCls( MGT8,     NONE,       NONE ), 0,      0,  0,      0xF7,     0x38,       P_86,        0)
ins (MUL, mul, 3,               OpCls( R,        NONE,       NONE ), 0,      0,  0,      0xF6,     0x20,       P_86,        0)
insn(MUL, 1,                    OpCls( M08,      NONE,       NONE ), 0,      0,  0,      0xF6,     0x20,       P_86,        0)
insn(MUL, 2,                    OpCls( MGT8,     NONE,       NONE ), 0,      0,  0,      0xF7,     0x20,       P_86,        0)
ins (NEG, neg, 3,               OpCls( R,        NONE,       NONE ), 0,      0,  0,      0xF6,     0x18,       P_86,        0)
insn(NEG, 1,                    OpCls( M08,      NONE,       NONE ), 0,      0,  0,      0xF6,     0x18,       P_86,        AP_LOCK)
insn(NEG, 2,                    OpCls( MGT8,     NONE,       NONE ), 0,      0,  0,      0xF7,     0x18,       P_86,        AP_LOCK)
ins (NOT, not, 3,               OpCls( R,        NONE,       NONE ), 0,      0,  0,      0xF6,     0x10,       P_86,        0)
insn(NOT, 1,                    OpCls( M08,      NONE,       NONE ), 0,      0,  0,      0xF6,     0x10,       P_86,        AP_LOCK)
insn(NOT, 2,                    OpCls( MGT8,     NONE,       NONE ), 0,      0,  0,      0xF7,     0x10,       P_86,        AP_LOCK)

/* prefixes. must start with LOCK, end with REPZ and be consecutive */
ins (LOCK,  lock,  4,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF0,     0,          P_86,        AP_LOCK)
ins (REP,   rep,   3,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF3,     0,          P_86,        AP_REP)
ins (REPE,  repe,  4,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF3,     0,          P_86,        AP_REPxx)
ins (REPNE, repne, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF2,     0,          P_86,        AP_REPxx)
ins (REPNZ, repnz, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF2,     0,          P_86,        AP_REPxx)
ins (REPZ,  repz,  4,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF3,     0,          P_86,        AP_REPxx)

/* BTx */

ins (BT, bt, 2,                 OpCls( RGT8,     RGT8,       NONE ), F_0F,   0,  no_WDS, 0xA3,     0x00,       P_386,       0)
insn(BT,   1,                   OpCls( RGT8,     I8_U,       NONE ), F_0F,   0,  no_WDS, 0xBA,     0x20,       P_386,       0)
insn(BT,   2,                   OpCls( MGT8,     RGT8,       NONE ), F_0F,   0,  no_WDS, 0xA3,     0x00,       P_386,       0)
insn(BT,   3,                   OpCls( MGT8,     I8_U,       NONE ), F_0F,   0,  no_WDS, 0xBA,     0x20,       P_386,       0)
ins (BTC, btc, 3,               OpCls( RGT8,     RGT8,       NONE ), F_0F,   0,  no_WDS, 0xBB,     0x00,       P_386,       0)
insn(BTC,  1,                   OpCls( RGT8,     I8_U,       NONE ), F_0F,   0,  no_WDS, 0xBA,     0x38,       P_386,       0)
insn(BTC,  2,                   OpCls( MGT8,     RGT8,       NONE ), F_0F,   0,  no_WDS, 0xBB,     0x00,       P_386,       AP_LOCK)
insn(BTC,  3,                   OpCls( MGT8,     I8_U,       NONE ), F_0F,   0,  no_WDS, 0xBA,     0x38,       P_386,       AP_LOCK)
ins (BTR, btr, 3,               OpCls( RGT8,     RGT8,       NONE ), F_0F,   0,  no_WDS, 0xB3,     0x00,       P_386,       0)
insn(BTR,  1,                   OpCls( RGT8,     I8_U,       NONE ), F_0F,   0,  no_WDS, 0xBA,     0x30,       P_386,       0)
insn(BTR,  2,                   OpCls( MGT8,     RGT8,       NONE ), F_0F,   0,  no_WDS, 0xB3,     0x00,       P_386,       AP_LOCK)
insn(BTR,  3,                   OpCls( MGT8,     I8_U,       NONE ), F_0F,   0,  no_WDS, 0xBA,     0x30,       P_386,       AP_LOCK)
ins (BTS, bts, 3,               OpCls( RGT8,     RGT8,       NONE ), F_0F,   0,  no_WDS, 0xAB,     0x00,       P_386,       0)
insn(BTS,  1,                   OpCls( RGT8,     I8_U,       NONE ), F_0F,   0,  no_WDS, 0xBA,     0x28,       P_386,       0)
insn(BTS,  2,                   OpCls( MGT8,     RGT8,       NONE ), F_0F,   0,  no_WDS, 0xAB,     0x00,       P_386,       AP_LOCK)
insn(BTS,  3,                   OpCls( MGT8,     I8_U,       NONE ), F_0F,   0,  no_WDS, 0xBA,     0x28,       P_386,       AP_LOCK)

/* set/reset flags */

ins (CMC, cmc, 3,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF5,     0x00,       P_86,        0)
ins (CLC, clc, 3,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF8,     0x00,       P_86,        0)
ins (STC, stc, 3,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF9,     0x00,       P_86,        0)
ins (CLI, cli, 3,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xFA,     0x00,       P_86,        0)
ins (STI, sti, 3,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xFB,     0x00,       P_86,        0)
ins (CLD, cld, 3,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xFC,     0x00,       P_86,        0)
ins (STD, std, 3,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xFD,     0x00,       P_86,        0)

/* INC/DEC. (hack for 64-bit in reswords.c!) */

ins (INC, inc, 3,               OpCls( RGT8,     NONE,       NONE ), 0,      0,  R_in_OP,0x40,     0x00,       P_86,        0)
insn(INC, 1,                    OpCls( R,        NONE,       NONE ), 0,      0,  0,      0xFE,     0x00,       P_86,        0)
insn(INC, 2,                    OpCls( M08,      NONE,       NONE ), 0,      0,  0,      0xFE,     0x00,       P_86,        AP_LOCK)
insn(INC, 3,                    OpCls( MGT8,     NONE,       NONE ), 0,      0,  0,      0xFF,     0x00,       P_86,        AP_LOCK)
ins (DEC, dec, 3,               OpCls( RGT8,     NONE,       NONE ), 0,      0,  R_in_OP,0x48,     0x00,       P_86,        0)
insn(DEC, 1,                    OpCls( R,        NONE,       NONE ), 0,      0,  0,      0xFE,     0x08,       P_86,        0)
insn(DEC, 2,                    OpCls( M08,      NONE,       NONE ), 0,      0,  0,      0xFE,     0x08,       P_86,        AP_LOCK)
insn(DEC, 3,                    OpCls( MGT8,     NONE,       NONE ), 0,      0,  0,      0xFF,     0x08,       P_86,        AP_LOCK)

/* PUSH/POP (16- and 32-bit only) */

ins (PUSH,  push,  4,           OpCls( R16_R32,  NONE,       NONE ), 0,     0,  R_in_OP,0x50,     0x00,       P_86,        0)
insn(PUSH, 1,                   OpCls( I8,       NONE,       NONE ), 0,     0,  R_in_OP,0x6A,     0x00,       P_186,       0)
insn(PUSH, 2,                   OpCls( I,        NONE,       NONE ), 0,     0,  R_in_OP,0x68,     0x00,       P_186,       0)
insn(PUSH, 3,                   OpCls( SR86,     NONE,       NONE ), 0,     1,  R_in_OP,0x06,     0x00,       P_86,        0)
insn(PUSH, 4,                   OpCls( SR,       NONE,       NONE ), F_0F,  1,  R_in_OP,0x80,     0x00,       P_386,       0)
insn(PUSH, 5,                   OpCls( M16_M32,  NONE,       NONE ), 0,     0,  0,      0xFF,     0x30,       P_86,        0)
ins (POP, pop, 3,               OpCls( R16_R32,  NONE,       NONE ), 0,     0,  R_in_OP,0x58,     0x00,       P_86,        0)
insn(POP, 1,                    OpCls( SR86,     NONE,       NONE ), 0,     1,  R_in_OP,0x07,     0x00,       P_86,        0)
insn(POP, 2,                    OpCls( SR,       NONE,       NONE ), F_0F,  1,  R_in_OP,0x81,     0x00,       P_386,       0)
insn(POP, 3,                    OpCls( M16_M32,  NONE,       NONE ), 0,     0,  0,      0x8F,     0x00,       P_86,        0)
ins (PUSHW,  pushw,  5,         OpCls( I8,       NONE,       NONE ), F_16,  0,  R_in_OP,0x6A,     0x00,       P_186,       0)
insn(PUSHW,  1,                 OpCls( I16,      NONE,       NONE ), F_16,  0,  R_in_OP,0x68,     0x00,       P_186,       0)
ins (PUSHF,  pushf,  5,         OpCls( NONE,     NONE,       NONE ), F_16,  0,  no_RM,  0x9C,     0x00,       P_86,        0)
ins (POPF,  popf,  4,           OpCls( NONE,     NONE,       NONE ), F_16,  0,  no_RM,  0x9D,     0x00,       P_86,        0)

/* MOV */

ins (MOV, mov, 3,               OpCls( A,        MS,         NONE ), 0,      1,  no_RM,  0xA0,     0x00,       P_86,        0)
insn(MOV, 1,                    OpCls( R,        R_MS,       NONE ), 0,      1,  0,      0x8A,     0x00,       P_86,        0)
insn(MOV, 2,                    OpCls( R8,       I,          NONE ), 0,      0,  R_in_OP,0xB0,     0x00,       P_86,        0)
insn(MOV, 3,                    OpCls( R16_R32,  I,          NONE ), 0,      0,  R_in_OP,0xB8,     0x00,       P_86,        0)
#if AMD64_SUPPORT
insn(MOV, 4,                    OpCls( R64,      I,          NONE ), 0,      0,  0,      0xC6,     0x00,       P_64,        0)
insn(MOV, 5,                    OpCls( R64,      I64,        NONE ), 0,      0,  R_in_OP,0xB8,     0x00,       P_64,        0)
#endif
insn(MOV, 6,                    OpCls( RGT8,     SR,         NONE ), 0,      0,  no_WDS, 0x8C,     0xC0,       P_86,        0)
insn(MOV, 7,                    OpCls( SR,       RGT8,       NONE ), 0,      1,  no_WDS, 0x8E,     0xC0,       P_86,        0)
insn(MOV, 8,                    OpCls( SR,       MS,         NONE ), 0,      1,  no_WDS, 0x8E,     0x00,       P_86,        0)
insn(MOV, 9,                    OpCls( MS,       A,          NONE ), 0,      0,  no_RM,  0xA2,     0x00,       P_86,        0)
insn(MOV, 10,                   OpCls( MS,       R,          NONE ), 0,      0,  0,      0x88,     0x00,       P_86,        0)
insn(MOV, 11,                   OpCls( MS,       I,          NONE ), 0,      0,  0,      0xC6,     0x00,       P_86,        0)
insn(MOV, 12,                   OpCls( MS,       SR,         NONE ), 0,      0,  no_WDS, 0x8C,     0x00,       P_86,        0)
insn(MOV, 13,                   OpCls( RGT16,    RSPEC,      NONE ), F_0FNO66,0, no_WDS, 0x20,     0xC0,       P_386,       0)
insn(MOV, 14,                   OpCls( RSPEC,    RGT16,      NONE ), F_0FNO66,1, no_WDS, 0x22,     0xC0,       P_386,       0)

/* rest */

ins (BOUND_, bound, 5,          OpCls( RGT8,     MS,         NONE ), 0,      1,  no_WDS, 0x62,     0x00,       P_186,       0)
ins (BSF, bsf, 3,               OpCls( RGT8,     RGT8_MS,    NONE ), F_0F,   1,  no_WDS, 0xBC,     0x00,       P_386,       0)
ins (BSR, bsr, 3,               OpCls( RGT8,     RGT8_MS,    NONE ), F_0F,   1,  no_WDS, 0xBD,     0x00,       P_386,       0)
ins (BSWAP, bswap, 5,           OpCls( RGT16,    NONE,       NONE ), F_0F,   0,  R_in_OP,0xC8,     0x00,       P_486,       0)
ins (CBW, cbw, 3,               OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0x98,     0x00,       P_86,        0)
ins (CDQ, cdq, 3,               OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0x99,     0x00,       P_386,       0)
ins (CWD, cwd, 3,               OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0x99,     0x00,       P_86,        0)
ins (CWDE, cwde, 4,             OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0x98,     0x00,       P_386,       0)
ins (CLTS, clts, 4,             OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0x0F,     0x06,       P_286p,      0)
ins (CMPXCHG, cmpxchg, 7,       OpCls( R,        R,          NONE ), F_0F,   0,  0,      0xB0,     0x00,       P_486,       0)
insn(CMPXCHG, 1,                OpCls( MS,       R,          NONE ), F_0F,   0,  0,      0xB0,     0x00,       P_486,       AP_LOCK)
ins (CMPXCHG8B, cmpxchg8b, 9,   OpCls( M64,      NONE,       NONE ), F_0F,   0,  0,      0xC7,     0x08,       P_586,       AP_LOCK)
ins (CPUID, cpuid, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0x0F,     0xA2,       P_586,       0)
ins (ENTER, enter, 5,           OpCls( I16,      I8_U,       NONE ), 0,      0,  no_RM,  0xC8,     0x00,       P_186,       0)
ins (HLT, hlt, 3,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xF4,     0x00,       P_86,        0)
ins (IMUL, imul, 4,             OpCls( R,        NONE,       NONE ), 0,      0,  0,      0xF6,     0x28,       P_86,        0)
insn(IMUL, 2,                   OpCls( M08,      NONE,       NONE ), 0,      0,  0,      0xF6,     0x28,       P_86,        0)
insn(IMUL, 3,                   OpCls( MGT8,     NONE,       NONE ), 0,      0,  0,      0xF7,     0x28,       P_86,        0)
insn(IMUL, 4,                   OpCls( RGT8,     R_MS,       NONE ), F_0F,   1,  no_WDS, 0xAF,     0x00,       P_386,       0)
insn(IMUL, 6,                   OpCls( RGT8,     I8,         NONE ), 0,      1,  no_WDS, 0x6B,     0x00,       P_186,       0)
insn(IMUL, 7,                   OpCls( RGT8,     I,          NONE ), 0,      1,  no_WDS, 0x69,     0x00,       P_186,       0)
insn(IMUL, 8,                   OpCls( RGT8,     R_MS,       I8_U ), 0,      1,  no_WDS, 0x6B,     0x00,       P_186,       0)
insn(IMUL, 9,                   OpCls( RGT8,     R_MS,       I    ), 0,      1,  no_WDS, 0x69,     0x00,       P_186,       0)
ins (IN, in, 2,                 OpCls( A,        DX_ONLY,    NONE ), 0,      0,  no_RM,  0xEC,     0x00,       P_86,        0)
insn(IN, 1,                     OpCls( A,        I8_U,       NONE ), 0,      0,  no_RM,  0xE4,     0x00,       P_86,        0)
ins (INT, int, 3,               OpCls( I_3,      NONE,       NONE ), 0,      0,  no_RM,  0xCC,     0x00,       P_86,        0)
insn(INT, 1,                    OpCls( I8_U,     NONE,       NONE ), 0,      0,  no_RM,  0xCD,     0x00,       P_86,        0)
ins (INTO, into, 4,             OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xCE,     0x00,       P_86,        0)
ins (INVD, invd, 4,             OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x08,     0x00,       P_486,       0)
ins (INVLPG, invlpg, 6,         OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0x38,       P_486,       0)
ins (IRET, iret, 4,             OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0xCF,     0x00,       P_86,        0)
ins (IRETD, iretd, 5,           OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0xCF,     0x00,       P_386,       0)
ins (IRETDF, iretdf, 6,         OpCls( NONE,     NONE,       NONE ), F_32,   0,  no_RM,  0xCF,     0x00,       P_386,       0)
ins (IRETF, iretf, 5,           OpCls( NONE,     NONE,       NONE ), F_16,   0,  no_RM,  0xCF,     0x00,       P_86,        0)
ins (LAHF, lahf, 4,             OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x9F,     0x00,       P_86,        0)
ins (LAR, lar, 3,               OpCls( RGT8,     RGT8_MS,    NONE ), F_0F,   1,  no_WDS, 0x02,     0x00,       P_286,       0)
ins (LSL, lsl, 3,               OpCls( RGT8,     RGT8_MS,    NONE ), F_0F,   1,  no_WDS, 0x03,     0x00,       P_286,       0)
ins (LEA, lea, 3,               OpCls( RGT8,     MS,         NONE ), 0,      1,  no_WDS, 0x8D,     0x00,       P_86,        0)
ins (LEAVE, leave, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xC9,     0x00,       P_186,       0)
ins (LFS, lfs, 3,               OpCls( RGT8,     MFPTR,      NONE ), F_0F,   1,  no_WDS, 0xB4,     0x00,       P_386,       0)
ins (LGS, lgs, 3,               OpCls( RGT8,     MFPTR,      NONE ), F_0F,   1,  no_WDS, 0xB5,     0x00,       P_386,       0)
ins (LSS, lss, 3,               OpCls( RGT8,     MFPTR,      NONE ), F_0F,   1,  no_WDS, 0xB2,     0x00,       P_386,       0)
ins (LGDT, lgdt, 4,             OpCls( M48,      NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0x10,       P_286p,      0)
ins (LIDT, lidt, 4,             OpCls( M48,      NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0x18,       P_286p,      0)
ins (MOVSX, movsx, 5,           OpCls( RGT8,     R_MS,       NONE ), F_0F,   1,  0,      0xBE,     0x00,       P_386,       0)
ins (MOVZX, movzx, 5,           OpCls( RGT8,     R_MS,       NONE ), F_0F,   1,  0,      0xB6,     0x00,       P_386,       0)
ins (NOP, nop, 3,               OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x90,     0x00,       P_86,        0)
ins (OUT, out, 3,               OpCls( DX_ONLY,  A,          NONE ), 0,      0,  no_RM,  0xEE,     0x00,       P_86,        0)
insn(OUT, 1,                    OpCls( I8_U,     A,          NONE ), 0,      0,  no_RM,  0xE6,     0x00,       P_86,        0)

ins (RDMSR, rdmsr, 5,           OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x32,     0x00,       P_586,       0)
ins (RDPMC, rdpmc, 5,           OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x33,     0x00,       P_686,       0)
ins (RDTSC, rdtsc, 5,           OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x31,     0x00,       P_586,       0)
ins (RDTSCP, rdtscp, 6,         OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0xF9,       P_686,       0)
ins (RET,  ret,  3,             OpCls( I16,      NONE,       NONE ), 0,      0,  no_RM,  0xC2,     0x00,       P_86,        0)
insn(RET,  1,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xC3,     0x00,       P_86,        0)
ins (RETN, retn, 4,             OpCls( I16,      NONE,       NONE ), 0,      0,  no_RM,  0xC2,     0x00,       P_86,        0)
insn(RETN, 1,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xC3,     0x00,       P_86,        0)
ins (RETF, retf, 4,             OpCls( I16,      NONE,       NONE ), 0,      0,  no_RM,  0xCA,     0x00,       P_86,        0)
insn(RETF, 1,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xCB,     0x00,       P_86,        0)
ins (RSM, rsm, 3,               OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0xAA,     0x00,       P_586,       0)
ins (SAHF, sahf, 4,             OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x9E,     0x00,       P_86,        0)
ins (SGDT, sgdt, 4,             OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0x00,       P_286,       0)
ins (SIDT, sidt, 4,             OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0x08,       P_286,       0)
ins (SHLD, shld, 4,             OpCls( RGT8_MGT8,RGT8,       CL   ), F_0F,   0,  no_WDS, 0xA5,     0x00,       P_386,       0)
insn(SHLD, 1,                   OpCls( RGT8_MGT8,RGT8,       I8_U ), F_0F,   0,  no_WDS, 0xA4,     0x00,       P_386,       0)
ins (SHRD, shrd, 4,             OpCls( RGT8_MGT8,RGT8,       CL   ), F_0F,   0,  no_WDS, 0xAD,     0x00,       P_386,       0)
insn(SHRD, 1,                   OpCls( RGT8_MGT8,RGT8,       I8_U ), F_0F,   0,  no_WDS, 0xAC,     0x00,       P_386,       0)
ins (SYSENTER, sysenter, 8,     OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x34,     0x00,       P_686,       0)
ins (SYSEXIT, sysexit,7,        OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x35,     0x00,       P_686p,      0)
ins (TEST, test, 4,             OpCls( A,        I,          NONE ), 0,      0,  no_RM,  0xA8,     0x00,       P_86,        0)
insn(TEST, 1,                   OpCls( R,        R_MS,       NONE ), 0,      1,  0,      0x84,     0x00,       P_86,        0)
insn(TEST, 3,                   OpCls( R_MS,     I,          NONE ), 0,      0,  0,      0xF6,     0x00,       P_86,        0)
insn(TEST, 4,                   OpCls( MS,       R,          NONE ), 0,      0,  0,      0x84,     0x00,       P_86,        0)
ins (UD2, ud2, 3,               OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x0B,     0x00,       P_686,       0)
ins (WAIT, wait, 4,             OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x9B,     0x00,       P_86,        0)
ins (WBINVD, wbinvd, 6,         OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x09,     0x00,       P_486,       0)
ins (WRMSR, wrmsr, 5,           OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x30,     0x00,       P_586,       0)
ins (XADD, xadd, 4,             OpCls( R,        R,          NONE ), F_0F,   0,  0,      0xC0,     0x00,       P_486,       0)
insn(XADD, 1,                   OpCls( MS,       R,          NONE ), F_0F,   0,  0,      0xC0,     0x00,       P_486,       AP_LOCK)
ins (XCHG, xchg, 4,             OpCls( A,        RGT8,       NONE ), 0,      0,  R_in_OP,0x90,     0x00,       P_86,        0)
insn(XCHG, 1,                   OpCls( RGT8,     A,          NONE ), 0,      0,  R_in_OP,0x90,     0x00,       P_86,        0)
insn(XCHG, 2,                   OpCls( R,        R,          NONE ), 0,      1,  0,      0x86,     0x00,       P_86,        0)
insn(XCHG, 3,                   OpCls( R,        MS,         NONE ), 0,      1,  0,      0x86,     0x00,       P_86,        AP_LOCK)
insn(XCHG, 4,                   OpCls( MS,       R,          NONE ), 0,      0,  0,      0x86,     0x00,       P_86,        AP_LOCK)
ins (XLAT, xlat, 4,             OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xD7,     0x00,       P_86,        0)
insn(XLAT, 1,                   OpCls( M08,      NONE,       NONE ), 0,      0,  no_RM,  0xD7,     0x00,       P_86,        0)
ins (XLATB, xlatb, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0xD7,     0x00,       P_86,        0)
insn(XLATB, 1,                  OpCls( M08,      NONE,       NONE ), 0,      0,  no_RM,  0xD7,     0x00,       P_86,        0)

ins (SETA,  seta,  4,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x97,     0x00,       P_386,       0)
ins (SETAE, setae, 5,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x93,     0x00,       P_386,       0)
ins (SETB,  setb,  4,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x92,     0x00,       P_386,       0)
ins (SETBE, setbe, 5,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x96,     0x00,       P_386,       0)
ins (SETC,  setc,  4,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x92,     0x00,       P_386,       0)
ins (SETE,  sete,  4,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x94,     0x00,       P_386,       0)
ins (SETG,  setg,  4,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9F,     0x00,       P_386,       0)
ins (SETGE, setge, 5,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9D,     0x00,       P_386,       0)
ins (SETL,  setl,  4,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9C,     0x00,       P_386,       0)
ins (SETLE, setle, 5,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9E,     0x00,       P_386,       0)
ins (SETNA, setna, 5,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x96,     0x00,       P_386,       0)
ins (SETNAE,setnae,6,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x92,     0x00,       P_386,       0)
ins (SETNB, setnb, 5,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x93,     0x00,       P_386,       0)
ins (SETNBE,setnbe,6,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x97,     0x00,       P_386,       0)
ins (SETNC, setnc, 5,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x93,     0x00,       P_386,       0)
ins (SETNE, setne, 5,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x95,     0x00,       P_386,       0)
ins (SETNG, setng, 5,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9E,     0x00,       P_386,       0)
ins (SETNGE,setnge,6,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9C,     0x00,       P_386,       0)
ins (SETNL, setnl, 5,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9D,     0x00,       P_386,       0)
ins (SETNLE,setnle,6,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9F,     0x00,       P_386,       0)
ins (SETNO, setno, 5,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x91,     0x00,       P_386,       0)
ins (SETNP, setnp, 5,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9B,     0x00,       P_386,       0)
ins (SETNS, setns, 5,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x99,     0x00,       P_386,       0)
ins (SETNZ, setnz, 5,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x95,     0x00,       P_386,       0)
ins (SETO,  seto,  4,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x90,     0x00,       P_386,       0)
ins (SETP,  setp,  4,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9A,     0x00,       P_386,       0)
ins (SETPE, setpe, 5,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9A,     0x00,       P_386,       0)
ins (SETPO, setpo, 5,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x9B,     0x00,       P_386,       0)
ins (SETS,  sets,  4,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x98,     0x00,       P_386,       0)
ins (SETZ,  setz,  4,           OpCls( R8_M08,   NONE,       NONE ), F_0F,   0,  no_WDS, 0x94,     0x00,       P_386,       0)

#define cmov( cond, code, condlc, x )      \
ins (CMOV##cond, cmov##condlc, 4+x,      OpCls( RGT8,     R_MS,    NONE ), F_0F,   1,  no_WDS, 0x40+code,0x00,   P_686,   0)

cmov( A,   0x7,   a, 1 )
cmov( AE,  0x3,  ae, 2 )
cmov( B,   0x2,   b, 1 )
cmov( BE,  0x6,  be, 2 )
cmov( C,   0x2,   c, 1 )
cmov( E,   0x4,   e, 1 )
cmov( G,   0xf,   g, 1 )
cmov( GE,  0xd,  ge, 2 )
cmov( L,   0xc,   l, 1 )
cmov( LE,  0xe,  le, 2 )
cmov( NA,  0x6,  na, 2 )
cmov( NAE, 0x2, nae, 3 )
cmov( NB,  0x3,  nb, 2 )
cmov( NBE, 0x7, nbe, 3 )
cmov( NC,  0x3,  nc, 2 )
cmov( NE,  0x5,  ne, 2 )
cmov( NG,  0xe,  ng, 2 )
cmov( NGE, 0xc, nge, 3 )
cmov( NL,  0xd,  nl, 2 )
cmov( NLE, 0xf, nle, 3 )
cmov( NO,  0x1,  no, 2 )
cmov( NP,  0xb,  np, 2 )
cmov( NS,  0x9,  ns, 2 )
cmov( NZ,  0x5,  nz, 2 )
cmov( O,   0x0,   o, 1 )
cmov( P,   0xa,   p, 1 )
cmov( PE,  0xa,  pe, 2 )
cmov( PO,  0xb,  po, 2 )
cmov( S,   0x8,   s, 1 )
cmov( Z,   0x4,   z, 1 )

#undef cmov

/* FPU opcodes */

ins (FCMOVB, fcmovb, 6,         OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDA,     0xC0,       P_686,       0)
ins (FCMOVBE, fcmovbe, 7,       OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDA,     0xD0,       P_686,       0)
ins (FCMOVE, fcmove, 6,         OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDA,     0xC8,       P_686,       0)
ins (FCMOVNB, fcmovnb, 7,       OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDB,     0xC0,       P_686,       0)
ins (FCMOVNBE, fcmovnbe, 8,     OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDB,     0xD0,       P_686,       0)
ins (FCMOVNE, fcmovne, 7,       OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDB,     0xC8,       P_686,       0)
ins (FCMOVNU, fcmovnu, 7,       OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDB,     0xD8,       P_686,       0)
ins (FCMOVU, fcmovu, 6,         OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDA,     0xD8,       P_686,       0)

ins (FCOM, fcom, 4,             OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xD8,     0xD0,       P_87,        0)
insn(FCOM, 1,                   OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD8,     0x10,       P_87,        0)
insn(FCOM, 2,                   OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDC,     0x10,       P_87,        0)
insn(FCOM, 3,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD8,     0xD1,       P_87,        0)
ins (FCOMP, fcomp, 5,           OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xD8,     0xD8,       P_87,        0)
insn(FCOMP, 1,                  OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD8,     0x18,       P_87,        0)
insn(FCOMP, 2,                  OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDC,     0x18,       P_87,        0)
insn(FCOMP, 3,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD8,     0xD9,       P_87,        0)
ins (FCOMPP, fcompp, 6,         OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xD9,       P_87,        0)

ins (FUCOM, fucom, 5,           OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xDD,     0xE0,       P_387,       0)
insn(FUCOM, 1,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDD,     0xE1,       P_387,       0)
ins (FUCOMP, fucomp, 6,         OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xDD,     0xE8,       P_387,       0)
insn(FUCOMP, 1,                 OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDD,     0xE9,       P_387,       0)
ins (FUCOMPP, fucompp, 7,       OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDA,     0xE9,       P_387,       0)
ins (FCOMI, fcomi, 5,           OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDB,     0xF0,       P_686,       0)
ins (FCOMIP, fcomip, 6,         OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDF,     0xF0,       P_686,       0)
ins (FUCOMI, fucomi, 6,         OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDB,     0xE8,       P_686,       0)
ins (FUCOMIP, fucomip, 7,       OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xDF,     0xE8,       P_686,       0)

ins (FADD, fadd, 4,             OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDC,     0xC0,       P_87,        0)
insn(FADD, 1,                   OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xD8,     0xC0,       P_87,        0)
insn(FADD, 2,                   OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD8,     0x00,       P_87,        0)
insn(FADD, 3,                   OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDC,     0x00,       P_87,        0)
insn(FADD, 4,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xC1,       P_87,        0)
ins (FADDP, faddp, 5,           OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDE,     0xC0,       P_87,        0)
insn(FADDP, 1,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xC1,       P_87,        0)
ins (FMUL, fmul, 4,             OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDC,     0xC8,       P_87,        0)
insn(FMUL, 1,                   OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xD8,     0xC8,       P_87,        0)
insn(FMUL, 2,                   OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD8,     0x08,       P_87,        0)
insn(FMUL, 3,                   OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDC,     0x08,       P_87,        0)
insn(FMUL, 4,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xC9,       P_87,        0)
ins (FMULP, fmulp, 5,           OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDE,     0xC8,       P_87,        0)
insn(FMULP, 1,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xC9,       P_87,        0)

ins (FDIV, fdiv, 4,             OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDC,     0xF8,       P_87,        0)
insn(FDIV, 1,                   OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xD8,     0xF0,       P_87,        0)
insn(FDIV, 2,                   OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD8,     0x30,       P_87,        0)
insn(FDIV, 3,                   OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDC,     0x30,       P_87,        0)
insn(FDIV, 4,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xF9,       P_87,        0)
ins (FDIVP, fdivp, 5,           OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDE,     0xF8,       P_87,        0)
insn(FDIVP, 1,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xF9,       P_87,        0)
ins (FDIVR, fdivr, 5,           OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDC,     0xF0,       P_87,        0)
insn(FDIVR, 1,                  OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xD8,     0xF8,       P_87,        0)
insn(FDIVR, 2,                  OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD8,     0x38,       P_87,        0)
insn(FDIVR, 3,                  OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDC,     0x38,       P_87,        0)
insn(FDIVR, 4,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xF1,       P_87,        0)
ins (FDIVRP, fdivrp, 6,         OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDE,     0xF0,       P_87,        0)
insn(FDIVRP, 1,                 OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xF1,       P_87,        0)
ins (FSUB, fsub, 4,             OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDC,     0xE8,       P_87,        0)
insn(FSUB, 1,                   OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xD8,     0xE0,       P_87,        0)
insn(FSUB, 2,                   OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD8,     0x20,       P_87,        0)
insn(FSUB, 3,                   OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDC,     0x20,       P_87,        0)
insn(FSUB, 4,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xE9,       P_87,        0)
ins (FSUBP, fsubp, 5,           OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDE,     0xE8,       P_87,        0)
insn(FSUBP, 1,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xE9,       P_87,        0)
ins (FSUBR, fsubr, 5,           OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDC,     0xE0,       P_87,        0)
insn(FSUBR, 1,                  OpCls( ST,       STI,        NONE ), 0,      0,  0,      0xD8,     0xE8,       P_87,        0)
insn(FSUBR, 2,                  OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD8,     0x28,       P_87,        0)
insn(FSUBR, 3,                  OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDC,     0x28,       P_87,        0)
insn(FSUBR, 4,                  OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xE1,       P_87,        0)
ins (FSUBRP, fsubrp, 6,         OpCls( STI,      ST,         NONE ), 0,      0,  0,      0xDE,     0xE0,       P_87,        0)
insn(FSUBRP, 1,                 OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDE,     0xE1,       P_87,        0)

ins (FIADD, fiadd, 5,           OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDA,     0x00,       P_87,        0)
insn(FIADD, 1,                  OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDE,     0x00,       P_87,        0)
ins (FICOM, ficom, 5,           OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDA,     0x10,       P_87,        0)
insn(FICOM, 1,                  OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDE,     0x10,       P_87,        0)
ins (FICOMP, ficomp, 6,         OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDA,     0x18,       P_87,        0)
insn(FICOMP, 1,                 OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDE,     0x18,       P_87,        0)
ins (FIDIV, fidiv, 5,           OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDA,     0x30,       P_87,        0)
insn(FIDIV, 1,                  OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDE,     0x30,       P_87,        0)
ins (FIDIVR, fidivr, 6,         OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDA,     0x38,       P_87,        0)
insn(FIDIVR, 1,                 OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDE,     0x38,       P_87,        0)
ins (FIMUL, fimul, 5,           OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDA,     0x08,       P_87,        0)
insn(FIMUL, 1,                  OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDE,     0x08,       P_87,        0)
ins (FISUB, fisub, 5,           OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDA,     0x20,       P_87,        0)
insn(FISUB, 1,                  OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDE,     0x20,       P_87,        0)
ins (FISUBR, fisubr, 6,         OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDA,     0x28,       P_87,        0)
insn(FISUBR, 1,                 OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDE,     0x28,       P_87,        0)

ins (FILD, fild, 4,             OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDB,     0x00,       P_87,        0)
insn(FILD, 1,                   OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDF,     0x28,       P_87,        0)
insn(FILD, 2,                   OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDF,     0x00,       P_87,        0)
ins (FISTP, fistp, 5,           OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDB,     0x18,       P_87,        0)
insn(FISTP, 1,                  OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDF,     0x38,       P_87,        0)
insn(FISTP, 2,                  OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDF,     0x18,       P_87,        0)
ins (FIST, fist, 4,             OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xDB,     0x10,       P_87,        0)
insn(FIST, 1,                   OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDF,     0x10,       P_87,        0)

ins (FLD, fld, 3,               OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xD9,     0xC0,       P_87,        0)
insn(FLD, 1,                    OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD9,     0x00,       P_87,        0)
insn(FLD, 2,                    OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDD,     0x00,       P_87,        0)
insn(FLD, 3,                    OpCls( M80,      NONE,       NONE ), 0,      0,  0,      0xDB,     0x28,       P_87,        0)
ins (FSTP, fstp, 4,             OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xDD,     0xD8,       P_87,        0)
insn(FSTP, 1,                   OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD9,     0x18,       P_87,        0)
insn(FSTP, 2,                   OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDD,     0x18,       P_87,        0)
insn(FSTP, 3,                   OpCls( M80,      NONE,       NONE ), 0,      0,  0,      0xDB,     0x38,       P_87,        0)
ins (FST, fst, 3,               OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xDD,     0xD0,       P_87,        0)
insn(FST, 1,                    OpCls( M32,      NONE,       NONE ), 0,      0,  0,      0xD9,     0x10,       P_87,        0)
insn(FST, 2,                    OpCls( M64,      NONE,       NONE ), 0,      0,  0,      0xDD,     0x10,       P_87,        0)

ins (FLDENV, fldenv, 6,         OpCls( M_ANY,    NONE,       NONE ), 0,      0,  0,      0xD9,     0x20,       P_87,        0)
ins (FLDENVD, fldenvd, 7,       OpCls( M_ANY,    NONE,       NONE ), F_32,   0,  0,      0xD9,     0x20,       P_387,       0)
ins (FLDENVW, fldenvw, 7,       OpCls( M_ANY,    NONE,       NONE ), F_16,   0,  0,      0xD9,     0x20,       P_87,        0)
ins (FNSAVE, fnsave, 6,         OpCls( M_ANY,    NONE,       NONE ), 0,      0,  0,      0xDD,     0x30,       P_87,        AP_NO_FWAIT)
ins (FNSAVED, fnsaved, 7,       OpCls( M_ANY,    NONE,       NONE ), F_32,   0,  0,      0xDD,     0x30,       P_387,       AP_NO_FWAIT)
ins (FNSAVEW, fnsavew, 7,       OpCls( M_ANY,    NONE,       NONE ), F_16,   0,  0,      0xDD,     0x30,       P_87,        AP_NO_FWAIT)
ins (FNSTENV, fnstenv, 7,       OpCls( M_ANY,    NONE,       NONE ), 0,      0,  0,      0xD9,     0x30,       P_87,        AP_NO_FWAIT)
ins (FNSTENVD, fnstenvd, 8,     OpCls( M_ANY,    NONE,       NONE ), F_32,   0,  0,      0xD9,     0x30,       P_387,       AP_NO_FWAIT)
ins (FNSTENVW, fnstenvw, 8,     OpCls( M_ANY,    NONE,       NONE ), F_16,   0,  0,      0xD9,     0x30,       P_87,        AP_NO_FWAIT)
ins (FRSTOR, frstor, 6,         OpCls( M_ANY,    NONE,       NONE ), 0,      0,  0,      0xDD,     0x20,       P_87,        0)
ins (FRSTORD, frstord, 7,       OpCls( M_ANY,    NONE,       NONE ), F_32,   0,  0,      0xDD,     0x20,       P_387,       0)
ins (FRSTORW, frstorw, 7,       OpCls( M_ANY,    NONE,       NONE ), F_16,   0,  0,      0xDD,     0x20,       P_87,        0)
ins (FSAVE, fsave, 5,           OpCls( M_ANY,    NONE,       NONE ), 0,      0,  0,      0xDD,     0x30,       P_87,        AP_FWAIT)
ins (FSAVED, fsaved, 6,         OpCls( M_ANY,    NONE,       NONE ), F_32,   0,  0,      0xDD,     0x30,       P_387,       AP_FWAIT)
ins (FSAVEW, fsavew, 6,         OpCls( M_ANY,    NONE,       NONE ), F_16,   0,  0,      0xDD,     0x30,       P_87,        AP_FWAIT)
ins (FSTENV, fstenv, 6,         OpCls( M_ANY,    NONE,       NONE ), 0,      0,  0,      0xD9,     0x30,       P_87,        AP_FWAIT)
ins (FSTENVD, fstenvd, 7,       OpCls( M_ANY,    NONE,       NONE ), F_32,   0,  0,      0xD9,     0x30,       P_387,       AP_FWAIT)
ins (FSTENVW, fstenvw, 7,       OpCls( M_ANY,    NONE,       NONE ), F_16,   0,  0,      0xD9,     0x30,       P_87,        AP_FWAIT)

ins (FLDCW, fldcw, 5,           OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xD9,     0x28,       P_87,        0)
ins (FNSTCW, fnstcw, 6,         OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xD9,     0x38,       P_87,        AP_NO_FWAIT)
ins (FNSTSW, fnstsw, 6,         OpCls( AX,       NONE,       NONE ), 0,      0,  no_WDS, 0xDF,     0xE0,       P_287,       AP_NO_FWAIT)
insn(FNSTSW, 1,                 OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDD,     0x38,       P_87,        AP_NO_FWAIT)
ins (FSTCW, fstcw, 5,           OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xD9,     0x38,       P_87,        AP_FWAIT)
ins (FSTSW, fstsw, 5,           OpCls( AX,       NONE,       NONE ), 0,      0,  no_WDS, 0xDF,     0xE0,       P_287,       AP_FWAIT)
insn(FSTSW, 1,                  OpCls( M16,      NONE,       NONE ), 0,      0,  0,      0xDD,     0x38,       P_87,        AP_FWAIT)

ins (FCOS, fcos, 4,             OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xFF,       P_387,       0)
ins (FPATAN, fpatan, 6,         OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF3,       P_87,        0)
ins (FPTAN, fptan, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF2,       P_87,        0)
ins (FSIN, fsin, 4,             OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xFE,       P_387,       0)
ins (FSINCOS, fsincos, 7,       OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xFB,       P_387,       0)

ins (FINIT, finit, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE3,       P_87,        AP_FWAIT)
ins (FNINIT, fninit, 6,         OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE3,       P_87,        AP_NO_FWAIT)
ins (FDISI, fdisi, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE1,       P_87,        AP_FWAIT)
ins (FNDISI, fndisi, 6,         OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE1,       P_87,        AP_NO_FWAIT)
ins (FENI, feni, 4,             OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE0,       P_87,        AP_FWAIT)
ins (FNENI, fneni, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE0,       P_87,        AP_NO_FWAIT)
ins (FCLEX, fclex, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE2,       P_87,        AP_FWAIT)
ins (FNCLEX, fnclex, 6,         OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE2,       P_87,        AP_NO_FWAIT)

ins (F2XM1, f2xm1, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF0,       P_87,        0)
ins (FABS, fabs, 4,             OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xE1,       P_87,        0)
ins (FBLD, fbld, 4,             OpCls( M80,      NONE,       NONE ), 0,      0,  0,      0xDF,     0x20,       P_87,        0)
ins (FBSTP, fbstp, 5,           OpCls( M80,      NONE,       NONE ), 0,      0,  0,      0xDF,     0x30,       P_87,        0)
ins (FCHS, fchs, 4,             OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xE0,       P_87,        0)
ins (FLD1, fld1, 4,             OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xE8,       P_87,        0)
ins (FLDL2E, fldl2e, 6,         OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xEA,       P_87,        0)
ins (FLDL2T, fldl2t, 6,         OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xE9,       P_87,        0)
ins (FLDLG2, fldlg2, 6,         OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xEC,       P_87,        0)
ins (FLDLN2, fldln2, 6,         OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xED,       P_87,        0)
ins (FLDPI, fldpi, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xEB,       P_87,        0)
ins (FLDZ, fldz, 4,             OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xEE,       P_87,        0)
ins (FDECSTP, fdecstp, 7,       OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF6,       P_87,        0)
ins (FINCSTP, fincstp, 7,       OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF7,       P_87,        0)
ins (FFREE, ffree, 5,           OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xDD,     0xC0,       P_87,        0)
/* FFREEP is undocumented (same as FFREE + POP) */
ins (FFREEP, ffreep, 6,         OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xDF,     0xC0,       P_87,        0)
ins (FNOP, fnop, 4,             OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xD0,       P_87,        0)
ins (FPREM, fprem, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF8,       P_87,        0)
ins (FPREM1, fprem1, 6,         OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF5,       P_387,       0)
ins (FRNDINT, frndint, 7,       OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xFC,       P_87,        0)
ins (FSCALE, fscale, 6,         OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xFD,       P_87,        0)
ins (FSETPM, fsetpm, 6,         OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xDB,     0xE4,       P_287,       0)
ins (FSQRT, fsqrt, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xFA,       P_87,        0)
ins (FTST, ftst, 4,             OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xE4,       P_87,        0)
ins (FWAIT, fwait, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x9B,     0x00,       P_87,        0)
ins (FXAM, fxam, 4,             OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xE5,       P_87,        0)
ins (FXCH, fxch, 4,             OpCls( STI,      NONE,       NONE ), 0,      0,  0,      0xD9,     0xC8,       P_87,        0)
insn(FXCH, 1,                   OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xC9,       P_87,        0)
ins (FXRSTOR, fxrstor, 7,       OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0x08,       P_686|P_SSE1,0)
ins (FXSAVE, fxsave, 6,         OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0x00,       P_686|P_SSE1,0)
ins (FXTRACT, fxtract, 7,       OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF4,       P_87,        0)
ins (FYL2X, fyl2x, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF1,       P_87,        0)
ins (FYL2XP1, fyl2xp1, 7,       OpCls( NONE,     NONE,       NONE ), 0,      0,  0,      0xD9,     0xF9,       P_87,        0)

/* MMX/SSE related opcodes (except SSE instructions CMPSD and MOVSD) */

ins (EMMS, emms, 4,             OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x77,     0x00,       P_586|P_MMX, 0)
ins (CLFLUSH, clflush, 7,       OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0x38,       P_686|P_SSE2,0)
ins (LDMXCSR, ldmxcsr, 7,       OpCls( M32,      NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0x10,       P_686|P_SSE1,0)
ins (STMXCSR, stmxcsr, 7,       OpCls( M32,      NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0x18,       P_686|P_SSE1,0)
ins (LFENCE, lfence, 6,         OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0xE8,       P_686|P_SSE2,0)
ins (MFENCE, mfence, 6,         OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0xF0,       P_686|P_SSE2,0)
ins (SFENCE, sfence, 6,         OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0xF8,       P_686|P_SSE1,0)
ins (PREFETCHNTA,prefetchnta,11,OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0x18,     0x00,       P_686|P_SSE1,0)
ins (PREFETCHT0, prefetcht0, 10,OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0x18,     0x08,       P_686|P_SSE1,0)
ins (PREFETCHT1, prefetcht1, 10,OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0x18,     0x10,       P_686|P_SSE1,0)
ins (PREFETCHT2, prefetcht2, 10,OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0x18,     0x18,       P_686|P_SSE1,0)
ins (PAUSE, pause, 5,           OpCls( NONE,     NONE,       NONE ), F_F3,   0,  no_RM,  0x90,     0x00,       P_686|P_SSE2,0)

#define arfl( prefix, prefixlc, len, opc )      \
ins (prefix ## PD, prefixlc ## pd, len,  OpCls( XMM,  XMM_M128,NONE ), F_660F, 1,  no_WDS, opc,   0x00,   P_686|P_SSE2,0) \
ins (prefix ## PS, prefixlc ## ps, len,  OpCls( XMM,  XMM_M128,NONE ), F_0F,   1,  no_WDS, opc,   0x00,   P_686|P_SSE1,0) \
ins (prefix ## SD, prefixlc ## sd, len,  OpCls( XMM,  XMM_M64, NONE ), F_F20F, 1,  no_WDS, opc,   0x00,   P_686|P_SSE2,0) \
ins (prefix ## SS, prefixlc ## ss, len,  OpCls( XMM,  XMM_M32, NONE ), F_F30F, 1,  no_WDS, opc,   0x00,   P_686|P_SSE1,0)

arfl( ADD,  add,  5, 0x58 )
arfl( DIV,  div,  5, 0x5E )
arfl( MAX,  max,  5, 0x5F )
arfl( MIN,  min,  5, 0x5D )
arfl( MUL,  mul,  5, 0x59 )
arfl( SQRT, sqrt, 6, 0x51 )
arfl( SUB,  sub,  5, 0x5C )

/* CMP can't be added because CMPSD is special */
ins (CMPPD, cmppd, 5,           OpCls( XMM,      XMM_M128, I8_U ), F_660F, 1,  no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPPS, cmpps, 5,           OpCls( XMM,      XMM_M128, I8_U ), F_0F,   1,  no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)
//ins (CMPSD, cmpsd, 5            OpCls( XMM,      XMM_M64, I8_U ), F_F20F, 1,  no_WDS, 0xC2,     0x00,       P_686|P_SSE2,0)
ins (CMPSS, cmpss, 5,           OpCls( XMM,      XMM_M32,  I8_U ), F_F30F, 1,  no_WDS, 0xC2,     0x00,       P_686|P_SSE1,0)

#undef arfl

#define cmpxx( suffix, suffixlc, byte1, memop, ssever )      \
ins (CMP ## EQ    ## suffix, cmp ## eq    ## suffixlc, 7, OpCls( XMM, XMM_ ## memop, HID ),byte1, 1, no_WDS, 0xC2, 0x00, P_686|ssever, 0 ) \
ins (CMP ## LT    ## suffix, cmp ## lt    ## suffixlc, 7, OpCls( XMM, XMM_ ## memop, HID ),byte1, 1, no_WDS, 0xC2, 0x00, P_686|ssever, 0 ) \
ins (CMP ## LE    ## suffix, cmp ## le    ## suffixlc, 7, OpCls( XMM, XMM_ ## memop, HID ),byte1, 1, no_WDS, 0xC2, 0x00, P_686|ssever, 0 ) \
ins (CMP ## UNORD ## suffix, cmp ## unord ## suffixlc,10, OpCls( XMM, XMM_ ## memop, HID ),byte1, 1, no_WDS, 0xC2, 0x00, P_686|ssever, 0 ) \
ins (CMP ## NEQ   ## suffix, cmp ## neq   ## suffixlc, 8, OpCls( XMM, XMM_ ## memop, HID ),byte1, 1, no_WDS, 0xC2, 0x00, P_686|ssever, 0 ) \
ins (CMP ## NLT   ## suffix, cmp ## nlt   ## suffixlc, 8, OpCls( XMM, XMM_ ## memop, HID ),byte1, 1, no_WDS, 0xC2, 0x00, P_686|ssever, 0 ) \
ins (CMP ## NLE   ## suffix, cmp ## nle   ## suffixlc, 8, OpCls( XMM, XMM_ ## memop, HID ),byte1, 1, no_WDS, 0xC2, 0x00, P_686|ssever, 0 ) \
ins (CMP ## ORD   ## suffix, cmp ## ord   ## suffixlc, 8, OpCls( XMM, XMM_ ## memop, HID ),byte1, 1, no_WDS, 0xC2, 0x00, P_686|ssever, 0 )

cmpxx( PD, pd, F_660F, M128, P_SSE2 )
cmpxx( PS, ps, F_0F,   M128, P_SSE1 )
cmpxx( SD, sd, F_F20F, M64,  P_SSE2 )
cmpxx( SS, ss, F_F30F, M32,  P_SSE1 )

#undef cmpxx

ins (ANDNPD, andnpd, 6,         OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x55,     0x00,       P_686|P_SSE2,0)
ins (ANDNPS, andnps, 6,         OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x55,     0x00,       P_686|P_SSE1,0)
ins (ANDPD, andpd, 5,           OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x54,     0x00,       P_686|P_SSE2,0)
ins (ANDPS, andps, 5,           OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x54,     0x00,       P_686|P_SSE1,0)
ins (ORPD, orpd, 4,             OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x56,     0x00,       P_686|P_SSE2,0)
ins (ORPS, orps, 4,             OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x56,     0x00,       P_686|P_SSE1,0)
ins (COMISD, comisd, 6,         OpCls( XMM,      XMM_M64,  NONE ), F_660F, 1,  no_WDS, 0x2F,     0x00,       P_686|P_SSE2,0)
ins (COMISS, comiss, 6,         OpCls( XMM,      XMM_M32,  NONE ), F_0F,   1,  no_WDS, 0x2F,     0x00,       P_686|P_SSE1,0)
ins (XORPD, xorpd, 5,           OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x57,     0x00,       P_686|P_SSE2,0)
ins (XORPS, xorps, 5,           OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x57,     0x00,       P_686|P_SSE1,0)

ins (CVTPD2PI, cvtpd2pi, 8,     OpCls( MMX,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x2D,     0x00,       P_686|P_SSE2,0)
ins (CVTPS2PI, cvtps2pi, 8,     OpCls( MMX,      XMM_M64,  NONE ), F_0F,   1,  no_WDS, 0x2D,     0x00,       P_686|P_SSE1,0)
ins (CVTSD2SI, cvtsd2si, 8,     OpCls( RGT16,    XMM_M64,  NONE ), F_F20F, 1,  no_WDS, 0x2D,     0x00,       P_686|P_SSE2,0)
ins (CVTSS2SI, cvtss2si, 8,     OpCls( RGT16,    XMM_M32,  NONE ), F_F30F, 1,  no_WDS, 0x2D,     0x00,       P_686|P_SSE1,0)
ins (CVTPI2PD, cvtpi2pd, 8,     OpCls( XMM,      MMX_M64,  NONE ), F_660F, 1,  no_WDS, 0x2A,     0x00,       P_686|P_SSE2,0)
ins (CVTPI2PS, cvtpi2ps, 8,     OpCls( XMM,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x2A,     0x00,       P_686|P_SSE1,0)
ins (CVTSI2SD, cvtsi2sd, 8,     OpCls( XMM,      RMGT16,   NONE ), F_F20F, 1,  no_WDS, 0x2A,     0x00,       P_686|P_SSE2,0)
ins (CVTSI2SS, cvtsi2ss, 8,     OpCls( XMM,      RMGT16,   NONE ), F_F30F, 1,  no_WDS, 0x2A,     0x00,       P_686|P_SSE1,0)
ins (CVTTPD2PI, cvttpd2pi, 9,   OpCls( MMX,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x2C,     0x00,       P_686|P_SSE2,0)
ins (CVTTPS2PI, cvttps2pi, 9,   OpCls( MMX,      XMM_M64,  NONE ), F_0F,   1,  no_WDS, 0x2C,     0x00,       P_686|P_SSE1,0)
ins (CVTTSD2SI, cvttsd2si, 9,   OpCls( RGT16,    XMM_M64,  NONE ), F_F20F, 1,  no_WDS, 0x2C,     0x00,       P_686|P_SSE2,0)
ins (CVTTSS2SI, cvttss2si, 9,   OpCls( RGT16,    XMM_M32,  NONE ), F_F30F, 1,  no_WDS, 0x2C,     0x00,       P_686|P_SSE1,0)

ins (CVTDQ2PS, cvtdq2ps, 8,     OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x5B,     0x00,       P_686|P_SSE2,0)
ins (CVTPS2DQ, cvtps2dq, 8,     OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x5B,     0x00,       P_686|P_SSE2,0)
ins (CVTTPS2DQ, cvttps2dq, 9,   OpCls( XMM,      XMM_M128, NONE ), F_F30F, 1,  no_WDS, 0x5B,     0x00,       P_686|P_SSE2,0)

ins (CVTPD2DQ, cvtpd2dq, 8,     OpCls( XMM,      XMM_M128, NONE ), F_F20F, 1,  no_WDS, 0xE6,     0x00,       P_686|P_SSE2,0)
ins (CVTDQ2PD, cvtdq2pd, 8,     OpCls( XMM,      XMM_M64,  NONE ), F_F30F, 1,  no_WDS, 0xE6,     0x00,       P_686|P_SSE2,0)
ins (CVTTPD2DQ, cvttpd2dq, 9,   OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE6,     0x00,       P_686|P_SSE2,0)

ins (CVTPD2PS, cvtpd2ps, 8,     OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x5A,     0x00,       P_686|P_SSE2,0)
ins (CVTPS2PD, cvtps2pd, 8,     OpCls( XMM,      XMM_M64,  NONE ), F_0F,   1,  no_WDS, 0x5A,     0x00,       P_686|P_SSE2,0)
ins (CVTSD2SS, cvtsd2ss, 8,     OpCls( XMM,      XMM_M64,  NONE ), F_F20F, 1,  no_WDS, 0x5A,     0x00,       P_686|P_SSE2,0)
ins (CVTSS2SD, cvtss2sd, 8,     OpCls( XMM,      XMM_M32,  NONE ), F_F30F, 1,  no_WDS, 0x5A,     0x00,       P_686|P_SSE2,0)

ins (MASKMOVDQU, maskmovdqu, 10,OpCls( XMM,      XMM,      NONE ), F_660F, 1,  no_WDS, 0xF7,     0x00,       P_686|P_SSE2,0)
ins (MASKMOVQ, maskmovq, 8,     OpCls( MMX,      MMX,      NONE ), F_0F,   1,  no_WDS, 0xF7,     0x00,       P_686|P_SSE1,0)

/* Masm (ML64) uses MOVD if a 64-bit register is src/dst. Intel docs prefer MOVQ */
ins (MOVD, movd, 4,             OpCls( MMX,      RMGT16,   NONE ), F_0F,   1,  no_WDS, 0x6E,     0x00,       P_586|P_MMX, 0)
insn(MOVD, 1,                   OpCls( XMM,      RMGT16,   NONE ), F_660F, 1,  no_WDS, 0x6E,     0x00,       P_686|P_SSE2,0)
#if INTELMOVQ
insn(MOVD, 2,                   OpCls( R32_M32,  MMX,      NONE ), F_0F,   0,  no_WDS, 0x7E,     0x00,       P_586|P_MMX, 0)
insn(MOVD, 3,                   OpCls( R32_M32,  XMM,      NONE ), F_660F, 0,  no_WDS, 0x7E,     0x00,       P_686|P_SSE2,0)
#else
insn(MOVD, 2,                   OpCls( RMGT16,   MMX,      NONE ), F_0F,   0,  no_WDS, 0x7E,     0x00,       P_586|P_MMX, 0)
insn(MOVD, 3,                   OpCls( RMGT16,   XMM,      NONE ), F_660F, 0,  no_WDS, 0x7E,     0x00,       P_686|P_SSE2,0)
#endif
ins (MOVQ, movq, 4,             OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x6F,     0x00,       P_586|P_MMX, 0)
insn(MOVQ, 1,                   OpCls( XMM,      XMM_M64,  NONE ), F_F30F, 1,  no_WDS, 0x7E,     0x00,       P_686|P_SSE2,0)
#if INTELMOVQ
insn(MOVQ, 2,                   OpCls( R64_M64,  MMX,      NONE ), F_0F,   0,  no_WDS, 0x7F,     0x00,       P_586|P_MMX, 0)
insn(MOVQ, 3,                   OpCls( R64_M64,  XMM,      NONE ), F_660F, 0,  no_WDS, 0xD6,     0x00,       P_686|P_SSE2,0)
#else
insn(MOVQ, 2,                   OpCls( M64,      MMX,      NONE ), F_0F,   0,  no_WDS, 0x7F,     0x00,       P_586|P_MMX, 0)
insn(MOVQ, 3,                   OpCls( M64,      XMM,      NONE ), F_660F, 0,  no_WDS, 0xD6,     0x00,       P_686|P_SSE2,0)
#endif

ins (MOVAPD, movapd, 6,         OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x28,     0x00,       P_686|P_SSE2,0)
insn(MOVAPD, 1,                 OpCls( M128,     XMM,      NONE ), F_660F, 0,  no_WDS, 0x29,     0x00,       P_686|P_SSE2,0)
ins (MOVAPS, movaps, 6,         OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x28,     0x00,       P_686|P_SSE1,0)
insn(MOVAPS, 1,                 OpCls( M128,     XMM,      NONE ), F_0F,   0,  no_WDS, 0x29,     0x00,       P_686|P_SSE1,0)
ins (MOVDQA, movdqa, 6,         OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x6F,     0x00,       P_686|P_SSE2,0)
insn(MOVDQA, 1,                 OpCls( M128,     XMM,      NONE ), F_660F, 0,  no_WDS, 0x7F,     0x00,       P_686|P_SSE2,0)
ins (MOVDQU, movdqu, 6,         OpCls( XMM,      XMM_M128, NONE ), F_F30F, 1,  no_WDS, 0x6F,     0x00,       P_686|P_SSE2,0)
insn(MOVDQU, 1,                 OpCls( M128,     XMM,      NONE ), F_F30F, 0,  no_WDS, 0x7F,     0x00,       P_686|P_SSE2,0)
ins (MOVUPD, movupd, 6,         OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x10,     0x00,       P_686|P_SSE2,0)
insn(MOVUPD, 1,                 OpCls( M128,     XMM,      NONE ), F_660F, 0,  no_WDS, 0x11,     0x00,       P_686|P_SSE2,0)
ins (MOVUPS, movups, 6,         OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x10,     0x00,       P_686|P_SSE1,0)
insn(MOVUPS, 1,                 OpCls( M128,     XMM,      NONE ), F_0F,   0,  no_WDS, 0x11,     0x00,       P_686|P_SSE1,0)

ins (MOVHPD, movhpd, 6,         OpCls( XMM,      M64,      NONE ), F_660F, 1,  no_WDS, 0x16,     0x00,       P_686|P_SSE2,0)
insn(MOVHPD, 1,                 OpCls( M64,      XMM,      NONE ), F_660F, 0,  no_WDS, 0x17,     0x00,       P_686|P_SSE2,0)
ins (MOVHPS, movhps, 6,         OpCls( XMM,      M64,      NONE ), F_0F,   1,  no_WDS, 0x16,     0x00,       P_686|P_SSE1,0)
insn(MOVHPS, 1,                 OpCls( M64,      XMM,      NONE ), F_0F,   0,  no_WDS, 0x17,     0x00,       P_686|P_SSE1,0)
ins (MOVLPD, movlpd, 6,         OpCls( XMM,      M64,      NONE ), F_660F, 1,  no_WDS, 0x12,     0x00,       P_686|P_SSE2,0)
insn(MOVLPD, 1,                 OpCls( M64,      XMM,      NONE ), F_660F, 0,  no_WDS, 0x13,     0x00,       P_686|P_SSE2,0)
ins (MOVLPS, movlps, 6,         OpCls( XMM,      M64,      NONE ), F_0F,   1,  no_WDS, 0x12,     0x00,       P_686|P_SSE1,0)
insn(MOVLPS, 1,                 OpCls( M64,      XMM,      NONE ), F_0F,   0,  no_WDS, 0x13,     0x00,       P_686|P_SSE1,0)

ins (MOVHLPS, movhlps, 7,       OpCls( XMM,      XMM,      NONE ), F_0F,   1,  no_WDS, 0x12,     0x00,       P_686|P_SSE1,0)
ins (MOVLHPS, movlhps, 7,       OpCls( XMM,      XMM,      NONE ), F_0F,   1,  no_WDS, 0x16,     0x00,       P_686|P_SSE1,0)
ins (MOVDQ2Q, movdq2q, 7,       OpCls( MMX,      XMM,      NONE ), F_F20F, 1,  no_WDS, 0xD6,     0x00,       P_686|P_SSE2,0)
ins (MOVQ2DQ, movq2dq, 7,       OpCls( XMM,      MMX,      NONE ), F_F30F, 1,  no_WDS, 0xD6,     0x00,       P_686|P_SSE2,0)

ins (MOVMSKPD, movmskpd, 8,     OpCls( RGT16,    XMM,      NONE ), F_660F, 1,  no_WDS, 0x50,     0x00,       P_686|P_SSE2,0)
ins (MOVMSKPS, movmskps, 8,     OpCls( RGT16,    XMM,      NONE ), F_0F,   1,  no_WDS, 0x50,     0x00,       P_686|P_SSE1,0)
ins (MOVNTDQ, movntdq, 7,       OpCls( M128,     XMM,      NONE ), F_660F, 0,  no_WDS, 0xE7,     0x00,       P_686|P_SSE2,0)
ins (MOVNTI, movnti, 6,         OpCls( MGT16,    RGT16,    NONE ), F_0F,   0,  no_WDS, 0xC3,     0x00,       P_686|P_SSE2,0)
ins (MOVNTPD, movntpd, 7,       OpCls( M128,     XMM,      NONE ), F_660F, 0,  no_WDS, 0x2B,     0x00,       P_686|P_SSE2,0)
ins (MOVNTPS, movntps, 7,       OpCls( M128,     XMM,      NONE ), F_0F,   0,  no_WDS, 0x2B,     0x00,       P_686|P_SSE1,0)
ins (MOVNTQ, movntq, 6,         OpCls( M64,      MMX,      NONE ), F_0F,   0,  no_WDS, 0xE7,     0x00,       P_686|P_SSE1,0)
//ins (MOVSD, movsd, 5,           OpCls( XMM,      XMM_M64,  NONE ), F_F20F, 1,  no_WDS, 0x10,     0x00,       P_686|P_SSE2,0)
//insn(MOVSD, 1                   OpCls( M64,      XMM,      NONE ), F_F20F, 0,  no_WDS, 0x11,     0x00,       P_686|P_SSE2,0)
ins (MOVSS, movss, 5,           OpCls( XMM,      XMM_M32,  NONE ), F_F30F, 1,  no_WDS, 0x10,     0x00,       P_686|P_SSE1,0)
insn(MOVSS, 1,                  OpCls( M32,      XMM,      NONE ), F_F30F, 0,  no_WDS, 0x11,     0x00,       P_686|P_SSE1,0)

ins (PACKSSDW, packssdw, 8,     OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x6B,     0x00,       P_586|P_MMX, 0)
insn(PACKSSDW, 1,               OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x6B,     0x00,       P_686|P_SSE2,0)
ins (PACKSSWB, packsswb, 8,     OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x63,     0x00,       P_586|P_MMX, 0)
insn(PACKSSWB, 1,               OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x63,     0x00,       P_686|P_SSE2,0)
ins (PACKUSWB, packuswb, 8,     OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x67,     0x00,       P_586|P_MMX, 0)
insn(PACKUSWB, 1,               OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x67,     0x00,       P_686|P_SSE2,0)
ins (PADDB, paddb, 5,           OpCls( MMX,    MMX_M64_08, NONE ), F_0F,   1,  no_WDS, 0xFC,     0x00,       P_586|P_MMX, 0)
insn(PADDB, 1,                  OpCls( XMM,    XMM_M128_08,NONE ), F_660F, 1,  no_WDS, 0xFC,     0x00,       P_686|P_SSE2,0)
ins (PADDW, paddw, 5,           OpCls( MMX,    MMX_M64_16, NONE ), F_0F,   1,  no_WDS, 0xFD,     0x00,       P_586|P_MMX, 0)
insn(PADDW, 1,                  OpCls( XMM,    XMM_M128_16,NONE ), F_660F, 1,  no_WDS, 0xFD,     0x00,       P_686|P_SSE2,0)
ins (PADDD, paddd, 5,           OpCls( MMX,    MMX_M64_32, NONE ), F_0F,   1,  no_WDS, 0xFE,     0x00,       P_586|P_MMX, 0)
insn(PADDD, 1,                  OpCls( XMM,    XMM_M128_32,NONE ), F_660F, 1,  no_WDS, 0xFE,     0x00,       P_686|P_SSE2,0)
ins (PADDQ, paddq, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xD4,     0x00,       P_686|P_SSE2,0)
insn(PADDQ, 1,                  OpCls( XMM,    XMM_M128_64,NONE ), F_660F, 1,  no_WDS, 0xD4,     0x00,       P_686|P_SSE2,0)
ins (PADDSB, paddsb, 6,         OpCls( MMX,    MMX_M64_08, NONE ), F_0F,   1,  no_WDS, 0xEC,     0x00,       P_586|P_MMX, 0)
insn(PADDSB, 1,                 OpCls( XMM,    XMM_M128_08,NONE ), F_660F, 1,  no_WDS, 0xEC,     0x00,       P_686|P_SSE2,0)
ins (PADDSW, paddsw, 6,         OpCls( MMX,    MMX_M64_16, NONE ), F_0F,   1,  no_WDS, 0xED,     0x00,       P_586|P_MMX, 0)
insn(PADDSW, 1,                 OpCls( XMM,    XMM_M128_16,NONE ), F_660F, 1,  no_WDS, 0xED,     0x00,       P_686|P_SSE2,0)
ins (PADDUSB, paddusb, 7,       OpCls( MMX,    MMX_M64_08, NONE ), F_0F,   1,  no_WDS, 0xDC,     0x00,       P_586|P_MMX, 0)
insn(PADDUSB, 1,                OpCls( XMM,    XMM_M128_08,NONE ), F_660F, 1,  no_WDS, 0xDC,     0x00,       P_686|P_SSE2,0)
ins (PADDUSW, paddusw, 7,       OpCls( MMX,    MMX_M64_16, NONE ), F_0F,   1,  no_WDS, 0xDD,     0x00,       P_586|P_MMX, 0)
insn(PADDUSW, 1,                OpCls( XMM,    XMM_M128_16,NONE ), F_660F, 1,  no_WDS, 0xDD,     0x00,       P_686|P_SSE2,0)
ins (PAND, pand, 4,             OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xDB,     0x00,       P_586|P_MMX, 0)
insn(PAND, 1,                   OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xDB,     0x00,       P_686|P_SSE2,0)
ins (PANDN, pandn, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xDF,     0x00,       P_586|P_MMX, 0)
insn(PANDN, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xDF,     0x00,       P_686|P_SSE2,0)
ins (PAVGB, pavgb, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xE0,     0x00,       P_686|P_SSE1,0)
insn(PAVGB, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE0,     0x00,       P_686|P_SSE2,0)
ins (PAVGW, pavgw, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xE3,     0x00,       P_686|P_SSE1,0)
insn(PAVGW, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE3,     0x00,       P_686|P_SSE2,0)
ins (PCMPEQB, pcmpeqb, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x74,     0x00,       P_586|P_MMX, 0)
insn(PCMPEQB, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x74,     0x00,       P_686|P_SSE2,0)
ins (PCMPEQW, pcmpeqw, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x75,     0x00,       P_586|P_MMX, 0)
insn(PCMPEQW, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x75,     0x00,       P_686|P_SSE2,0)
ins (PCMPEQD, pcmpeqd, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x76,     0x00,       P_586|P_MMX, 0)
insn(PCMPEQD, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x76,     0x00,       P_686|P_SSE2,0)
ins (PCMPGTB, pcmpgtb, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x64,     0x00,       P_586|P_MMX, 0)
insn(PCMPGTB, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x64,     0x00,       P_686|P_SSE2,0)
ins (PCMPGTW, pcmpgtw, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x65,     0x00,       P_586|P_MMX, 0)
insn(PCMPGTW, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x65,     0x00,       P_686|P_SSE2,0)
ins (PCMPGTD, pcmpgtd, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x66,     0x00,       P_586|P_MMX, 0)
insn(PCMPGTD, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x66,     0x00,       P_686|P_SSE2,0)
ins (PEXTRW, pextrw, 6,         OpCls( RGT16,    MMX,      I8_U ), F_0F,   1,  no_WDS, 0xC5,     0x00,       P_686|P_SSE1,0)
insn(PEXTRW, 1,                 OpCls( RGT16,    XMM,      I8_U ), F_660F, 1,  no_WDS, 0xC5,     0x00,       P_686|P_SSE1,0)
#if SSE4SUPP /* SSE 4.1 */
insn(PEXTRW, 2,                 OpCls( M16,      XMM,      I8_U ), F_660F3A, 0,no_WDS, 0x15,     0x00,       P_686|P_SSE4,0)
#endif
/* v2.06: define it like PINSRB/PINSRD */
//ins (PINSRW, pinsrw, 6,         OpCls( MMX,      R32,      I8_U ), F_0F,   1,  no_WDS, 0xC4,     0x00,       P_686|P_SSE1,0)
//insn(PINSRW, 1,                 OpCls( MMX,      M16,      I8_U ), F_0F,   1,  no_WDS, 0xC4,     0x00,       P_686|P_SSE1,0)
//insn(PINSRW, 2,                 OpCls( XMM,      R32,      I8_U ), F_660F, 1,  no_WDS, 0xC4,     0x00,       P_686|P_SSE1,0)
//insn(PINSRW, 3,                 OpCls( XMM,      M16,      I8_U ), F_660F, 1,  no_WDS, 0xC4,     0x00,       P_686|P_SSE1,0)
ins (PINSRW, pinsrw, 6,         OpCls( MMX,      R32_M16,  I8_U ), F_0F,   1,  no_WDS, 0xC4,     0x00,       P_686|P_SSE1,0)
insn(PINSRW, 1,                 OpCls( XMM,      R32_M16,  I8_U ), F_660F, 1,  no_WDS, 0xC4,     0x00,       P_686|P_SSE1,0)
ins (PMADDWD, pmaddwd, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xF5,     0x00,       P_586|P_MMX, 0)
insn(PMADDWD, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xF5,     0x00,       P_686|P_SSE2,0)
ins (PMAXSW, pmaxsw, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xEE,     0x00,       P_686|P_SSE1,0)
insn(PMAXSW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xEE,     0x00,       P_686|P_SSE2,0)
ins (PMAXUB, pmaxub, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xDE,     0x00,       P_686|P_SSE1,0)
insn(PMAXUB, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xDE,     0x00,       P_686|P_SSE2,0)
ins (PMINSW, pminsw, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xEA,     0x00,       P_686|P_SSE1,0)
insn(PMINSW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xEA,     0x00,       P_686|P_SSE2,0)
ins (PMINUB, pminub, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xDA,     0x00,       P_686|P_SSE1,0)
insn(PMINUB, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xDA,     0x00,       P_686|P_SSE2,0)
ins (PMOVMSKB, pmovmskb, 8,     OpCls( RGT16,    MMX,      NONE ), F_0F,   1,  no_WDS, 0xD7,     0x00,       P_686|P_SSE1,0)
insn(PMOVMSKB, 1,               OpCls( RGT16,    XMM,      NONE ), F_660F, 1,  no_WDS, 0xD7,     0x00,       P_686|P_SSE2,0)
ins (PMULHUW, pmulhuw, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xE4,     0x00,       P_586|P_SSE1,0)
insn(PMULHUW, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE4,     0x00,       P_686|P_SSE2,0)
ins (PMULHW, pmulhw, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xE5,     0x00,       P_586|P_MMX, 0)
insn(PMULHW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE5,     0x00,       P_686|P_SSE2,0)
ins (PMULLW, pmullw, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xD5,     0x00,       P_586|P_MMX, 0)
insn(PMULLW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xD5,     0x00,       P_686|P_SSE2,0)
ins (PMULUDQ, pmuludq, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xF4,     0x00,       P_686|P_SSE2,0)
insn(PMULUDQ, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xF4,     0x00,       P_686|P_SSE2,0)
ins (POR, por, 3,               OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xEB,     0x00,       P_586|P_MMX, 0)
insn(POR,  1,                   OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xEB,     0x00,       P_686|P_SSE2,0)
ins (PSADBW, psadbw, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xF6,     0x00,       P_686|P_SSE1,0)
insn(PSADBW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xF6,     0x00,       P_686|P_SSE2,0)
ins (PSHUFD, pshufd, 6,         OpCls( XMM,      XMM_M128, I8_U ), F_660F, 1,  no_WDS, 0x70,     0x00,       P_686|P_SSE2,0)
ins (PSHUFW, pshufw, 6,         OpCls( MMX,      MMX_M64,  I8_U ), F_0F,   1,  no_WDS, 0x70,     0x00,       P_686|P_SSE1,0)
ins (PSHUFHW, pshufhw, 7,       OpCls( XMM,      XMM_M128, I8_U ), F_F30F, 1,  no_WDS, 0x70,     0x00,       P_686|P_SSE2,0)
ins (PSHUFLW, pshuflw, 7,       OpCls( XMM,      XMM_M128, I8_U ), F_F20F, 1,  no_WDS, 0x70,     0x00,       P_686|P_SSE2,0)

ins (PSLLW, psllw, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xF1,     0x00,       P_586|P_MMX, 0)
insn(PSLLW, 1,                  OpCls( MMX,      I8_U,     NONE ), F_0F,   0,  no_WDS, 0x71,     0x30,       P_586|P_MMX, 0)
insn(PSLLW, 2,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xF1,     0x00,       P_686|P_SSE2,0)
insn(PSLLW, 3,                  OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x71,     0x30,       P_686|P_SSE2,0)
ins (PSLLD, pslld, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xF2,     0x00,       P_586|P_MMX, 0)
insn(PSLLD, 1,                  OpCls( MMX,      I8_U,     NONE ), F_0F,   0,  no_WDS, 0x72,     0x30,       P_586|P_MMX, 0)
insn(PSLLD, 2,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xF2,     0x00,       P_686|P_SSE2,0)
insn(PSLLD, 3,                  OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x72,     0x30,       P_686|P_SSE2,0)
ins (PSLLQ, psllq, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xF3,     0x00,       P_586|P_MMX, 0)
insn(PSLLQ, 1,                  OpCls( MMX,      I8_U,     NONE ), F_0F,   0,  no_WDS, 0x73,     0x30,       P_586|P_MMX, 0)
insn(PSLLQ, 2,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xF3,     0x00,       P_686|P_SSE2,0)
insn(PSLLQ, 3,                  OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x73,     0x30,       P_686|P_SSE2,0)
ins (PSRAW, psraw, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xE1,     0x00,       P_586|P_MMX, 0)
insn(PSRAW, 1,                  OpCls( MMX,      I8_U,     NONE ), F_0F,   0,  no_WDS, 0x71,     0x20,       P_586|P_MMX, 0)
insn(PSRAW, 2,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE1,     0x00,       P_586|P_SSE2,0)
insn(PSRAW, 3,                  OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x71,     0x20,       P_686|P_SSE2,0)
ins (PSRAD, psrad, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xE2,     0x00,       P_586|P_MMX, 0)
insn(PSRAD, 1,                  OpCls( MMX,      I8_U,     NONE ), F_0F,   0,  no_WDS, 0x72,     0x20,       P_586|P_MMX, 0)
insn(PSRAD, 2,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE2,     0x00,       P_686|P_SSE2,0)
insn(PSRAD, 3,                  OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x72,     0x20,       P_686|P_SSE2,0)
ins (PSRLW, psrlw, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xD1,     0x00,       P_586|P_MMX, 0)
insn(PSRLW, 1,                  OpCls( MMX,      I8_U,     NONE ), F_0F,   0,  no_WDS, 0x71,     0x10,       P_586|P_MMX, 0)
insn(PSRLW, 2,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xD1,     0x00,       P_686|P_SSE2,0)
insn(PSRLW, 3,                  OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x71,     0x10,       P_686|P_SSE2,0)
ins (PSRLD, psrld, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xD2,     0x00,       P_586|P_MMX, 0)
insn(PSRLD, 1,                  OpCls( MMX,      I8_U,     NONE ), F_0F,   0,  no_WDS, 0x72,     0x10,       P_586|P_MMX, 0)
insn(PSRLD, 2,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xD2,     0x00,       P_686|P_SSE2,0)
insn(PSRLD, 3,                  OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x72,     0x10,       P_686|P_SSE2,0)
ins (PSRLQ, psrlq, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xD3,     0x00,       P_586|P_MMX, 0)
insn(PSRLQ, 1,                  OpCls( MMX,      I8_U,     NONE ), F_0F,   0,  no_WDS, 0x73,     0x10,       P_586|P_MMX, 0)
insn(PSRLQ, 2,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xD3,     0x00,       P_686|P_SSE2,0)
insn(PSRLQ, 3,                  OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x73,     0x10,       P_686|P_SSE2,0)

ins (PSLLDQ, pslldq, 6,         OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x73,     0x38,       P_686|P_SSE2,0)
ins (PSRLDQ, psrldq, 6,         OpCls( XMM,      I8_U,     NONE ), F_660F, 0,  no_WDS, 0x73,     0x18,       P_686|P_SSE2,0)

ins (PSUBB, psubb, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xF8,     0x00,       P_586|P_MMX, 0)
insn(PSUBB, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xF8,     0x00,       P_686|P_SSE2,0)
ins (PSUBW, psubw, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xF9,     0x00,       P_586|P_MMX, 0)
insn(PSUBW, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xF9,     0x00,       P_686|P_SSE2,0)
ins (PSUBD, psubd, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xFA,     0x00,       P_586|P_MMX, 0)
insn(PSUBD, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xFA,     0x00,       P_686|P_SSE2,0)
ins (PSUBQ, psubq, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xFB,     0x00,       P_686|P_SSE2,0)
insn(PSUBQ, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xFB,     0x00,       P_686|P_SSE2,0)
ins (PSUBSB, psubsb, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xE8,     0x00,       P_586|P_MMX, 0)
insn(PSUBSB, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE8,     0x00,       P_686|P_SSE2,0)
ins (PSUBSW, psubsw, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xE9,     0x00,       P_586|P_MMX, 0)
insn(PSUBSW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xE9,     0x00,       P_686|P_SSE2,0)
ins (PSUBUSB, psubusb, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xD8,     0x00,       P_586|P_MMX, 0)
insn(PSUBUSB, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xD8,     0x00,       P_686|P_SSE2,0)
ins (PSUBUSW, psubusw, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xD9,     0x00,       P_586|P_MMX, 0)
insn(PSUBUSW, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xD9,     0x00,       P_686|P_SSE2,0)
ins (PXOR, pxor, 4,             OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0xEF,     0x00,       P_586|P_MMX, 0)
insn(PXOR, 1,                   OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xEF,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKHBW, punpckhbw, 9,   OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x68,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKHBW, 1,              OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x68,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKHWD, punpckhwd, 9,   OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x69,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKHWD, 1,              OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x69,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKHDQ, punpckhdq, 9,   OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x6A,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKHDQ, 1,              OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x6A,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKLBW, punpcklbw, 9,   OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x60,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKLBW, 1,              OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x60,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKLWD, punpcklwd, 9,   OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x61,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKLWD, 1,              OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x61,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKLDQ, punpckldq, 9,   OpCls( MMX,      MMX_M64,  NONE ), F_0F,   1,  no_WDS, 0x62,     0x00,       P_586|P_MMX, 0)
insn(PUNPCKLDQ, 1,              OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x62,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKHQDQ, punpckhqdq, 10,OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x6D,     0x00,       P_686|P_SSE2,0)
ins (PUNPCKLQDQ, punpcklqdq, 10,OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x6C,     0x00,       P_686|P_SSE2,0)

ins (RCPPS, rcpps, 5,           OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x53,     0x00,       P_686|P_SSE1,0)
ins (RCPSS, rcpss, 5,           OpCls( XMM,      XMM_M32,  NONE ), F_F30F, 1,  no_WDS, 0x53,     0x00,       P_686|P_SSE1,0)
ins (RSQRTPS, rsqrtps, 7,       OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x52,     0x00,       P_686|P_SSE1,0)
ins (RSQRTSS, rsqrtss, 7,       OpCls( XMM,      XMM_M32,  NONE ), F_F30F, 1,  no_WDS, 0x52,     0x00,       P_686|P_SSE1,0)
ins (SHUFPD, shufpd, 6,         OpCls( XMM,      XMM_M128, I8_U ), F_660F, 1,  no_WDS, 0xC6,     0x00,       P_686|P_SSE2,0)
ins (SHUFPS, shufps, 6,         OpCls( XMM,      XMM_M128, I8_U ), F_0F,   1,  no_WDS, 0xC6,     0x00,       P_686|P_SSE1,0)
ins (UCOMISD, ucomisd, 7,       OpCls( XMM,      XMM_M64,  NONE ), F_660F, 1,  no_WDS, 0x2E,     0x00,       P_686|P_SSE2,0)
ins (UCOMISS, ucomiss, 7,       OpCls( XMM,      XMM_M32,  NONE ), F_0F,   1,  no_WDS, 0x2E,     0x00,       P_686|P_SSE1,0)
ins (UNPCKHPD, unpckhpd, 8,     OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x15,     0x00,       P_686|P_SSE2,0)
ins (UNPCKHPS, unpckhps, 8,     OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x15,     0x00,       P_686|P_SSE1,0)
ins (UNPCKLPD, unpcklpd, 8,     OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x14,     0x00,       P_686|P_SSE2,0)
ins (UNPCKLPS, unpcklps, 8,     OpCls( XMM,      XMM_M128, NONE ), F_0F,   1,  no_WDS, 0x14,     0x00,       P_686|P_SSE1,0)

/* K3D instructions */
#if K3DSUPP
ins (FEMMS, femms, 5,           OpCls( NONE,     NONE,     NONE ), F_0F,   0,  no_RM,  0x0E,     0x00,       P_586|P_K3D, 0)
ins (PREFETCH, prefetch, 8,     OpCls( M_ANY,    NONE,     NONE ), F_0F,   0,  no_WDS, 0x0D,     0x00,       P_586|P_K3D, 0)
ins (PREFETCHW, prefetchw, 9,   OpCls( M_ANY,    NONE,     NONE ), F_0F,   0,  no_WDS, 0x0D,     0x08,       P_586|P_K3D, 0)
ins (PAVGUSB, pavgusb, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xBF,     0x00,       P_586|P_K3D, 0)
ins (PF2ID, pf2id, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x1D,     0x00,       P_586|P_K3D, 0)
ins (PF2IW, pf2iw, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x1C,     0x00,       P_586|P_K3D, 0)
ins (PFACC, pfacc, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xAE,     0x00,       P_586|P_K3D, 0)
ins (PFADD, pfadd, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x9E,     0x00,       P_586|P_K3D, 0)
ins (PFCMPEQ, pfcmpeq, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xB0,     0x00,       P_586|P_K3D, 0)
ins (PFCMPGE, pfcmpge, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x90,     0x00,       P_586|P_K3D, 0)
ins (PFCMPGT, pfcmpgt, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xA0,     0x00,       P_586|P_K3D, 0)
ins (PFMAX, pfmax, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xA4,     0x00,       P_586|P_K3D, 0)
ins (PFMIN, pfmin, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x94,     0x00,       P_586|P_K3D, 0)
ins (PFMUL, pfmul, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xB4,     0x00,       P_586|P_K3D, 0)
ins (PFNACC, pfnacc, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x8A,     0x00,       P_586|P_K3D, 0)
ins (PFPNACC, pfpnacc, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x8E,     0x00,       P_586|P_K3D, 0)
ins (PFRCP, pfrcp, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x96,     0x00,       P_586|P_K3D, 0)
ins (PFRCPIT1, pfrcpit1, 8,     OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xA6,     0x00,       P_586|P_K3D, 0)
ins (PFRCPIT2, pfrcpit2, 8,     OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xB6,     0x00,       P_586|P_K3D, 0)
ins (PFRSQIT1, pfrsqit1, 8,     OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xA7,     0x00,       P_586|P_K3D, 0)
ins (PFRSQRT, pfrsqrt, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x97,     0x00,       P_586|P_K3D, 0)
ins (PFSUB, pfsub, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x9A,     0x00,       P_586|P_K3D, 0)
ins (PFSUBR, pfsubr, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xAA,     0x00,       P_586|P_K3D, 0)
ins (PI2FD, pi2fd, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x0D,     0x00,       P_586|P_K3D, 0)
ins (PI2FW, pi2fw, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0x0C,     0x00,       P_586|P_K3D, 0)
ins (PMULHRW, pmulhrw, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xB7,     0x00,       P_586|P_K3D, 0)
ins (PSWAPD, pswapd, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F0F, 1,  no_WDS, 0xBB,     0x00,       P_586|P_K3D, 0)
#endif

#if SSE3SUPP
ins (ADDSUBPD, addsubpd, 8,     OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0xD0,     0x00,       P_686|P_SSE3,0)
ins (ADDSUBPS, addsubps, 8,     OpCls( XMM,      XMM_M128, NONE ), F_F20F, 1,  no_WDS, 0xD0,     0x00,       P_686|P_SSE3,0)
ins (FISTTP, fisttp, 6,         OpCls( M32,      NONE,     NONE ), 0,      0,  no_WDS, 0xDB,     0x08,       P_686|P_SSE3,0)
insn(FISTTP, 1,                 OpCls( M64,      NONE,     NONE ), 0,      0,  no_WDS, 0xDD,     0x08,       P_686|P_SSE3,0)
insn(FISTTP, 2,                 OpCls( M16,      NONE,     NONE ), 0,      0,  no_WDS, 0xDF,     0x08,       P_686|P_SSE3,0)
ins (HADDPD, haddpd, 6,         OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x7C,     0x00,       P_686|P_SSE3,0)
ins (HADDPS, haddps, 6,         OpCls( XMM,      XMM_M128, NONE ), F_F20F, 1,  no_WDS, 0x7C,     0x00,       P_686|P_SSE3,0)
ins (HSUBPD, hsubpd, 6,         OpCls( XMM,      XMM_M128, NONE ), F_660F, 1,  no_WDS, 0x7D,     0x00,       P_686|P_SSE3,0)
ins (HSUBPS, hsubps, 6,         OpCls( XMM,      XMM_M128, NONE ), F_F20F, 1,  no_WDS, 0x7D,     0x00,       P_686|P_SSE3,0)
ins (LDDQU, lddqu, 5,           OpCls( XMM,      M128,     NONE ), F_F20F, 1,  no_WDS, 0xF0,     0x00,       P_686|P_SSE3,0)
ins (MONITOR, monitor, 7,       OpCls( NONE,     NONE,     NONE ), F_0F,   0,  0,      0x01,     0xC8,       P_686|P_SSE3,0)
ins (MOVDDUP, movddup, 7,       OpCls( XMM,      XMM_M64,  NONE ), F_F20F, 1,  no_WDS, 0x12,     0x00,       P_686|P_SSE3,0)
ins (MOVSHDUP, movshdup, 8,     OpCls( XMM,      XMM_M128, NONE ), F_F30F, 1,  no_WDS, 0x16,     0x00,       P_686|P_SSE3,0)
ins (MOVSLDUP, movsldup, 8,     OpCls( XMM,      XMM_M128, NONE ), F_F30F, 1,  no_WDS, 0x12,     0x00,       P_686|P_SSE3,0)
ins (MWAIT, mwait, 5,           OpCls( NONE,     NONE,     NONE ), F_0F,   0,  0,      0x01,     0xC9,       P_686|P_SSE3,0)
#endif

#if SSSE3SUPP
ins (PABSB, pabsb, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x1C,     0x00,       P_686|P_SSSE3, 0)
insn(PABSB, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x1C,     0x00,       P_686|P_SSSE3, 0)
ins (PABSD, pabsd, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x1E,     0x00,       P_686|P_SSSE3, 0)
insn(PABSD, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x1E,     0x00,       P_686|P_SSSE3, 0)
ins (PABSW, pabsw, 5,           OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x1D,     0x00,       P_686|P_SSSE3, 0)
insn(PABSW, 1,                  OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x1D,     0x00,       P_686|P_SSSE3, 0)
ins (PALIGNR, palignr, 7,       OpCls( MMX,      MMX_M64,  I8_U ), F_0F3A,  1,  no_WDS, 0x0F,     0x00,       P_686|P_SSSE3, 0)
insn(PALIGNR, 1,                OpCls( XMM,      XMM_M128, I8_U ), F_660F3A,1,  no_WDS, 0x0F,     0x00,       P_686|P_SSSE3, 0)
ins (PHADDD, phaddd, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x02,     0x00,       P_686|P_SSSE3, 0)
insn(PHADDD, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x02,     0x00,       P_686|P_SSSE3, 0)
ins (PHADDSW, phaddsw, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x03,     0x00,       P_686|P_SSSE3, 0)
insn(PHADDSW, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x03,     0x00,       P_686|P_SSSE3, 0)
ins (PHADDW, phaddw, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x01,     0x00,       P_686|P_SSSE3, 0)
insn(PHADDW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x01,     0x00,       P_686|P_SSSE3, 0)
ins (PHSUBD, phsubd, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x06,     0x00,       P_686|P_SSSE3, 0)
insn(PHSUBD, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x06,     0x00,       P_686|P_SSSE3, 0)
ins (PHSUBSW, phsubsw, 7,       OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x07,     0x00,       P_686|P_SSSE3, 0)
insn(PHSUBSW, 1,                OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x07,     0x00,       P_686|P_SSSE3, 0)
ins (PHSUBW, phsubw, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x05,     0x00,       P_686|P_SSSE3, 0)
insn(PHSUBW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x05,     0x00,       P_686|P_SSSE3, 0)
ins (PMADDUBSW, pmaddubsw, 9,   OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x04,     0x00,       P_686|P_SSSE3, 0)
insn(PMADDUBSW, 1,              OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x04,     0x00,       P_686|P_SSSE3, 0)
ins (PMULHRSW, pmulhrsw, 8,     OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x0B,     0x00,       P_686|P_SSSE3, 0)
insn(PMULHRSW, 1,               OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x0B,     0x00,       P_686|P_SSSE3, 0)
ins (PSHUFB, pshufb, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x00,     0x00,       P_686|P_SSSE3, 0)
insn(PSHUFB, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x00,     0x00,       P_686|P_SSSE3, 0)
ins (PSIGNB, psignb, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x08,     0x00,       P_686|P_SSSE3, 0)
insn(PSIGNB, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x08,     0x00,       P_686|P_SSSE3, 0)
ins (PSIGND, psignd, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x0A,     0x00,       P_686|P_SSSE3, 0)
insn(PSIGND, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x0A,     0x00,       P_686|P_SSSE3, 0)
ins (PSIGNW, psignw, 6,         OpCls( MMX,      MMX_M64,  NONE ), F_0F38,  1,  no_WDS, 0x09,     0x00,       P_686|P_SSSE3, 0)
insn(PSIGNW, 1,                 OpCls( XMM,      XMM_M128, NONE ), F_660F38,1,  no_WDS, 0x09,     0x00,       P_686|P_SSSE3, 0)
#endif
#if AMD64_SUPPORT
/* CDQE must be first in this group, see reswords.c */
insx(CDQE, cdqe, 4,             OpCls( NONE,     NONE,       NONE ), F_48,   0,  no_RM,  0x98,     0x00,       P_64,       0,        RWF_X64)
insx(CQO, cqo, 3,               OpCls( NONE,     NONE,       NONE ), F_48,   0,  no_RM,  0x99,     0x00,       P_64,       0,        RWF_X64)
insx(PUSHFQ,pushfq, 6,          OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x9C,     0x00,       P_64,       0,        RWF_X64)
insx(POPFQ, popfq, 5,           OpCls( NONE,     NONE,       NONE ), 0,      0,  no_RM,  0x9D,     0x00,       P_64,       0,        RWF_X64)
insx(IRETQ, iretq, 5,           OpCls( NONE,     NONE,       NONE ), F_48,   0,  no_RM,  0xCF,     0x00,       P_64,       0,        RWF_X64)
insx(CMPXCHG16B, cmpxchg16b, 10,OpCls( M128,     NONE,       NONE ), F_480F, 0,  0,      0xC7,     0x08,       P_64,       AP_LOCK,  RWF_X64)
insx(MOVSXD,movsxd, 6,          OpCls( R64,      R32_M32,    NONE ), 0,      1,  0,      0x63,     0x00,       P_64,       0,        RWF_X64)

insx(CMPSQ, cmpsq, 5,           OpCls( NONE,     NONE,       NONE ), F_48,   0,  no_RM,  0xA7,     0x00,       P_64,       AP_REPxx, RWF_X64)
insn(CMPSQ, 1,                  OpCls( M64,      M64,        NONE ), F_48,   0,  no_RM,  0xA7,     0x00,       P_64,       AP_REPxx)
insx(LODSQ, lodsq, 5,           OpCls( NONE,     NONE,       NONE ), F_48,   0,  no_RM,  0xAD,     0x00,       P_64,       AP_REP,   RWF_X64)
insn(LODSQ, 1,                  OpCls( M64,      NONE,       NONE ), F_48,   0,  no_RM,  0xAD,     0x00,       P_64,       AP_REP  )
insx(MOVSQ, movsq, 5,           OpCls( NONE,     NONE,       NONE ), F_48,   0,  no_RM,  0xA5,     0x00,       P_64,       AP_REP,   RWF_X64)
insn(MOVSQ, 1,                  OpCls( M64,      M64,        NONE ), F_48,   0,  no_RM,  0xA5,     0x00,       P_64,       AP_REP  )
insx(SCASQ, scasq, 5,           OpCls( NONE,     NONE,       NONE ), F_48,   0,  no_RM,  0xAF,     0x00,       P_64,       AP_REPxx, RWF_X64)
insn(SCASQ, 1,                  OpCls( M64,      NONE,       NONE ), F_48,   0,  no_RM,  0xAF,     0x00,       P_64,       AP_REPxx)
insx(STOSQ, stosq, 5,           OpCls( NONE,     NONE,       NONE ), F_48,   0,  no_RM,  0xAB,     0x00,       P_64,       AP_REP,   RWF_X64)
insn(STOSQ, 1,                  OpCls( M64,      NONE,       NONE ), F_48,   0,  no_RM,  0xAB,     0x00,       P_64,       AP_REP  )
#if SSE4SUPP
/* PEXTRQ/PINSRQ need a REX.W prefix if M64 is dst/src! */
insx(PEXTRQ, pextrq, 6,         OpCls( R64_M64,  XMM,        I8_U ), F_660F3A,0, no_WDS, 0x16,     0x00,       P_64|P_SSE4,0,        RWF_X64)
insx(PINSRQ, pinsrq, 6,         OpCls( XMM,      R64_M64,    I8_U ), F_660F3A,1, no_WDS, 0x22,     0x00,       P_64|P_SSE4,0,        RWF_X64)
#endif

insx(SWAPGS, swapgs, 6,         OpCls( NONE,     NONE,       NONE ), F_0F,   0,  0,      0x01,     0xF8,       P_64,       0,        RWF_X64)
insx(SYSCALL_, syscall, 7,      OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x05,     0x00,       P_64,       0,        RWF_X64)
insx(SYSRET, sysret, 6,         OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_RM,  0x07,     0x00,       P_64,       0,        RWF_X64)
#endif
#if SSE4SUPP
/* SSE4.1 */
ins (BLENDPD, blendpd, 7,       OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x0D,     0x00,       P_686|P_SSE4, 0)
ins (BLENDPS, blendps, 7,       OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x0C,     0x00,       P_686|P_SSE4, 0)
ins (BLENDVPD, blendvpd, 8,     OpCls( XMM,      XMM_M128, XMM0 ), F_660F38, 1,  no_WDS, 0x15,     0x00,       P_686|P_SSE4, 0)
ins (BLENDVPS, blendvps, 8,     OpCls( XMM,      XMM_M128, XMM0 ), F_660F38, 1,  no_WDS, 0x14,     0x00,       P_686|P_SSE4, 0)
ins (DPPD, dppd, 4,             OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x41,     0x00,       P_686|P_SSE4, 0)
ins (DPPS, dpps, 4,             OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x40,     0x00,       P_686|P_SSE4, 0)
ins (EXTRACTPS, extractps, 9,   OpCls( RGT16,    XMM,      I8_U ), F_660F3A, 0,  no_WDS, 0x17,     0x00,       P_686|P_SSE4, 0)
insn(EXTRACTPS, 1,              OpCls( M32,      XMM,      I8_U ), F_660F3A, 0,  no_WDS, 0x17,     0x00,       P_686|P_SSE4, 0)
ins (INSERTPS, insertps, 8,     OpCls( XMM,      XMM_M32,  I8_U ), F_660F3A, 1,  no_WDS, 0x21,     0x00,       P_686|P_SSE4, 0)
ins (MOVNTDQA, movntdqa, 8,     OpCls( XMM,      M128,     NONE ), F_660F38, 1,  no_WDS, 0x2A,     0x00,       P_686|P_SSE4, 0)
ins (MPSADBW, mpsadbw, 7,       OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x42,     0x00,       P_686|P_SSE4, 0)
ins (PACKUSDW, packusdw, 8,     OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x2B,     0x00,       P_686|P_SSE4, 0)
ins (PBLENDVB, pblendvb, 8,     OpCls( XMM,      XMM_M128, XMM0 ), F_660F38, 1,  no_WDS, 0x10,     0x00,       P_686|P_SSE4, 0)
ins (PBLENDW, pblendw, 7,       OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x0E,     0x00,       P_686|P_SSE4, 0)
ins (PCMPEQQ, pcmpeqq, 7,       OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x29,     0x00,       P_686|P_SSE4, 0)
ins (PEXTRB, pextrb, 6,         OpCls( RGT16_M08,XMM,      I8_U ), F_660F3A, 0,  no_WDS, 0x14,     0x00,       P_686|P_SSE4, 0)
ins (PEXTRD, pextrd, 6,         OpCls( R32_M32,  XMM,      I8_U ), F_660F3A, 0,  no_WDS, 0x16,     0x00,       P_686|P_SSE4, 0)
ins (PHMINPOSUW, phminposuw, 10,OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x41,     0x00,       P_686|P_SSE4, 0)
ins (PINSRB, pinsrb, 6,         OpCls( XMM,      R32_M08,  I8_U ), F_660F3A, 1,  no_WDS, 0x20,     0x00,       P_686|P_SSE4, 0)
ins (PINSRD, pinsrd, 6,         OpCls( XMM,      R32_M32,  I8_U ), F_660F3A, 1,  no_WDS, 0x22,     0x00,       P_686|P_SSE4, 0)
ins (PMAXSB, pmaxsb, 6,         OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x3C,     0x00,       P_686|P_SSE4, 0)
ins (PMAXSD, pmaxsd, 6,         OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x3D,     0x00,       P_686|P_SSE4, 0)
ins (PMAXUW, pmaxuw, 6,         OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x3E,     0x00,       P_686|P_SSE4, 0)
ins (PMAXUD, pmaxud, 6,         OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x3F,     0x00,       P_686|P_SSE4, 0)
ins (PMINSB, pminsb, 6,         OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x38,     0x00,       P_686|P_SSE4, 0)
ins (PMINSD, pminsd, 6,         OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x39,     0x00,       P_686|P_SSE4, 0)
ins (PMINUW, pminuw, 6,         OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x3A,     0x00,       P_686|P_SSE4, 0)
ins (PMINUD, pminud, 6,         OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x3B,     0x00,       P_686|P_SSE4, 0)
ins (PMOVSXBW, pmovsxbw, 8,     OpCls( XMM,      XMM_M64,  NONE ), F_660F38, 1,  no_WDS, 0x20,     0x00,       P_686|P_SSE4, 0)
ins (PMOVSXBD, pmovsxbd, 8,     OpCls( XMM,      XMM_M32,  NONE ), F_660F38, 1,  no_WDS, 0x21,     0x00,       P_686|P_SSE4, 0)
ins (PMOVSXBQ, pmovsxbq, 8,     OpCls( XMM,      XMM_M16,  NONE ), F_660F38, 1,  no_WDS, 0x22,     0x00,       P_686|P_SSE4, 0)
ins (PMOVSXWD, pmovsxwd, 8,     OpCls( XMM,      XMM_M64,  NONE ), F_660F38, 1,  no_WDS, 0x23,     0x00,       P_686|P_SSE4, 0)
ins (PMOVSXWQ, pmovsxwq, 8,     OpCls( XMM,      XMM_M32,  NONE ), F_660F38, 1,  no_WDS, 0x24,     0x00,       P_686|P_SSE4, 0)
ins (PMOVSXDQ, pmovsxdq, 8,     OpCls( XMM,      XMM_M64,  NONE ), F_660F38, 1,  no_WDS, 0x25,     0x00,       P_686|P_SSE4, 0)
ins (PMOVZXBW, pmovzxbw, 8,     OpCls( XMM,      XMM_M64,  NONE ), F_660F38, 1,  no_WDS, 0x30,     0x00,       P_686|P_SSE4, 0)
ins (PMOVZXBD, pmovzxbd, 8,     OpCls( XMM,      XMM_M32,  NONE ), F_660F38, 1,  no_WDS, 0x31,     0x00,       P_686|P_SSE4, 0)
ins (PMOVZXBQ, pmovzxbq, 8,     OpCls( XMM,      XMM_M16,  NONE ), F_660F38, 1,  no_WDS, 0x32,     0x00,       P_686|P_SSE4, 0)
ins (PMOVZXWD, pmovzxwd, 8,     OpCls( XMM,      XMM_M64,  NONE ), F_660F38, 1,  no_WDS, 0x33,     0x00,       P_686|P_SSE4, 0)
ins (PMOVZXWQ, pmovzxwq, 8,     OpCls( XMM,      XMM_M32,  NONE ), F_660F38, 1,  no_WDS, 0x34,     0x00,       P_686|P_SSE4, 0)
ins (PMOVZXDQ, pmovzxdq, 8,     OpCls( XMM,      XMM_M64,  NONE ), F_660F38, 1,  no_WDS, 0x35,     0x00,       P_686|P_SSE4, 0)
ins (PMULDQ, pmuldq, 6,         OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x28,     0x00,       P_686|P_SSE4, 0)
ins (PMULLD, pmulld, 6,         OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x40,     0x00,       P_686|P_SSE4, 0)
ins (PTEST, ptest, 5,           OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x17,     0x00,       P_686|P_SSE4, 0)
ins (ROUNDPS, roundps, 7,       OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x08,     0x00,       P_686|P_SSE4, 0)
ins (ROUNDPD, roundpd, 7,       OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x09,     0x00,       P_686|P_SSE4, 0)
ins (ROUNDSS, roundss, 7,       OpCls( XMM,      XMM_M32 , I8_U ), F_660F3A, 1,  no_WDS, 0x0A,     0x00,       P_686|P_SSE4, 0)
ins (ROUNDSD, roundsd, 7,       OpCls( XMM,      XMM_M64 , I8_U ), F_660F3A, 1,  no_WDS, 0x0B,     0x00,       P_686|P_SSE4, 0)
/* SSE4.2 */
ins (CRC32, crc32, 5,           OpCls( RGT16,    R8_M08,   NONE ), F_F20F38, 1,  no_WDS, 0xF0,     0x00,       P_686|P_SSE4, 0)
insn(CRC32, 1,                  OpCls( RGT16,    RGT8_MS,  NONE ), F_F20F38, 1,  no_WDS, 0xF1,     0x00,       P_686|P_SSE4, 0)
ins (PCMPESTRM, pcmpestrm, 9,   OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x60,     0x00,       P_686|P_SSE4, 0)
ins (PCMPESTRI, pcmpestri, 9,   OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x61,     0x00,       P_686|P_SSE4, 0)
ins (PCMPISTRM, pcmpistrm, 9,   OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x62,     0x00,       P_686|P_SSE4, 0)
ins (PCMPISTRI, pcmpistri, 9,   OpCls( XMM,      XMM_M128, I8_U ), F_660F3A, 1,  no_WDS, 0x63,     0x00,       P_686|P_SSE4, 0)
ins (PCMPGTQ, pcmpgtq, 7,       OpCls( XMM,      XMM_M128, NONE ), F_660F38, 1,  no_WDS, 0x37,     0x00,       P_686|P_SSE4, 0)
ins (POPCNT, popcnt, 6,         OpCls( RGT8,     RGT8_MS,  NONE ), F_F30F,   1,  no_WDS ,0xB8,     0x00,       P_686|P_SSE4, 0)
#if 0
/* SSE4A (AMD only). */
/* disabled because INSERTQ needs 4 arguments, which JWasm cannot support currently */
ins (EXTRQ, extrq, 5,           OpCls( XMM,      I8_U,     I8_U ), F_660F, 0,  no_WDS ,0x78,     0x00,       P_686|P_SSE4, 0)
ins (INSERTQ, insertq, 7,       OpCls( XMM,      XMM,      I8_U ), F_F20F, 0,  no_WDS ,0x78,     0x00,       P_686|P_SSE4, 0)
ins (LZCNT, lzcnt, 5,           OpCls( RGT8,     RGT8_MS,  NONE ), F_F30F, 1,  no_WDS ,0xBD,     0x00,       P_686|P_SSE4, 0)
ins (MOVNTSD, movntsd, 7,       OpCls( M64,      XMM,      NONE ), F_F20F, 0,  no_WDS ,0x2B,     0x00,       P_686|P_SSE4, 0)
ins (MOVNTSS, movntss, 7,       OpCls( M32,      XMM,      NONE ), F_F30F, 0,  no_WDS ,0x2B,     0x00,       P_686|P_SSE4, 0)
#endif
/* v2.06: added xrstor, xsave, xgetbv, xsetbv */
ins (XRSTOR, xrstor, 6,         OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0x28,     P_686|P_SSE4,0)
ins (XSAVE, xsave, 5,           OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0x20,     P_686|P_SSE4,0)
ins (XSAVEOPT, xsaveopt, 8,     OpCls( M_ANY,    NONE,       NONE ), F_0F,   0,  no_WDS, 0xAE,     0x30,     P_686|P_SSE4,0)
ins (XGETBV, xgetbv, 6,         OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0xD0,     P_686|P_SSE4,0)
ins (XSETBV, xsetbv, 6,         OpCls( NONE,     NONE,       NONE ), F_0F,   0,  no_WDS, 0x01,     0xD1,     P_686p|P_SSE4,0)
#endif
#if AVXSUPP
/* VBROADCASTSS is first VEX encoded instruction (VEX_START in parser.h).
 * Important: currently vex_flags[] in reswords.c must match the order here!
 * (this is to be improved).
 * Most AVX instructions that also have a "legacy" encoding are not listed
 * here but are contained in instravx.h!. Exceptions:
 * - VBLENDVPD, VBLENDVPS, VPBLENDVB ( they use a different opcode in VEX )
 * - VCVT[T]PD* ( they expect a mix of xmm and ymm/m256 arguments )
 */
insx(VBROADCASTSS, vbroadcastss, 12,   OpCls( XMM,      M32,        NONE ), F_660F38,1,  no_WDS, 0x18,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VBROADCASTSS, 1,                  OpCls( YMM,      M32,        NONE ), F_660F38,1,  no_WDS, 0x18,     0x00,     P_686|P_AVX, 0)
insx(VBROADCASTSD, vbroadcastsd, 12,   OpCls( YMM,      M64,        NONE ), F_660F38,1,  no_WDS, 0x19,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VBROADCASTF128, vbroadcastf128,14,OpCls( YMM,      M128,       NONE ), F_660F38,1,  no_WDS, 0x1A,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VBLENDVPD, vblendvpd, 9,          OpCls( XMM,      XMM_M128,   XMM  ), F_660F3A,1,  no_WDS, 0x4B,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VBLENDVPS, vblendvps, 9,          OpCls( XMM,      XMM_M128,   XMM  ), F_660F3A,1,  no_WDS, 0x4A,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VINSERTF128, vinsertf128, 11,     OpCls( YMM,      XMM_M128,   I8_U ), F_660F3A,1,  no_WDS, 0x18,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VEXTRACTF128, vextractf128, 12,   OpCls( XMM,      YMM,        I8_U ), F_660F3A,0,  no_WDS, 0x19,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VEXTRACTF128, 1,                  OpCls( M128,     YMM,        I8_U ), F_660F3A,0,  no_WDS, 0x19,     0x00,     P_686|P_AVX, 0)
insx(VMASKMOVPS, vmaskmovps, 10,       OpCls( XMM,      XMM_M128,   NONE ), F_660F38,1,  no_WDS, 0x2C,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VMASKMOVPS, 1,                    OpCls( M128,     XMM,        NONE ), F_660F38,0,  no_WDS, 0x2E,     0x00,     P_686|P_AVX, 0)
insx(VMASKMOVPD, vmaskmovpd, 10,       OpCls( XMM,      XMM_M128,   NONE ), F_660F38,1,  no_WDS, 0x2D,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VMASKMOVPD, 1,                    OpCls( M128,     XMM,        NONE ), F_660F38,0,  no_WDS, 0x2F,     0x00,     P_686|P_AVX, 0)
insx(VPBLENDVB, vpblendvb, 9,          OpCls( XMM,      XMM_M128,   XMM  ), F_660F3A,1,  no_WDS, 0x4C,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VPERMILPD, vpermilpd, 9,          OpCls( XMM,      XMM_M128,   NONE ), F_660F38,1,  no_WDS, 0x0D,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VPERMILPD, 1,                     OpCls( XMM,      XMM_M128,   I8_U ), F_660F3A,1,  no_WDS, 0x0D,     0x00,     P_686|P_AVX, 0)
insx(VPERMILPS, vpermilps, 9,          OpCls( XMM,      XMM_M128,   NONE ), F_660F38,1,  no_WDS, 0x0C,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VPERMILPS, 1,                     OpCls( XMM,      XMM_M128,   I8_U ), F_660F3A,1,  no_WDS, 0x0C,     0x00,     P_686|P_AVX, 0)
/* the VPERMIL2xx instructions were dropped */
//insx(VPERMIL2PD, vpermil2pd, 10,       OpCls( XMM,      XMM_M128,   XMM  ), F_660F3A,1,  no_WDS, 0x49,     0x00,     P_686|P_AVX, 0, RWF_VEX )
//insx(VPERMIL2PS, vpermil2ps, 10,       OpCls( XMM,      XMM_M128,   XMM  ), F_660F3A,1,  no_WDS, 0x48,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VPERM2F128, vperm2f128, 10,       OpCls( YMM,      YMM_M256,   I8_U ), F_660F3A,1,  no_WDS, 0x06,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VTESTPS, vtestps, 7,              OpCls( XMM,      XMM_M128,   NONE ), F_660F38,1,  no_WDS, 0x0E,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VTESTPD, vtestpd, 7,              OpCls( XMM,      XMM_M128,   NONE ), F_660F38,1,  no_WDS, 0x0F,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VZEROALL, vzeroall, 8,            OpCls( NONE,     NONE,       NONE ), F_0F,    0,  no_RM,  0x77,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VZEROUPPER, vzeroupper, 10,       OpCls( NONE,     NONE,       NONE ), F_0F,    0,  no_RM,  0x77,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insx(VCVTPD2DQ, vcvtpd2dq, 9,          OpCls( XMM,      XMM_M128,   NONE ), F_F20F,  1,  no_WDS, 0xE6,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VCVTPD2DQ, 1,                     OpCls( XMM,      YMM_M256,   NONE ), F_F20F,  1,  no_WDS, 0xE6,     0x00,     P_686|P_AVX, 0)
insx(VCVTTPD2DQ, vcvttpd2dq, 10,       OpCls( XMM,      XMM_M128,   NONE ), F_660F,  1,  no_WDS, 0xE6,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VCVTTPD2DQ, 1,                    OpCls( XMM,      YMM_M256,   NONE ), F_660F,  1,  no_WDS, 0xE6,     0x00,     P_686|P_AVX, 0)
insx(VCVTPD2PS, vcvtpd2ps, 9,          OpCls( XMM,      XMM_M128,   NONE ), F_660F,  1,  no_WDS, 0x5A,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VCVTPD2PS, 1,                     OpCls( XMM,      YMM_M256,   NONE ), F_660F,  1,  no_WDS, 0x5A,     0x00,     P_686|P_AVX, 0)
insx(VMOVDDUP, vmovddup, 8,            OpCls( XMM,      XMM_M64,    NONE ), F_F20F,  1,  no_WDS, 0x12,     0x00,     P_686|P_AVX, 0, RWF_VEX )
insn(VMOVDDUP, 1,                      OpCls( YMM,      YMM_M256,   NONE ), F_F20F,  1,  no_WDS, 0x12,     0x00,     P_686|P_AVX, 0)
#endif
