/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.AbstractEventList;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.event.ListEventPublisher;
import ca.odell.glazedlists.util.concurrent.Lock;
import ca.odell.glazedlists.util.concurrent.LockFactory;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DebugList
extends AbstractEventList {
    private boolean lockCheckingEnabled;
    private final Set sanctionedReaderThreads = new HashSet();
    private final Set sanctionedWriterThreads = new HashSet();
    private final EventList delegate;
    private final DebugReadWriteLock debugReadWriteLock = new DebugReadWriteLock();

    public DebugList() {
        this.delegate = new BasicEventList(this.debugReadWriteLock);
        this.delegate.addListEventListener(new ListEventForwarder());
    }

    public boolean isLockCheckingEnabled() {
        return this.lockCheckingEnabled;
    }

    public void setLockCheckingEnabled(boolean lockCheckingEnabled) {
        this.lockCheckingEnabled = lockCheckingEnabled;
    }

    public Set getSanctionedReaderThreads() {
        return this.sanctionedReaderThreads;
    }

    public Set getSanctionedWriterThreads() {
        return this.sanctionedWriterThreads;
    }

    protected void beforeReadOperation() {
        if (!this.sanctionedReaderThreads.isEmpty() && !this.sanctionedReaderThreads.contains(Thread.currentThread())) {
            throw new IllegalStateException("DebugList detected an unexpected Thread (" + Thread.currentThread() + ") attempting to perform a read operation");
        }
        if (this.isLockCheckingEnabled() && !this.debugReadWriteLock.isThreadHoldingReadOrWriteLock()) {
            throw new IllegalStateException("DebugList detected a failure to acquire the readLock prior to a read operation");
        }
    }

    protected void afterReadOperation() {
    }

    protected void beforeWriteOperation() {
        if (!this.sanctionedWriterThreads.isEmpty() && !this.sanctionedWriterThreads.contains(Thread.currentThread())) {
            throw new IllegalStateException("DebugList detected an unexpected Thread (" + Thread.currentThread() + ") attempting to perform a write operation");
        }
        if (this.isLockCheckingEnabled() && !this.debugReadWriteLock.isThreadHoldingWriteLock()) {
            throw new IllegalStateException("DebugList detected a failure to acquire the writeLock prior to a write operation");
        }
    }

    protected void afterWriteOperation() {
    }

    public ReadWriteLock getReadWriteLock() {
        return this.delegate.getReadWriteLock();
    }

    public ListEventPublisher getPublisher() {
        return this.delegate.getPublisher();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(int index) {
        this.beforeReadOperation();
        try {
            Object e = this.delegate.get(index);
            return e;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        this.beforeReadOperation();
        try {
            int n = this.delegate.size();
            return n;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        this.beforeReadOperation();
        try {
            boolean bl = this.delegate.contains(object);
            return bl;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection collection) {
        this.beforeReadOperation();
        try {
            boolean bl = this.delegate.containsAll(collection);
            return bl;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object object) {
        this.beforeReadOperation();
        try {
            boolean bl = this.delegate.equals(object);
            return bl;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        this.beforeReadOperation();
        try {
            int n = this.delegate.hashCode();
            return n;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int indexOf(Object object) {
        this.beforeReadOperation();
        try {
            int n = this.delegate.indexOf(object);
            return n;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int lastIndexOf(Object object) {
        this.beforeReadOperation();
        try {
            int n = this.delegate.lastIndexOf(object);
            return n;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        this.beforeReadOperation();
        try {
            boolean bl = this.delegate.isEmpty();
            return bl;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        this.beforeReadOperation();
        try {
            Object[] objectArray = this.delegate.toArray();
            return objectArray;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] array) {
        this.beforeReadOperation();
        try {
            Object[] objectArray = this.delegate.toArray(array);
            return objectArray;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        this.beforeReadOperation();
        try {
            String string = this.delegate.toString();
            return string;
        }
        finally {
            this.afterReadOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(Object value) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.add(value);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(Object toRemove) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.remove(toRemove);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection values) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.addAll(values);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(int index, Collection values) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.addAll(index, values);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection values) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.removeAll(values);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainAll(Collection values) {
        this.beforeWriteOperation();
        try {
            boolean bl = this.delegate.retainAll(values);
            return bl;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.beforeWriteOperation();
        try {
            this.delegate.clear();
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object set(int index, Object value) {
        this.beforeWriteOperation();
        try {
            Object object = this.delegate.set(index, value);
            return object;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int index, Object value) {
        this.beforeWriteOperation();
        try {
            this.delegate.add(index, value);
        }
        finally {
            this.afterWriteOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object remove(int index) {
        this.beforeWriteOperation();
        try {
            Object e = this.delegate.remove(index);
            return e;
        }
        finally {
            this.afterWriteOperation();
        }
    }

    private static class DebugReadWriteLock
    implements ReadWriteLock {
        private final DebugLock readLock;
        private final DebugLock writeLock;

        public DebugReadWriteLock() {
            ReadWriteLock decorated = LockFactory.DEFAULT.createReadWriteLock();
            this.readLock = new DebugLock(decorated.readLock());
            this.writeLock = new DebugLock(decorated.writeLock());
        }

        public Lock readLock() {
            return this.readLock;
        }

        public Lock writeLock() {
            return this.writeLock;
        }

        public boolean isThreadHoldingWriteLock() {
            return this.writeLock.getThreadsHoldingLock().contains(Thread.currentThread());
        }

        public boolean isThreadHoldingReadOrWriteLock() {
            return this.readLock.getThreadsHoldingLock().contains(Thread.currentThread()) || this.writeLock.getThreadsHoldingLock().contains(Thread.currentThread());
        }

        private static class DebugLock
        implements Lock {
            private final Lock delegate;
            private final List threadsHoldingLock = new ArrayList();

            public DebugLock(Lock delegate) {
                this.delegate = delegate;
            }

            public void lock() {
                this.delegate.lock();
                this.threadsHoldingLock.add(Thread.currentThread());
            }

            public boolean tryLock() {
                boolean success = this.delegate.tryLock();
                if (success) {
                    this.threadsHoldingLock.add(Thread.currentThread());
                }
                return success;
            }

            public void unlock() {
                this.delegate.unlock();
                this.threadsHoldingLock.remove(Thread.currentThread());
            }

            public List getThreadsHoldingLock() {
                return this.threadsHoldingLock;
            }
        }
    }

    private class ListEventForwarder
    implements ListEventListener {
        private ListEventForwarder() {
        }

        public void listChanged(ListEvent listChanges) {
            DebugList.this.updates.forwardEvent(listChanges);
        }
    }
}

