/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.event;

import java.util.List;

final class Block {
    private int startIndex;
    private int endIndex;
    private int type;

    Block(int index, int type) {
        this(index, index, type);
    }

    Block(int startIndex, int endIndex, int type) {
        this.setData(startIndex, endIndex, type);
    }

    void setData(int index, int type) {
        this.setData(index, index, type);
    }

    void setData(int startIndex, int endIndex, int type) {
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.type = type;
        if (startIndex < 0 || endIndex < startIndex) {
            throw new IndexOutOfBoundsException("Illegal range: " + startIndex + ", " + endIndex);
        }
        if (type != 2 && type != 1 && type != 0) {
            throw new IllegalArgumentException();
        }
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public int getType() {
        return this.type;
    }

    boolean append(int appendStartIndex, int appendEndIndex, int type) {
        if (type != this.type) {
            return false;
        }
        if (type == 2 && (appendStartIndex > this.endIndex + 1 || appendStartIndex < this.startIndex)) {
            return false;
        }
        if (type == 0 && (appendEndIndex < this.startIndex - 1 || appendStartIndex > this.startIndex)) {
            return false;
        }
        if (type == 1 && (appendEndIndex < this.startIndex - 1 || appendStartIndex > this.endIndex + 1)) {
            return false;
        }
        if (type == 2 || type == 0) {
            int length = this.endIndex - this.startIndex + 1 + (appendEndIndex - appendStartIndex + 1);
            this.startIndex = Math.min(appendStartIndex, this.startIndex);
            this.endIndex = this.startIndex + length - 1;
        } else if (type == 1) {
            this.startIndex = Math.min(appendStartIndex, this.startIndex);
            this.endIndex = Math.max(appendEndIndex, this.endIndex);
        }
        if (this.startIndex < 0 || this.endIndex < this.startIndex) {
            throw new IllegalStateException();
        }
        return true;
    }

    public int getLength() {
        return this.endIndex - this.startIndex + 1;
    }

    static void sortListEventBlocks(List changes, boolean allowContradictingEvents) {
        int swapCount;
        do {
            swapCount = 0;
            int j = 0;
            while (j < changes.size() - 1) {
                Block second;
                Block first = (Block)changes.get(j);
                if (Block.blocksContradict(first, second = (Block)changes.get(j + 1))) {
                    if (!allowContradictingEvents) {
                        throw new IllegalStateException("Change blocks " + first + " and " + second + " intersect");
                    }
                    Block.simplifyContradiction(changes.subList(j, j + 2));
                    ++swapCount;
                    continue;
                }
                if (Block.requiresSplit(first, second)) {
                    Block third = Block.split(first, second);
                    changes.add(j + 2, third);
                    continue;
                }
                if (Block.canBeCombined(first, second)) {
                    Block.combine(first, second);
                    changes.remove(j + 1);
                    if (j <= 0) continue;
                    --j;
                    continue;
                }
                if (Block.requiresSwap(first, second)) {
                    ++swapCount;
                    Block.shift(first, second);
                    changes.set(j, second);
                    changes.set(j + 1, first);
                    ++j;
                    continue;
                }
                ++j;
            }
        } while (swapCount != 0);
    }

    private static boolean blocksContradict(Block first, Block second) {
        boolean rangesIntersect;
        boolean bl = rangesIntersect = first.endIndex >= second.startIndex && first.startIndex <= second.endIndex;
        if (!rangesIntersect) {
            return false;
        }
        return first.type != 0 && second.type != 2;
    }

    private static void simplifyContradiction(List contradictingPair) {
        if (contradictingPair.size() != 2) {
            throw new IllegalStateException();
        }
        Block first = (Block)contradictingPair.get(0);
        Block second = (Block)contradictingPair.get(1);
        int commonStart = Math.max(first.startIndex, second.startIndex);
        int commonEnd = Math.min(first.endIndex, second.endIndex);
        int commonLength = commonEnd - commonStart + 1;
        if (first.type == 2 && second.type == 0) {
            first.endIndex -= commonLength;
            second.endIndex -= commonLength;
            if (second.getLength() == 0) {
                contradictingPair.remove(1);
            }
            if (first.getLength() == 0) {
                contradictingPair.remove(0);
            }
        } else if (first.type == 2 && second.type == 1) {
            contradictingPair.remove(1);
            second.endIndex -= commonLength;
            int secondLength = second.getLength();
            if (secondLength == 0) {
                return;
            }
            second.startIndex = Math.min(first.startIndex, second.startIndex);
            second.endIndex = second.startIndex + secondLength - 1;
            contradictingPair.add(0, second);
        } else if (first.type == 1 && second.type == 0) {
            contradictingPair.remove(0);
            first.endIndex -= commonLength;
            int firstLength = first.getLength();
            if (firstLength == 0) {
                return;
            }
            first.startIndex = Math.min(first.startIndex, second.startIndex);
            first.endIndex = first.startIndex + firstLength - 1;
            contradictingPair.add(1, first);
        } else if (first.type == 1 && second.type == 1) {
            first.startIndex = Math.min(first.startIndex, second.startIndex);
            first.endIndex = Math.max(first.endIndex, second.endIndex);
            contradictingPair.remove(1);
        }
    }

    private static boolean requiresSwap(Block first, Block second) {
        if (second.type == 2 && first.type != 0) {
            return second.startIndex <= first.startIndex;
        }
        return second.startIndex < first.startIndex;
    }

    private static boolean canBeCombined(Block first, Block second) {
        if (first.type != second.type) {
            return false;
        }
        if (first.type == 2) {
            return second.startIndex >= first.startIndex && second.startIndex <= first.endIndex + 1;
        }
        if (first.type == 0) {
            return second.startIndex <= first.startIndex && second.endIndex >= first.startIndex - 1;
        }
        if (first.type == 1) {
            return second.startIndex <= first.endIndex && second.endIndex >= first.startIndex;
        }
        throw new IllegalStateException();
    }

    private static void combine(Block first, Block second) {
        if (first.type == 2 || first.type == 0) {
            int startIndex = Math.min(first.startIndex, second.startIndex);
            int length = first.getLength() + second.getLength();
            first.startIndex = startIndex;
            first.endIndex = startIndex + length - 1;
        } else if (first.type == 1) {
            int startIndex = Math.min(first.startIndex, second.startIndex);
            int endIndex = Math.max(first.endIndex, second.endIndex);
            first.startIndex = startIndex;
            first.endIndex = endIndex;
        }
    }

    private static void shift(Block alpha, Block beta) {
        int movedLength = beta.getLength();
        if (beta.type == 2) {
            alpha.startIndex += movedLength;
            alpha.endIndex += movedLength;
        } else if (beta.type != 1 && beta.type == 0) {
            alpha.startIndex -= movedLength;
            alpha.endIndex -= movedLength;
            if (alpha.startIndex < 0) {
                throw new IllegalStateException();
            }
        }
    }

    private static boolean requiresSplit(Block first, Block second) {
        Block otherBlock;
        Block updateBlock;
        boolean updateIsFirst;
        if (first.type != 1 && second.type != 1) {
            return false;
        }
        if (first.type == second.type) {
            return false;
        }
        boolean bl = updateIsFirst = first.type == 1;
        if (updateIsFirst) {
            updateBlock = first;
            otherBlock = second;
        } else {
            updateBlock = second;
            otherBlock = first;
        }
        if (updateBlock.startIndex >= otherBlock.startIndex) {
            return false;
        }
        return updateBlock.endIndex >= otherBlock.startIndex;
    }

    private static Block split(Block first, Block second) {
        Block otherBlock;
        Block updateBlock;
        boolean updateIsFirst;
        boolean bl = updateIsFirst = first.type == 1;
        if (updateIsFirst) {
            updateBlock = first;
            otherBlock = second;
        } else {
            updateBlock = second;
            otherBlock = first;
        }
        int splitLocation = otherBlock.startIndex;
        int part2Offset = -1;
        if (otherBlock.type == 0) {
            part2Offset = 0;
        } else if (otherBlock.type == 2) {
            part2Offset = otherBlock.getLength();
        }
        Block updateBlockPart2 = new Block(splitLocation + part2Offset, updateBlock.endIndex + part2Offset, 1);
        updateBlock.endIndex = splitLocation - 1;
        return updateBlockPart2;
    }

    public String toString() {
        String result = "";
        if (this.type == 0) {
            result = result + "D.";
        } else if (this.type == 1) {
            result = result + "U.";
        } else if (this.type == 2) {
            result = result + "I.";
        }
        result = this.startIndex == this.endIndex ? result + this.startIndex : result + this.startIndex + "-" + this.endIndex;
        return result;
    }
}

