/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.impl;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.impl.WeakReferenceProxy;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class EventListIterator
implements ListIterator,
ListEventListener {
    private EventList source;
    private int nextIndex;
    private int lastIndex = -1;

    public EventListIterator(EventList source) {
        this(source, 0, true);
    }

    public EventListIterator(EventList source, int nextIndex) {
        this(source, nextIndex, true);
    }

    public EventListIterator(EventList source, int nextIndex, boolean automaticallyRemove) {
        this.source = source;
        this.nextIndex = nextIndex;
        if (automaticallyRemove) {
            WeakReferenceProxy gcProxy = new WeakReferenceProxy(source, this);
            source.addListEventListener(gcProxy);
            source.getPublisher().removeDependency(source, gcProxy);
        } else {
            source.addListEventListener(this);
            source.getPublisher().removeDependency(source, this);
        }
    }

    public boolean hasNext() {
        return this.nextIndex < this.source.size();
    }

    public Object next() {
        if (this.nextIndex == this.source.size()) {
            throw new NoSuchElementException("Cannot retrieve element " + this.nextIndex + " on a list of size " + this.source.size());
        }
        this.lastIndex = this.nextIndex++;
        return this.source.get(this.lastIndex);
    }

    public int nextIndex() {
        return this.nextIndex;
    }

    public boolean hasPrevious() {
        return this.nextIndex > 0;
    }

    public Object previous() {
        if (this.nextIndex == 0) {
            throw new NoSuchElementException("Cannot retrieve element " + this.nextIndex + " on a list of size " + this.source.size());
        }
        --this.nextIndex;
        this.lastIndex = this.nextIndex;
        return this.source.get(this.nextIndex);
    }

    public int previousIndex() {
        return this.nextIndex - 1;
    }

    public void add(Object o) {
        this.source.add(this.nextIndex, o);
    }

    public void remove() {
        if (this.lastIndex == -1) {
            throw new IllegalStateException("Cannot remove() without a prior call to next() or previous()");
        }
        this.source.remove(this.lastIndex);
    }

    public void set(Object o) {
        if (this.lastIndex == -1) {
            throw new IllegalStateException("Cannot set() without a prior call to next() or previous()");
        }
        this.source.set(this.lastIndex, o);
    }

    public void listChanged(ListEvent listChanges) {
        while (listChanges.next()) {
            int changeIndex = listChanges.getIndex();
            int changeType = listChanges.getType();
            if (changeType == 2) {
                if (changeIndex <= this.nextIndex) {
                    ++this.nextIndex;
                }
                if (this.lastIndex == -1 || changeIndex > this.lastIndex) continue;
                ++this.lastIndex;
                continue;
            }
            if (changeType != 0) continue;
            if (changeIndex < this.nextIndex) {
                --this.nextIndex;
            }
            if (this.lastIndex != -1 && changeIndex < this.lastIndex) {
                --this.lastIndex;
                continue;
            }
            if (this.lastIndex == -1 || changeIndex != this.lastIndex) continue;
            this.lastIndex = -1;
        }
    }
}

