/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.jfreechart;

import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.jfreechart.ValueSegment;

public class DefaultValueSegment
implements ValueSegment {
    private final Comparable start;
    private final Comparable end;
    private final Comparable value;

    public DefaultValueSegment(Comparable start, Comparable end, Comparable value) {
        if (start == null) {
            throw new IllegalArgumentException("start may not be null");
        }
        if (end == null) {
            throw new IllegalArgumentException("end may not be null");
        }
        this.start = start;
        this.end = end;
        this.value = value;
    }

    public Comparable getStart() {
        return this.start;
    }

    public Comparable getEnd() {
        return this.end;
    }

    public Comparable getValue() {
        return this.value;
    }

    public int compareTo(Object x0) {
        ValueSegment o = (ValueSegment)x0;
        int valueComparison = GlazedLists.comparableComparator().compare(this.value, o.getValue());
        if (valueComparison != 0) {
            return valueComparison;
        }
        int startComparison = this.start.compareTo(o.getStart());
        if (startComparison != 0) {
            return startComparison;
        }
        return this.end.compareTo(o.getEnd());
    }

    public String toString() {
        return "(" + this.start + ", " + this.end + ")";
    }
}

