/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.matchers;

import ca.odell.glazedlists.Filterator;
import ca.odell.glazedlists.impl.matchers.BeanPropertyMatcher;
import ca.odell.glazedlists.impl.matchers.FalseMatcher;
import ca.odell.glazedlists.impl.matchers.NotMatcher;
import ca.odell.glazedlists.impl.matchers.RangeMatcher;
import ca.odell.glazedlists.impl.matchers.TrueMatcher;
import ca.odell.glazedlists.impl.matchers.WeakReferenceMatcherEditor;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.util.Collection;
import java.util.Iterator;

public final class Matchers {
    private Matchers() {
        throw new UnsupportedOperationException();
    }

    public static MatcherEditor weakReferenceProxy(MatcherEditor matcherEditor) {
        return new WeakReferenceMatcherEditor(matcherEditor);
    }

    public static Matcher trueMatcher() {
        return TrueMatcher.getInstance();
    }

    public static Matcher falseMatcher() {
        return FalseMatcher.getInstance();
    }

    public static Matcher invert(Matcher original) {
        return new NotMatcher(original);
    }

    public static Matcher beanPropertyMatcher(Class beanClass, String propertyName, Object expectedValue) {
        return new BeanPropertyMatcher(beanClass, propertyName, expectedValue);
    }

    public static Matcher rangeMatcher(Comparable start, Comparable end) {
        return new RangeMatcher(start, end);
    }

    public static Matcher rangeMatcher(Comparable start, Comparable end, Filterator filterator) {
        return new RangeMatcher(start, end, filterator);
    }

    public static boolean filter(Collection collection, Matcher matcher) {
        boolean changed = false;
        Iterator i = collection.iterator();
        while (i.hasNext()) {
            Object element = i.next();
            if (matcher.matches(element)) continue;
            i.remove();
            changed = true;
        }
        return changed;
    }
}

