/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.NotifyOption;
import gnu.dtools.ritopt.Option;
import gnu.dtools.ritopt.OptionEvent;
import gnu.dtools.ritopt.OptionException;
import gnu.dtools.ritopt.OptionListener;
import gnu.dtools.ritopt.OptionMenu;
import gnu.dtools.ritopt.OptionModule;
import gnu.dtools.ritopt.OptionModuleRegistrar;
import gnu.dtools.ritopt.OptionProcessingException;
import gnu.dtools.ritopt.OptionRegistrar;
import gnu.dtools.ritopt.Utility;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.jabref.Globals;

public class Options
implements OptionRegistrar,
OptionModuleRegistrar,
OptionListener {
    public static final int DEFAULT_VERBOSITY = 3;
    public static final boolean DEFAULT_DEPRECATED = false;
    public static final String DEFAULT_REASON = "No reason given.";
    public static final String DEFAULT_GENERAL_MODULE_NAME = "General";
    public static final boolean DEFAULT_DISPLAY_USAGE = false;
    public static final boolean DEFAULT_USE_MENU = false;
    public static final String DEFAULT_PROGRAM_NAME = "java program";
    public static final String DEFAULT_OPTION_FILENAME = "default.opt";
    private int verbosity = 3;
    private String usageProgram;
    private String version;
    private String defaultOptionFilename = "default.opt";
    private boolean displayUsage = false;
    private boolean useMenu = false;
    private boolean debugFlag;
    private OptionModule currentModule;
    private OptionModule generalModule;
    private HashMap modules;
    private NotifyOption helpOption;
    private NotifyOption menuOption;
    private NotifyOption versionOption;
    private OptionMenu menu;

    public Options() {
        this(DEFAULT_PROGRAM_NAME);
    }

    public Options(String string) {
        this.usageProgram = string;
        this.modules = new HashMap();
        this.menu = new OptionMenu(this);
        this.helpOption = new NotifyOption(this, "help", "");
        this.versionOption = new NotifyOption(this, "version", "");
        this.version = "Version 1.0";
        this.menuOption = new NotifyOption(this.menu, "menu", "");
        this.currentModule = this.generalModule = new OptionModule(DEFAULT_GENERAL_MODULE_NAME);
        this.register("version", 'v', "Displays version information.", this.versionOption);
    }

    public String getHelp() {
        String string = (this.displayUsage ? this.getUsage() + "\n\n" : "") + Option.getHelpHeader() + "\n\n" + this.generalModule.getHelp();
        Iterator iterator = this.modules.values().iterator();
        while (iterator.hasNext()) {
            OptionModule optionModule = (OptionModule)iterator.next();
            string = string + "\n\nOption Listing for " + optionModule.getName() + "\n";
            string = string + optionModule.getHelp() + "\n";
        }
        return string;
    }

    public String getUsage() {
        return this.getUsageProgram() + " @optionfile :module: OPTIONS ... :module: OPTIONS";
    }

    public String getUsageProgram() {
        return this.usageProgram;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDefaultOptionFilename() {
        return this.defaultOptionFilename;
    }

    public boolean getDebugFlag() {
        return this.debugFlag;
    }

    public boolean shouldDisplayUsage() {
        return this.displayUsage;
    }

    public boolean shouldUseMenu() {
        return this.useMenu;
    }

    public void setDisplayUsage(boolean bl) {
        this.displayUsage = bl;
    }

    public void setUseMenu(boolean bl) {
        this.useMenu = bl;
    }

    public void setUsageProgram(String string) {
        this.usageProgram = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void setDefaultOptionFilename(String string) {
        this.defaultOptionFilename = string;
    }

    public void displayHelp() {
        System.err.println(this.getHelp());
    }

    public void displayVersion() {
        System.err.println(this.getVersion() + " (build " + Globals.BUILD + ")");
    }

    public void register(String string, Option option) {
        this.generalModule.register(string, option);
    }

    public void register(char c, Option option) {
        this.generalModule.register(c, option);
    }

    public void register(String string, char c, Option option) {
        this.generalModule.register(string, c, option);
    }

    public void register(String string, char c, String string2, Option option) {
        this.generalModule.register(string, c, string2, option);
    }

    public void register(String string, char c, String string2, Option option, boolean bl) {
        this.generalModule.register(string, c, string2, option, bl);
    }

    public void register(OptionModule optionModule) {
        this.register(optionModule.getName(), optionModule);
    }

    public void register(String string, OptionModule optionModule) {
        this.modules.put(string.toLowerCase(), optionModule);
    }

    public String[] process(String[] stringArray) {
        String[] stringArray2 = new String[]{};
        try {
            stringArray2 = this.processOptions(stringArray);
        }
        catch (OptionException optionException) {
            System.err.println("Error: " + optionException.getMessage());
        }
        return stringArray2;
    }

    public OptionModule getModule(String string) {
        return (OptionModule)this.modules.get(string.toLowerCase());
    }

    public boolean moduleExists(String string) {
        return this.getModule(string) != null;
    }

    public void optionInvoked(OptionEvent optionEvent) {
        if (optionEvent.getCommand().equals("help")) {
            this.displayHelp();
        } else if (optionEvent.getCommand().equals("version")) {
            this.displayVersion();
        }
    }

    public String[] process(String string) {
        return this.process(this.split(string));
    }

    public String[] split(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = Utility.count(string, '\"');
        boolean bl = false;
        if ((double)n / 2.0 != (double)(n / 2)) {
            throw new OptionProcessingException("Expecting an end quote.");
        }
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\"') {
                bl = !bl;
                continue;
            }
            if (string.charAt(i) == ' ' && !bl) {
                arrayList.add(stringBuffer.toString());
                stringBuffer = new StringBuffer(string.length());
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        if (stringBuffer.length() != 0) {
            arrayList.add(stringBuffer.toString());
        }
        Iterator iterator = arrayList.iterator();
        String[] stringArray = new String[arrayList.size()];
        int n2 = 0;
        while (iterator.hasNext()) {
            stringArray[n2++] = (String)iterator.next();
        }
        return stringArray;
    }

    public void writeOptionFile(String string) {
        FilterOutputStream filterOutputStream = null;
        Object var3_3 = null;
        Iterator iterator = null;
        this.currentModule = this.generalModule;
        try {
            filterOutputStream = new BufferedOutputStream(new FileOutputStream(string));
            PrintStream printStream = new PrintStream(filterOutputStream);
            this.generalModule.writeFileToPrintStream(printStream);
            iterator = this.modules.values().iterator();
            while (iterator.hasNext()) {
                OptionModule optionModule = (OptionModule)iterator.next();
                optionModule.writeFileToPrintStream(printStream);
            }
        }
        catch (IOException iOException) {
            throw new OptionProcessingException(iOException.getMessage());
        }
        finally {
            try {
                if (filterOutputStream != null) {
                    filterOutputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new OptionProcessingException(iOException.getMessage());
            }
        }
    }

    public void loadOptionFile(String string) {
        BufferedReader bufferedReader = null;
        String string2 = null;
        this.currentModule = this.generalModule;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                string2 = Utility.stripComments(string2, '\"', ';');
                this.process(string2);
            }
        }
        catch (IOException iOException) {
            throw new OptionProcessingException(iOException.getMessage());
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                throw new OptionProcessingException(iOException.getMessage());
            }
        }
    }

    private String[] processOptions(String[] stringArray) {
        String[] stringArray2 = null;
        String string = "general";
        String string2 = "";
        char c = '\u0000';
        String string3 = "";
        for (int i = 0; i < stringArray.length && stringArray2 == null; ++i) {
            int n;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            if (stringArray[i].length() >= 1) {
                n = stringArray[i].charAt(0);
                bl = n == 58;
                bl4 = n == 64;
                boolean bl6 = bl5 = n == 37;
            }
            if (stringArray[i].length() >= 2) {
                String string4 = stringArray[i].substring(0, 2);
                bl2 = !string4.equals("--") && string4.charAt(0) == '-';
                bl3 = string4.equals("--");
            }
            if (this.debugFlag) {
                System.err.println("Short Option: " + bl2);
                System.err.println("Long Option: " + bl3);
                System.err.println("Module: " + bl);
                System.err.println("Load Option File: " + bl4);
                System.err.println("Write Option File: " + bl5);
            }
            if (bl) {
                if (stringArray[i].charAt(stringArray[i].length() - 1) != ':') {
                    System.err.println(stringArray[i]);
                    throw new OptionProcessingException("Module arguments must start with : and end with :.");
                }
                string = stringArray[i].substring(1, stringArray[i].length() - 1).toLowerCase();
                if (string.length() == 0 || string.equals("general")) {
                    string = "general";
                    this.currentModule = this.generalModule;
                } else {
                    this.currentModule = this.getModule(string);
                }
                if (this.currentModule == null) {
                    throw new OptionProcessingException("Module '" + string + "' does not exist.");
                }
                if (this.debugFlag) {
                    System.err.println("Module: " + string);
                }
                bl = false;
                continue;
            }
            if (bl4) {
                string2 = Utility.trim(stringArray[i].substring(1));
                if (string2.equals("@") || string2.length() == 0) {
                    string2 = this.defaultOptionFilename;
                }
                if (this.debugFlag) {
                    System.err.println("Option file: '" + string2 + "'.");
                }
                this.loadOptionFile(string2);
                continue;
            }
            if (bl2) {
                c = stringArray[i].charAt(1);
                if (!Utility.isAlphaNumeric(c)) {
                    throw new OptionProcessingException("A short option must be alphanumeric. -" + c + " is not acceptable.");
                }
                if (this.debugFlag) {
                    System.err.println("Short option text: " + c);
                }
                int n2 = n = stringArray[i].length() >= 3 ? (int)stringArray[i].charAt(2) : 0;
                if (n == 43 || n == 45) {
                    this.currentModule.action(c, (char)n);
                    continue;
                }
                if (n == 61) {
                    this.currentModule.action(c, stringArray[i].substring(3));
                    continue;
                }
                if (n == 0) {
                    String string5 = "+";
                    char c2 = '\u0000';
                    if (i < stringArray.length - 1) {
                        c2 = stringArray[i + '\u0001'].charAt(0);
                        if (!Utility.contains(stringArray[i + '\u0001'].charAt(0), "-[@")) {
                            string5 = stringArray[i + '\u0001'];
                            ++i;
                        }
                    }
                    this.currentModule.action(c, string5);
                    continue;
                }
                if (!Utility.isAlphaNumeric((char)n)) continue;
                for (int j = 1; j < stringArray[i].length(); ++j) {
                    if (!Utility.isAlphaNumeric(stringArray[i].charAt(j))) {
                        throw new OptionProcessingException("A short option must be alphanumeric. -" + c + " is not acceptable.");
                    }
                    this.currentModule.action(c, "+");
                }
                continue;
            }
            if (bl3) {
                n = stringArray[i].charAt(stringArray[i].length() - 1);
                int n3 = stringArray[i].indexOf("=");
                if (n3 != -1) {
                    string3 = stringArray[i].substring(2, n3);
                    String string6 = stringArray[i].substring(n3 + 1);
                    this.currentModule.action(string3, string6);
                } else if (Utility.contains((char)n, "+-")) {
                    string3 = stringArray[i].substring(2, stringArray[i].length() - 1);
                    this.currentModule.action(string3, (char)n);
                } else {
                    string3 = stringArray[i].substring(2);
                    String string7 = "+";
                    char c3 = '\u0000';
                    if (i < stringArray.length - 1 && stringArray[i + '\u0001'].length() > 0) {
                        c3 = stringArray[i + '\u0001'].charAt(0);
                        if (!Utility.contains(stringArray[i + '\u0001'].charAt(0), "-[@")) {
                            string7 = stringArray[i + 1];
                            ++i;
                        }
                    }
                    this.currentModule.action(string3, string7);
                }
                if (!this.debugFlag) continue;
                System.err.println("long option: " + string3);
                continue;
            }
            if (bl5) {
                string2 = Utility.trim(stringArray[i].substring(1));
                if (string2.equals("%") || string2.length() == 0) {
                    string2 = this.defaultOptionFilename;
                }
                if (this.debugFlag) {
                    System.err.println("Option file: '" + string2 + "'.");
                }
                this.writeOptionFile(string2);
                continue;
            }
            stringArray2 = new String[stringArray.length - i];
            for (n = i; n < stringArray.length; ++n) {
                stringArray2[n - i] = stringArray[n];
            }
        }
        if (stringArray2 == null) {
            stringArray2 = new String[]{};
        }
        return stringArray2;
    }
}

