/*
 * Decompiled with CFR 0.152.
 */
package gnu.dtools.ritopt;

import gnu.dtools.ritopt.Stoppable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class StreamPrinter
implements Runnable,
Stoppable {
    private InputStream stream;
    private PrintStream out;
    private Stoppable stop;
    private boolean stopped;
    private boolean flush;
    private Thread thread;

    public StreamPrinter(InputStream inputStream, PrintStream printStream) {
        this.stream = inputStream;
        this.out = printStream;
        this.thread = new Thread(this);
    }

    public void start() throws InterruptedException {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStop(Stoppable stoppable) {
        StreamPrinter streamPrinter = this;
        synchronized (streamPrinter) {
            this.stop = stoppable;
        }
    }

    public boolean isStopped() {
        return this.stopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFlush(boolean bl) {
        StreamPrinter streamPrinter = this;
        synchronized (streamPrinter) {
            this.flush = bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Stoppable stoppable = this;
        synchronized (stoppable) {
            this.stopped = true;
        }
        if (this.stop != null) {
            stoppable = this.stop;
            synchronized (stoppable) {
                if (!this.stop.isStopped()) {
                    this.stop.stop();
                }
            }
        }
    }

    public void join() throws InterruptedException {
        this.thread.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (!this.stopped) {
                boolean bl;
                int n = this.stream.read();
                if (n == -1) return;
                Object object = this;
                synchronized (object) {
                    bl = this.flush;
                }
                object = this.out;
                synchronized (object) {
                    this.out.print((char)n);
                    if (bl) {
                        this.out.flush();
                    }
                }
            }
            return;
        }
        catch (IOException iOException) {
            this.out.println("I/O error");
            return;
        }
        finally {
            PrintStream printStream = this.out;
            synchronized (printStream) {
                this.out.flush();
            }
            this.stop();
        }
    }
}

