/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.FontSelectorDialog;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.gui.ColorSetupPanel;

class AppearancePrefsTab
extends JPanel
implements PrefsTab {
    JabRefPreferences _prefs;
    private JCheckBox colorCodes;
    private JCheckBox antialias;
    private JCheckBox overrideFonts;
    private GridBagLayout gbl = new GridBagLayout();
    private JButton fontButton = new JButton(Globals.lang("Set table font"));
    private ColorSetupPanel colorPanel = new ColorSetupPanel();
    private Font font = GUIGlobals.CURRENTFONT;
    private int oldMenuFontSize;
    private boolean oldOverrideFontSize;
    private JTextField fontSize;

    public AppearancePrefsTab(JabRefPreferences jabRefPreferences) {
        this._prefs = jabRefPreferences;
        this.setLayout(new BorderLayout());
        this.fontSize = new JTextField(5);
        this.colorCodes = new JCheckBox(Globals.lang("Color codes for required and optional fields"));
        this.antialias = new JCheckBox(Globals.lang("Use antialiasing font"));
        this.overrideFonts = new JCheckBox(Globals.lang("Override default font settings"));
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref, 4dlu, fill:60dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.setLeadingColumnOffset(2);
        defaultFormBuilder.appendSeparator(Globals.lang("General"));
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(Globals.lang("Menu and label font size") + ":");
        jPanel.add(jLabel);
        jPanel.add(this.fontSize);
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.overrideFonts);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Table appearance"));
        defaultFormBuilder.append(this.antialias);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.colorCodes);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.fontButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(this.colorPanel);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        jPanel2.setLayout(this.gbl);
        jPanel3.setLayout(this.gbl);
        jPanel4.setLayout(this.gbl);
        jPanel5.setLayout(this.gbl);
        this.overrideFonts.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AppearancePrefsTab.this.fontSize.setEnabled(AppearancePrefsTab.this.overrideFonts.isSelected());
            }
        });
        this.fontButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Font font = new FontSelectorDialog(null, GUIGlobals.CURRENTFONT).getSelectedFont();
                if (font == null) {
                    return;
                }
                AppearancePrefsTab.this.font = font;
            }
        });
        JPanel jPanel6 = defaultFormBuilder.getPanel();
        jPanel6.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel6, "Center");
    }

    public void setValues() {
        this.colorCodes.setSelected(this._prefs.getBoolean("tableColorCodesOn"));
        this.antialias.setSelected(this._prefs.getBoolean("antialias"));
        this.fontSize.setText("" + this._prefs.getInt("menuFontSize"));
        this.oldMenuFontSize = this._prefs.getInt("menuFontSize");
        this.overrideFonts.setSelected(this._prefs.getBoolean("overrideDefaultFonts"));
        this.oldOverrideFontSize = this.overrideFonts.isSelected();
        this.fontSize.setEnabled(this.overrideFonts.isSelected());
        this.colorPanel.setValues();
    }

    public void storeSettings() {
        this._prefs.putBoolean("tableColorCodesOn", this.colorCodes.isSelected());
        this._prefs.putBoolean("antialias", this.antialias.isSelected());
        this._prefs.put("fontFamily", this.font.getFamily());
        this._prefs.putInt("fontStyle", this.font.getStyle());
        this._prefs.putInt("fontSize", this.font.getSize());
        this._prefs.putBoolean("overrideDefaultFonts", this.overrideFonts.isSelected());
        GUIGlobals.CURRENTFONT = this.font;
        this.colorPanel.storeSettings();
        try {
            int n = Integer.parseInt(this.fontSize.getText());
            if (this.overrideFonts.isSelected() != this.oldOverrideFontSize || n != this.oldMenuFontSize) {
                this._prefs.putInt("menuFontSize", n);
                JOptionPane.showMessageDialog(null, Globals.lang("You have changed the menu and label font size. You must restart JabRef for this to come into effect."), Globals.lang("Changed font settings"), 2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
    }

    public boolean readyToClose() {
        try {
            Integer.parseInt(this.fontSize.getText());
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(null, Globals.lang("You must enter an integer value in the text field for") + " '" + Globals.lang("Menu and label font size") + "'", Globals.lang("Changed font settings"), 0);
            return false;
        }
        return true;
    }

    public String getTabName() {
        return Globals.lang("Appearance");
    }
}

