/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.regex.PatternSyntaxException;
import javax.swing.SwingUtilities;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.ErrorMessageDisplay;
import net.sf.jabref.Globals;
import net.sf.jabref.SearchRuleSet;

public class DatabaseSearch
extends Thread {
    BasePanel panel = null;
    BibtexDatabase thisDatabase = null;
    SearchRuleSet thisRuleSet = null;
    Hashtable thisSearchOptions = null;
    String searchValueField = null;
    boolean reorder;
    boolean select;
    boolean grayOut;
    ErrorMessageDisplay errorDisplay;
    Set matches = new HashSet();

    public DatabaseSearch(ErrorMessageDisplay errorMessageDisplay, Hashtable hashtable, SearchRuleSet searchRuleSet, BasePanel basePanel, String string, boolean bl, boolean bl2, boolean bl3) {
        this.panel = basePanel;
        this.errorDisplay = errorMessageDisplay;
        this.thisDatabase = basePanel.getDatabase();
        this.thisSearchOptions = hashtable;
        this.thisRuleSet = searchRuleSet;
        this.searchValueField = string;
        this.reorder = bl;
        this.select = bl3;
        this.grayOut = bl2;
    }

    public void run() {
        int n = 0;
        this.matches.clear();
        BibtexEntry bibtexEntry = null;
        int n2 = 0;
        Iterator iterator = this.thisDatabase.getKeySet().iterator();
        while (iterator.hasNext()) {
            bibtexEntry = this.thisDatabase.getEntryById((String)iterator.next());
            if (bibtexEntry == null) continue;
            try {
                n = this.thisRuleSet.applyRule(this.thisSearchOptions, bibtexEntry);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                this.errorDisplay.reportError("Malformed regular expression", patternSyntaxException);
                return;
            }
            if (n > 0) {
                n = 1;
            }
            bibtexEntry.setField(this.searchValueField, String.valueOf(n));
            if (n <= 0) continue;
            ++n2;
            this.matches.add(bibtexEntry);
        }
        final int n3 = n2;
        SwingUtilities.invokeLater(new Thread(){

            public void run() {
                DatabaseSearch.this.panel.output(Globals.lang("Searched database. Global number of hits") + ": " + n3);
            }
        });
    }

    public Iterator matches() {
        return this.matches.iterator();
    }
}

