/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.CheckBoxMessage;
import net.sf.jabref.EntryEditorTab;
import net.sf.jabref.EntryEditorTabList;
import net.sf.jabref.FieldContentSelector;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldEditorFocusListener;
import net.sf.jabref.FieldTextArea;
import net.sf.jabref.FieldTextField;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.OpenFileFilter;
import net.sf.jabref.SimpleUrlDragDrop;
import net.sf.jabref.Util;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.external.ExternalFilePanel;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.ExplicitGroup;
import net.sf.jabref.gui.date.DatePickerButton;
import net.sf.jabref.imports.BibtexParser;
import net.sf.jabref.journals.JournalAbbreviations;
import net.sf.jabref.labelPattern.LabelPatternUtil;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;
import net.sf.jabref.undo.UndoableKeyChange;
import net.sf.jabref.undo.UndoableRemoveEntry;

public class EntryEditor
extends JPanel
implements VetoableChangeListener {
    private BibtexEntry entry;
    BibtexEntryType type;
    CloseAction closeAction;
    DeleteAction deleteAction = new DeleteAction();
    CopyKeyAction copyKeyAction;
    AbstractAction nextEntryAction = new NextEntryAction();
    AbstractAction prevEntryAction = new PrevEntryAction();
    public StoreFieldAction storeFieldAction;
    SwitchLeftAction switchLeftAction = new SwitchLeftAction();
    SwitchRightAction switchRightAction = new SwitchRightAction();
    GenerateKeyAction generateKeyAction;
    SaveDatabaseAction saveDatabaseAction = new SaveDatabaseAction();
    JPanel mainPanel = new JPanel();
    JPanel srcPanel = new JPanel();
    EntryEditorTab genPan;
    EntryEditorTab optPan;
    EntryEditorTab reqPan;
    EntryEditorTab absPan;
    JTextField bibtexKey;
    FieldTextField tf;
    JTextArea source;
    JToolBar tlb;
    JTabbedPane tabbed = new JTabbedPane();
    JLabel lab;
    TypeLabel typeLabel;
    JabRefFrame frame;
    BasePanel panel;
    EntryEditor ths = this;
    HashSet contentSelectors = new HashSet();
    Logger logger = Logger.getLogger(EntryEditor.class.getName());
    boolean updateSource = true;
    List tabs = new ArrayList();
    boolean lastSourceAccepted = true;
    String lastSourceStringAccepted = null;
    private int sourceIndex = -1;
    JabRefPreferences prefs;
    HelpAction helpAction;
    UndoAction undoAction = new UndoAction();
    RedoAction redoAction = new RedoAction();
    TabListener tabListener = new TabListener();

    public EntryEditor(JabRefFrame jabRefFrame, BasePanel basePanel, BibtexEntry bibtexEntry) {
        this.frame = jabRefFrame;
        this.panel = basePanel;
        this.entry = bibtexEntry;
        this.prefs = Globals.prefs;
        this.type = this.entry.getType();
        this.entry.addPropertyChangeListener(this);
        this.helpAction = new HelpAction(this.frame.helpDiag, GUIGlobals.entryEditorHelp, "Help");
        this.closeAction = new CloseAction();
        this.copyKeyAction = new CopyKeyAction();
        this.generateKeyAction = new GenerateKeyAction(this.frame);
        this.storeFieldAction = new StoreFieldAction();
        BorderLayout borderLayout = new BorderLayout();
        this.setLayout(borderLayout);
        this.setupToolBar();
        this.setupFieldPanels();
        this.setupSourcePanel();
        this.add((Component)this.tabbed, "Center");
        this.tabbed.addChangeListener(this.tabListener);
        if (this.prefs.getBoolean("showSource") && this.prefs.getBoolean("defaultShowSource")) {
            this.tabbed.setSelectedIndex(this.sourceIndex);
        }
        this.updateAllFields();
    }

    private void setupFieldPanels() {
        this.tabbed.removeAll();
        this.tabs.clear();
        String[] stringArray = this.entry.getRequiredFields();
        List<String> list = null;
        if (stringArray != null) {
            list = Arrays.asList(stringArray);
        }
        this.reqPan = new EntryEditorTab(list, this, true, Globals.lang("Required fields"));
        this.tabbed.addTab(Globals.lang("Required fields"), GUIGlobals.getImage("required"), this.reqPan.getPane(), Globals.lang("Show required fields"));
        this.tabs.add(this.reqPan);
        if (this.entry.getOptionalFields() != null && this.entry.getOptionalFields().length >= 1) {
            this.optPan = new EntryEditorTab(Arrays.asList(this.entry.getOptionalFields()), this, false, Globals.lang("Optional fields"));
            this.tabbed.addTab(Globals.lang("Optional fields"), GUIGlobals.getImage("optional"), this.optPan.getPane(), Globals.lang("Show optional fields"));
            this.tabs.add(this.optPan);
        }
        EntryEditorTabList entryEditorTabList = Globals.prefs.getEntryEditorTabList();
        for (int i = 0; i < entryEditorTabList.getTabCount(); ++i) {
            EntryEditorTab entryEditorTab = new EntryEditorTab(entryEditorTabList.getTabFields(i), this, false, entryEditorTabList.getTabName(i));
            this.tabbed.addTab(entryEditorTabList.getTabName(i), GUIGlobals.getImage("general"), entryEditorTab.getPane());
            this.tabs.add(entryEditorTab);
        }
        this.srcPanel.setName(Globals.lang("BibTeX source"));
        if (Globals.prefs.getBoolean("showSource")) {
            this.tabbed.addTab(Globals.lang("BibTeX source"), GUIGlobals.getImage("source"), this.srcPanel, Globals.lang("Show/edit BibTeX source"));
            this.tabs.add(this.srcPanel);
        }
        this.sourceIndex = this.tabs.size() - 1;
        this.srcPanel.setFocusCycleRoot(true);
    }

    public BibtexEntryType getType() {
        return this.type;
    }

    public BibtexEntry getEntry() {
        return this.entry;
    }

    private void setupToolBar() {
        this.tlb = new JToolBar(1);
        this.tlb.setMargin(new Insets(0, 0, 0, 2));
        ActionMap actionMap = this.tlb.getActionMap();
        InputMap inputMap = this.tlb.getInputMap(2);
        inputMap.put(this.prefs.getKey("Close entry editor"), "close");
        actionMap.put("close", this.closeAction);
        inputMap.put(this.prefs.getKey("Entry editor, store field"), "store");
        actionMap.put("store", this.storeFieldAction);
        inputMap.put(this.prefs.getKey("Autogenerate BibTeX keys"), "generateKey");
        actionMap.put("generateKey", this.generateKeyAction);
        inputMap.put(this.prefs.getKey("Entry editor, previous entry"), "prev");
        actionMap.put("prev", this.prevEntryAction);
        inputMap.put(this.prefs.getKey("Entry editor, next entry"), "next");
        actionMap.put("next", this.nextEntryAction);
        inputMap.put(this.prefs.getKey("Undo"), "undo");
        actionMap.put("undo", this.undoAction);
        inputMap.put(this.prefs.getKey("Redo"), "redo");
        actionMap.put("redo", this.redoAction);
        inputMap.put(this.prefs.getKey("Help"), "help");
        actionMap.put("help", this.helpAction);
        this.tlb.setFloatable(false);
        this.tlb.add(this.closeAction);
        this.setLabel();
        this.tlb.add(this.typeLabel);
        this.tlb.addSeparator();
        this.tlb.add(this.generateKeyAction);
        this.tlb.addSeparator();
        this.tlb.add(this.deleteAction);
        this.tlb.add(this.prevEntryAction);
        this.tlb.add(this.nextEntryAction);
        this.tlb.addSeparator();
        this.tlb.add(this.helpAction);
        Component[] componentArray = this.tlb.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            ((JComponent)componentArray[i]).setOpaque(false);
        }
        this.add((Component)this.tlb, "West");
    }

    private void setLabel() {
        this.typeLabel = new TypeLabel(this.entry.getType().getName());
    }

    public void rebuildPanels() {
        this.tabbed.removeChangeListener(this.tabListener);
        this.setupFieldPanels();
        this.tabbed.addChangeListener(this.tabListener);
        this.revalidate();
        this.repaint();
    }

    public JComponent getExtra(String string, FieldEditor fieldEditor) {
        final FieldEditor fieldEditor2 = fieldEditor;
        final String string2 = fieldEditor.getFieldName();
        String string3 = BibtexFields.getFieldExtras(string);
        if (string2.equals(Globals.prefs.get("timeStampField")) || string3 != null && string3.equals("datepicker")) {
            ((JTextArea)((Object)fieldEditor2)).addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.getClickCount() == 2) {
                        String string = Util.easyDateFormat();
                        fieldEditor2.setText(string);
                    }
                }
            });
            if (string3 != null && string3.equals("datepicker")) {
                DatePickerButton datePickerButton = new DatePickerButton(fieldEditor2);
                return datePickerButton.getDatePicker();
            }
        }
        if (string3 != null && string3.equals("external")) {
            ((JComponent)((Object)fieldEditor)).addMouseListener(new ExternalViewerListener());
            return null;
        }
        if (string3 != null && string3.equals("journalNames")) {
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            if (this.panel.metaData.getData("selector_" + fieldEditor.getFieldName()) != null) {
                FieldContentSelector fieldContentSelector = new FieldContentSelector(this.frame, this.panel, this.frame, fieldEditor, this.panel.metaData, this.storeFieldAction, false, ", ");
                this.contentSelectors.add(fieldContentSelector);
                jPanel.add((Component)fieldContentSelector, "North");
            }
            jPanel.add((Component)JournalAbbreviations.getNameSwitcher(this, fieldEditor, this.panel.undoManager), "South");
            return jPanel;
        }
        if (this.panel.metaData.getData("selector_" + fieldEditor.getFieldName()) != null) {
            FieldContentSelector fieldContentSelector = new FieldContentSelector(this.frame, this.panel, this.frame, fieldEditor, this.panel.metaData, this.storeFieldAction, false, fieldEditor.getFieldName().equals("author") ? " and " : ", ");
            this.contentSelectors.add(fieldContentSelector);
            return fieldContentSelector;
        }
        if (string3 != null && string3.equals("browse")) {
            JButton jButton = new JButton(Globals.lang("Browse"));
            ((JComponent)((Object)fieldEditor)).addMouseListener(new ExternalViewerListener());
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string;
                    String string22 = fieldEditor2.getText();
                    if (string22.equals("")) {
                        string22 = EntryEditor.this.prefs.get(string2 + "_dir", "");
                    }
                    if ((string = Globals.getNewFile(EntryEditor.this.frame, new File(string22), "." + string2, 0, false)) != null) {
                        File file = new File(string);
                        fieldEditor2.setText(file.getPath());
                        EntryEditor.this.prefs.put(string2 + "_dir", file.getPath());
                        EntryEditor.this.updateField(fieldEditor2);
                    }
                }
            });
            return jButton;
        }
        if (string3 != null && (string3.equals("browseDoc") || string3.equals("browseDocZip"))) {
            String string4 = "." + string2.toLowerCase();
            OpenFileFilter openFileFilter = string3.equals("browseDocZip") ? new OpenFileFilter(new String[]{string4, string4 + ".gz", string4 + ".bz2"}) : new OpenFileFilter(new String[]{string4});
            ExternalFilePanel externalFilePanel = new ExternalFilePanel(this.frame, this.panel.metaData(), this, string2, openFileFilter, fieldEditor2);
            return externalFilePanel;
        }
        if (string3 != null && string3.equals("url")) {
            ((JComponent)((Object)fieldEditor)).setDropTarget(new DropTarget((Component)((Object)fieldEditor), 0, new SimpleUrlDragDrop(fieldEditor, this.storeFieldAction)));
            return null;
        }
        return null;
    }

    private void setupSourcePanel() {
        this.source = new JTextArea(){
            private boolean antialias = Globals.prefs.getBoolean("antialias");

            public void paint(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                if (this.antialias) {
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                }
                super.paint(graphics2D);
            }
        };
        this.source.setEditable(true);
        this.source.setLineWrap(true);
        this.source.setTabSize(4);
        this.source.addFocusListener(new FieldEditorFocusListener());
        this.source.addFocusListener(Globals.focusListener);
        this.source.setFont(new Font("Monospaced", 0, Globals.prefs.getInt("fontSize")));
        this.setupJTextComponent(this.source);
        this.updateSource();
        JScrollPane jScrollPane = new JScrollPane(this.source, 20, 31);
        this.srcPanel.setLayout(new BorderLayout());
        this.srcPanel.add((Component)jScrollPane, "Center");
    }

    public void updateSource() {
        if (this.updateSource) {
            StringWriter stringWriter = new StringWriter(200);
            try {
                this.entry.write(stringWriter, new LatexFieldFormatter(), false);
                String string = stringWriter.getBuffer().toString();
                this.source.setText(string);
                this.lastSourceStringAccepted = string;
            }
            catch (IOException iOException) {
                this.source.setText(iOException.getMessage() + "\n\n" + Globals.lang("Correct the entry, and reopen editor to display/edit source."));
                this.source.setEditable(false);
            }
        }
    }

    public void setupJTextComponent(JTextComponent jTextComponent) {
        InputMap inputMap = jTextComponent.getInputMap(0);
        ActionMap actionMap = jTextComponent.getActionMap();
        inputMap.put(this.prefs.getKey("Entry editor, store field"), "store");
        actionMap.put("store", this.storeFieldAction);
        inputMap.put(this.prefs.getKey("Entry editor, next panel"), "right");
        inputMap.put(this.prefs.getKey("Entry editor, next panel 2"), "right");
        actionMap.put("right", this.switchRightAction);
        inputMap.put(this.prefs.getKey("Entry editor, previous panel"), "left");
        inputMap.put(this.prefs.getKey("Entry editor, previous panel 2"), "left");
        actionMap.put("left", this.switchLeftAction);
        inputMap.put(this.prefs.getKey("Help"), "help");
        actionMap.put("help", this.helpAction);
        inputMap.put(this.prefs.getKey("Save database"), "save");
        actionMap.put("save", this.saveDatabaseAction);
        inputMap.put(Globals.prefs.getKey("Next tab"), "nexttab");
        actionMap.put("nexttab", this.frame.nextTab);
        inputMap.put(Globals.prefs.getKey("Previous tab"), "prevtab");
        actionMap.put("prevtab", this.frame.prevTab);
        try {
            HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(jTextComponent.getFocusTraversalKeys(0));
            hashSet.clear();
            hashSet.add(AWTKeyStroke.getAWTKeyStroke("pressed TAB"));
            jTextComponent.setFocusTraversalKeys(0, hashSet);
            hashSet = new HashSet<AWTKeyStroke>(jTextComponent.getFocusTraversalKeys(1));
            hashSet.clear();
            hashSet.add(KeyStroke.getKeyStroke("shift pressed TAB"));
            jTextComponent.setFocusTraversalKeys(1, hashSet);
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
        }
        jTextComponent.addFocusListener(new FieldListener());
    }

    public void requestFocus() {
        this.activateVisible();
    }

    private void activateVisible() {
        Object e = this.tabs.get(this.tabbed.getSelectedIndex());
        if (e instanceof EntryEditorTab) {
            ((EntryEditorTab)e).activate();
        } else {
            new FocusRequester(this.source);
        }
    }

    public boolean isEnabled() {
        return this.source.isEnabled();
    }

    public void setEnabled(boolean bl) {
        Iterator iterator = this.tabs.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof EntryEditorTab)) continue;
            ((EntryEditorTab)e).setEnabled(bl);
        }
        this.source.setEnabled(bl);
    }

    private void scrollTo(int n) {
        this.panel.mainTable.setRowSelectionInterval(n, n);
        this.panel.mainTable.ensureVisible(n);
    }

    public void storeCurrentEdit() {
        JComponent jComponent = Globals.focusListener.getFocused();
        if (jComponent instanceof FieldEditor && this.isAncestorOf(jComponent)) {
            this.storeFieldAction.actionPerformed(new ActionEvent(jComponent, 0, ""));
        }
    }

    public int getVisiblePanel() {
        return this.tabbed.getSelectedIndex();
    }

    public String getVisiblePanelName() {
        return this.tabbed.getSelectedComponent().getName();
    }

    public void setVisiblePanel(int n) {
        this.tabbed.setSelectedIndex(Math.min(n, this.tabbed.getTabCount() - 1));
    }

    public void setVisiblePanel(String string) {
        for (int i = 0; i < this.tabbed.getTabCount(); ++i) {
            if (!string.equals(this.tabbed.getComponent(i).getName())) continue;
            this.tabbed.setSelectedIndex(i);
            return;
        }
        if (this.tabbed.getTabCount() > 0) {
            this.tabbed.setSelectedIndex(0);
        }
    }

    public synchronized void switchTo(BibtexEntry bibtexEntry) {
        if (this.entry == bibtexEntry) {
            return;
        }
        this.storeCurrentEdit();
        this.entry.removePropertyChangeListener(this);
        bibtexEntry.addPropertyChangeListener(this);
        this.entry = bibtexEntry;
        this.updateAllFields();
        this.validateAllFields();
        this.updateSource();
        this.panel.showing = bibtexEntry;
    }

    public boolean lastSourceAccepted() {
        if (this.tabbed.getSelectedComponent() == this.srcPanel) {
            this.storeSource(false);
        }
        return this.lastSourceAccepted;
    }

    public boolean storeSource(boolean bl) {
        BibtexParser bibtexParser = new BibtexParser(new StringReader(this.source.getText()));
        try {
            int n;
            boolean bl2;
            BibtexDatabase bibtexDatabase = bibtexParser.parse().getDatabase();
            if (bibtexDatabase.getEntryCount() > 1) {
                throw new Exception("More than one entry found.");
            }
            if (bibtexDatabase.getEntryCount() < 1) {
                throw new Exception("No entries found.");
            }
            NamedCompound namedCompound = new NamedCompound(Globals.lang("source edit"));
            BibtexEntry bibtexEntry = bibtexDatabase.getEntryById((String)bibtexDatabase.getKeySet().iterator().next());
            String string = this.entry.getId();
            String string2 = bibtexEntry.getCiteKey();
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = bl2 = string2 == null || string2.equals("");
            if (this.panel.database.setCiteKeyForEntry(string, string2)) {
                bl4 = true;
            }
            Object[] objectArray = this.entry.getAllFields();
            for (n = 0; n < objectArray.length; ++n) {
                if (!BibtexFields.isDisplayableField(objectArray[n].toString()) || bibtexEntry.getField(objectArray[n].toString()) != null) continue;
                namedCompound.addEdit(new UndoableFieldChange(this.entry, objectArray[n].toString(), this.entry.getField(objectArray[n].toString()), null));
                this.entry.clearField(objectArray[n].toString());
                bl3 = true;
            }
            objectArray = bibtexEntry.getAllFields();
            for (n = 0; n < objectArray.length; ++n) {
                if (this.entry.getField(objectArray[n].toString()) == bibtexEntry.getField(objectArray[n].toString())) continue;
                String string3 = (String)bibtexEntry.getField(objectArray[n].toString());
                new LatexFieldFormatter().format(string3, objectArray[n].toString());
                namedCompound.addEdit(new UndoableFieldChange(this.entry, objectArray[n].toString(), this.entry.getField(objectArray[n].toString()), string3));
                this.entry.setField(objectArray[n].toString(), string3);
                bl3 = true;
            }
            namedCompound.end();
            if (!bl3) {
                return true;
            }
            this.panel.undoManager.addEdit(namedCompound);
            if (bl4) {
                this.warnDuplicateBibtexkey();
            } else if (bl2 && bl) {
                this.warnEmptyBibtexkey();
            } else {
                this.panel.output(Globals.lang("Stored entry") + ".");
            }
            this.lastSourceStringAccepted = this.source.getText();
            this.updateAllFields();
            this.lastSourceAccepted = true;
            this.updateSource = true;
            this.panel.markBaseChanged();
            return true;
        }
        catch (Throwable throwable) {
            this.updateSource = false;
            this.lastSourceAccepted = false;
            this.tabbed.setSelectedComponent(this.srcPanel);
            if (bl) {
                Object[] objectArray = new Object[]{Globals.lang("Edit"), Globals.lang("Revert to original source")};
                int n = JOptionPane.showOptionDialog(this.frame, "Error: " + throwable.getMessage(), Globals.lang("Problem with parsing entry"), 0, 0, null, objectArray, objectArray[0]);
                if (n != 0) {
                    this.updateSource = true;
                    this.updateSource();
                }
            }
            return false;
        }
    }

    public void setField(String string, String string2) {
        Iterator iterator = this.tabs.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof EntryEditorTab)) continue;
            ((EntryEditorTab)e).updateField(string, string2);
        }
    }

    public void updateAllFields() {
        Iterator iterator = this.tabs.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof EntryEditorTab)) continue;
            ((EntryEditorTab)e).setEntry(this.entry);
        }
    }

    public void validateAllFields() {
        Iterator iterator = this.tabs.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof EntryEditorTab)) continue;
            ((EntryEditorTab)e).validateAllFields();
        }
    }

    public void updateAllContentSelectors() {
        if (this.contentSelectors.size() > 0) {
            Iterator iterator = this.contentSelectors.iterator();
            while (iterator.hasNext()) {
                ((FieldContentSelector)iterator.next()).rebuildComboBox();
            }
        }
    }

    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getNewValue() != null ? propertyChangeEvent.getNewValue().toString() : "";
        this.setField(propertyChangeEvent.getPropertyName(), string);
    }

    public void updateField(Object object) {
        this.storeFieldAction.actionPerformed(new ActionEvent(object, 0, ""));
    }

    private boolean containedInExplicitGroup(BibtexEntry bibtexEntry) {
        AbstractGroup[] abstractGroupArray = this.panel.getGroupSelector().getGroupTreeRoot().getMatchingGroups(bibtexEntry);
        for (int i = 0; i < abstractGroupArray.length; ++i) {
            if (!(abstractGroupArray[i] instanceof ExplicitGroup)) continue;
            return true;
        }
        return false;
    }

    private void warnDuplicateBibtexkey() {
        this.panel.output(Globals.lang("Warning") + ": " + Globals.lang("Duplicate BibTeX key."));
        if (this.prefs.getBoolean("dialogWarningForDuplicateKey")) {
            CheckBoxMessage checkBoxMessage = new CheckBoxMessage(Globals.lang("Warning") + ": " + Globals.lang("Duplicate BibTeX key. Grouping may not work for this entry."), Globals.lang("Disable this warning dialog"), false);
            JOptionPane.showMessageDialog(this.frame, checkBoxMessage, Globals.lang("Warning"), 2);
            if (checkBoxMessage.isSelected()) {
                this.prefs.putBoolean("dialogWarningForDuplicateKey", false);
            }
        }
    }

    private void warnEmptyBibtexkey() {
        this.panel.output(Globals.lang("Warning") + ": " + Globals.lang("Empty BibTeX key."));
        if (this.prefs.getBoolean("dialogWarningForEmptyKey")) {
            CheckBoxMessage checkBoxMessage = new CheckBoxMessage(Globals.lang("Warning") + ": " + Globals.lang("Empty BibTeX key. Grouping may not work for this entry."), Globals.lang("Disable this warning dialog"), false);
            JOptionPane.showMessageDialog(this.frame, checkBoxMessage, Globals.lang("Warning"), 2);
            if (checkBoxMessage.isSelected()) {
                this.prefs.putBoolean("dialogWarningForEmptyKey", false);
            }
        }
    }

    class ChangeTypeAction
    extends AbstractAction {
        BibtexEntryType type;
        BasePanel panel;

        public ChangeTypeAction(BibtexEntryType bibtexEntryType, BasePanel basePanel) {
            super(bibtexEntryType.getName());
            this.type = bibtexEntryType;
            this.panel = basePanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.panel.changeType(EntryEditor.this.entry, this.type);
        }
    }

    class ExternalViewerListener
    extends MouseAdapter {
        ExternalViewerListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                FieldTextArea fieldTextArea = (FieldTextArea)mouseEvent.getSource();
                if (fieldTextArea.getText().equals("")) {
                    return;
                }
                fieldTextArea.selectAll();
                String string = fieldTextArea.getText();
                try {
                    Util.openExternalViewer(EntryEditor.this.panel.metaData(), string, fieldTextArea.getFieldName());
                }
                catch (IOException iOException) {
                    System.err.println("Error opening file.");
                }
            }
        }
    }

    class SaveDatabaseAction
    extends AbstractAction {
        public SaveDatabaseAction() {
            super("Save database");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object e = EntryEditor.this.tabs.get(EntryEditor.this.tabbed.getSelectedIndex());
            if (e instanceof EntryEditorTab) {
                EntryEditorTab entryEditorTab = (EntryEditorTab)e;
                EntryEditor.this.updateField(entryEditorTab.getActive());
            } else {
                EntryEditor.this.updateField(e);
            }
            try {
                EntryEditor.this.panel.runCommand("save");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Undo", GUIGlobals.getImage("redo"));
            this.putValue("ShortDescription", "Redo");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                EntryEditor.this.panel.runCommand("redo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo", GUIGlobals.getImage("undo"));
            this.putValue("ShortDescription", "Undo");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                EntryEditor.this.panel.runCommand("undo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class GenerateKeyAction
    extends AbstractAction {
        JabRefFrame parent;
        BibtexEntry selectedEntry;

        public GenerateKeyAction(JabRefFrame jabRefFrame) {
            super(Globals.lang("Generate BibTeX key"), GUIGlobals.getImage("makeKey"));
            this.parent = jabRefFrame;
            this.putValue("ShortDescription", Globals.lang("Generate BibTeX key"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                Object object = EntryEditor.this.entry.getField("bibtexkey");
                LabelPatternUtil.makeLabel(EntryEditor.this.prefs.getKeyPattern(), EntryEditor.this.panel.database, EntryEditor.this.entry);
                EntryEditor.this.panel.undoManager.addEdit(new UndoableKeyChange(EntryEditor.this.panel.database, EntryEditor.this.entry.getId(), (String)object, (String)EntryEditor.this.entry.getField("bibtexkey")));
                String string = (String)EntryEditor.this.entry.getField("bibtexkey");
                EntryEditor.this.setField("bibtexkey", string);
                EntryEditor.this.updateSource();
                EntryEditor.this.panel.markBaseChanged();
            }
            catch (Throwable throwable) {
                System.err.println("error setting key: " + throwable);
            }
        }
    }

    class PrevEntryAction
    extends AbstractAction {
        public PrevEntryAction() {
            super(Globals.lang("Previous entry"), GUIGlobals.getImage("up"));
            this.putValue("ShortDescription", Globals.lang("Previous entry"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = EntryEditor.this.panel.mainTable.findEntry(EntryEditor.this.entry);
            int n2 = -1;
            if (n - 1 >= 0) {
                n2 = n - 1;
            } else if (n != EntryEditor.this.panel.database.getEntryCount() - 1) {
                n2 = EntryEditor.this.panel.database.getEntryCount() - 1;
            } else {
                return;
            }
            EntryEditor.this.scrollTo(n2);
            EntryEditor.this.panel.mainTable.setRowSelectionInterval(n2, n2);
        }
    }

    class NextEntryAction
    extends AbstractAction {
        public NextEntryAction() {
            super(Globals.lang("Next entry"), GUIGlobals.getImage("down"));
            this.putValue("ShortDescription", Globals.lang("Next entry"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = EntryEditor.this.panel.mainTable.findEntry(EntryEditor.this.entry);
            int n2 = -1;
            if (n + 1 < EntryEditor.this.panel.database.getEntryCount()) {
                n2 = n + 1;
            } else if (n > 0) {
                n2 = 0;
            } else {
                return;
            }
            EntryEditor.this.scrollTo(n2);
            EntryEditor.this.panel.mainTable.setRowSelectionInterval(n2, n2);
        }
    }

    class SwitchRightAction
    extends AbstractAction {
        public SwitchRightAction() {
            super("Switch to the panel to the right");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = EntryEditor.this.tabbed.getSelectedIndex();
            EntryEditor.this.tabbed.setSelectedIndex(n < EntryEditor.this.tabbed.getTabCount() - 1 ? n + 1 : 0);
            EntryEditor.this.activateVisible();
        }
    }

    class SwitchLeftAction
    extends AbstractAction {
        public SwitchLeftAction() {
            super("Switch to the panel to the left");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = EntryEditor.this.tabbed.getSelectedIndex();
            EntryEditor.this.tabbed.setSelectedIndex(n > 0 ? n - 1 : EntryEditor.this.tabbed.getTabCount() - 1);
            EntryEditor.this.activateVisible();
        }
    }

    public class StoreFieldAction
    extends AbstractAction {
        public StoreFieldAction() {
            super("Store field value");
            this.putValue("ShortDescription", "Store field value");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            if (actionEvent.getSource() instanceof FieldTextArea) {
                String string = null;
                FieldEditor fieldEditor = (FieldEditor)actionEvent.getSource();
                String string2 = fieldEditor.getText();
                String string3 = string2.trim();
                if (string3.length() > 0) {
                    string = string3;
                }
                boolean bl2 = string == null ? EntryEditor.this.entry.getField(fieldEditor.getFieldName()) != null : EntryEditor.this.entry.getField(fieldEditor.getFieldName()) == null || !string.equals(EntryEditor.this.entry.getField(fieldEditor.getFieldName()).toString());
                if (bl2) {
                    try {
                        if (string != null) {
                            new LatexFieldFormatter().format(string, fieldEditor.getFieldName());
                        }
                        Object object = EntryEditor.this.entry.getField(fieldEditor.getFieldName());
                        if (string != null) {
                            EntryEditor.this.entry.setField(fieldEditor.getFieldName(), string);
                        } else {
                            EntryEditor.this.entry.clearField(fieldEditor.getFieldName());
                        }
                        if (string != null && string.length() > 0) {
                            fieldEditor.setBackground(GUIGlobals.validFieldBackground);
                        } else {
                            fieldEditor.setBackground(GUIGlobals.validFieldBackground);
                        }
                        EntryEditor.this.panel.undoManager.addEdit(new UndoableFieldChange(EntryEditor.this.entry, fieldEditor.getFieldName(), object, string));
                        EntryEditor.this.updateSource();
                        EntryEditor.this.panel.markBaseChanged();
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                ((StoreFieldAction)StoreFieldAction.this).EntryEditor.this.panel.highlightEntry(EntryEditor.this.entry);
                            }
                        });
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        JOptionPane.showMessageDialog(EntryEditor.this.frame, "Error: " + illegalArgumentException.getMessage(), Globals.lang("Error setting field"), 0);
                        fieldEditor.setBackground(GUIGlobals.invalidFieldBackground);
                    }
                } else {
                    fieldEditor.setBackground(GUIGlobals.validFieldBackground);
                }
            } else if (actionEvent.getSource() instanceof FieldTextField) {
                FieldTextField fieldTextField = (FieldTextField)actionEvent.getSource();
                String string = EntryEditor.this.entry.getCiteKey();
                String string4 = fieldTextField.getText();
                if (string4.equals("")) {
                    string4 = null;
                }
                if (string == null && string4 == null || string != null && string4 != null && string.equals(string4)) {
                    return;
                }
                String string5 = Util.checkLegalKey(string4);
                if (string5 != null && !string5.equals(string4)) {
                    JOptionPane.showMessageDialog(EntryEditor.this.frame, Globals.lang("Invalid BibTeX key"), Globals.lang("Error setting field"), 0);
                    fieldTextField.setBackground(GUIGlobals.invalidFieldBackground);
                    return;
                }
                fieldTextField.setBackground(GUIGlobals.validFieldBackground);
                boolean bl3 = EntryEditor.this.panel.database.setCiteKeyForEntry(EntryEditor.this.entry.getId(), string4);
                if (string4 != null) {
                    if (bl3) {
                        EntryEditor.this.warnDuplicateBibtexkey();
                    } else {
                        EntryEditor.this.panel.output(Globals.lang("BibTeX key is unique."));
                    }
                } else {
                    EntryEditor.this.warnEmptyBibtexkey();
                }
                EntryEditor.this.panel.undoManager.addEdit(new UndoableKeyChange(EntryEditor.this.panel.database, EntryEditor.this.entry.getId(), string, string4));
                if (string4 != null && string4.length() > 0) {
                    fieldTextField.setBackground(GUIGlobals.validFieldBackground);
                } else {
                    fieldTextField.setBackground(GUIGlobals.validFieldBackground);
                }
                EntryEditor.this.updateSource();
                EntryEditor.this.panel.markBaseChanged();
            } else if (!EntryEditor.this.source.isEditable() || EntryEditor.this.source.getText().equals(EntryEditor.this.lastSourceStringAccepted) || (bl = EntryEditor.this.storeSource(true))) {
                // empty if block
            }
        }
    }

    class CopyKeyAction
    extends AbstractAction {
        public CopyKeyAction() {
            super("Copy BibTeX key to clipboard");
            this.putValue("ShortDescription", "Copy BibTeX key to clipboard (Ctrl-K)");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)EntryEditor.this.entry.getField("bibtexkey");
            StringSelection stringSelection = new StringSelection(string);
            if (string != null) {
                Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Globals.lang("Close window"), GUIGlobals.getImage("close"));
            this.putValue("ShortDescription", Globals.lang("Close window"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (EntryEditor.this.tabbed.getSelectedComponent() == EntryEditor.this.srcPanel) {
                EntryEditor.this.updateField(EntryEditor.this.source);
                if (EntryEditor.this.lastSourceAccepted) {
                    EntryEditor.this.panel.entryEditorClosing(EntryEditor.this);
                }
            } else {
                EntryEditor.this.panel.entryEditorClosing(EntryEditor.this);
            }
        }
    }

    class DeleteAction
    extends AbstractAction {
        public DeleteAction() {
            super(Globals.lang("Delete"), GUIGlobals.getImage("delete"));
            this.putValue("ShortDescription", Globals.lang("Delete entry"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = EntryEditor.this.panel.showDeleteConfirmationDialog(1);
            if (!bl) {
                return;
            }
            EntryEditor.this.panel.entryEditorClosing(EntryEditor.this);
            EntryEditor.this.panel.database.removeEntry(EntryEditor.this.entry.getId());
            EntryEditor.this.panel.markBaseChanged();
            EntryEditor.this.panel.undoManager.addEdit(new UndoableRemoveEntry(EntryEditor.this.panel.database, EntryEditor.this.entry, EntryEditor.this.panel));
            EntryEditor.this.panel.output(Globals.lang("Deleted") + " " + Globals.lang("entry"));
        }
    }

    class TabListener
    implements ChangeListener {
        TabListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EntryEditor.this.activateVisible();
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Object e = ((TabListener)TabListener.this).EntryEditor.this.tabs.get(((TabListener)TabListener.this).EntryEditor.this.tabbed.getSelectedIndex());
                    if (e instanceof EntryEditorTab) {
                        ((EntryEditorTab)e).updateAll();
                    }
                }
            });
        }
    }

    class FieldListener
    extends FocusAdapter {
        FieldListener() {
        }

        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
            if (!focusEvent.isTemporary()) {
                EntryEditor.this.updateField(focusEvent.getSource());
            }
        }
    }

    private class TypeLabel
    extends JPanel {
        private String label;

        public TypeLabel(String string) {
            this.label = string;
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    boolean bl = ((TypeLabel)TypeLabel.this).EntryEditor.this.prefs.getBoolean("ctrlClick");
                    if (mouseEvent.getButton() == 3 || bl && mouseEvent.getButton() == 1 && mouseEvent.isControlDown()) {
                        JPopupMenu jPopupMenu = new JPopupMenu();
                        Iterator iterator = BibtexEntryType.ALL_TYPES.keySet().iterator();
                        while (iterator.hasNext()) {
                            jPopupMenu.add(new ChangeTypeAction(BibtexEntryType.getType((String)iterator.next()), ((TypeLabel)TypeLabel.this).EntryEditor.this.panel));
                        }
                        jPopupMenu.show(((TypeLabel)TypeLabel.this).EntryEditor.this.ths, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setColor(GUIGlobals.validFieldColor);
            graphics2D.setFont(GUIGlobals.typeNameFont);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int n = fontMetrics.stringWidth(this.label);
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.rotate(-1.5707963267948966, 0.0, 0.0);
            graphics2D.drawString(this.label, -n - 7, 28);
        }
    }
}

