/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldTextArea;
import net.sf.jabref.FieldTextField;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;

public class EntryEditorTab {
    private JPanel panel = new JPanel();
    private String[] fields;
    private EntryEditor parent;
    private HashMap editors = new HashMap();
    private FieldEditor activeField = null;
    private Component firstComponent;
    BibtexEntry entry;
    protected boolean updating = false;
    FocusListener fieldListener = new FocusListener(){
        JTextComponent c;
        DocumentListener d;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void focusGained(FocusEvent focusEvent) {
            1 var2_2 = this;
            synchronized (var2_2) {
                if (this.c != null) {
                    this.c.getDocument().removeDocumentListener(this.d);
                    this.c = null;
                    this.d = null;
                }
                if (focusEvent.getSource() instanceof JTextComponent) {
                    this.c = (JTextComponent)focusEvent.getSource();
                    this.d = new DocumentListener(){

                        void fire(DocumentEvent documentEvent) {
                            if (c.isFocusOwner()) {
                                EntryEditorTab.this.markIfModified((FieldEditor)((Object)c));
                            }
                        }

                        public void changedUpdate(DocumentEvent documentEvent) {
                            this.fire(documentEvent);
                        }

                        public void insertUpdate(DocumentEvent documentEvent) {
                            this.fire(documentEvent);
                        }

                        public void removeUpdate(DocumentEvent documentEvent) {
                            this.fire(documentEvent);
                        }
                    };
                    this.c.getDocument().addDocumentListener(this.d);
                }
            }
            EntryEditorTab.this.setActive((FieldEditor)focusEvent.getSource());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void focusLost(FocusEvent focusEvent) {
            1 var2_2 = this;
            synchronized (var2_2) {
                if (this.c != null) {
                    this.c.getDocument().removeDocumentListener(this.d);
                    this.c = null;
                    this.d = null;
                }
            }
            if (!focusEvent.isTemporary()) {
                EntryEditorTab.this.parent.updateField((FieldEditor)focusEvent.getSource());
            }
        }
    };

    public EntryEditorTab(List list, EntryEditor entryEditor, boolean bl, String string) {
        this.fields = list != null ? list.toArray(new String[0]) : new String[0];
        this.parent = entryEditor;
        this.newSetupPanel(bl, string);
        this.panel.setFocusCycleRoot(true);
    }

    void newSetupPanel(boolean bl, String string) {
        InputMap inputMap = this.panel.getInputMap(0);
        ActionMap actionMap = this.panel.getActionMap();
        inputMap.put(Globals.prefs.getKey("Entry editor, previous entry"), "prev");
        actionMap.put("prev", this.parent.prevEntryAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, next entry"), "next");
        actionMap.put("next", this.parent.nextEntryAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, store field"), "store");
        actionMap.put("store", this.parent.storeFieldAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, next panel"), "right");
        inputMap.put(Globals.prefs.getKey("Entry editor, next panel 2"), "right");
        actionMap.put("left", this.parent.switchLeftAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, previous panel"), "left");
        inputMap.put(Globals.prefs.getKey("Entry editor, previous panel 2"), "left");
        actionMap.put("right", this.parent.switchRightAction);
        inputMap.put(Globals.prefs.getKey("Help"), "help");
        actionMap.put("help", this.parent.helpAction);
        inputMap.put(Globals.prefs.getKey("Save database"), "save");
        actionMap.put("save", this.parent.saveDatabaseAction);
        inputMap.put(Globals.prefs.getKey("Next tab"), "nexttab");
        actionMap.put("nexttab", this.parent.frame.nextTab);
        inputMap.put(Globals.prefs.getKey("Previous tab"), "prevtab");
        actionMap.put("prevtab", this.parent.frame.prevTab);
        this.panel.setName(string);
        String string2 = "fill:pref, 1dlu, fill:pref:grow, 1dlu, fill:pref";
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.fields.length; ++i) {
            stringBuffer.append("fill:pref:grow, ");
        }
        if (bl) {
            stringBuffer.append("4dlu, fill:pref");
        } else {
            stringBuffer.delete(stringBuffer.length() - 2, stringBuffer.length());
        }
        String string3 = stringBuffer.toString();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(this.panel, new FormLayout(string2, string3));
        for (int i = 0; i < this.fields.length; ++i) {
            FieldTextArea fieldTextArea = new FieldTextArea(this.fields[i], null);
            JComponent jComponent = this.parent.getExtra(this.fields[i], fieldTextArea);
            this.setupJTextComponent(fieldTextArea);
            this.editors.put(this.fields[i], fieldTextArea);
            if (i == 0) {
                this.activeField = fieldTextArea;
            }
            fieldTextArea.getPane().setPreferredSize(new Dimension(100, (int)(50.0 * BibtexFields.getFieldWeight(this.fields[i]))));
            defaultFormBuilder.append(fieldTextArea.getLabel());
            if (jComponent == null) {
                defaultFormBuilder.append((Component)fieldTextArea.getPane(), 3);
            } else {
                defaultFormBuilder.append(fieldTextArea.getPane());
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add((Component)jComponent, "North");
                defaultFormBuilder.append(jPanel);
            }
            defaultFormBuilder.nextLine();
        }
        if (bl) {
            FieldTextField fieldTextField = new FieldTextField("bibtexkey", (String)this.parent.getEntry().getField("bibtexkey"), true);
            this.setupJTextComponent(fieldTextField);
            this.editors.put("bibtexkey", fieldTextField);
            if (this.editors.size() == 1) {
                this.activeField = fieldTextField;
            }
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(fieldTextField.getLabel());
            defaultFormBuilder.append((Component)fieldTextField, 3);
        }
    }

    void setupPanel(boolean bl, String string) {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.panel.setLayout(gridBagLayout);
        double d = 0.0;
        for (int i = 0; i < this.fields.length; ++i) {
            FieldTextArea fieldTextArea = new FieldTextArea(this.fields[i], null);
            JComponent jComponent = this.parent.getExtra(this.fields[i], fieldTextArea);
            if (this.firstComponent == null) {
                this.firstComponent = jComponent;
            }
            this.setupJTextComponent(fieldTextArea);
            this.editors.put(this.fields[i], fieldTextArea);
            if (i == 0) {
                this.activeField = fieldTextArea;
            }
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 1;
            gridBagLayout.setConstraints(fieldTextArea.getLabel(), gridBagConstraints);
            this.panel.add(fieldTextArea.getLabel());
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = BibtexFields.getFieldWeight(this.fields[i]);
            d += gridBagConstraints.weighty;
            gridBagConstraints.gridwidth = jComponent != null ? 1 : 0;
            gridBagLayout.setConstraints(fieldTextArea.getPane(), gridBagConstraints);
            this.panel.add(fieldTextArea.getPane());
            if (jComponent != null) {
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.anchor = 11;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 0.0;
                gridBagLayout.setConstraints(jComponent, gridBagConstraints);
                this.panel.add(jComponent);
            }
            this.panel.setName(string);
        }
        if (bl) {
            gridBagConstraints.insets.top += 25;
            gridBagConstraints.insets.bottom = 10;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 16;
            FieldTextField fieldTextField = new FieldTextField("bibtexkey", (String)this.parent.getEntry().getField("bibtexkey"), true);
            this.setupJTextComponent(fieldTextField);
            this.editors.put("bibtexkey", fieldTextField);
            if (this.editors.size() == 1) {
                this.activeField = fieldTextField;
            }
            gridBagLayout.setConstraints(fieldTextField.getLabel(), gridBagConstraints);
            this.panel.add(fieldTextField.getLabel());
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagLayout.setConstraints(fieldTextField, gridBagConstraints);
            this.panel.add(fieldTextField);
        }
    }

    public BibtexEntry getEntry() {
        return this.entry;
    }

    boolean isFieldModified(FieldEditor fieldEditor) {
        String string = fieldEditor.getText().trim();
        if (string.length() == 0) {
            return this.getEntry().getField(fieldEditor.getFieldName()) != null;
        }
        Object object = this.getEntry().getField(fieldEditor.getFieldName());
        return object == null || !object.toString().equals(string);
    }

    public void markIfModified(FieldEditor fieldEditor) {
        if (!this.updating && !this.parent.panel.isBaseChanged() && this.isFieldModified(fieldEditor)) {
            this.markBaseChanged();
        }
    }

    void markBaseChanged() {
        this.parent.panel.markBaseChanged();
    }

    public void setActive(FieldEditor fieldEditor) {
        this.activeField = fieldEditor;
    }

    public FieldEditor getActive() {
        return this.activeField;
    }

    public List getFields() {
        return Arrays.asList(this.fields);
    }

    public void activate() {
        if (this.activeField != null) {
            new FocusRequester(this.activeField.getTextComponent());
        }
    }

    public void updateAll() {
        this.setEntry(this.getEntry());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEntry(BibtexEntry bibtexEntry) {
        try {
            this.updating = true;
            Iterator iterator = this.editors.values().iterator();
            while (iterator.hasNext()) {
                FieldEditor fieldEditor;
                Object object = bibtexEntry.getField((fieldEditor = (FieldEditor)iterator.next()).getFieldName());
                fieldEditor.setText(object == null ? "" : object.toString());
            }
            this.entry = bibtexEntry;
        }
        finally {
            this.updating = false;
        }
    }

    public boolean updateField(String string, String string2) {
        if (!this.editors.containsKey(string)) {
            return false;
        }
        FieldEditor fieldEditor = (FieldEditor)this.editors.get(string);
        fieldEditor.setText(string2);
        return true;
    }

    public void validateAllFields() {
        Iterator iterator = this.editors.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            FieldEditor fieldEditor = (FieldEditor)this.editors.get(string);
            fieldEditor.setEnabled(true);
            if (((Component)((Object)fieldEditor)).hasFocus()) {
                fieldEditor.setBackground(GUIGlobals.activeEditor);
                continue;
            }
            fieldEditor.setBackground(GUIGlobals.validFieldBackground);
        }
    }

    public void setEnabled(boolean bl) {
        Iterator iterator = this.editors.values().iterator();
        while (iterator.hasNext()) {
            FieldEditor fieldEditor = (FieldEditor)iterator.next();
            fieldEditor.setEnabled(bl);
        }
    }

    public Component getPane() {
        return this.panel;
    }

    public void setupJTextComponent(JTextComponent jTextComponent) {
        jTextComponent.addFocusListener(this.fieldListener);
        InputMap inputMap = jTextComponent.getInputMap(0);
        ActionMap actionMap = jTextComponent.getActionMap();
        inputMap.put(Globals.prefs.getKey("Entry editor, previous entry"), "prev");
        actionMap.put("prev", this.parent.prevEntryAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, next entry"), "next");
        actionMap.put("next", this.parent.nextEntryAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, store field"), "store");
        actionMap.put("store", this.parent.storeFieldAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, next panel"), "right");
        inputMap.put(Globals.prefs.getKey("Entry editor, next panel 2"), "right");
        actionMap.put("left", this.parent.switchLeftAction);
        inputMap.put(Globals.prefs.getKey("Entry editor, previous panel"), "left");
        inputMap.put(Globals.prefs.getKey("Entry editor, previous panel 2"), "left");
        actionMap.put("right", this.parent.switchRightAction);
        inputMap.put(Globals.prefs.getKey("Help"), "help");
        actionMap.put("help", this.parent.helpAction);
        inputMap.put(Globals.prefs.getKey("Save database"), "save");
        actionMap.put("save", this.parent.saveDatabaseAction);
        inputMap.put(Globals.prefs.getKey("Next tab"), "nexttab");
        actionMap.put("nexttab", this.parent.frame.nextTab);
        inputMap.put(Globals.prefs.getKey("Previous tab"), "prevtab");
        actionMap.put("prevtab", this.parent.frame.prevTab);
        try {
            HashSet<AWTKeyStroke> hashSet = new HashSet<AWTKeyStroke>(jTextComponent.getFocusTraversalKeys(0));
            hashSet.clear();
            hashSet.add(AWTKeyStroke.getAWTKeyStroke("pressed TAB"));
            jTextComponent.setFocusTraversalKeys(0, hashSet);
            hashSet = new HashSet<AWTKeyStroke>(jTextComponent.getFocusTraversalKeys(1));
            hashSet.clear();
            hashSet.add(KeyStroke.getKeyStroke("shift pressed TAB"));
            jTextComponent.setFocusTraversalKeys(1, hashSet);
        }
        catch (Throwable throwable) {
            System.err.println(throwable);
        }
    }
}

