/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.HelpDialog;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;

public class ExternalTab
extends JPanel
implements PrefsTab {
    JabRefPreferences _prefs;
    JabRefFrame _frame;
    JTextField pdfDir;
    JTextField regExpTextField;
    JTextField psDir;
    JTextField pdf;
    JTextField ps;
    JTextField html;
    JTextField lyx;
    JTextField winEdt;
    JTextField citeCommand;
    ItemListener regExpListener;
    JCheckBox useRegExpComboBox;

    public ExternalTab(JabRefFrame jabRefFrame, JabRefPreferences jabRefPreferences, HelpDialog helpDialog) {
        this._prefs = jabRefPreferences;
        this._frame = jabRefFrame;
        this.setLayout(new BorderLayout());
        this.psDir = new JTextField(30);
        this.pdfDir = new JTextField(30);
        this.pdf = new JTextField(30);
        this.ps = new JTextField(30);
        this.html = new JTextField(30);
        this.lyx = new JTextField(30);
        this.winEdt = new JTextField(30);
        this.citeCommand = new JTextField(30);
        this.regExpTextField = new JTextField(30);
        this.useRegExpComboBox = new JCheckBox(Globals.lang("Use Regular Expression Search"));
        this.regExpListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                ExternalTab.this.regExpTextField.setEditable(ExternalTab.this.useRegExpComboBox.isSelected());
                if (ExternalTab.this.useRegExpComboBox.isSelected()) {
                    ExternalTab.this.regExpTextField.setText(Globals.prefs.get("regExpSearchExpression"));
                } else {
                    Globals.prefs.put("regExpSearchExpression", ExternalTab.this.regExpTextField.getText());
                    ExternalTab.this.regExpTextField.setText(Globals.prefs.get("defaultRegExpSearchExpression"));
                }
            }
        };
        this.useRegExpComboBox.addItemListener(this.regExpListener);
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:200dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.appendSeparator(Globals.lang("PDF and PS links"));
        JPanel jPanel = new JPanel();
        defaultFormBuilder.append(jPanel);
        JLabel jLabel = new JLabel(Globals.lang("Main PDF directory") + ":");
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.append(this.pdfDir);
        BrowseAction browseAction = new BrowseAction(this._frame, this.pdfDir, true);
        defaultFormBuilder.append(new JButton(browseAction));
        defaultFormBuilder.nextLine();
        jPanel = new JPanel();
        defaultFormBuilder.append(jPanel);
        jLabel = new JLabel(Globals.lang("Main PS directory") + ":");
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.append(this.psDir);
        browseAction = new BrowseAction(this._frame, this.psDir, true);
        defaultFormBuilder.append(new JButton(browseAction));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append(this.useRegExpComboBox);
        defaultFormBuilder.append(this.regExpTextField);
        HelpAction helpAction = new HelpAction(helpDialog, GUIGlobals.regularExpressionSearchHelp, Globals.lang("Help on Regular Expression Search"), GUIGlobals.getIconUrl("helpSmall"));
        defaultFormBuilder.append(helpAction.getIconButton());
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("External programs"));
        defaultFormBuilder.nextLine();
        jLabel = new JLabel(Globals.lang("Path to PDF viewer") + ":");
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.append(this.pdf);
        browseAction = new BrowseAction(this._frame, this.pdf, false);
        if (Globals.ON_WIN) {
            browseAction.setEnabled(false);
        }
        defaultFormBuilder.append(new JButton(browseAction));
        defaultFormBuilder.nextLine();
        jLabel = new JLabel(Globals.lang("Path to PS viewer") + ":");
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.append(this.ps);
        browseAction = new BrowseAction(this._frame, this.ps, false);
        if (Globals.ON_WIN) {
            browseAction.setEnabled(false);
        }
        defaultFormBuilder.append(new JButton(browseAction));
        defaultFormBuilder.nextLine();
        jLabel = new JLabel(Globals.lang("Path to HTML viewer") + ":");
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.append(this.html);
        browseAction = new BrowseAction(this._frame, this.html, false);
        if (Globals.ON_WIN) {
            browseAction.setEnabled(false);
        }
        defaultFormBuilder.append(new JButton(browseAction));
        defaultFormBuilder.nextLine();
        jLabel = new JLabel(Globals.lang("Path to LyX pipe") + ":");
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.append(this.lyx);
        browseAction = new BrowseAction(this._frame, this.lyx, false);
        defaultFormBuilder.append(new JButton(browseAction));
        defaultFormBuilder.nextLine();
        jLabel = new JLabel(Globals.lang("Path to WinEdt.exe") + ":");
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.append(this.winEdt);
        browseAction = new BrowseAction(this._frame, this.winEdt, false);
        defaultFormBuilder.append(new JButton(browseAction));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(Globals.lang("Cite command (for Emacs/WinEdt)") + ":");
        defaultFormBuilder.append(this.citeCommand);
        jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel, "Center");
    }

    public void setValues() {
        this.pdfDir.setText(this._prefs.get("pdfDirectory"));
        this.psDir.setText(this._prefs.get("psDirectory"));
        if (!Globals.ON_WIN) {
            this.pdf.setText(this._prefs.get("pdfviewer"));
            this.ps.setText(this._prefs.get("psviewer"));
            this.html.setText(this._prefs.get("htmlviewer"));
        } else {
            this.pdf.setText(Globals.lang("Uses default application"));
            this.ps.setText(Globals.lang("Uses default application"));
            this.html.setText(Globals.lang("Uses default application"));
            this.pdf.setEnabled(false);
            this.ps.setEnabled(false);
            this.html.setEnabled(false);
        }
        this.lyx.setText(this._prefs.get("lyxpipe"));
        this.winEdt.setText(this._prefs.get("winEdtPath"));
        this.citeCommand.setText(this._prefs.get("citeCommand"));
        this.regExpTextField.setText(this._prefs.get("regExpSearchExpression"));
        this.useRegExpComboBox.setSelected(this._prefs.getBoolean("useRegExpSearch"));
        this.regExpListener.itemStateChanged(null);
    }

    public void storeSettings() {
        this._prefs.putBoolean("useRegExpSearch", this.useRegExpComboBox.isSelected());
        if (this.useRegExpComboBox.isSelected()) {
            this._prefs.put("regExpSearchExpression", this.regExpTextField.getText());
        }
        this._prefs.put("pdfDirectory", this.pdfDir.getText());
        this._prefs.put("psDirectory", this.psDir.getText());
        this._prefs.put("pdfviewer", this.pdf.getText());
        this._prefs.put("psviewer", this.ps.getText());
        this._prefs.put("htmlviewer", this.html.getText());
        this._prefs.put("lyxpipe", this.lyx.getText());
        this._prefs.put("winEdtPath", this.winEdt.getText());
        this._prefs.put("citeCommand", this.citeCommand.getText());
    }

    public boolean readyToClose() {
        return true;
    }

    public String getTabName() {
        return Globals.lang("External programs");
    }
}

