/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldEditorFocusListener;
import net.sf.jabref.FieldNameLabel;
import net.sf.jabref.FieldTextMenu;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;

public class FieldTextArea
extends JTextArea
implements FieldEditor {
    Dimension PREFERRED_SIZE;
    JScrollPane sp;
    FieldNameLabel label;
    String fieldName;
    static final Pattern bull = Pattern.compile("\\s*[-\\*]+.*");
    static final Pattern indent = Pattern.compile("\\s+.*");
    final boolean antialias = Globals.prefs.getBoolean("antialias");

    public FieldTextArea(String string, String string2) {
        super(string2);
        this.addFocusListener(Globals.focusListener);
        this.addFocusListener(new FieldEditorFocusListener());
        this.sp = new JScrollPane(this, 20, 31);
        this.sp.setMinimumSize(new Dimension(200, 1));
        this.setLineWrap(true);
        this.setWrapStyleWord(true);
        this.fieldName = string;
        this.label = new FieldNameLabel(" " + Util.nCase(this.fieldName) + " ");
        this.setBackground(GUIGlobals.validFieldBackground);
        FieldTextMenu fieldTextMenu = new FieldTextMenu(this);
        this.addMouseListener(fieldTextMenu);
        this.label.addMouseListener(fieldTextMenu);
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.antialias) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        super.paint(graphics2D);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String string) {
        this.fieldName = string;
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void setLabelColor(Color color) {
        this.label.setForeground(color);
    }

    public JComponent getPane() {
        return this.sp;
    }

    public JComponent getTextComponent() {
        return this;
    }

    public void paste(String string) {
        int n = this.getSelectionEnd() - this.getSelectionStart();
        if (n > 0) {
            this.replaceSelection(string);
        } else {
            int n2 = this.getCaretPosition();
            this.insert(string, n2);
        }
    }
}

