/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.Globals;

class KeyBindingsDialog
extends JDialog {
    KeystrokeTable table;
    KeystrokeTableModel tableModel;
    JTextField keyTF = new JTextField();
    JButton ok;
    JButton cancel;
    JButton grabB;
    JButton defB;
    HashMap bindHM;
    HashMap defBinds;
    boolean clickedSave = false;
    int selectedRow = -1;

    boolean getAction() {
        return this.clickedSave;
    }

    HashMap getNewKeyBindings() {
        return this.bindHM;
    }

    public KeyBindingsDialog(HashMap hashMap, HashMap hashMap2) {
        this.defBinds = hashMap2;
        this.setTitle(Globals.lang("Key bindings"));
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.bindHM = hashMap;
        this.setList();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(250, 400));
        this.getContentPane().add((Component)jScrollPane, "Center");
        Box box = new Box(0);
        this.ok = new JButton(Globals.lang("Ok"));
        this.cancel = new JButton(Globals.lang("Cancel"));
        this.grabB = new JButton(Globals.lang("Grab"));
        this.defB = new JButton(Globals.lang("Default"));
        this.grabB.addKeyListener(new JBM_CustomKeyBindingsListener());
        box.add(this.grabB);
        box.add(this.defB);
        box.add(this.ok);
        box.add(this.cancel);
        this.getContentPane().add((Component)box, "South");
        this.setButtons();
        this.keyTF.setEditable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                KeyBindingsDialog.this.clickedSave = false;
                KeyBindingsDialog.this.dispose();
            }
        });
    }

    void setTop() {
        Box box = new Box(0);
        box.add(new JLabel(Globals.lang("Binding") + ":", 4));
        box.add(this.keyTF);
        this.getContentPane().add((Component)box, "North");
    }

    void setList() {
        Object object;
        DefaultListModel defaultListModel = new DefaultListModel();
        Iterator iterator = this.bindHM.keySet().iterator();
        String[][] stringArray = new String[this.bindHM.size()][3];
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n][2] = object = (String)iterator.next();
            stringArray[n][1] = (String)this.bindHM.get(object);
            stringArray[n][0] = Globals.lang((String)object);
            ++n;
        }
        object = new TreeMap();
        for (n = 0; n < stringArray.length; ++n) {
            ((TreeMap)object).put(stringArray[n][0], stringArray[n]);
        }
        this.tableModel = new KeystrokeTableModel((TreeMap)object);
        this.table = new KeystrokeTable(this.tableModel);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        tableColumnModel.getColumn(1).setPreferredWidth(80);
        this.table.setRowSelectionInterval(0, 0);
    }

    void setButtons() {
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KeyBindingsDialog.this.dispose();
                KeyBindingsDialog.this.clickedSave = true;
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KeyBindingsDialog.this.dispose();
                KeyBindingsDialog.this.clickedSave = false;
            }
        });
        this.defB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
    }

    String setToDefault(String string) {
        String string2 = (String)this.defBinds.get(string);
        this.bindHM.put(string, string2);
        return string2;
    }

    class KeystrokeTableModel
    extends AbstractTableModel {
        String[][] data;

        public KeystrokeTableModel(TreeMap treeMap) {
            this.data = new String[treeMap.size()][3];
            Iterator iterator = treeMap.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                this.data[n++] = (String[])treeMap.get(iterator.next());
            }
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public String getColumnName(int n) {
            return n == 0 ? Globals.lang("Action") : Globals.lang("Shortcut");
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.data.length;
        }

        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        public void setValueAt(Object object, int n, int n2) {
            this.data[n][n2] = (String)object;
        }
    }

    class KeystrokeTable
    extends JTable {
        public KeystrokeTable(KeystrokeTableModel keystrokeTableModel) {
            super(keystrokeTableModel);
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public String getOriginalName(int n) {
            return ((KeystrokeTableModel)this.getModel()).data[n][2];
        }
    }

    class MyListDataListener
    implements ListDataListener {
        MyListDataListener() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            DefaultListModel defaultListModel = (DefaultListModel)listDataEvent.getSource();
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            int n3 = n2 - n + 1;
            for (int i = n; i <= n2; ++i) {
                Object e = defaultListModel.getElementAt(i);
            }
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            int n3 = n2 - n + 1;
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            DefaultListModel defaultListModel = (DefaultListModel)listDataEvent.getSource();
            int n = listDataEvent.getIndex0();
            int n2 = listDataEvent.getIndex1();
            int n3 = n2 - n + 1;
            for (int i = n; i <= n2; ++i) {
                Object e = defaultListModel.getElementAt(i);
            }
        }
    }

    class MyListSelectionListener
    implements ListSelectionListener {
        MyListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                JList jList = (JList)listSelectionEvent.getSource();
                Object[] objectArray = jList.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = objectArray[i];
                    KeyBindingsDialog.this.keyTF.setText((String)KeyBindingsDialog.this.bindHM.get(object));
                }
            }
        }
    }

    public class JBM_CustomKeyBindingsListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            int n2 = KeyBindingsDialog.this.table.getSelectedRow();
            if (n2 < 0) {
                return;
            }
            String string = KeyEvent.getKeyText(keyEvent.getKeyCode());
            String string2 = KeyEvent.getKeyModifiersText(keyEvent.getModifiers());
            if (string2.equals("") && (n = keyEvent.getKeyCode()) < 112 && n > 123 && n != 27 && n != 127) {
                return;
            }
            if (string.equals("Tab") || string.equals("Backspace") || string.equals("Enter") || string.equals("Space") || string.equals("Ctrl") || string.equals("Shift") || string.equals("Alt")) {
                return;
            }
            String string3 = !string2.equals("") ? string2.toLowerCase().replaceAll("\\+", " ") + " " + string : string;
            KeyBindingsDialog.this.keyTF.setText(string3);
            String string4 = KeyBindingsDialog.this.table.getOriginalName(n2);
            KeyBindingsDialog.this.table.setValueAt(string3, n2, 1);
            KeyBindingsDialog.this.table.revalidate();
            KeyBindingsDialog.this.table.repaint();
            KeyBindingsDialog.this.bindHM.put(string4, string3);
        }
    }
}

