/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.SidePane;
import net.sf.jabref.SidePaneComponent;

public class SidePaneManager {
    JabRefFrame frame;
    BasePanel panel;
    SidePane sidep;
    Map components = new LinkedHashMap();
    List visible = new LinkedList();

    public SidePaneManager(JabRefFrame jabRefFrame) {
        this.frame = jabRefFrame;
        jabRefFrame.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        SidePaneManager.this.setActiveBasePanel((BasePanel)(this).SidePaneManager.this.frame.tabbedPane.getSelectedComponent());
                    }
                });
            }
        });
        this.sidep = new SidePane();
        this.sidep.setVisible(false);
    }

    public SidePane getPanel() {
        return this.sidep;
    }

    public synchronized boolean hasComponent(String string) {
        return this.components.get(string) != null;
    }

    public boolean isComponentVisible(String string) {
        Object v = this.components.get(string);
        if (v != null) {
            return this.visible.contains(v);
        }
        return false;
    }

    public synchronized void toggle(String string) {
        if (this.isComponentVisible(string)) {
            this.hide(string);
        } else {
            this.show(string);
        }
    }

    public void show(String string) {
        Object v = this.components.get(string);
        if (v != null) {
            this.show((SidePaneComponent)v);
        } else {
            System.err.println("Side pane component '" + string + "' unknown.");
        }
    }

    public void hide(String string) {
        Object v = this.components.get(string);
        if (v != null) {
            this.hideComponent((SidePaneComponent)v);
        } else {
            System.err.println("Side pane component '" + string + "' unknown.");
        }
    }

    public synchronized void register(String string, SidePaneComponent sidePaneComponent) {
        this.components.put(string, sidePaneComponent);
    }

    public synchronized void registerAndShow(String string, SidePaneComponent sidePaneComponent) {
        this.register(string, sidePaneComponent);
        this.show(string);
    }

    private synchronized void show(SidePaneComponent sidePaneComponent) {
        if (!this.visible.contains(sidePaneComponent)) {
            this.visible.add(0, sidePaneComponent);
            this.updateView();
            sidePaneComponent.componentOpening();
        }
    }

    public synchronized void hideComponent(SidePaneComponent sidePaneComponent) {
        if (this.visible.contains(sidePaneComponent)) {
            sidePaneComponent.componentClosing();
            this.visible.remove(sidePaneComponent);
            this.updateView();
        }
    }

    public synchronized void hideComponent(String string) {
        SidePaneComponent sidePaneComponent = (SidePaneComponent)this.components.get(string);
        if (sidePaneComponent == null) {
            return;
        }
        if (this.visible.contains(sidePaneComponent)) {
            sidePaneComponent.componentClosing();
            this.visible.remove(sidePaneComponent);
            this.updateView();
        }
    }

    public synchronized void unregisterComponent(String string) {
        this.components.remove(string);
    }

    public void setActiveBasePanel(BasePanel basePanel) {
        Iterator iterator = this.components.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            ((SidePaneComponent)this.components.get(k)).setActiveBasePanel(basePanel);
        }
    }

    public void updateView() {
        this.sidep.setComponents(this.visible);
        if (this.visible.size() > 0) {
            boolean bl = this.sidep.isVisible();
            this.sidep.setVisible(true);
            if (!bl) {
                int n = Globals.prefs.getInt("sidePaneWidth");
                if (n > 0) {
                    this.frame.contentPane.setDividerLocation(n);
                } else {
                    this.frame.contentPane.setDividerLocation(this.getPanel().getPreferredSize().width);
                }
            }
        } else {
            if (this.sidep.isVisible()) {
                Globals.prefs.putInt("sidePaneWidth", this.frame.contentPane.getDividerLocation());
            }
            this.sidep.setVisible(false);
        }
    }

    public void revalidate() {
        this.sidep.revalidate();
        this.sidep.repaint();
    }
}

