/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.undo.CompoundEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexString;
import net.sf.jabref.BibtexStringComparator;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.Util;
import net.sf.jabref.export.LatexFieldFormatter;
import net.sf.jabref.undo.UndoableInsertString;
import net.sf.jabref.undo.UndoableRemoveString;
import net.sf.jabref.undo.UndoableStringChange;

public class StringDialog
extends JDialog {
    BibtexDatabase base;
    JabRefFrame frame;
    BasePanel panel;
    JabRefPreferences prefs;
    TreeSet stringsSet;
    Object[] strings;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JLabel lab;
    Container conPane = this.getContentPane();
    JToolBar tlb = new JToolBar();
    JPanel pan = new JPanel();
    StringTable table;
    HelpAction helpAction;
    CloseAction closeAction = new CloseAction(this);
    NewStringAction newStringAction = new NewStringAction(this);
    StoreContentAction storeContentAction = new StoreContentAction(this);
    RemoveStringAction removeStringAction = new RemoveStringAction(this);
    UndoAction undoAction = new UndoAction();
    RedoAction redoAction = new RedoAction();
    static /* synthetic */ Class class$java$lang$String;

    public StringDialog(JabRefFrame jabRefFrame, BasePanel basePanel, BibtexDatabase bibtexDatabase, JabRefPreferences jabRefPreferences) {
        super(jabRefFrame);
        this.frame = jabRefFrame;
        this.panel = basePanel;
        this.base = bibtexDatabase;
        this.prefs = jabRefPreferences;
        this.sortStrings();
        this.helpAction = new HelpAction(jabRefFrame.helpDiag, GUIGlobals.stringEditorHelp, "Help");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                StringDialog.this.closeAction.actionPerformed(null);
            }
        });
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            protected boolean accept(Component component) {
                return super.accept(component) && component instanceof StringTable;
            }
        });
        this.setLocation(jabRefPreferences.getInt("stringsPosX"), jabRefPreferences.getInt("stringsPosY"));
        this.setSize(jabRefPreferences.getInt("stringsSizeX"), jabRefPreferences.getInt("stringsSizeY"));
        this.pan.setLayout(this.gbl);
        this.con.fill = 1;
        this.con.weighty = 1.0;
        this.con.weightx = 1.0;
        StringTableModel stringTableModel = new StringTableModel(this, bibtexDatabase);
        this.table = new StringTable(stringTableModel);
        if (bibtexDatabase.getStringCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        this.gbl.setConstraints(this.table.getPane(), this.con);
        this.pan.add(this.table.getPane());
        InputMap inputMap = this.tlb.getInputMap(2);
        ActionMap actionMap = this.tlb.getActionMap();
        inputMap.put(jabRefPreferences.getKey("String dialog, add string"), "add");
        actionMap.put("add", this.newStringAction);
        inputMap.put(jabRefPreferences.getKey("String dialog, remove string"), "remove");
        actionMap.put("remove", this.removeStringAction);
        inputMap.put(jabRefPreferences.getKey("Close dialog"), "close");
        actionMap.put("close", this.closeAction);
        inputMap.put(jabRefPreferences.getKey("Help"), "help");
        actionMap.put("help", this.helpAction);
        inputMap.put(jabRefPreferences.getKey("Undo"), "undo");
        actionMap.put("undo", this.undoAction);
        inputMap.put(jabRefPreferences.getKey("Redo"), "redo");
        actionMap.put("redo", this.redoAction);
        this.tlb.add(this.newStringAction);
        this.tlb.add(this.removeStringAction);
        this.tlb.addSeparator();
        this.tlb.addSeparator();
        this.tlb.add(this.helpAction);
        this.conPane.add((Component)this.tlb, "North");
        this.conPane.add((Component)this.pan, "Center");
        if (basePanel.getFile() != null) {
            this.setTitle(Globals.lang(GUIGlobals.stringsTitle) + ": " + basePanel.getFile().getName());
        } else {
            this.setTitle(Globals.lang(GUIGlobals.stringsTitle) + ": " + Globals.lang(GUIGlobals.untitledTitle));
        }
    }

    private void sortStrings() {
        this.stringsSet = new TreeSet(new BibtexStringComparator(false));
        Iterator iterator = this.base.getStringKeySet().iterator();
        while (iterator.hasNext()) {
            this.stringsSet.add(this.base.getString(iterator.next()));
        }
        this.strings = this.stringsSet.toArray();
    }

    public void refreshTable() {
        this.sortStrings();
        this.table.revalidate();
        this.table.clearSelection();
        this.table.repaint();
    }

    protected boolean isNumber(String string) {
        try {
            Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    protected void assureNotEditing() {
        if (this.table.isEditing()) {
            int n = this.table.getEditingColumn();
            int n2 = this.table.getEditingRow();
            this.table.getCellEditor(n2, n).stopCellEditing();
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Undo", GUIGlobals.getImage("redo"));
            this.putValue("ShortDescription", Globals.lang("Redo"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                StringDialog.this.panel.runCommand("redo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo", GUIGlobals.getImage("undo"));
            this.putValue("ShortDescription", Globals.lang("Undo"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                StringDialog.this.panel.runCommand("undo");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    class RemoveStringAction
    extends AbstractAction {
        StringDialog parent;

        public RemoveStringAction(StringDialog stringDialog2) {
            super("Remove selected strings", GUIGlobals.getImage("remove"));
            this.putValue("ShortDescription", Globals.lang("Remove selected strings"));
            this.parent = stringDialog2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = StringDialog.this.table.getSelectedRows();
            if (nArray.length > 0) {
                StringDialog.this.assureNotEditing();
                String string = Globals.lang("Really delete the selected") + " " + (nArray.length > 1 ? nArray.length + " " + Globals.lang("entries") : Globals.lang("entry")) + "?";
                int n = JOptionPane.showConfirmDialog(this.parent, string, Globals.lang("Delete strings"), 0, 3);
                if (n == 0) {
                    CompoundEdit compoundEdit = new CompoundEdit();
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        BibtexString bibtexString = (BibtexString)StringDialog.this.strings[nArray[i]];
                        compoundEdit.addEdit(new UndoableRemoveString(StringDialog.this.panel, StringDialog.this.base, bibtexString));
                        StringDialog.this.base.removeString(bibtexString.getId());
                    }
                    compoundEdit.end();
                    StringDialog.this.panel.undoManager.addEdit(compoundEdit);
                    StringDialog.this.refreshTable();
                    if (StringDialog.this.base.getStringCount() > 0) {
                        StringDialog.this.table.setRowSelectionInterval(0, 0);
                    }
                }
            }
        }
    }

    class StoreContentAction
    extends AbstractAction {
        StringDialog parent;

        public StoreContentAction(StringDialog stringDialog2) {
            super("Store string", GUIGlobals.getImage("add"));
            this.putValue("ShortDescription", Globals.lang("Store string"));
            this.parent = stringDialog2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    class NewStringAction
    extends AbstractAction {
        StringDialog parent;

        public NewStringAction(StringDialog stringDialog2) {
            super("New string", GUIGlobals.getImage("add"));
            this.putValue("ShortDescription", Globals.lang("New string"));
            this.parent = stringDialog2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = JOptionPane.showInputDialog(this.parent, (Object)Globals.lang("Please enter the string's label"));
            if (string == null) {
                return;
            }
            if (StringDialog.this.isNumber(string)) {
                JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not be a number."), Globals.lang("Label"), 0);
                return;
            }
            if (string.indexOf("#") >= 0) {
                JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not contain the '#' character."), Globals.lang("Label"), 0);
                return;
            }
            if (string.indexOf(" ") >= 0) {
                JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not contain spaces."), Globals.lang("Label"), 0);
                return;
            }
            try {
                String string2 = Util.createNeutralId();
                BibtexString bibtexString = new BibtexString(string2, string, "");
                StringDialog.this.panel.undoManager.addEdit(new UndoableInsertString(StringDialog.this.panel, StringDialog.this.panel.database, bibtexString));
                StringDialog.this.base.addString(bibtexString);
                StringDialog.this.refreshTable();
                StringDialog.this.panel.markBaseChanged();
            }
            catch (KeyCollisionException keyCollisionException) {
                JOptionPane.showMessageDialog(this.parent, Globals.lang("A string with that label already exists"), Globals.lang("Label"), 0);
            }
        }
    }

    class CloseAction
    extends AbstractAction {
        StringDialog parent;

        public CloseAction(StringDialog stringDialog2) {
            super("Close window");
            this.putValue("ShortDescription", Globals.lang("Close dialog"));
            this.parent = stringDialog2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            StringDialog.this.panel.stringsClosing();
            StringDialog.this.dispose();
            Point point = StringDialog.this.getLocation();
            Dimension dimension = StringDialog.this.getSize();
            StringDialog.this.prefs.putInt("stringsPosX", point.x);
            StringDialog.this.prefs.putInt("stringsPosY", point.y);
            StringDialog.this.prefs.putInt("stringsSizeX", dimension.width);
            StringDialog.this.prefs.putInt("stringsSizeY", dimension.height);
        }
    }

    class StringTableModel
    extends AbstractTableModel {
        BibtexDatabase base;
        StringDialog parent;

        public StringTableModel(StringDialog stringDialog2, BibtexDatabase bibtexDatabase) {
            this.parent = stringDialog2;
            this.base = bibtexDatabase;
        }

        public Object getValueAt(int n, int n2) {
            return n2 == 0 ? ((BibtexString)StringDialog.this.strings[n]).getName() : ((BibtexString)StringDialog.this.strings[n]).getContent();
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                if (!((String)object).equals(((BibtexString)StringDialog.this.strings[n]).getName())) {
                    if (this.base.hasStringLabel((String)object)) {
                        JOptionPane.showMessageDialog(this.parent, Globals.lang("A string with that label already exists"), Globals.lang("Label"), 0);
                    } else if (((String)object).indexOf(" ") >= 0) {
                        JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not contain spaces."), Globals.lang("Label"), 0);
                    } else if (((String)object).indexOf("#") >= 0) {
                        JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not contain the '#' character."), Globals.lang("Label"), 0);
                    } else if (object != null && StringDialog.this.isNumber((String)object)) {
                        JOptionPane.showMessageDialog(this.parent, Globals.lang("The label of the string can not be a number."), Globals.lang("Label"), 0);
                    } else {
                        BibtexString bibtexString = (BibtexString)StringDialog.this.strings[n];
                        StringDialog.this.panel.undoManager.addEdit(new UndoableStringChange(StringDialog.this.panel, bibtexString, true, bibtexString.getName(), (String)object));
                        bibtexString.setName((String)object);
                        StringDialog.this.panel.markBaseChanged();
                        StringDialog.this.refreshTable();
                    }
                }
            } else {
                BibtexString bibtexString = (BibtexString)StringDialog.this.strings[n];
                if (!((String)object).equals(bibtexString.getContent())) {
                    try {
                        new LatexFieldFormatter().format((String)object, "__dummy");
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        return;
                    }
                    StringDialog.this.panel.undoManager.addEdit(new UndoableStringChange(StringDialog.this.panel, bibtexString, false, bibtexString.getContent(), (String)object));
                    bibtexString.setContent((String)object);
                    StringDialog.this.panel.markBaseChanged();
                }
            }
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return StringDialog.this.strings.length;
        }

        public String getColumnName(int n) {
            return n == 0 ? Globals.lang("Name") : Globals.lang("Content");
        }

        public boolean isCellEditable(int n, int n2) {
            return true;
        }
    }

    class StringTable
    extends JTable {
        JScrollPane sp;

        public StringTable(StringTableModel stringTableModel) {
            super(stringTableModel);
            this.sp = new JScrollPane(this);
            this.setShowVerticalLines(true);
            this.setShowHorizontalLines(true);
            this.setColumnSelectionAllowed(true);
            DefaultCellEditor defaultCellEditor = new DefaultCellEditor(new JTextField());
            defaultCellEditor.setClickCountToStart(2);
            this.setDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = StringDialog.class$("java.lang.String")) : class$java$lang$String, defaultCellEditor);
            TableColumnModel tableColumnModel = this.getColumnModel();
            tableColumnModel.getColumn(0).setPreferredWidth(800);
            tableColumnModel.getColumn(1).setPreferredWidth(2000);
            this.sp.getViewport().setBackground(Globals.prefs.getColor("tableBackground"));
            this.getInputMap().put(StringDialog.this.frame.prefs.getKey("Close dialog"), "close");
            this.getActionMap().put("close", StringDialog.this.closeAction);
            this.getInputMap().put(StringDialog.this.frame.prefs.getKey("Help"), "help");
            this.getActionMap().put("help", StringDialog.this.helpAction);
        }

        public JComponent getPane() {
            return this.sp;
        }
    }
}

