/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.HelpDialog;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.Util;
import net.sf.jabref.labelPattern.LabelPattern;
import net.sf.jabref.labelPattern.LabelPatternUtil;

public class TabLabelPattern
extends JPanel
implements PrefsTab {
    private String def = Globals.lang("Default");
    private GridBagLayout gbl = new GridBagLayout();
    private GridBagConstraints con = new GridBagConstraints();
    private HashMap textFields = new HashMap();
    private JabRefPreferences _prefs;
    private LabelPattern _keypatterns = null;
    private JCheckBox dontOverwrite = new JCheckBox(Globals.lang("Do not overwrite existing keys"));
    private JCheckBox warnBeforeOverwriting = new JCheckBox(Globals.lang("Warn before overwriting existing keys"));
    private JCheckBox generateOnSave = new JCheckBox(Globals.lang("Generate keys before saving (for entries without a key)"));
    private JCheckBox autoGenerateOnImport = new JCheckBox(Globals.lang("Generate keys for imported entries"));
    private JLabel lblEntryType;
    private JLabel lblKeyPattern;
    private JTextField defaultPat = new JTextField();
    private JTextField KeyPatternRegex = new JTextField(20);
    private JTextField KeyPatternReplacement = new JTextField(20);
    private JButton btnDefaultAll;
    private JButton btnDefault;
    private HelpAction help;

    public TabLabelPattern(JabRefPreferences jabRefPreferences, HelpDialog helpDialog) {
        this._prefs = jabRefPreferences;
        this.help = new HelpAction(helpDialog, GUIGlobals.labelPatternHelp, "Help on key patterns");
        this.buildGUI();
    }

    public void storeSettings() {
        Globals.prefs.put("defaultLabelPattern", this.defaultPat.getText());
        Globals.prefs.putBoolean("warnBeforeOverwritingKey", this.warnBeforeOverwriting.isSelected());
        Globals.prefs.putBoolean("avoidOverwritingKey", this.dontOverwrite.isSelected());
        Globals.prefs.put("KeyPatternRegex", this.KeyPatternRegex.getText());
        Globals.prefs.put("KeyPatternReplacement", this.KeyPatternReplacement.getText());
        Globals.prefs.putBoolean("generateKeysAfterInspection", this.autoGenerateOnImport.isSelected());
        Globals.prefs.putBoolean("generateKeysBeforeSaving", this.generateOnSave.isSelected());
        LabelPatternUtil.updateDefaultPattern();
        LabelPattern labelPattern = this._keypatterns.getParent();
        this._keypatterns = new LabelPattern(labelPattern);
        Iterator iterator = this.textFields.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = ((JTextField)this.textFields.get(string)).getText();
            if ("".equals(string2.trim())) continue;
            this._keypatterns.addLabelPattern(string, string2);
        }
        this._prefs.putKeyPattern(this._keypatterns);
    }

    private JTextField addEntryType(Container container, String string, int n) {
        JLabel jLabel = new JLabel(Util.nCase(string));
        string = string.toLowerCase();
        this.con.gridx = 0;
        this.con.gridy = n;
        this.con.fill = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 17;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(jLabel, this.con);
        container.add(jLabel);
        JTextField jTextField = new JTextField();
        jTextField.setColumns(15);
        this.con.gridx = 1;
        this.con.fill = 2;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.anchor = 10;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(jTextField, this.con);
        container.add(jTextField);
        JButton jButton = new JButton(this.def);
        this.con.gridx = 2;
        this.con.fill = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 10;
        this.con.insets = new Insets(0, 5, 0, 5);
        this.gbl.setConstraints(jButton, this.con);
        jButton.setActionCommand(string);
        jButton.addActionListener(new buttonHandler());
        container.add(jButton);
        return jTextField;
    }

    private void setValue(JTextField jTextField, String string) {
        if (this._keypatterns.isDefaultValue(string)) {
            jTextField.setText("");
        } else {
            jTextField.setText(this._keypatterns.getValue(string).get(0).toString());
        }
    }

    private void buildGUI() {
        Object object;
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane(jPanel);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jPanel.setLayout(this.gbl);
        this.setLayout(this.gbl);
        this.lblEntryType = new JLabel(Globals.lang("Entry type"));
        Font font = new Font("plain", 1, 12);
        this.lblEntryType.setFont(font);
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.con.gridwidth = 1;
        this.con.gridheight = 1;
        this.con.fill = 3;
        this.con.anchor = 17;
        this.con.insets = new Insets(5, 5, 10, 0);
        this.gbl.setConstraints(this.lblEntryType, this.con);
        jPanel.add(this.lblEntryType);
        this.lblKeyPattern = new JLabel(Globals.lang("Key pattern"));
        this.lblKeyPattern.setFont(font);
        this.con.gridx = 1;
        this.con.gridy = 0;
        this.con.gridheight = 1;
        this.con.fill = 2;
        this.con.anchor = 17;
        this.con.insets = new Insets(5, 5, 10, 5);
        this.gbl.setConstraints(this.lblKeyPattern, this.con);
        jPanel.add(this.lblKeyPattern);
        this.con.gridy = 1;
        this.con.gridx = 0;
        JLabel jLabel = new JLabel(Globals.lang("Default pattern"));
        this.gbl.setConstraints(jLabel, this.con);
        jPanel.add(jLabel);
        this.con.gridx = 1;
        this.gbl.setConstraints(this.defaultPat, this.con);
        jPanel.add(this.defaultPat);
        this.con.insets = new Insets(5, 5, 10, 5);
        this.btnDefault = new JButton(Globals.lang("Default"));
        this.btnDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TabLabelPattern.this.defaultPat.setText((String)Globals.prefs.defaults.get("defaultLabelPattern"));
            }
        });
        this.con.gridx = 2;
        int n = 2;
        this.gbl.setConstraints(this.btnDefault, this.con);
        jPanel.add(this.btnDefault);
        Iterator iterator = BibtexEntryType.ALL_TYPES.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            this.textFields.put(object, this.addEntryType(jPanel, (String)object, n));
            ++n;
        }
        this.con.fill = 1;
        this.con.gridx = 0;
        this.con.gridy = 1;
        this.con.gridwidth = 3;
        this.con.weightx = 1.0;
        this.con.weighty = 1.0;
        this.gbl.setConstraints(jScrollPane, this.con);
        this.add(jScrollPane);
        this.con.gridwidth = 1;
        this.con.gridx = 1;
        this.con.gridy = 2;
        this.con.fill = 2;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.anchor = 14;
        this.con.insets = new Insets(0, 5, 0, 5);
        object = new JButton(GUIGlobals.getImage("helpSmall"));
        ((JComponent)object).setToolTipText(Globals.lang("Help on key patterns"));
        this.gbl.setConstraints((Component)object, this.con);
        this.add((Component)object);
        ((AbstractButton)object).addActionListener(this.help);
        this.btnDefaultAll = new JButton(Globals.lang("Reset all"));
        this.con.gridx = 2;
        this.con.gridy = 2;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.anchor = 14;
        this.con.insets = new Insets(20, 5, 0, 5);
        this.gbl.setConstraints(this.btnDefaultAll, this.con);
        this.btnDefaultAll.addActionListener(new buttonHandler());
        this.add(this.btnDefaultAll);
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 8dlu, left:pref", "");
        jPanel = new JPanel();
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.appendSeparator(Globals.lang("Key generator settings"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.autoGenerateOnImport);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.warnBeforeOverwriting);
        defaultFormBuilder.append(this.dontOverwrite);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.generateOnSave);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(Globals.lang("Replace (regular expression)") + ":");
        defaultFormBuilder.append(Globals.lang("by") + ":");
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.KeyPatternRegex);
        defaultFormBuilder.append(this.KeyPatternReplacement);
        defaultFormBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.con.gridx = 1;
        this.con.gridy = 3;
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.fill = 1;
        this.gbl.setConstraints(defaultFormBuilder.getPanel(), this.con);
        this.add(defaultFormBuilder.getPanel());
        this.dontOverwrite.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                TabLabelPattern.this.warnBeforeOverwriting.setEnabled(!TabLabelPattern.this.dontOverwrite.isSelected());
            }
        });
    }

    public boolean readyToClose() {
        return true;
    }

    public void setValues() {
        this._keypatterns = this._prefs.getKeyPattern();
        this.defaultPat.setText(Globals.prefs.get("defaultLabelPattern"));
        this.dontOverwrite.setSelected(Globals.prefs.getBoolean("avoidOverwritingKey"));
        this.generateOnSave.setSelected(Globals.prefs.getBoolean("generateKeysBeforeSaving"));
        this.autoGenerateOnImport.setSelected(Globals.prefs.getBoolean("generateKeysAfterInspection"));
        this.warnBeforeOverwriting.setSelected(Globals.prefs.getBoolean("warnBeforeOverwritingKey"));
        this.warnBeforeOverwriting.setEnabled(!this.dontOverwrite.isSelected());
        Iterator iterator = this.textFields.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            JTextField jTextField = (JTextField)this.textFields.get(string);
            this.setValue(jTextField, string);
        }
        this.KeyPatternRegex.setText(Globals.prefs.get("KeyPatternRegex"));
        this.KeyPatternReplacement.setText(Globals.prefs.get("KeyPatternReplacement"));
    }

    public String getTabName() {
        return Globals.lang("Key pattern");
    }

    class buttonHandler
    implements ActionListener {
        buttonHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == TabLabelPattern.this.btnDefaultAll) {
                Iterator iterator = TabLabelPattern.this.textFields.keySet().iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    JTextField jTextField = (JTextField)TabLabelPattern.this.textFields.get(string);
                    jTextField.setText("");
                }
                return;
            }
            JTextField jTextField = (JTextField)TabLabelPattern.this.textFields.get(actionEvent.getActionCommand());
            jTextField.setText("");
        }
    }
}

