/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;

class TableColumnsTab
extends JPanel
implements PrefsTab {
    JabRefPreferences _prefs;
    private boolean tableChanged = false;
    private JTable colSetup;
    private int rowCount = -1;
    private int ncWidth = -1;
    private Vector tableRows = new Vector(10);
    private JabRefFrame frame;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public TableColumnsTab(JabRefPreferences jabRefPreferences, JabRefFrame jabRefFrame) {
        this._prefs = jabRefPreferences;
        this.frame = jabRefFrame;
        this.setLayout(new BorderLayout());
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            public int getRowCount() {
                return TableColumnsTab.this.rowCount;
            }

            public int getColumnCount() {
                return 2;
            }

            public Object getValueAt(int n, int n2) {
                if (n == 0) {
                    return n2 == 0 ? GUIGlobals.NUMBER_COL : "" + TableColumnsTab.this.ncWidth;
                }
                if (--n >= TableColumnsTab.this.tableRows.size()) {
                    return "";
                }
                Object e = TableColumnsTab.this.tableRows.elementAt(n);
                if (e == null) {
                    return "";
                }
                TableRow tableRow = (TableRow)e;
                switch (n2) {
                    case 0: {
                        return tableRow.name;
                    }
                    case 1: {
                        return tableRow.length > 0 ? Integer.toString(tableRow.length) : "";
                    }
                }
                return null;
            }

            public String getColumnName(int n) {
                return n == 0 ? Globals.lang("Field name") : Globals.lang("Column width");
            }

            public Class getColumnClass(int n) {
                if (n == 0) {
                    return class$java$lang$String == null ? (class$java$lang$String = TableColumnsTab.class$("java.lang.String")) : class$java$lang$String;
                }
                return class$java$lang$Integer == null ? (class$java$lang$Integer = TableColumnsTab.class$("java.lang.Integer")) : class$java$lang$Integer;
            }

            public boolean isCellEditable(int n, int n2) {
                return n != 0 || n2 != 0;
            }

            public void setValueAt(Object object, int n, int n2) {
                TableColumnsTab.this.tableChanged = true;
                while (n >= TableColumnsTab.this.tableRows.size()) {
                    TableColumnsTab.this.tableRows.add(new TableRow("", -1));
                }
                if (n == 0 && n2 == 1) {
                    TableColumnsTab.this.ncWidth = Integer.parseInt(object.toString());
                    return;
                }
                TableRow tableRow = (TableRow)TableColumnsTab.this.tableRows.elementAt(n - 1);
                if (n2 == 0) {
                    tableRow.name = object.toString();
                    if (((String)this.getValueAt(n, 1)).equals("")) {
                        this.setValueAt("" + GUIGlobals.DEFAULT_FIELD_LENGTH, n, 1);
                    }
                } else {
                    tableRow.length = object == null ? -1 : Integer.parseInt(object.toString());
                }
            }
        };
        this.colSetup = new JTable(abstractTableModel);
        TableColumnModel tableColumnModel = this.colSetup.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(140);
        tableColumnModel.getColumn(1).setPreferredWidth(80);
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.colSetup, 20, 31);
        this.colSetup.setPreferredScrollableViewportSize(new Dimension(250, 200));
        jScrollPane.setMinimumSize(new Dimension(250, 300));
        jPanel2.add((Component)jScrollPane, "Center");
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        AddRowAction addRowAction = new AddRowAction();
        DeleteRowAction deleteRowAction = new DeleteRowAction();
        jToolBar.setBorder(null);
        jToolBar.add(addRowAction);
        jToolBar.add(deleteRowAction);
        jPanel2.add((Component)jToolBar, "East");
        defaultFormBuilder.appendSeparator(Globals.lang("Entry table columns"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(jPanel2);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        JButton jButton = new JButton(new UpdateWidthsAction());
        defaultFormBuilder.append(jButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.nextLine();
        jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel, "Center");
    }

    public void setValues() {
        this.tableRows.clear();
        String[] stringArray = this._prefs.getStringArray("columnNames");
        String[] stringArray2 = this._prefs.getStringArray("columnWidths");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i < stringArray2.length) {
                this.tableRows.add(new TableRow(stringArray[i], Integer.parseInt(stringArray2[i])));
                continue;
            }
            this.tableRows.add(new TableRow(stringArray[i]));
        }
        this.rowCount = this.tableRows.size() + 5;
        this.ncWidth = this._prefs.getInt("numberColWidth");
    }

    public void storeSettings() {
        int n;
        if (this.colSetup.isEditing()) {
            n = this.colSetup.getEditingColumn();
            int n2 = this.colSetup.getEditingRow();
            this.colSetup.getCellEditor(n2, n).stopCellEditing();
        }
        if (this.tableChanged) {
            n = 0;
            while (n < this.tableRows.size()) {
                if (((TableRow)this.tableRows.elementAt((int)n)).name.equals("")) {
                    this.tableRows.removeElementAt(n);
                    continue;
                }
                ++n;
            }
            String[] stringArray = new String[this.tableRows.size()];
            String[] stringArray2 = new String[this.tableRows.size()];
            int[] nArray = new int[this.tableRows.size()];
            this._prefs.putInt("numberColWidth", this.ncWidth);
            for (n = 0; n < this.tableRows.size(); ++n) {
                TableRow tableRow = (TableRow)this.tableRows.elementAt(n);
                stringArray[n] = tableRow.name;
                nArray[n] = tableRow.length;
                stringArray2[n] = "" + tableRow.length;
            }
            this._prefs.putStringArray("columnNames", stringArray);
            this._prefs.putStringArray("columnWidths", stringArray2);
        }
    }

    public boolean readyToClose() {
        return true;
    }

    public String getTabName() {
        return Globals.lang("Entry table columns");
    }

    class UpdateWidthsAction
    extends AbstractAction {
        public UpdateWidthsAction() {
            super(Globals.lang("Update to current column widths"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BasePanel basePanel = TableColumnsTab.this.frame.basePanel();
            if (basePanel == null) {
                return;
            }
            TableColumnModel tableColumnModel = basePanel.mainTable.getColumnModel();
            TableColumnsTab.this.colSetup.setValueAt("" + tableColumnModel.getColumn(0).getWidth(), 0, 1);
            for (int i = 1; i < tableColumnModel.getColumnCount(); ++i) {
                block6: {
                    try {
                        String string = basePanel.mainTable.getColumnName(i).toLowerCase();
                        int n = tableColumnModel.getColumn(i).getWidth();
                        if (i <= TableColumnsTab.this.tableRows.size() && ((String)TableColumnsTab.this.colSetup.getValueAt(i, 0)).toLowerCase().equals(string)) {
                            TableColumnsTab.this.colSetup.setValueAt("" + n, i, 1);
                            break block6;
                        }
                        for (int j = 0; j < TableColumnsTab.this.colSetup.getRowCount(); ++j) {
                            if (j >= TableColumnsTab.this.tableRows.size() || !((String)TableColumnsTab.this.colSetup.getValueAt(j, 0)).toLowerCase().equals(string)) continue;
                            TableColumnsTab.this.colSetup.setValueAt("" + n, j, 1);
                            break;
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                TableColumnsTab.this.colSetup.revalidate();
                TableColumnsTab.this.colSetup.repaint();
            }
        }
    }

    class AddRowAction
    extends AbstractAction {
        public AddRowAction() {
            super("Add row", GUIGlobals.getImage("add"));
            this.putValue("ShortDescription", Globals.lang("Insert rows"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TableColumnsTab.this.colSetup.getSelectedRows();
            if (nArray.length == 0) {
                TableColumnsTab.this.rowCount++;
                TableColumnsTab.this.colSetup.revalidate();
                TableColumnsTab.this.colSetup.repaint();
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] + i - 1 >= TableColumnsTab.this.tableRows.size()) continue;
                TableColumnsTab.this.tableRows.add(Math.max(0, nArray[i] + i - 1), new TableRow(GUIGlobals.DEFAULT_FIELD_LENGTH));
            }
            TableColumnsTab.this.rowCount += nArray.length;
            if (nArray.length > 1) {
                TableColumnsTab.this.colSetup.clearSelection();
            }
            TableColumnsTab.this.colSetup.revalidate();
            TableColumnsTab.this.colSetup.repaint();
            TableColumnsTab.this.tableChanged = true;
        }
    }

    class DeleteRowAction
    extends AbstractAction {
        public DeleteRowAction() {
            super("Delete row", GUIGlobals.getImage("remove"));
            this.putValue("ShortDescription", Globals.lang("Delete rows"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = TableColumnsTab.this.colSetup.getSelectedRows();
            if (nArray.length == 0) {
                return;
            }
            int n = 0;
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] > TableColumnsTab.this.tableRows.size() || nArray[i] == 0) continue;
                TableColumnsTab.this.tableRows.remove(nArray[i] - 1);
                ++n;
            }
            TableColumnsTab.this.rowCount -= n;
            if (nArray.length > 1) {
                TableColumnsTab.this.colSetup.clearSelection();
            }
            TableColumnsTab.this.colSetup.revalidate();
            TableColumnsTab.this.colSetup.repaint();
            TableColumnsTab.this.tableChanged = true;
        }
    }

    class TableRow {
        String name;
        int length;

        public TableRow(String string) {
            this.name = string;
            this.length = GUIGlobals.DEFAULT_FIELD_LENGTH;
        }

        public TableRow(int n) {
            this.length = n;
            this.name = "";
        }

        public TableRow(String string, int n) {
            this.name = string;
            this.length = n;
        }
    }
}

