/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.bst;

import java.util.Stack;
import net.sf.jabref.bst.BibtexTextPrefix;
import net.sf.jabref.bst.VM;
import net.sf.jabref.bst.VMException;

public class TextPrefixFunction
implements VM.BstFunction {
    VM vm;

    public TextPrefixFunction(VM vM) {
        this.vm = vM;
    }

    public void execute(VM.BstEntry bstEntry) {
        Stack stack = this.vm.getStack();
        if (stack.size() < 2) {
            throw new VMException("Not enough operands on stack for operation text.prefix$");
        }
        Object e = stack.pop();
        Object e2 = stack.pop();
        if (!(e instanceof Integer)) {
            this.vm.warn("An integer is needed as first parameter to text.prefix$");
            stack.push("");
            return;
        }
        if (!(e instanceof String)) {
            this.vm.warn("A string is needed as second parameter to text.prefix$");
            stack.push("");
            return;
        }
        stack.push(BibtexTextPrefix.textPrefix((Integer)e, (String)e2, this.vm));
    }
}

