/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JLabel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.collab.Change;
import net.sf.jabref.groups.AllEntriesGroup;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.UndoableModifySubtree;
import net.sf.jabref.undo.NamedCompound;

public class GroupChange
extends Change {
    private final GroupTreeNode m_changedGroups;

    public GroupChange(GroupTreeNode groupTreeNode) {
        super(groupTreeNode != null ? "Modified groups tree" : "Removed all groups");
        this.m_changedGroups = groupTreeNode;
    }

    public void makeChange(BasePanel basePanel, NamedCompound namedCompound) {
        GroupTreeNode groupTreeNode = basePanel.getGroupSelector().getGroupTreeRoot();
        UndoableModifySubtree undoableModifySubtree = new UndoableModifySubtree(basePanel.getGroupSelector(), groupTreeNode, Globals.lang("Modified groups"));
        groupTreeNode.removeAllChildren();
        if (this.m_changedGroups == null) {
            groupTreeNode.setGroup(new AllEntriesGroup());
        } else {
            groupTreeNode.setGroup(this.m_changedGroups.getGroup());
            for (int i = 0; i < this.m_changedGroups.getChildCount(); ++i) {
                groupTreeNode.add(((GroupTreeNode)this.m_changedGroups.getChildAt(i)).deepCopy());
            }
            groupTreeNode.refreshGroupsForNewDatabase(basePanel.database());
        }
        basePanel.getGroupSelector().revalidateGroups();
        namedCompound.addEdit(undoableModifySubtree);
    }

    JComponent description() {
        return new JLabel("<html>" + this.name + "." + (this.m_changedGroups != null ? " Accepting the change replaces the complete groups tree with the externally modified groups tree." : "") + "</html>");
    }
}

