/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.InfoPane;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertString;

public class StringAddChange
extends Change {
    BibtexString string;
    InfoPane tp = new InfoPane();
    JScrollPane sp = new JScrollPane(this.tp);

    public StringAddChange(BibtexString bibtexString) {
        this.name = Globals.lang("Added string") + ": '" + bibtexString.getName() + "'";
        this.string = bibtexString;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<HTML><H2>");
        stringBuffer.append(Globals.lang("Added string"));
        stringBuffer.append("</H2><H3>");
        stringBuffer.append(Globals.lang("Label")).append(":</H3>");
        stringBuffer.append(bibtexString.getName());
        stringBuffer.append("<H3>");
        stringBuffer.append(Globals.lang("Content")).append(":</H3>");
        stringBuffer.append(bibtexString.getContent());
        stringBuffer.append("</HTML>");
        this.tp.setText(stringBuffer.toString());
    }

    public void makeChange(BasePanel basePanel, NamedCompound namedCompound) {
        if (basePanel.database().hasStringLabel(this.string.getName())) {
            Globals.logger("Cannot add string '" + this.string.getName() + "' because the name " + "is already in use.");
        }
        try {
            basePanel.database().addString(this.string);
            namedCompound.addEdit(new UndoableInsertString(basePanel, basePanel.database(), this.string));
        }
        catch (KeyCollisionException keyCollisionException) {
            Globals.logger("Error: could not add string '" + this.string.getName() + "': " + keyCollisionException.getMessage());
        }
    }

    JComponent description() {
        return this.sp;
    }
}

