/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.export.ExportFileFilter;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.export.SaveException;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.export.VerifyingWriter;
import net.sf.jabref.export.layout.Layout;
import net.sf.jabref.export.layout.LayoutHelper;

public class ExportFormat {
    private String displayName;
    private String consoleName;
    private String lfFileName;
    private String directory;
    private String extension;
    private FileFilter fileFilter;
    private boolean customExport = false;

    public ExportFormat(String string, String string2, String string3, String string4, String string5) {
        this.displayName = string;
        this.consoleName = string2;
        this.lfFileName = string3;
        this.directory = string4;
        this.extension = string5;
        this.fileFilter = new ExportFileFilter(this);
    }

    public void setCustomExport(boolean bl) {
        this.customExport = bl;
    }

    public String getConsoleName() {
        return this.consoleName;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void performExport(BibtexDatabase bibtexDatabase, String string, String string2, Set set) throws Exception {
        Object object;
        Object object2;
        Reader reader;
        File file = new File(string);
        SaveSession saveSession = this.getSaveSession(string2, file);
        String string3 = this.customExport ? "" : (this.directory == null ? "/resource/layout/" : "/resource/layout/" + this.directory + "/");
        VerifyingWriter verifyingWriter = saveSession.getWriter();
        Layout layout = null;
        try {
            reader = FileActions.getReader(string3 + this.lfFileName + ".begin.layout");
            object2 = new LayoutHelper(reader);
            layout = ((LayoutHelper)object2).getLayoutFromText("net.sf.jabref.export.layout.format.");
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (layout != null) {
            verifyingWriter.write(layout.doLayout(bibtexDatabase));
        }
        object2 = FileActions.getSortedEntries(bibtexDatabase, set, false);
        reader = FileActions.getReader(string3 + this.lfFileName + ".layout");
        LayoutHelper layoutHelper = new LayoutHelper(reader);
        Layout layout2 = layoutHelper.getLayoutFromText("net.sf.jabref.export.layout.format.");
        reader.close();
        HashMap<String, Layout> hashMap = new HashMap<String, Layout>();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            Layout layout3;
            object = (BibtexEntry)iterator.next();
            String string4 = ((BibtexEntry)object).getType().getName().toLowerCase();
            if (hashMap.containsKey(string4)) {
                layout3 = (Layout)hashMap.get(string4);
            } else {
                try {
                    reader = FileActions.getReader(string3 + this.lfFileName + "." + string4 + ".layout");
                    layoutHelper = new LayoutHelper(reader);
                    layout3 = layoutHelper.getLayoutFromText("net.sf.jabref.export.layout.format.");
                    hashMap.put(string4, layout3);
                    reader.close();
                }
                catch (IOException iOException) {
                    layout3 = layout2;
                }
            }
            verifyingWriter.write(layout3.doLayout((BibtexEntry)object, bibtexDatabase));
        }
        object = null;
        try {
            reader = FileActions.getReader(string3 + this.lfFileName + ".end.layout");
            layoutHelper = new LayoutHelper(reader);
            object = layoutHelper.getLayoutFromText("net.sf.jabref.export.layout.format.");
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (object != null) {
            verifyingWriter.write(((Layout)object).doLayout(bibtexDatabase));
        }
        this.finalizeSaveSession(saveSession);
    }

    public SaveSession getSaveSession(String string, File file) throws IOException {
        SaveSession saveSession = new SaveSession(file, string, false);
        return saveSession;
    }

    public void finalizeSaveSession(SaveSession saveSession) throws Exception, SaveException {
        saveSession.getWriter().flush();
        saveSession.getWriter().close();
        if (!saveSession.getWriter().couldEncodeAll()) {
            System.err.println("Could not encode...");
        }
        saveSession.commit();
    }

    public FileFilter getFileFilter() {
        return this.fileFilter;
    }
}

