/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public class RtfSelection
implements Transferable {
    DataFlavor rtfFlavor;
    DataFlavor[] supportedFlavors;
    private String content;

    public RtfSelection(String string) {
        this.content = string;
        try {
            this.rtfFlavor = new DataFlavor("text/rtf; class=java.io.InputStream");
            this.supportedFlavors = new DataFlavor[]{this.rtfFlavor, DataFlavor.stringFlavor};
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(this.rtfFlavor) || dataFlavor.equals(DataFlavor.stringFlavor);
    }

    public DataFlavor[] getTransferDataFlavors() {
        return this.supportedFlavors;
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            return this.content;
        }
        if (dataFlavor.equals(this.rtfFlavor)) {
            byte[] byArray = this.content.getBytes();
            return new ByteArrayInputStream(byArray);
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

