/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.undo.NamedCompound;

public class AddToGroupAction
extends AbstractAction {
    protected GroupTreeNode m_node;
    protected final boolean m_move;
    protected BasePanel m_panel;

    public AddToGroupAction(GroupTreeNode groupTreeNode, boolean bl, BasePanel basePanel) {
        super(groupTreeNode.getGroup().getName());
        this.m_node = groupTreeNode;
        this.m_move = bl;
        this.m_panel = basePanel;
    }

    public AddToGroupAction(boolean bl) {
        super(Globals.lang(bl ? "Assign entry selection exclusively to this group" : "Add entry selection to this group"));
        this.m_move = bl;
    }

    public void setBasePanel(BasePanel basePanel) {
        this.m_panel = basePanel;
    }

    public void setNode(GroupTreeNode groupTreeNode) {
        this.m_node = groupTreeNode;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Serializable serializable;
        Object object2;
        BibtexEntry[] bibtexEntryArray = this.m_panel.getSelectedEntries();
        Vector<GroupTreeNode> vector = new Vector<GroupTreeNode>();
        if (this.m_move) {
            object2 = ((GroupTreeNode)this.m_node.getRoot()).preorderEnumeration();
            while (object2.hasMoreElements()) {
                serializable = (GroupTreeNode)object2.nextElement();
                if (!serializable.getGroup().supportsRemove()) continue;
                for (int i = 0; i < bibtexEntryArray.length; ++i) {
                    if (!serializable.getGroup().contains(bibtexEntryArray[i])) continue;
                    vector.add((GroupTreeNode)serializable);
                }
            }
            object = new AbstractGroup[vector.size() + 1];
            for (int i = 0; i < vector.size(); ++i) {
                object[i] = ((GroupTreeNode)vector.elementAt(i)).getGroup();
            }
            object[((AbstractGroup[])object).length - 1] = this.m_node.getGroup();
            if (!Util.warnAssignmentSideEffects((AbstractGroup[])object, bibtexEntryArray, this.m_panel.getDatabase(), this.m_panel.frame())) {
                return;
            }
        } else if (!Util.warnAssignmentSideEffects(new AbstractGroup[]{this.m_node.getGroup()}, bibtexEntryArray, this.m_panel.getDatabase(), this.m_panel.frame())) {
            return;
        }
        this.m_panel.storeCurrentEdit();
        object2 = new NamedCompound(Globals.lang("change assignment of entries"));
        if (this.m_move) {
            for (int i = 0; i < vector.size(); ++i) {
                object = (GroupTreeNode)vector.elementAt(i);
                if (!((GroupTreeNode)object).getGroup().containsAny(bibtexEntryArray)) continue;
                ((CompoundEdit)object2).addEdit(((GroupTreeNode)object).removeFromGroup(bibtexEntryArray));
            }
            AbstractUndoableEdit abstractUndoableEdit = this.m_node.addToGroup(bibtexEntryArray);
            if (abstractUndoableEdit != null) {
                ((CompoundEdit)object2).addEdit(abstractUndoableEdit);
            }
        } else {
            serializable = this.m_node.addToGroup(bibtexEntryArray);
            if (serializable == null) {
                return;
            }
            ((CompoundEdit)object2).addEdit((UndoableEdit)((Object)serializable));
        }
        ((CompoundEdit)object2).end();
        this.m_panel.undoManager.addEdit((UndoableEdit)object2);
        this.m_panel.markBaseChanged();
        this.m_panel.updateEntryEditorIfShowing();
        this.m_panel.getGroupSelector().valueChanged(null);
    }
}

