/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.util.Map;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.SearchRule;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.UnsupportedVersionException;

public class AllEntriesGroup
extends AbstractGroup
implements SearchRule {
    public static final String ID = "AllEntriesGroup:";

    public AllEntriesGroup() {
        super(Globals.lang("All Entries"), 0);
    }

    public static AbstractGroup fromString(String string, BibtexDatabase bibtexDatabase, int n) throws Exception {
        if (!string.startsWith(ID)) {
            throw new Exception("Internal error: AllEntriesGroup cannot be created from \"" + string + "\". " + "Please report this on www.sf.net/projects/jabref");
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return new AllEntriesGroup();
            }
        }
        throw new UnsupportedVersionException("AllEntriesGroup", n);
    }

    public SearchRule getSearchRule() {
        return this;
    }

    public boolean supportsAdd() {
        return false;
    }

    public boolean supportsRemove() {
        return false;
    }

    public AbstractUndoableEdit add(BibtexEntry[] bibtexEntryArray) {
        return null;
    }

    public AbstractUndoableEdit remove(BibtexEntry[] bibtexEntryArray) {
        return null;
    }

    public boolean contains(Map map, BibtexEntry bibtexEntry) {
        return true;
    }

    public AbstractGroup deepCopy() {
        return new AllEntriesGroup();
    }

    public int applyRule(Map map, BibtexEntry bibtexEntry) {
        return 1;
    }

    public boolean equals(Object object) {
        return object instanceof AllEntriesGroup;
    }

    public String toString() {
        return ID;
    }

    public boolean contains(BibtexEntry bibtexEntry) {
        return true;
    }

    public boolean isDynamic() {
        return false;
    }

    public String getDescription() {
        return "This group contains all entries. It cannot be edited or removed.";
    }

    public String getShortDescription() {
        return "<b>All Entries</b> (this group cannot be edited or removed)";
    }
}

