/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.ErrorMessageDisplay;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.SearchRule;
import net.sf.jabref.SearchRuleSet;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.groups.AbstractGroup;
import net.sf.jabref.groups.AddToGroupAction;
import net.sf.jabref.groups.AllEntriesGroup;
import net.sf.jabref.groups.AndOrSearchRuleSet;
import net.sf.jabref.groups.AutoGroupDialog;
import net.sf.jabref.groups.GroupDialog;
import net.sf.jabref.groups.GroupMatcher;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.GroupsTree;
import net.sf.jabref.groups.RemoveFromGroupAction;
import net.sf.jabref.groups.UndoableAddOrRemoveGroup;
import net.sf.jabref.groups.UndoableModifyGroup;
import net.sf.jabref.groups.UndoableModifySubtree;
import net.sf.jabref.undo.NamedCompound;

public class GroupSelector
extends SidePaneComponent
implements TreeSelectionListener,
ActionListener,
ErrorMessageDisplay {
    JButton newButton = new JButton(GUIGlobals.getImage("new"));
    JButton helpButton = new JButton(GUIGlobals.getImage("help"));
    JButton refresh = new JButton(GUIGlobals.getImage("refresh"));
    JButton autoGroup = new JButton(GUIGlobals.getImage("autoGroup"));
    JButton openset = new JButton(Globals.lang("Settings"));
    Color bgColor = Color.white;
    GroupsTree groupsTree;
    DefaultTreeModel groupsTreeModel;
    GroupTreeNode groupsRoot;
    JScrollPane sp;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JabRefFrame frame;
    String searchField;
    JPopupMenu groupsContextMenu = new JPopupMenu();
    JPopupMenu settings = new JPopupMenu();
    private JRadioButtonMenuItem hideNonHits;
    private JRadioButtonMenuItem grayOut;
    JRadioButtonMenuItem andCb = new JRadioButtonMenuItem(Globals.lang("Intersection"), true);
    JRadioButtonMenuItem orCb = new JRadioButtonMenuItem(Globals.lang("Union"), false);
    JRadioButtonMenuItem floatCb = new JRadioButtonMenuItem(Globals.lang("Float"), true);
    JRadioButtonMenuItem highlCb = new JRadioButtonMenuItem(Globals.lang("Highlight"), false);
    JCheckBoxMenuItem invCb = new JCheckBoxMenuItem(Globals.lang("Inverted"), false);
    JCheckBoxMenuItem select = new JCheckBoxMenuItem(Globals.lang("Select matches"), false);
    JCheckBoxMenuItem showOverlappingGroups = new JCheckBoxMenuItem(Globals.lang("Highlight overlapping groups"));
    ButtonGroup bgr = new ButtonGroup();
    ButtonGroup visMode = new ButtonGroup();
    ButtonGroup nonHits = new ButtonGroup();
    JButton expand = new JButton(GUIGlobals.getImage("down"));
    JButton reduce = new JButton(GUIGlobals.getImage("up"));
    SidePaneManager manager;
    final AbstractAction editGroupAction = new EditGroupAction();
    final NodeAction editGroupPopupAction = new EditGroupAction();
    final NodeAction addGroupPopupAction = new AddGroupAction();
    final NodeAction addSubgroupPopupAction = new AddSubgroupAction();
    final NodeAction removeGroupAndSubgroupsPopupAction = new RemoveGroupAndSubgroupsAction();
    final NodeAction removeSubgroupsPopupAction = new RemoveSubgroupsAction();
    final NodeAction removeGroupKeepSubgroupsPopupAction = new RemoveGroupKeepSubgroupsAction();
    final NodeAction moveNodeUpPopupAction = new MoveNodeUpAction();
    final NodeAction moveNodeDownPopupAction = new MoveNodeDownAction();
    final NodeAction moveNodeLeftPopupAction = new MoveNodeLeftAction();
    final NodeAction moveNodeRightPopupAction = new MoveNodeRightAction();
    final NodeAction moveNodeUpAction = new MoveNodeUpAction();
    final NodeAction moveNodeDownAction = new MoveNodeDownAction();
    final NodeAction moveNodeLeftAction = new MoveNodeLeftAction();
    final NodeAction moveNodeRightAction = new MoveNodeRightAction();
    final NodeAction expandSubtreePopupAction = new ExpandSubtreeAction();
    final NodeAction collapseSubtreePopupAction = new CollapseSubtreeAction();
    final NodeAction sortDirectSubgroupsPopupAction = new SortDirectSubgroupsAction();
    final NodeAction sortAllSubgroupsPopupAction = new SortAllSubgroupsAction();
    final AddToGroupAction addToGroup = new AddToGroupAction(false);
    final AddToGroupAction moveToGroup = new AddToGroupAction(true);
    final RemoveFromGroupAction removeFromGroup = new RemoveFromGroupAction();
    public final AbstractAction clearHighlightAction = new AbstractAction(Globals.lang("Clear highlight")){

        public void actionPerformed(ActionEvent actionEvent) {
            GroupSelector.this.groupsTree.setHighlight3Cells(null);
        }
    };
    JMenu moveSubmenu = new JMenu(Globals.lang("Move"));
    JMenu sortSubmenu = new JMenu(Globals.lang("Sort alphabetically"));

    public GroupSelector(JabRefFrame jabRefFrame, SidePaneManager sidePaneManager) {
        super(sidePaneManager, GUIGlobals.getIconUrl("toggleGroups"), Globals.lang("Groups"));
        this.groupsRoot = new GroupTreeNode(new AllEntriesGroup());
        this.manager = sidePaneManager;
        this.frame = jabRefFrame;
        this.hideNonHits = new JRadioButtonMenuItem(Globals.lang("Hide non-hits"), !Globals.prefs.getBoolean("grayOutNonHits"));
        this.grayOut = new JRadioButtonMenuItem(Globals.lang("Gray out non-hits"), Globals.prefs.getBoolean("grayOutNonHits"));
        this.nonHits.add(this.hideNonHits);
        this.nonHits.add(this.grayOut);
        this.floatCb.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Globals.prefs.putBoolean("groupFloatSelections", GroupSelector.this.floatCb.isSelected());
            }
        });
        this.andCb.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Globals.prefs.putBoolean("groupIntersectSelections", GroupSelector.this.andCb.isSelected());
            }
        });
        this.invCb.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Globals.prefs.putBoolean("groupInvertSelections", GroupSelector.this.invCb.isSelected());
            }
        });
        this.showOverlappingGroups.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Globals.prefs.putBoolean("groupShowOverlapping", GroupSelector.this.showOverlappingGroups.isSelected());
                if (!GroupSelector.this.showOverlappingGroups.isSelected()) {
                    GroupSelector.this.groupsTree.setHighlight2Cells(null);
                }
            }
        });
        this.select.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Globals.prefs.putBoolean("groupSelectMatches", GroupSelector.this.select.isSelected());
            }
        });
        this.grayOut.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Globals.prefs.putBoolean("grayOutNonHits", GroupSelector.this.grayOut.isSelected());
            }
        });
        if (Globals.prefs.getBoolean("groupFloatSelections")) {
            this.floatCb.setSelected(true);
            this.highlCb.setSelected(false);
        } else {
            this.highlCb.setSelected(true);
            this.floatCb.setSelected(false);
        }
        if (Globals.prefs.getBoolean("groupIntersectSelections")) {
            this.andCb.setSelected(true);
            this.orCb.setSelected(false);
        } else {
            this.orCb.setSelected(true);
            this.andCb.setSelected(false);
        }
        this.invCb.setSelected(Globals.prefs.getBoolean("groupInvertSelections"));
        this.showOverlappingGroups.setSelected(Globals.prefs.getBoolean("groupShowOverlapping"));
        this.select.setSelected(Globals.prefs.getBoolean("groupSelectMatches"));
        this.openset.setMargin(new Insets(0, 0, 0, 0));
        this.settings.add(this.andCb);
        this.settings.add(this.orCb);
        this.settings.addSeparator();
        this.settings.add(this.invCb);
        this.settings.addSeparator();
        this.settings.add(this.select);
        this.settings.addSeparator();
        this.settings.add(this.grayOut);
        this.settings.add(this.hideNonHits);
        this.settings.addSeparator();
        this.settings.add(this.showOverlappingGroups);
        this.openset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!GroupSelector.this.settings.isVisible()) {
                    JButton jButton = (JButton)actionEvent.getSource();
                    GroupSelector.this.settings.show(jButton, 0, GroupSelector.this.openset.getHeight());
                }
            }
        });
        this.expand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Globals.prefs.getInt("groupsVisibleRows") + 1;
                GroupSelector.this.groupsTree.setVisibleRowCount(n);
                GroupSelector.this.groupsTree.revalidate();
                GroupSelector.this.groupsTree.repaint();
                GroupSelector.this.revalidate();
                GroupSelector.this.repaint();
                Globals.prefs.putInt("groupsVisibleRows", n);
                System.out.println(GroupSelector.this.getHeight());
                System.out.println(GroupSelector.this.getPreferredSize().getHeight());
            }
        });
        this.reduce.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Globals.prefs.getInt("groupsVisibleRows") - 1;
                if (n < 1) {
                    n = 1;
                }
                GroupSelector.this.groupsTree.setVisibleRowCount(n);
                GroupSelector.this.groupsTree.revalidate();
                GroupSelector.this.groupsTree.repaint();
                GroupSelector.this.revalidate();
                GroupSelector.this.repaint();
                Globals.prefs.putInt("groupsVisibleRows", n);
            }
        });
        int n = this.newButton.getIcon().getIconHeight() + 5;
        Dimension dimension = new Dimension(n, n);
        this.newButton.setPreferredSize(dimension);
        this.newButton.setMinimumSize(dimension);
        this.refresh.setPreferredSize(dimension);
        this.refresh.setMinimumSize(dimension);
        this.helpButton.setPreferredSize(dimension);
        this.helpButton.setMinimumSize(dimension);
        this.autoGroup.setPreferredSize(dimension);
        this.autoGroup.setMinimumSize(dimension);
        this.openset.setPreferredSize(dimension);
        this.openset.setMinimumSize(dimension);
        this.expand.setPreferredSize(dimension);
        this.expand.setMinimumSize(dimension);
        this.reduce.setPreferredSize(dimension);
        this.reduce.setMinimumSize(dimension);
        Insets insets = new Insets(0, 0, 0, 0);
        this.helpButton.setMargin(insets);
        this.reduce.setMargin(insets);
        this.expand.setMargin(insets);
        this.openset.setMargin(insets);
        this.newButton.addActionListener(this);
        this.refresh.addActionListener(this);
        this.andCb.addActionListener(this);
        this.orCb.addActionListener(this);
        this.invCb.addActionListener(this);
        this.showOverlappingGroups.addActionListener(this);
        this.autoGroup.addActionListener(this);
        this.floatCb.addActionListener(this);
        this.highlCb.addActionListener(this);
        this.select.addActionListener(this);
        this.hideNonHits.addActionListener(this);
        this.grayOut.addActionListener(this);
        this.newButton.setToolTipText(Globals.lang("New group"));
        this.refresh.setToolTipText(Globals.lang("Refresh view"));
        this.andCb.setToolTipText(Globals.lang("Display only entries belonging to all selected groups."));
        this.orCb.setToolTipText(Globals.lang("Display all entries belonging to one or more of the selected groups."));
        this.autoGroup.setToolTipText(Globals.lang("Automatically create groups for database."));
        this.invCb.setToolTipText(Globals.lang("Show entries *not* in group selection"));
        this.showOverlappingGroups.setToolTipText("Highlight groups that contain entries contained in any currently selected group");
        this.floatCb.setToolTipText(Globals.lang("Move entries in group selection to the top"));
        this.highlCb.setToolTipText(Globals.lang("Gray out entries not in group selection"));
        this.select.setToolTipText(Globals.lang("Select entries in group selection"));
        this.expand.setToolTipText(Globals.lang("Show one more row"));
        this.reduce.setToolTipText(Globals.lang("Show one less rows"));
        this.bgr.add(this.andCb);
        this.bgr.add(this.orCb);
        this.visMode.add(this.floatCb);
        this.visMode.add(this.highlCb);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.gbl);
        this.con.fill = 1;
        this.con.weightx = 1.0;
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.newButton, this.con);
        jPanel.add(this.newButton);
        this.gbl.setConstraints(this.refresh, this.con);
        jPanel.add(this.refresh);
        this.gbl.setConstraints(this.autoGroup, this.con);
        jPanel.add(this.autoGroup);
        this.con.gridwidth = 0;
        HelpAction helpAction = new HelpAction(jabRefFrame.helpDiag, GUIGlobals.groupsHelp, "Help on groups");
        this.helpButton.addActionListener(helpAction);
        this.helpButton.setToolTipText(Globals.lang("Help on groups"));
        this.gbl.setConstraints(this.helpButton, this.con);
        jPanel.add(this.helpButton);
        this.groupsTree = new GroupsTree(this);
        this.groupsTree.addTreeSelectionListener(this);
        this.groupsTreeModel = new DefaultTreeModel(this.groupsRoot);
        this.groupsTree.setModel(this.groupsTreeModel);
        this.sp = new JScrollPane(this.groupsTree, 20, 30);
        this.revalidateGroups();
        this.con.gridwidth = 0;
        this.con.weighty = 1.0;
        this.gbl.setConstraints(this.sp, this.con);
        jPanel.add(this.sp);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.con.weighty = 0.0;
        this.gbl.setConstraints(jPanel2, this.con);
        jPanel2.setLayout(gridBagLayout);
        this.con.weightx = 1.0;
        this.con.gridwidth = 1;
        gridBagLayout.setConstraints(this.openset, this.con);
        jPanel2.add(this.openset);
        this.con.weightx = 0.0;
        gridBagLayout.setConstraints(this.expand, this.con);
        jPanel2.add(this.expand);
        this.con.gridwidth = 0;
        gridBagLayout.setConstraints(this.reduce, this.con);
        jPanel2.add(this.reduce);
        jPanel.add(jPanel2);
        jPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add((Component)jPanel, "Center");
        this.definePopup();
        this.moveNodeUpAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 2));
        this.moveNodeDownAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 2));
        this.moveNodeLeftAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 2));
        this.moveNodeRightAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 2));
    }

    private void definePopup() {
        this.groupsContextMenu.add(this.editGroupPopupAction);
        this.groupsContextMenu.add(this.addGroupPopupAction);
        this.groupsContextMenu.add(this.addSubgroupPopupAction);
        this.groupsContextMenu.addSeparator();
        this.groupsContextMenu.add(this.removeGroupAndSubgroupsPopupAction);
        this.groupsContextMenu.add(this.removeGroupKeepSubgroupsPopupAction);
        this.groupsContextMenu.add(this.removeSubgroupsPopupAction);
        this.groupsContextMenu.addSeparator();
        this.groupsContextMenu.add(this.expandSubtreePopupAction);
        this.groupsContextMenu.add(this.collapseSubtreePopupAction);
        this.groupsContextMenu.addSeparator();
        this.groupsContextMenu.add(this.moveSubmenu);
        this.sortSubmenu.add(this.sortDirectSubgroupsPopupAction);
        this.sortSubmenu.add(this.sortAllSubgroupsPopupAction);
        this.groupsContextMenu.add(this.sortSubmenu);
        this.moveSubmenu.add(this.moveNodeUpPopupAction);
        this.moveSubmenu.add(this.moveNodeDownPopupAction);
        this.moveSubmenu.add(this.moveNodeLeftPopupAction);
        this.moveSubmenu.add(this.moveNodeRightPopupAction);
        this.groupsContextMenu.addSeparator();
        this.groupsContextMenu.add(this.addToGroup);
        this.groupsContextMenu.add(this.moveToGroup);
        this.groupsContextMenu.add(this.removeFromGroup);
        this.groupsTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    GroupSelector.this.showPopup(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    GroupSelector.this.showPopup(mouseEvent);
                }
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath = GroupSelector.this.groupsTree.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                if (treePath == null) {
                    return;
                }
                GroupTreeNode groupTreeNode = (GroupTreeNode)treePath.getLastPathComponent();
                if (groupTreeNode.isRoot()) {
                    return;
                }
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    GroupSelector.this.editGroupAction.actionPerformed(null);
                }
            }
        });
        this.groupsContextMenu.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                GroupSelector.this.groupsTree.setHighlightBorderCell(null);
            }

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                GroupSelector.this.groupsTree.setHighlightBorderCell(null);
            }
        });
    }

    private void showPopup(MouseEvent mouseEvent) {
        TreePath treePath = this.groupsTree.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        this.addGroupPopupAction.setEnabled(true);
        this.addSubgroupPopupAction.setEnabled(treePath != null);
        this.editGroupPopupAction.setEnabled(treePath != null);
        this.removeGroupAndSubgroupsPopupAction.setEnabled(treePath != null);
        this.removeGroupKeepSubgroupsPopupAction.setEnabled(treePath != null);
        this.moveSubmenu.setEnabled(treePath != null);
        this.expandSubtreePopupAction.setEnabled(treePath != null);
        this.collapseSubtreePopupAction.setEnabled(treePath != null);
        this.removeSubgroupsPopupAction.setEnabled(treePath != null);
        this.sortSubmenu.setEnabled(treePath != null);
        this.addToGroup.setEnabled(false);
        this.moveToGroup.setEnabled(false);
        this.removeFromGroup.setEnabled(false);
        if (treePath != null) {
            GroupTreeNode groupTreeNode = (GroupTreeNode)treePath.getLastPathComponent();
            this.editGroupPopupAction.setNode(groupTreeNode);
            this.addSubgroupPopupAction.setNode(groupTreeNode);
            this.removeGroupAndSubgroupsPopupAction.setNode(groupTreeNode);
            this.removeSubgroupsPopupAction.setNode(groupTreeNode);
            this.removeGroupKeepSubgroupsPopupAction.setNode(groupTreeNode);
            this.expandSubtreePopupAction.setNode(groupTreeNode);
            this.collapseSubtreePopupAction.setNode(groupTreeNode);
            this.sortDirectSubgroupsPopupAction.setNode(groupTreeNode);
            this.sortAllSubgroupsPopupAction.setNode(groupTreeNode);
            this.groupsTree.setHighlightBorderCell(groupTreeNode);
            AbstractGroup abstractGroup = groupTreeNode.getGroup();
            if (abstractGroup instanceof AllEntriesGroup) {
                this.editGroupPopupAction.setEnabled(false);
                this.addGroupPopupAction.setEnabled(false);
                this.removeGroupAndSubgroupsPopupAction.setEnabled(false);
                this.removeGroupKeepSubgroupsPopupAction.setEnabled(false);
            } else {
                this.editGroupPopupAction.setEnabled(true);
                this.addGroupPopupAction.setEnabled(true);
                this.addGroupPopupAction.setNode(groupTreeNode);
                this.removeGroupAndSubgroupsPopupAction.setEnabled(true);
                this.removeGroupKeepSubgroupsPopupAction.setEnabled(true);
            }
            this.expandSubtreePopupAction.setEnabled(this.groupsTree.isCollapsed(treePath) || this.groupsTree.hasCollapsedDescendant(treePath));
            this.collapseSubtreePopupAction.setEnabled(this.groupsTree.isExpanded(treePath) || this.groupsTree.hasExpandedDescendant(treePath));
            this.sortSubmenu.setEnabled(!groupTreeNode.isLeaf());
            this.removeSubgroupsPopupAction.setEnabled(!groupTreeNode.isLeaf());
            this.moveNodeUpPopupAction.setEnabled(groupTreeNode.canMoveUp());
            this.moveNodeDownPopupAction.setEnabled(groupTreeNode.canMoveDown());
            this.moveNodeLeftPopupAction.setEnabled(groupTreeNode.canMoveLeft());
            this.moveNodeRightPopupAction.setEnabled(groupTreeNode.canMoveRight());
            this.moveSubmenu.setEnabled(this.moveNodeUpPopupAction.isEnabled() || this.moveNodeDownPopupAction.isEnabled() || this.moveNodeLeftPopupAction.isEnabled() || this.moveNodeRightPopupAction.isEnabled());
            this.moveNodeUpPopupAction.setNode(groupTreeNode);
            this.moveNodeDownPopupAction.setNode(groupTreeNode);
            this.moveNodeLeftPopupAction.setNode(groupTreeNode);
            this.moveNodeRightPopupAction.setNode(groupTreeNode);
            BibtexEntry[] bibtexEntryArray = this.frame.basePanel().getSelectedEntries();
            if (bibtexEntryArray.length > 0) {
                if (groupTreeNode.getGroup().supportsAdd() && !groupTreeNode.getGroup().containsAll(bibtexEntryArray)) {
                    this.addToGroup.setNode(groupTreeNode);
                    this.addToGroup.setBasePanel(this.panel);
                    this.addToGroup.setEnabled(true);
                    this.moveToGroup.setNode(groupTreeNode);
                    this.moveToGroup.setBasePanel(this.panel);
                    this.moveToGroup.setEnabled(true);
                }
                if (groupTreeNode.getGroup().supportsRemove() && groupTreeNode.getGroup().containsAny(bibtexEntryArray)) {
                    this.removeFromGroup.setNode(groupTreeNode);
                    this.removeFromGroup.setBasePanel(this.panel);
                    this.removeFromGroup.setEnabled(true);
                }
            }
        } else {
            this.editGroupPopupAction.setNode(null);
            this.addGroupPopupAction.setNode(null);
            this.addSubgroupPopupAction.setNode(null);
            this.removeGroupAndSubgroupsPopupAction.setNode(null);
            this.removeSubgroupsPopupAction.setNode(null);
            this.removeGroupKeepSubgroupsPopupAction.setNode(null);
            this.moveNodeUpPopupAction.setNode(null);
            this.moveNodeDownPopupAction.setNode(null);
            this.moveNodeLeftPopupAction.setNode(null);
            this.moveNodeRightPopupAction.setNode(null);
            this.expandSubtreePopupAction.setNode(null);
            this.collapseSubtreePopupAction.setNode(null);
            this.sortDirectSubgroupsPopupAction.setNode(null);
            this.sortAllSubgroupsPopupAction.setNode(null);
        }
        this.groupsContextMenu.show(this.groupsTree, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.panel == null) {
            return;
        }
        TreePath[] treePathArray = this.groupsTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0 || treePathArray.length == 1 && ((GroupTreeNode)treePathArray[0].getLastPathComponent()).getGroup() instanceof AllEntriesGroup) {
            this.panel.stopShowingGroup();
            this.panel.mainTable.stopShowingFloatGrouping();
            if (this.showOverlappingGroups.isSelected()) {
                this.groupsTree.setHighlight2Cells(null);
            }
            this.frame.output(Globals.lang("Displaying no groups") + ".");
            return;
        }
        AndOrSearchRuleSet andOrSearchRuleSet = new AndOrSearchRuleSet(this.andCb.isSelected(), this.invCb.isSelected());
        for (int i = 0; i < treePathArray.length; ++i) {
            andOrSearchRuleSet.addRule(((GroupTreeNode)treePathArray[i].getLastPathComponent()).getSearchRule());
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("option", "dummy");
        GroupingWorker groupingWorker = new GroupingWorker(andOrSearchRuleSet, hashtable);
        groupingWorker.getWorker().run();
        groupingWorker.getCallBack().update();
    }

    public void revalidateGroups(TreePath[] treePathArray, Enumeration enumeration) {
        this.revalidateGroups(treePathArray, enumeration, null);
    }

    public void revalidateGroups(TreePath[] treePathArray, Enumeration enumeration, GroupTreeNode groupTreeNode) {
        this.groupsTreeModel.reload();
        this.groupsTree.clearSelection();
        if (treePathArray != null) {
            this.groupsTree.setSelectionPaths(treePathArray);
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                this.groupsTree.expandPath((TreePath)enumeration.nextElement());
            }
        }
        this.groupsTree.revalidate();
        if (groupTreeNode != null) {
            this.groupsTree.scrollPathToVisible(new TreePath(groupTreeNode.getPath()));
        }
    }

    public void revalidateGroups() {
        this.revalidateGroups(null);
    }

    public void revalidateGroups(GroupTreeNode groupTreeNode) {
        this.revalidateGroups(this.groupsTree.getSelectionPaths(), this.getExpandedPaths(), groupTreeNode);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.refresh) {
            this.valueChanged(null);
        } else if (actionEvent.getSource() == this.newButton) {
            GroupDialog groupDialog = new GroupDialog(this.frame, this.panel, null);
            groupDialog.setVisible(true);
            if (groupDialog.okPressed()) {
                AbstractGroup abstractGroup = groupDialog.getResultingGroup();
                GroupTreeNode groupTreeNode = new GroupTreeNode(abstractGroup);
                this.groupsRoot.add(groupTreeNode);
                this.revalidateGroups();
                UndoableAddOrRemoveGroup undoableAddOrRemoveGroup = new UndoableAddOrRemoveGroup(this, this.groupsRoot, groupTreeNode, 0);
                this.panel.undoManager.addEdit(undoableAddOrRemoveGroup);
                this.panel.markBaseChanged();
                this.frame.output(Globals.lang("Created_group_\"%0\".", abstractGroup.getName()));
            }
        } else if (actionEvent.getSource() == this.autoGroup) {
            AutoGroupDialog autoGroupDialog = new AutoGroupDialog(this.frame, this.panel, this, this.groupsRoot, Globals.prefs.get("groupsDefaultField"), " .,", ",");
            autoGroupDialog.setVisible(true);
        } else if (actionEvent.getSource() instanceof JCheckBox) {
            this.valueChanged(null);
        } else if (actionEvent.getSource() instanceof JCheckBoxMenuItem) {
            this.valueChanged(null);
        } else if (actionEvent.getSource() instanceof JRadioButtonMenuItem) {
            this.valueChanged(null);
        }
    }

    public void componentOpening() {
        this.valueChanged(null);
    }

    public void componentClosing() {
        if (this.panel != null) {
            this.panel.stopShowingGroup();
            this.panel.mainTable.stopShowingFloatGrouping();
        }
        this.frame.groupToggle.setSelected(false);
    }

    public void setGroups(GroupTreeNode groupTreeNode) {
        this.groupsTreeModel = new DefaultTreeModel(groupTreeNode);
        this.groupsTree.setModel(this.groupsTreeModel);
        this.groupsRoot = groupTreeNode;
        if (Globals.prefs.getBoolean("groupExpandTree")) {
            this.groupsTree.expandSubtree(groupTreeNode);
        }
    }

    public void addGroups(GroupTreeNode groupTreeNode, CompoundEdit compoundEdit) {
        if (groupTreeNode.getGroup() instanceof AllEntriesGroup) {
            return;
        }
        this.groupsRoot.add(groupTreeNode);
        UndoableAddOrRemoveGroup undoableAddOrRemoveGroup = new UndoableAddOrRemoveGroup(this, this.groupsRoot, groupTreeNode, 0);
        compoundEdit.addEdit(undoableAddOrRemoveGroup);
    }

    public TreePath getSelectionPath() {
        return this.groupsTree.getSelectionPath();
    }

    public boolean moveNodeUp(GroupTreeNode groupTreeNode, boolean bl) {
        if (bl && this.groupsTree.getSelectionCount() != 1) {
            this.frame.output(Globals.lang("Please select exactly one group to move."));
            return false;
        }
        AbstractUndoableEdit abstractUndoableEdit = null;
        if (!groupTreeNode.canMoveUp() || (abstractUndoableEdit = groupTreeNode.moveUp(this)) == null) {
            this.frame.output(Globals.lang("Cannot move group \"%0\" up.", groupTreeNode.getGroup().getName()));
            return false;
        }
        this.revalidateGroups(this.groupsTree.refreshPaths(this.groupsTree.getSelectionPaths()), this.groupsTree.refreshPaths(this.getExpandedPaths()));
        this.concludeMoveGroup(abstractUndoableEdit, groupTreeNode);
        return true;
    }

    public boolean moveNodeDown(GroupTreeNode groupTreeNode, boolean bl) {
        if (bl && this.groupsTree.getSelectionCount() != 1) {
            this.frame.output(Globals.lang("Please select exactly one group to move."));
            return false;
        }
        AbstractUndoableEdit abstractUndoableEdit = null;
        if (!groupTreeNode.canMoveDown() || (abstractUndoableEdit = groupTreeNode.moveDown(this)) == null) {
            this.frame.output(Globals.lang("Cannot move group \"%0\" down.", groupTreeNode.getGroup().getName()));
            return false;
        }
        this.revalidateGroups(this.groupsTree.refreshPaths(this.groupsTree.getSelectionPaths()), this.groupsTree.refreshPaths(this.getExpandedPaths()));
        this.concludeMoveGroup(abstractUndoableEdit, groupTreeNode);
        return true;
    }

    public boolean moveNodeLeft(GroupTreeNode groupTreeNode, boolean bl) {
        if (bl && this.groupsTree.getSelectionCount() != 1) {
            this.frame.output(Globals.lang("Please select exactly one group to move."));
            return false;
        }
        AbstractUndoableEdit abstractUndoableEdit = null;
        if (!groupTreeNode.canMoveLeft() || (abstractUndoableEdit = groupTreeNode.moveLeft(this)) == null) {
            this.frame.output(Globals.lang("Cannot move group \"%0\" left.", groupTreeNode.getGroup().getName()));
            return false;
        }
        this.revalidateGroups(this.groupsTree.refreshPaths(this.groupsTree.getSelectionPaths()), this.groupsTree.refreshPaths(this.getExpandedPaths()));
        this.concludeMoveGroup(abstractUndoableEdit, groupTreeNode);
        return true;
    }

    public boolean moveNodeRight(GroupTreeNode groupTreeNode, boolean bl) {
        if (bl && this.groupsTree.getSelectionCount() != 1) {
            this.frame.output(Globals.lang("Please select exactly one group to move."));
            return false;
        }
        AbstractUndoableEdit abstractUndoableEdit = null;
        if (!groupTreeNode.canMoveRight() || (abstractUndoableEdit = groupTreeNode.moveRight(this)) == null) {
            this.frame.output(Globals.lang("Cannot move group \"%0\" right.", groupTreeNode.getGroup().getName()));
            return false;
        }
        this.revalidateGroups(this.groupsTree.refreshPaths(this.groupsTree.getSelectionPaths()), this.groupsTree.refreshPaths(this.getExpandedPaths()));
        this.concludeMoveGroup(abstractUndoableEdit, groupTreeNode);
        return true;
    }

    public void concludeMoveGroup(AbstractUndoableEdit abstractUndoableEdit, GroupTreeNode groupTreeNode) {
        this.panel.undoManager.addEdit(abstractUndoableEdit);
        this.panel.markBaseChanged();
        this.frame.output(Globals.lang("Moved group \"%0\".", groupTreeNode.getGroup().getName()));
    }

    public void concludeAssignment(AbstractUndoableEdit abstractUndoableEdit, GroupTreeNode groupTreeNode, int n) {
        if (abstractUndoableEdit == null) {
            this.frame.output(Globals.lang("The group \"%0\" already contains the selection.", new String[]{groupTreeNode.getGroup().getName()}));
            return;
        }
        this.panel.undoManager.addEdit(abstractUndoableEdit);
        this.panel.markBaseChanged();
        this.panel.updateEntryEditorIfShowing();
        String string = groupTreeNode.getGroup().getName();
        if (n == 1) {
            this.frame.output(Globals.lang("Assigned 1 entry to group \"%0\".", string));
        } else {
            this.frame.output(Globals.lang("Assigned %0 entries to group \"%1\".", String.valueOf(n), string));
        }
    }

    public GroupTreeNode getGroupTreeRoot() {
        return this.groupsRoot;
    }

    public Enumeration getExpandedPaths() {
        return this.groupsTree.getExpandedDescendants(new TreePath(this.groupsRoot.getPath()));
    }

    public void setActiveBasePanel(BasePanel basePanel) {
        super.setActiveBasePanel(basePanel);
        if (basePanel == null) {
            this.frame.sidePaneManager.hide("groups");
            return;
        }
        MetaData metaData = basePanel.metaData();
        if (metaData.getGroups() != null) {
            this.setGroups(metaData.getGroups());
        } else {
            GroupTreeNode groupTreeNode = new GroupTreeNode(new AllEntriesGroup());
            metaData.setGroups(groupTreeNode);
            this.setGroups(groupTreeNode);
        }
        if (Globals.prefs.getBoolean("groupAutoShow") && !this.groupsRoot.isLeaf()) {
            this.frame.sidePaneManager.show("groups");
            this.frame.groupToggle.setSelected(true);
        } else if (Globals.prefs.getBoolean("groupAutoHide") && this.groupsRoot.isLeaf()) {
            this.frame.sidePaneManager.hide("groups");
            this.frame.groupToggle.setSelected(false);
        }
        this.validateTree();
    }

    public void reportError(String string) {
        System.err.println("Error in group search: " + string + ". Please report this on www.sf.net/projects/jabref");
    }

    public void reportError(String string, Exception exception) {
        this.reportError(string);
    }

    public void showMatchingGroups(BibtexEntry[] bibtexEntryArray, boolean bl) {
        GroupTreeNode groupTreeNode;
        if (bibtexEntryArray == null || bibtexEntryArray.length == 0) {
            this.groupsTree.setHighlight3Cells(null);
            this.groupsTree.revalidate();
            return;
        }
        Vector<GroupTreeNode> vector = new Vector<GroupTreeNode>();
        Enumeration<TreeNode> enumeration = this.groupsRoot.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            int n;
            groupTreeNode = (GroupTreeNode)enumeration.nextElement();
            AbstractGroup abstractGroup = groupTreeNode.getGroup();
            for (n = 0; n < bibtexEntryArray.length; ++n) {
                if (bl) {
                    if (abstractGroup.contains(bibtexEntryArray[n])) continue;
                    break;
                }
                if (!abstractGroup.contains(bibtexEntryArray[n])) continue;
                vector.add(groupTreeNode);
            }
            if (!bl || n < bibtexEntryArray.length) continue;
            vector.add(groupTreeNode);
        }
        this.groupsTree.setHighlight3Cells(vector.toArray());
        for (int i = 0; i < vector.size(); ++i) {
            groupTreeNode = (GroupTreeNode)((GroupTreeNode)vector.elementAt(i)).getParent();
            if (groupTreeNode == null) continue;
            this.groupsTree.expandPath(new TreePath(groupTreeNode.getPath()));
        }
        this.groupsTree.revalidate();
    }

    protected void showOverlappingGroups(List list) {
        Vector<GroupTreeNode> vector = new Vector<GroupTreeNode>();
        HashMap hashMap = new HashMap();
        Enumeration<TreeNode> enumeration = this.groupsRoot.depthFirstEnumeration();
        block0: while (enumeration.hasMoreElements()) {
            GroupTreeNode groupTreeNode = (GroupTreeNode)enumeration.nextElement();
            SearchRule searchRule = groupTreeNode.getSearchRule();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
                if (searchRule.applyRule(hashMap, bibtexEntry) == 0) continue;
                vector.add(groupTreeNode);
                continue block0;
            }
        }
        this.groupsTree.setHighlight2Cells(vector.toArray());
    }

    private class MoveNodeRightAction
    extends NodeAction {
        public MoveNodeRightAction() {
            super(Globals.lang("Right"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            GroupSelector.this.moveNodeRight(groupTreeNode, false);
        }
    }

    private class MoveNodeLeftAction
    extends NodeAction {
        public MoveNodeLeftAction() {
            super(Globals.lang("Left"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            GroupSelector.this.moveNodeLeft(groupTreeNode, false);
        }
    }

    private class MoveNodeDownAction
    extends NodeAction {
        public MoveNodeDownAction() {
            super(Globals.lang("Down"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            GroupSelector.this.moveNodeDown(groupTreeNode, false);
        }
    }

    private class MoveNodeUpAction
    extends NodeAction {
        public MoveNodeUpAction() {
            super(Globals.lang("Up"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            GroupSelector.this.moveNodeUp(groupTreeNode, false);
        }
    }

    private class CollapseSubtreeAction
    extends NodeAction {
        public CollapseSubtreeAction() {
            super(Globals.lang("Collapse subtree"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            TreePath treePath = new TreePath(groupTreeNode.getPath());
            GroupSelector.this.groupsTree.collapseSubtree((GroupTreeNode)treePath.getLastPathComponent());
            GroupSelector.this.revalidateGroups();
        }
    }

    private class ExpandSubtreeAction
    extends NodeAction {
        public ExpandSubtreeAction() {
            super(Globals.lang("Expand subtree"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            TreePath treePath = new TreePath(groupTreeNode.getPath());
            GroupSelector.this.groupsTree.expandSubtree((GroupTreeNode)treePath.getLastPathComponent());
            GroupSelector.this.revalidateGroups();
        }
    }

    private class SortAllSubgroupsAction
    extends NodeAction {
        public SortAllSubgroupsAction() {
            super(Globals.lang("All subgroups (recursively)"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            UndoableModifySubtree undoableModifySubtree = new UndoableModifySubtree(GroupSelector.this, groupTreeNode, Globals.lang("sort subgroups"));
            GroupSelector.this.groupsTree.sort(groupTreeNode, true);
            ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undoableModifySubtree);
            GroupSelector.this.panel.markBaseChanged();
            GroupSelector.this.frame.output(Globals.lang("Sorted all subgroups recursively."));
        }
    }

    private class SortDirectSubgroupsAction
    extends NodeAction {
        public SortDirectSubgroupsAction() {
            super(Globals.lang("Immediate subgroups"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            UndoableModifySubtree undoableModifySubtree = new UndoableModifySubtree(GroupSelector.this, groupTreeNode, Globals.lang("sort subgroups"));
            GroupSelector.this.groupsTree.sort(groupTreeNode, false);
            ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undoableModifySubtree);
            GroupSelector.this.panel.markBaseChanged();
            GroupSelector.this.frame.output(Globals.lang("Sorted immediate subgroups."));
        }
    }

    private class RemoveGroupKeepSubgroupsAction
    extends NodeAction {
        public RemoveGroupKeepSubgroupsAction() {
            super(Globals.lang("Remove group, keep subgroups"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            AbstractGroup abstractGroup = groupTreeNode.getGroup();
            int n = JOptionPane.showConfirmDialog(GroupSelector.this.frame, Globals.lang("Remove group \"%0\"?", abstractGroup.getName()), Globals.lang("Remove group"), 0);
            if (n == 0) {
                UndoableAddOrRemoveGroup undoableAddOrRemoveGroup = new UndoableAddOrRemoveGroup(GroupSelector.this, GroupSelector.this.groupsRoot, groupTreeNode, 1);
                GroupTreeNode groupTreeNode2 = (GroupTreeNode)groupTreeNode.getParent();
                int n2 = groupTreeNode2.getIndex(groupTreeNode);
                groupTreeNode.removeFromParent();
                while (groupTreeNode.getChildCount() > 0) {
                    groupTreeNode2.insert((GroupTreeNode)groupTreeNode.getFirstChild(), n2);
                }
                GroupSelector.this.revalidateGroups();
                ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undoableAddOrRemoveGroup);
                GroupSelector.this.panel.markBaseChanged();
                GroupSelector.this.frame.output(Globals.lang("Removed group \"%0\".", abstractGroup.getName()));
            }
        }
    }

    private class RemoveSubgroupsAction
    extends NodeAction {
        public RemoveSubgroupsAction() {
            super(Globals.lang("Remove all subgroups"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            AbstractGroup abstractGroup = groupTreeNode.getGroup();
            int n = JOptionPane.showConfirmDialog(GroupSelector.this.frame, Globals.lang("Remove all subgroups of \"%0\"?", abstractGroup.getName()), Globals.lang("Remove all subgroups"), 0);
            if (n == 0) {
                UndoableModifySubtree undoableModifySubtree = new UndoableModifySubtree(GroupSelector.this, groupTreeNode, "Remove all subgroups");
                groupTreeNode.removeAllChildren();
                GroupSelector.this.revalidateGroups();
                ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undoableModifySubtree);
                GroupSelector.this.panel.markBaseChanged();
                GroupSelector.this.frame.output(Globals.lang("Removed all subgroups of group \"%0\".", abstractGroup.getName()));
            }
        }
    }

    private class RemoveGroupAndSubgroupsAction
    extends NodeAction {
        public RemoveGroupAndSubgroupsAction() {
            super(Globals.lang("Remove group and subgroups"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            AbstractGroup abstractGroup = groupTreeNode.getGroup();
            int n = JOptionPane.showConfirmDialog(GroupSelector.this.frame, Globals.lang("Remove group \"%0\" and its subgroups?", abstractGroup.getName()), Globals.lang("Remove group and subgroups"), 0);
            if (n == 0) {
                UndoableAddOrRemoveGroup undoableAddOrRemoveGroup = new UndoableAddOrRemoveGroup(GroupSelector.this, GroupSelector.this.groupsRoot, groupTreeNode, 2);
                groupTreeNode.removeFromParent();
                GroupSelector.this.revalidateGroups();
                ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undoableAddOrRemoveGroup);
                GroupSelector.this.panel.markBaseChanged();
                GroupSelector.this.frame.output(Globals.lang("Removed group \"%0\" and its subgroups.", abstractGroup.getName()));
            }
        }
    }

    private class AddSubgroupAction
    extends NodeAction {
        public AddSubgroupAction() {
            super(Globals.lang("Add Subgroup"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            GroupDialog groupDialog = new GroupDialog(GroupSelector.this.frame, GroupSelector.this.panel, null);
            groupDialog.setVisible(true);
            if (!groupDialog.okPressed()) {
                return;
            }
            AbstractGroup abstractGroup = groupDialog.getResultingGroup();
            GroupTreeNode groupTreeNode2 = new GroupTreeNode(abstractGroup);
            groupTreeNode.add(groupTreeNode2);
            UndoableAddOrRemoveGroup undoableAddOrRemoveGroup = new UndoableAddOrRemoveGroup(GroupSelector.this, GroupSelector.this.groupsRoot, groupTreeNode2, 0);
            GroupSelector.this.revalidateGroups();
            GroupSelector.this.groupsTree.expandPath(new TreePath(groupTreeNode.getPath()));
            ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undoableAddOrRemoveGroup);
            GroupSelector.this.panel.markBaseChanged();
            GroupSelector.this.frame.output(Globals.lang("Added group \"%0\".", abstractGroup.getName()));
        }
    }

    private class AddGroupAction
    extends NodeAction {
        public AddGroupAction() {
            super(Globals.lang("Add Group"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            GroupDialog groupDialog = new GroupDialog(GroupSelector.this.frame, GroupSelector.this.panel, null);
            groupDialog.setVisible(true);
            if (!groupDialog.okPressed()) {
                return;
            }
            AbstractGroup abstractGroup = groupDialog.getResultingGroup();
            GroupTreeNode groupTreeNode2 = new GroupTreeNode(abstractGroup);
            if (groupTreeNode == null) {
                GroupSelector.this.groupsRoot.add(groupTreeNode2);
            } else {
                ((GroupTreeNode)groupTreeNode.getParent()).insert(groupTreeNode2, groupTreeNode.getParent().getIndex(groupTreeNode) + 1);
            }
            UndoableAddOrRemoveGroup undoableAddOrRemoveGroup = new UndoableAddOrRemoveGroup(GroupSelector.this, GroupSelector.this.groupsRoot, groupTreeNode2, 0);
            GroupSelector.this.revalidateGroups();
            GroupSelector.this.groupsTree.expandPath(new TreePath((groupTreeNode != null ? groupTreeNode : GroupSelector.this.groupsRoot).getPath()));
            ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undoableAddOrRemoveGroup);
            GroupSelector.this.panel.markBaseChanged();
            GroupSelector.this.frame.output(Globals.lang("Added group \"%0\".", abstractGroup.getName()));
        }
    }

    private class EditGroupAction
    extends NodeAction {
        public EditGroupAction() {
            super(Globals.lang("Edit group"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            AbstractGroup abstractGroup = groupTreeNode.getGroup();
            GroupDialog groupDialog = new GroupDialog(GroupSelector.this.frame, GroupSelector.this.panel, abstractGroup);
            groupDialog.setVisible(true);
            if (groupDialog.okPressed()) {
                AbstractGroup abstractGroup2 = groupDialog.getResultingGroup();
                AbstractUndoableEdit abstractUndoableEdit = groupDialog.getUndoForAddPreviousEntries();
                UndoableModifyGroup undoableModifyGroup = new UndoableModifyGroup(GroupSelector.this, GroupSelector.this.groupsRoot, groupTreeNode, abstractGroup2);
                groupTreeNode.setGroup(abstractGroup2);
                GroupSelector.this.revalidateGroups(groupTreeNode);
                if (abstractUndoableEdit == null) {
                    ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undoableModifyGroup);
                } else {
                    NamedCompound namedCompound = new NamedCompound("Modify Group");
                    namedCompound.addEdit(undoableModifyGroup);
                    namedCompound.addEdit(abstractUndoableEdit);
                    namedCompound.end();
                    ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(namedCompound);
                }
                GroupSelector.this.panel.markBaseChanged();
                GroupSelector.this.frame.output(Globals.lang("Modified group \"%0\".", abstractGroup2.getName()));
            }
        }
    }

    private abstract class NodeAction
    extends AbstractAction {
        protected GroupTreeNode m_node;

        public NodeAction(String string) {
            super(string);
            this.m_node = null;
        }

        public GroupTreeNode getNode() {
            return this.m_node;
        }

        public void setNode(GroupTreeNode groupTreeNode) {
            this.m_node = groupTreeNode;
        }

        public GroupTreeNode getNodeToUse() {
            if (this.m_node != null) {
                return this.m_node;
            }
            TreePath treePath = GroupSelector.this.groupsTree.getSelectionPath();
            if (treePath != null) {
                return (GroupTreeNode)treePath.getLastPathComponent();
            }
            return null;
        }
    }

    class GroupingWorker
    extends AbstractWorker {
        private SearchRuleSet rules;
        private Hashtable searchTerm;
        private ArrayList matches = new ArrayList();
        private boolean showOverlappingGroupsP;
        int hits = 0;

        public GroupingWorker(SearchRuleSet searchRuleSet, Hashtable hashtable) {
            this.rules = searchRuleSet;
            this.searchTerm = hashtable;
            this.showOverlappingGroupsP = GroupSelector.this.showOverlappingGroups.isSelected();
        }

        public void run() {
            Collection collection = GroupSelector.this.panel.getDatabase().getEntries();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                BibtexEntry bibtexEntry = (BibtexEntry)iterator.next();
                boolean bl = this.rules.applyRule(this.searchTerm, bibtexEntry) > 0;
                bibtexEntry.setGroupHit(bl);
                if (!bl) continue;
                ++this.hits;
                if (!this.showOverlappingGroupsP) continue;
                this.matches.add(bibtexEntry);
            }
        }

        public void update() {
            if (GroupSelector.this.hideNonHits.isSelected()) {
                ((GroupSelector)GroupSelector.this).panel.mainTable.stopShowingFloatGrouping();
                GroupSelector.this.panel.setGroupMatcher(GroupMatcher.INSTANCE);
            } else if (GroupSelector.this.grayOut.isSelected()) {
                GroupSelector.this.panel.stopShowingGroup();
                ((GroupSelector)GroupSelector.this).panel.mainTable.showFloatGrouping(GroupMatcher.INSTANCE);
            }
            if (this.showOverlappingGroupsP) {
                GroupSelector.this.showOverlappingGroups(this.matches);
            }
            GroupSelector.this.frame.output(Globals.lang("Updated group selection") + ".");
        }
    }
}

