/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import net.sf.jabref.BibtexEntry;

public class TransferableEntrySelection
implements Transferable {
    public static final DataFlavor flavorInternal;
    public static final DataFlavor flavorExternal;
    public static final DataFlavor[] flavors;
    public final BibtexEntry[] selectedEntries;
    public final String selectedEntriesCiteKeys;
    protected boolean includeCiteKeyword = false;

    public TransferableEntrySelection(BibtexEntry[] bibtexEntryArray) {
        this.selectedEntries = bibtexEntryArray;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < bibtexEntryArray.length; ++i) {
            stringBuffer.append(bibtexEntryArray[i].getCiteKey());
            if (i + 1 >= bibtexEntryArray.length) continue;
            stringBuffer.append(",");
        }
        this.selectedEntriesCiteKeys = stringBuffer.toString();
    }

    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(flavorInternal) || dataFlavor.equals(flavorExternal);
    }

    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (dataFlavor.equals(flavorInternal)) {
            return this;
        }
        String string = this.includeCiteKeyword ? "\\cite{" + this.selectedEntriesCiteKeys + "}" : this.selectedEntriesCiteKeys;
        return new ByteArrayInputStream(string.getBytes(flavorExternal.getParameter("charset").trim()));
    }

    public BibtexEntry[] getSelection() {
        return this.selectedEntries;
    }

    public void setIncludeCiteKeyword(boolean bl) {
        this.includeCiteKeyword = bl;
    }

    static {
        DataFlavor dataFlavor = null;
        DataFlavor dataFlavor2 = null;
        try {
            dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=net.sf.jabref.groups.TransferableEntrySelection");
            dataFlavor2 = DataFlavor.getTextPlainUnicodeFlavor();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        flavorInternal = dataFlavor;
        flavorExternal = dataFlavor2;
        flavors = new DataFlavor[]{flavorInternal, flavorExternal};
    }
}

