/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.util.Vector;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.Globals;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.GroupTreeNode;

public class UndoableModifySubtree
extends AbstractUndoableEdit {
    private final GroupTreeNode m_subtreeBackup;
    private final int[] m_subtreeRootPath;
    private final GroupSelector m_groupSelector;
    private Vector m_modifiedSubtree = new Vector();
    private boolean m_revalidate = true;
    private final String m_name;

    public UndoableModifySubtree(GroupSelector groupSelector, GroupTreeNode groupTreeNode, String string) {
        this.m_subtreeBackup = groupTreeNode.deepCopy();
        this.m_subtreeRootPath = groupTreeNode.getIndexedPath();
        this.m_groupSelector = groupSelector;
        this.m_name = string;
    }

    public String getUndoPresentationName() {
        return Globals.lang("Undo") + ": " + this.m_name;
    }

    public String getRedoPresentationName() {
        return Globals.lang("Redo") + ": " + this.m_name;
    }

    public void undo() {
        int n;
        super.undo();
        this.m_modifiedSubtree.clear();
        GroupTreeNode groupTreeNode = this.m_groupSelector.getGroupTreeRoot().getNode(this.m_subtreeRootPath);
        for (n = 0; n < groupTreeNode.getChildCount(); ++n) {
            this.m_modifiedSubtree.add(groupTreeNode.getChildAt(n));
        }
        groupTreeNode.removeAllChildren();
        for (n = 0; n < this.m_subtreeBackup.getChildCount(); ++n) {
            groupTreeNode.add(((GroupTreeNode)this.m_subtreeBackup.getChildAt(n)).deepCopy());
        }
        if (this.m_revalidate) {
            this.m_groupSelector.revalidateGroups();
        }
    }

    public void redo() {
        super.redo();
        GroupTreeNode groupTreeNode = this.m_groupSelector.getGroupTreeRoot().getNode(this.m_subtreeRootPath);
        groupTreeNode.removeAllChildren();
        for (int i = 0; i < this.m_modifiedSubtree.size(); ++i) {
            groupTreeNode.add((GroupTreeNode)this.m_modifiedSubtree.elementAt(i));
        }
        if (this.m_revalidate) {
            this.m_groupSelector.revalidateGroups();
        }
    }

    public void setRevalidate(boolean bl) {
        this.m_revalidate = bl;
    }
}

