/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.CustomEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.gui.FieldSetComponent;

public class EntryTypeList
extends FieldSetComponent
implements ListSelectionListener,
ActionListener {
    protected JButton def = new JButton(Globals.lang("Default"));

    public EntryTypeList(List list) {
        super(Globals.lang("Entry types"), list, false, true);
        this.con.gridx = 0;
        this.con.gridy = 2;
        this.con.fill = 3;
        this.con.anchor = 13;
        this.gbl.setConstraints(this.def, this.con);
        this.add(this.def);
        this.list.addListSelectionListener(this);
        this.def.addActionListener(this);
        this.def.setEnabled(false);
        this.remove.setEnabled(false);
    }

    protected void addField(String string) {
        string = string.trim();
        if (this.forceLowerCase) {
            string = string.toLowerCase();
        }
        if (string.equals("") || this.listModel.contains(string)) {
            return;
        }
        String string2 = Util.checkLegalKey(string);
        if (!string2.equals(string) || string.indexOf(38) >= 0) {
            JOptionPane.showMessageDialog(this, Globals.lang("Entry type names are not allowed to contain white space or the following characters") + ": # { } ~ , ^ &", Globals.lang("Error"), 0);
            return;
        }
        this.addFieldUncritically(string);
    }

    protected void removeSelected() {
        int[] nArray = this.list.getSelectedIndices();
        if (nArray.length > 0) {
            this.changesMade = true;
        }
        for (int i = 0; i < nArray.length; ++i) {
            boolean bl;
            String string = (String)this.listModel.get(nArray[nArray.length - 1 - i]);
            BibtexEntryType bibtexEntryType = BibtexEntryType.getType(string);
            boolean bl2 = bl = BibtexEntryType.getStandardType(string) != null;
            if (bibtexEntryType != null && bibtexEntryType instanceof CustomEntryType) {
                this.listModel.removeElementAt(nArray[nArray.length - 1 - i]);
                continue;
            }
            JOptionPane.showMessageDialog(null, Globals.lang("This entry type cannot be removed."), Globals.lang("Remove entry type"), 0);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
    }

    public void enable(String string, boolean bl) {
        if (BibtexEntryType.getStandardType(string) != null) {
            if (bl || BibtexEntryType.getType(string) instanceof CustomEntryType) {
                this.def.setEnabled(true);
            } else {
                this.def.setEnabled(false);
            }
            this.remove.setEnabled(false);
        } else {
            this.def.setEnabled(false);
            this.remove.setEnabled(true);
        }
    }

    public void addDefaultActionListener(ActionListener actionListener) {
        this.def.addActionListener(actionListener);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.def) {
            this.def.setEnabled(false);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.def.setEnabled(bl);
    }
}

