/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.DatabaseChangeEvent;
import net.sf.jabref.DatabaseChangeListener;
import net.sf.jabref.IdComparator;

public class GlazedEntrySorter
implements DatabaseChangeListener {
    EventList list = new BasicEventList();
    Comparator comp;
    String[] idArray;
    BibtexEntry[] entryArray;
    private boolean outdated = false;
    private boolean changed = false;

    public GlazedEntrySorter(Map map, Comparator comparator) {
        this.comp = comparator;
        this.list.getReadWriteLock().writeLock().lock();
        Set set = map.keySet();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                this.list.add(map.get(iterator.next()));
            }
        }
        Collections.sort(this.list, new IdComparator());
        this.list.getReadWriteLock().writeLock().unlock();
    }

    public EventList getTheList() {
        return this.list;
    }

    public void databaseChanged(DatabaseChangeEvent databaseChangeEvent) {
        this.list.getReadWriteLock().writeLock().lock();
        if (databaseChangeEvent.getType() == DatabaseChangeEvent.ADDED_ENTRY) {
            this.list.add(databaseChangeEvent.getEntry());
        } else if (databaseChangeEvent.getType() == DatabaseChangeEvent.REMOVED_ENTRY) {
            this.list.remove(databaseChangeEvent.getEntry());
        } else if (databaseChangeEvent.getType() == DatabaseChangeEvent.CHANGED_ENTRY) {
            int n = this.list.indexOf(databaseChangeEvent.getEntry());
            this.list.set(n, databaseChangeEvent.getEntry());
        }
        this.list.getReadWriteLock().writeLock().unlock();
    }
}

