/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.gui;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.event.ListEventListener;
import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.swing.EventSelectionModel;
import ca.odell.glazedlists.swing.EventTableModel;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Comparator;
import java.util.List;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.TransferHandler;
import javax.swing.plaf.TableUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.FieldComparator;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.GeneralRenderer;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.Util;
import net.sf.jabref.groups.EntryTableTransferHandler;
import net.sf.jabref.gui.FirstColumnComparator;
import net.sf.jabref.gui.IconComparator;
import net.sf.jabref.gui.IsMarkedComparator;
import net.sf.jabref.gui.MainTableFormat;
import net.sf.jabref.search.HitOrMissComparator;

public class MainTable
extends JTable {
    private MainTableFormat tableFormat;
    private SortedList sortedForMarking;
    private SortedList sortedForTable;
    private SortedList sortedForSearch;
    private SortedList sortedForGrouping;
    private boolean tableColorCodes;
    private boolean showingFloatSearch = false;
    private boolean showingFloatGrouping = false;
    private EventSelectionModel selectionModel;
    private TableComparatorChooser comparatorChooser;
    private JScrollPane pane;
    private Comparator searchComparator;
    private Comparator groupComparator;
    private Comparator markingComparator = new IsMarkedComparator();
    private Matcher searchMatcher;
    private Matcher groupMatcher;
    public static final int REQUIRED = 1;
    public static final int OPTIONAL = 2;
    public static final int REQ_STRING = 1;
    public static final int REQ_NUMBER = 2;
    public static final int OPT_STRING = 3;
    public static final int OTHER = 3;
    public static final int BOOLEAN = 4;
    public static final int ICON_COL = 8;
    private static GeneralRenderer defRenderer;
    private static GeneralRenderer reqRenderer;
    private static GeneralRenderer optRenderer;
    private static GeneralRenderer grayedOutRenderer;
    private static GeneralRenderer veryGrayedOutRenderer;
    private static GeneralRenderer markedRenderer;
    private static IncompleteRenderer incRenderer;
    private static CompleteRenderer compRenderer;
    private static CompleteRenderer grayedOutNumberRenderer;
    private static CompleteRenderer veryGrayedOutNumberRenderer;
    private static CompleteRenderer markedNumberRenderer;

    public MainTable(MainTableFormat mainTableFormat, EventList eventList, JabRefFrame jabRefFrame, BasePanel basePanel) {
        this.tableFormat = mainTableFormat;
        this.sortedForTable = new SortedList(eventList, null);
        this.sortedForMarking = new SortedList(this.sortedForTable, null);
        this.sortedForSearch = new SortedList(this.sortedForMarking, null);
        this.sortedForGrouping = new SortedList(this.sortedForSearch, null);
        this.searchMatcher = null;
        this.groupMatcher = null;
        this.searchComparator = null;
        this.groupComparator = null;
        EventTableModel eventTableModel = new EventTableModel(this.sortedForGrouping, mainTableFormat);
        this.setModel(eventTableModel);
        this.tableColorCodes = Globals.prefs.getBoolean("tableColorCodesOn");
        this.selectionModel = new EventSelectionModel(this.sortedForGrouping);
        this.setSelectionModel(this.selectionModel);
        this.pane = new JScrollPane(this);
        this.pane.getViewport().setBackground(Globals.prefs.getColor("tableBackground"));
        this.setGridColor(Globals.prefs.getColor("gridColor"));
        this.comparatorChooser = new MyTableComparatorChooser(this, this.sortedForTable, TableComparatorChooser.MULTIPLE_COLUMN_KEYBOARD);
        EventList eventList2 = this.getSelected();
        this.setDragEnabled(true);
        EntryTableTransferHandler entryTableTransferHandler = new EntryTableTransferHandler(this, jabRefFrame, basePanel);
        this.setTransferHandler(entryTableTransferHandler);
        this.pane.setTransferHandler(entryTableTransferHandler);
        this.setupComparatorChooser();
        this.refreshSorting();
        this.setWidths();
    }

    public void refreshSorting() {
        this.sortedForMarking.getReadWriteLock().writeLock().lock();
        if (Globals.prefs.getBoolean("floatMarkedEntries")) {
            this.sortedForMarking.setComparator(this.markingComparator);
        } else {
            this.sortedForMarking.setComparator(null);
        }
        this.sortedForMarking.getReadWriteLock().writeLock().unlock();
        this.sortedForSearch.getReadWriteLock().writeLock().lock();
        this.sortedForSearch.setComparator(this.searchComparator);
        this.sortedForSearch.getReadWriteLock().writeLock().unlock();
        this.sortedForGrouping.getReadWriteLock().writeLock().lock();
        this.sortedForGrouping.setComparator(this.groupComparator);
        this.sortedForGrouping.getReadWriteLock().writeLock().unlock();
    }

    public void showFloatSearch(Matcher matcher) {
        this.showingFloatSearch = true;
        this.searchMatcher = matcher;
        this.searchComparator = new HitOrMissComparator(matcher);
        this.refreshSorting();
        this.scrollTo(0);
    }

    public void stopShowingFloatSearch() {
        this.showingFloatSearch = false;
        this.searchMatcher = null;
        this.searchComparator = null;
        this.refreshSorting();
    }

    public void showFloatGrouping(Matcher matcher) {
        this.showingFloatGrouping = true;
        this.groupMatcher = matcher;
        this.groupComparator = new HitOrMissComparator(matcher);
        this.refreshSorting();
    }

    public void stopShowingFloatGrouping() {
        this.showingFloatGrouping = false;
        this.groupMatcher = null;
        this.groupComparator = null;
        this.refreshSorting();
    }

    public EventList getTableRows() {
        return this.sortedForGrouping;
    }

    public void addSelectionListener(ListEventListener listEventListener) {
        this.getSelected().addListEventListener(listEventListener);
    }

    public JScrollPane getPane() {
        return this.pane;
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        int n3 = -3;
        TableCellRenderer tableCellRenderer = defRenderer;
        int n4 = this.getCellStatus(n, n2);
        if (!this.showingFloatSearch || this.matches(n, this.searchMatcher)) {
            ++n3;
        }
        if (!this.showingFloatGrouping || this.matches(n, this.groupMatcher)) {
            n3 += 2;
        }
        if (n3 < -1) {
            if (n2 == 0) {
                veryGrayedOutNumberRenderer.setNumber(n);
                tableCellRenderer = veryGrayedOutNumberRenderer;
            } else {
                tableCellRenderer = veryGrayedOutRenderer;
            }
        } else if (n3 == -1) {
            if (n2 == 0) {
                grayedOutNumberRenderer.setNumber(n);
                tableCellRenderer = grayedOutNumberRenderer;
            } else {
                tableCellRenderer = grayedOutRenderer;
            }
        } else if (n2 == 0) {
            if (!this.isComplete(n)) {
                incRenderer.setNumber(n);
                tableCellRenderer = incRenderer;
            } else {
                compRenderer.setNumber(n);
                if (this.isMarked(n)) {
                    tableCellRenderer = markedNumberRenderer;
                    markedNumberRenderer.setNumber(n);
                } else {
                    tableCellRenderer = compRenderer;
                }
            }
        } else if (this.tableColorCodes) {
            if (n4 == 1) {
                tableCellRenderer = reqRenderer;
            } else if (n4 == 2) {
                tableCellRenderer = optRenderer;
            } else if (n4 == 4) {
                tableCellRenderer = this.getDefaultRenderer(Boolean.class);
            }
        }
        if (n2 != 0 && this.isMarked(n)) {
            tableCellRenderer = markedRenderer;
        }
        return tableCellRenderer;
    }

    public void setWidths() {
        int n;
        int n2 = Globals.prefs.getInt("numberColWidth");
        String[] stringArray = Globals.prefs.getStringArray("columnWidths");
        TableColumnModel tableColumnModel = this.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(n2);
        for (n = 1; n < this.tableFormat.padleft; ++n) {
            tableColumnModel.getColumn(n).setPreferredWidth(GUIGlobals.WIDTH_ICON_COL);
            tableColumnModel.getColumn(n).setMinWidth(GUIGlobals.WIDTH_ICON_COL);
            tableColumnModel.getColumn(n).setMaxWidth(GUIGlobals.WIDTH_ICON_COL);
        }
        for (n = this.tableFormat.padleft; n < this.getModel().getColumnCount(); ++n) {
            try {
                tableColumnModel.getColumn(n).setPreferredWidth(Integer.parseInt(stringArray[n - this.tableFormat.padleft]));
                continue;
            }
            catch (Throwable throwable) {
                Globals.logger("Exception while setting column widths. Choosing default.");
                tableColumnModel.getColumn(n).setPreferredWidth(GUIGlobals.DEFAULT_FIELD_LENGTH);
            }
        }
    }

    public BibtexEntry getEntryAt(int n) {
        return (BibtexEntry)this.sortedForGrouping.get(n);
    }

    public BibtexEntry[] getSelectedEntries() {
        BibtexEntry[] bibtexEntryArray = new BibtexEntry[]{};
        return this.getSelected().toArray(bibtexEntryArray);
    }

    private void setupComparatorChooser() {
        Object[] objectArray;
        int n;
        List list = this.comparatorChooser.getComparatorsForColumn(0);
        list.clear();
        list.add(new FirstColumnComparator());
        for (n = 1; n < this.tableFormat.padleft; ++n) {
            list = this.comparatorChooser.getComparatorsForColumn(n);
            list.clear();
            objectArray = this.tableFormat.getIconTypeForColumn(n);
            list.add(new IconComparator((String[])objectArray));
        }
        for (n = this.tableFormat.padleft; n < this.tableFormat.getColumnCount(); ++n) {
            list = this.comparatorChooser.getComparatorsForColumn(n);
            list.clear();
            list.add(new FieldComparator(this.tableFormat.getColumnName(n).toLowerCase()));
        }
        String[] stringArray = new String[]{Globals.prefs.get("priSort"), Globals.prefs.get("secSort"), Globals.prefs.get("terSort")};
        objectArray = new boolean[]{Globals.prefs.getBoolean("priDescending"), Globals.prefs.getBoolean("secDescending"), Globals.prefs.getBoolean("terDescending")};
        this.sortedForTable.getReadWriteLock().writeLock().lock();
        for (int i = 0; i < stringArray.length; ++i) {
            int n2 = this.tableFormat.getColumnIndex(stringArray[i]);
            if (n2 < 0) continue;
            this.comparatorChooser.appendComparator(n2, 0, (boolean)objectArray[i]);
        }
        this.sortedForTable.getReadWriteLock().writeLock().unlock();
    }

    public int getCellStatus(int n, int n2) {
        try {
            BibtexEntry bibtexEntry = (BibtexEntry)this.sortedForGrouping.get(n);
            BibtexEntryType bibtexEntryType = bibtexEntry.getType();
            String string = this.tableFormat.getColumnName(n2).toLowerCase();
            if (string.equals("bibtexkey") || bibtexEntryType.isRequired(string)) {
                return 1;
            }
            if (bibtexEntryType.isOptional(string)) {
                return 2;
            }
            return 3;
        }
        catch (NullPointerException nullPointerException) {
            return 3;
        }
    }

    public EventList getSelected() {
        return this.selectionModel.getSelected();
    }

    public int findEntry(BibtexEntry bibtexEntry) {
        return this.sortedForGrouping.indexOf(bibtexEntry);
    }

    public String[] getIconTypeForColumn(int n) {
        return this.tableFormat.getIconTypeForColumn(n);
    }

    private boolean nonZeroField(int n, String string) {
        BibtexEntry bibtexEntry = (BibtexEntry)this.sortedForGrouping.get(n);
        Object object = bibtexEntry.getField(string);
        return object == null || !object.equals("0");
    }

    private boolean matches(int n, Matcher matcher) {
        Object object = this.sortedForGrouping.get(n);
        return matcher.matches(object);
    }

    private boolean isComplete(int n) {
        try {
            BibtexEntry bibtexEntry = (BibtexEntry)this.sortedForGrouping.get(n);
            return bibtexEntry.hasAllRequiredFields();
        }
        catch (NullPointerException nullPointerException) {
            return true;
        }
    }

    private boolean isMarked(int n) {
        try {
            BibtexEntry bibtexEntry = (BibtexEntry)this.sortedForGrouping.get(n);
            return Util.isMarked(bibtexEntry);
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public void scrollTo(int n) {
        JScrollBar jScrollBar = this.pane.getVerticalScrollBar();
        jScrollBar.setValue(n * jScrollBar.getUnitIncrement(1));
    }

    public void updateFont() {
        this.setFont(GUIGlobals.CURRENTFONT);
        this.setRowHeight(4 + GUIGlobals.CURRENTFONT.getSize());
    }

    public void ensureVisible(int n) {
        JScrollBar jScrollBar = this.pane.getVerticalScrollBar();
        int n2 = n * this.getRowHeight();
        if (n2 < jScrollBar.getValue() || n2 > jScrollBar.getValue() + jScrollBar.getVisibleAmount()) {
            this.scrollToCenter(n, 1);
        }
    }

    public void scrollToCenter(int n, int n2) {
        if (!(this.getParent() instanceof JViewport)) {
            return;
        }
        JViewport jViewport = (JViewport)this.getParent();
        Rectangle rectangle = this.getCellRect(n, n2, true);
        Rectangle rectangle2 = jViewport.getViewRect();
        rectangle.setLocation(rectangle.x - rectangle2.x, rectangle.y - rectangle2.y);
        int n3 = (rectangle2.width - rectangle.width) / 2;
        int n4 = (rectangle2.height - rectangle.height) / 2;
        if (rectangle.x < n3) {
            n3 = -n3;
        }
        if (rectangle.y < n4) {
            n4 = -n4;
        }
        rectangle.translate(n3, n4);
        jViewport.scrollRectToVisible(rectangle);
        this.revalidate();
        this.repaint();
    }

    public static void updateRenderers() {
        boolean bl = Globals.prefs.getBoolean("antialias");
        defRenderer = new GeneralRenderer(Globals.prefs.getColor("tableBackground"), Globals.prefs.getColor("tableText"), bl);
        reqRenderer = new GeneralRenderer(Globals.prefs.getColor("tableReqFieldBackground"), Globals.prefs.getColor("tableText"), bl);
        optRenderer = new GeneralRenderer(Globals.prefs.getColor("tableOptFieldBackground"), Globals.prefs.getColor("tableText"), bl);
        incRenderer = new IncompleteRenderer(bl);
        compRenderer = new CompleteRenderer(Globals.prefs.getColor("tableBackground"), bl);
        markedNumberRenderer = new CompleteRenderer(Globals.prefs.getColor("markedEntryBackground"), bl);
        grayedOutNumberRenderer = new CompleteRenderer(Globals.prefs.getColor("grayedOutBackground"), bl);
        veryGrayedOutNumberRenderer = new CompleteRenderer(Globals.prefs.getColor("veryGrayedOutBackground"), bl);
        grayedOutRenderer = new GeneralRenderer(Globals.prefs.getColor("grayedOutBackground"), Globals.prefs.getColor("grayedOutText"), bl);
        veryGrayedOutRenderer = new GeneralRenderer(Globals.prefs.getColor("veryGrayedOutBackground"), Globals.prefs.getColor("veryGrayedOutText"), bl);
        markedRenderer = new GeneralRenderer(Globals.prefs.getColor("markedEntryBackground"), Globals.prefs.getColor("tableText"), bl);
    }

    public void setUI(TableUI tableUI) {
        super.setUI(tableUI);
        TransferHandler transferHandler = this.getTransferHandler();
        this.setTransferHandler(null);
        this.setTransferHandler(transferHandler);
    }

    public Comparator getComparatorForColumn(int n) {
        List list = this.comparatorChooser.getComparatorsForColumn(n);
        return list.size() == 0 ? null : (Comparator)list.get(0);
    }

    public int getSortingColumn(int n) {
        List list = this.comparatorChooser.getSortingColumns();
        if (list.size() <= n) {
            return -1;
        }
        return (Integer)list.get(n);
    }

    public SortedList getSortedForTable() {
        return this.sortedForTable;
    }

    static {
        MainTable.updateRenderers();
    }

    class MyTableComparatorChooser
    extends TableComparatorChooser {
        public MyTableComparatorChooser(JTable jTable, SortedList sortedList, Object object) {
            super(jTable, sortedList, object);
            this.addSortActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainTable.this.refreshSorting();
                }
            });
        }
    }

    static class CompleteRenderer
    extends GeneralRenderer {
        public CompleteRenderer(Color color, boolean bl) {
            super(color, bl);
        }

        protected void setNumber(int n) {
            super.setValue(String.valueOf(n + 1));
        }

        protected void setValue(Object object) {
        }
    }

    static class IncompleteRenderer
    extends GeneralRenderer {
        public IncompleteRenderer(boolean bl) {
            super(Globals.prefs.getColor("incompleteEntryBackground"), bl);
            super.setToolTipText(Globals.lang("This entry is incomplete"));
        }

        protected void setNumber(int n) {
            super.setValue(String.valueOf(n + 1));
        }

        protected void setValue(Object object) {
        }
    }
}

