/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.TreeSet;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.imports.ImportFormat;

public class CustomImportList
extends TreeSet {
    private JabRefPreferences prefs;

    public CustomImportList(JabRefPreferences jabRefPreferences) {
        this.prefs = jabRefPreferences;
        this.readPrefs();
    }

    private void readPrefs() {
        int n = 0;
        String[] stringArray = null;
        while ((stringArray = this.prefs.getStringArray("customImportFormat" + n)) != null) {
            try {
                super.add(new Importer(stringArray));
            }
            catch (Exception exception) {
                System.err.println("Warning! Could not load " + stringArray[0] + " from preferences. Will ignore.");
            }
            ++n;
        }
    }

    public void addImporter(Importer importer) {
        super.add(importer);
    }

    public boolean replaceImporter(Importer importer) {
        boolean bl = this.remove(importer);
        this.addImporter(importer);
        return bl;
    }

    public void store() {
        this.purgeAll();
        Importer[] importerArray = this.toArray(new Importer[0]);
        for (int i = 0; i < importerArray.length; ++i) {
            Globals.prefs.putStringArray("customImportFormat" + i, importerArray[i].getAsStringArray());
        }
    }

    private void purgeAll() {
        int n = 0;
        while (Globals.prefs.getStringArray("customImportFormat" + n) != null) {
            Globals.prefs.remove("customImportFormat" + n);
            ++n;
        }
    }

    public class Importer
    implements Comparable {
        private String name;
        private String cliId;
        private String className;
        private String basePath;

        public Importer() {
        }

        public Importer(String[] stringArray) {
            this.name = stringArray[0];
            this.cliId = stringArray[1];
            this.className = stringArray[2];
            this.basePath = stringArray[3];
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getClidId() {
            return this.cliId;
        }

        public void setCliId(String string) {
            this.cliId = string;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String string) {
            this.className = string;
        }

        public void setBasePath(String string) {
            this.basePath = string;
        }

        public File getBasePath() {
            return new File(this.basePath);
        }

        public URL getBasePathUrl() throws MalformedURLException {
            return this.getBasePath().toURL();
        }

        public String[] getAsStringArray() {
            return new String[]{this.name, this.cliId, this.className, this.basePath};
        }

        public boolean equals(Object object) {
            return object != null && object instanceof Importer && this.getName().equals(((Importer)object).getName());
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public int compareTo(Object object) {
            return this.getName().compareTo(((Importer)object).getName());
        }

        public String toString() {
            return this.name;
        }

        public ImportFormat getInstance() throws MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
            URLClassLoader uRLClassLoader = new URLClassLoader(new URL[]{this.getBasePathUrl()});
            Class<?> clazz = Class.forName(this.className, true, uRLClassLoader);
            ImportFormat importFormat = (ImportFormat)clazz.newInstance();
            importFormat.setIsCustomImporter(true);
            return importFormat;
        }
    }
}

