/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.Util;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class EndnoteImporter
extends ImportFormat {
    public String getFormatName() {
        return "Refer/Endnote";
    }

    public String getCLIId() {
        return "refer";
    }

    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        Pattern pattern = Pattern.compile("%A .*");
        while ((string = bufferedReader.readLine()) != null) {
            if (!pattern.matcher(string).find()) continue;
            return true;
        }
        return false;
    }

    public List importEntries(InputStream inputStream) throws IOException {
        String string;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        StringBuffer stringBuffer = new StringBuffer();
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        String string2 = "__EOREOR__";
        boolean bl = true;
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).indexOf("%0") == 0) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(string2);
                }
                stringBuffer.append(string);
            } else {
                stringBuffer.append(string);
            }
            stringBuffer.append("\n");
        }
        String[] stringArray = stringBuffer.toString().split(string2);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.clear();
            string3 = "";
            string4 = "";
            string5 = "";
            boolean bl2 = false;
            String[] stringArray2 = stringArray[i].trim().substring(1).split("\n%");
            for (int j = 0; j < stringArray2.length; ++j) {
                if (stringArray2[j].length() < 3) continue;
                String string6 = stringArray2[j].substring(0, 1);
                String string7 = stringArray2[j].substring(2);
                if (string6.equals("A")) {
                    if (string3.equals("")) {
                        string3 = string7;
                        continue;
                    }
                    string3 = string3 + " and " + string7;
                    continue;
                }
                if (string6.equals("E")) {
                    if (string5.equals("")) {
                        string5 = string7;
                        continue;
                    }
                    string5 = string5 + " and " + string7;
                    continue;
                }
                if (string6.equals("T")) {
                    hashMap.put("title", string7);
                    continue;
                }
                if (string6.equals("0")) {
                    if (string7.indexOf("Journal") == 0) {
                        string4 = "article";
                        continue;
                    }
                    if (string7.indexOf("Book Section") == 0) {
                        string4 = "incollection";
                        continue;
                    }
                    if (string7.indexOf("Book") == 0) {
                        string4 = "book";
                        continue;
                    }
                    if (string7.indexOf("Edited Book") == 0) {
                        string4 = "book";
                        bl2 = true;
                        continue;
                    }
                    if (string7.indexOf("Conference") == 0) {
                        string4 = "inproceedings";
                        continue;
                    }
                    if (string7.indexOf("Report") == 0) {
                        string4 = "techreport";
                        continue;
                    }
                    if (string7.indexOf("Review") == 0) {
                        string4 = "article";
                        continue;
                    }
                    if (string7.indexOf("Thesis") == 0) {
                        string4 = "phdthesis";
                        continue;
                    }
                    string4 = "misc";
                    continue;
                }
                if (string6.equals("7")) {
                    hashMap.put("edition", string7);
                    continue;
                }
                if (string6.equals("C")) {
                    hashMap.put("address", string7);
                    continue;
                }
                if (string6.equals("D")) {
                    hashMap.put("year", string7);
                    continue;
                }
                if (string6.equals("8")) {
                    hashMap.put("date", string7);
                    continue;
                }
                if (string6.equals("J")) {
                    if (hashMap.get("journal") != null) continue;
                    hashMap.put("journal", string7);
                    continue;
                }
                if (string6.equals("B")) {
                    if (string4.equals("article")) {
                        hashMap.put("journal", string7);
                        continue;
                    }
                    if (string4.equals("book") || string4.equals("inbook")) {
                        hashMap.put("series", string7);
                        continue;
                    }
                    hashMap.put("booktitle", string7);
                    continue;
                }
                if (string6.equals("I")) {
                    if (string4.equals("phdthesis")) {
                        hashMap.put("school", string7);
                        continue;
                    }
                    hashMap.put("publisher", string7);
                    continue;
                }
                if (string6.equals("P")) {
                    hashMap.put("pages", string7.replaceAll("([0-9]) *- *([0-9])", "$1--$2"));
                    continue;
                }
                if (string6.equals("V")) {
                    hashMap.put("volume", string7);
                    continue;
                }
                if (string6.equals("N")) {
                    hashMap.put("number", string7);
                    continue;
                }
                if (string6.equals("U")) {
                    hashMap.put("url", string7);
                    continue;
                }
                if (string6.equals("O")) {
                    hashMap.put("note", string7);
                    continue;
                }
                if (string6.equals("K")) {
                    hashMap.put("keywords", string7);
                    continue;
                }
                if (string6.equals("X")) {
                    hashMap.put("abstract", string7);
                    continue;
                }
                if (string6.equals("9")) {
                    if (string7.indexOf("Ph.D.") == 0) {
                        string4 = "phdthesis";
                    }
                    if (string7.indexOf("Masters") != 0) continue;
                    string4 = "mastersthesis";
                    continue;
                }
                if (!string6.equals("F")) continue;
                hashMap.put("bibtexkey", Util.checkLegalKey(string7));
            }
            if (bl2 && string5.equals("")) {
                string5 = string3;
                string3 = "";
            }
            if (!string3.equals("")) {
                hashMap.put("author", this.fixAuthor(string3));
            }
            if (!string5.equals("")) {
                hashMap.put("editor", this.fixAuthor(string5));
            }
            BibtexEntry bibtexEntry = new BibtexEntry("__ID", Globals.getEntryType(string4));
            bibtexEntry.setField(hashMap);
            if (bibtexEntry.getAllFields().length <= 0) continue;
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }

    private String fixAuthor(String string) {
        int n = string.indexOf(" and ");
        if (n >= 0) {
            return AuthorList.fixAuthor_lastNameFirst(string);
        }
        n = string.lastIndexOf(",");
        if (n == string.length() - 1) {
            String string2 = string.substring(0, string.length() - 1).replaceAll(", ", " and ");
            return AuthorList.fixAuthor_lastNameFirst(string2);
        }
        return AuthorList.fixAuthor_lastNameFirst(string);
    }
}

