/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.HelpAction;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.Util;
import net.sf.jabref.gui.ImportInspectionDialog;
import net.sf.jabref.imports.EntryFetcher;

public class GeneralFetcher
extends SidePaneComponent
implements ActionListener {
    JTextField tf = new JTextField();
    JPanel pan = new JPanel();
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints con = new GridBagConstraints();
    JButton go = new JButton(Globals.lang("Fetch"));
    JButton helpBut = new JButton(GUIGlobals.getImage("helpSmall"));
    HelpAction help;
    EntryFetcher fetcher;
    SidePaneManager sidePaneManager;
    Action action;
    JabRefFrame frame;

    public GeneralFetcher(SidePaneManager sidePaneManager, JabRefFrame jabRefFrame, EntryFetcher entryFetcher) {
        super(sidePaneManager, entryFetcher.getIcon(), entryFetcher.getTitle());
        JPanel jPanel;
        this.sidePaneManager = sidePaneManager;
        this.frame = jabRefFrame;
        this.fetcher = entryFetcher;
        this.action = new FetcherAction();
        this.help = new HelpAction(Globals.helpDiag, entryFetcher.getHelpPage(), "Help");
        this.helpBut.addActionListener(this.help);
        this.helpBut.setMargin(new Insets(0, 0, 0, 0));
        this.tf.setPreferredSize(new Dimension(1, this.tf.getPreferredSize().height));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(this.gbl);
        this.con.fill = 1;
        this.con.insets = new Insets(0, 0, 2, 0);
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.weighty = 1.0;
        this.con.insets = new Insets(0, 0, 0, 0);
        this.con.fill = 1;
        this.gbl.setConstraints(this.tf, this.con);
        jPanel2.add(this.tf);
        this.con.weighty = 0.0;
        this.con.gridwidth = entryFetcher.getHelpPage() != null ? 1 : 0;
        this.gbl.setConstraints(this.go, this.con);
        jPanel2.add(this.go);
        if (entryFetcher.getHelpPage() != null) {
            this.con.gridwidth = 0;
            this.gbl.setConstraints(this.helpBut, this.con);
            jPanel2.add(this.helpBut);
        }
        if ((jPanel = entryFetcher.getOptionsPanel()) != null) {
            this.gbl.setConstraints(jPanel, this.con);
            jPanel2.add(jPanel);
        }
        jPanel2.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add((Component)jPanel2, "Center");
        this.go.addActionListener(this);
        this.tf.addActionListener(this);
    }

    public JTextField getTextField() {
        return this.tf;
    }

    public Action getAction() {
        return this.action;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.tf.getText().trim().length() == 0) {
            return;
        }
        ImportInspectionDialog importInspectionDialog = new ImportInspectionDialog(this.frame, this.frame.basePanel(), BibtexFields.DEFAULT_INSPECTION_FIELDS, this.fetcher.getTitle(), false);
        importInspectionDialog.addCallBack(this.fetcher);
        Util.placeDialog(importInspectionDialog, this.frame);
        this.fetcher.processQuery(this.tf.getText().trim(), importInspectionDialog, this.frame);
    }

    class FetcherAction
    extends AbstractAction {
        public FetcherAction() {
            super(GeneralFetcher.this.fetcher.getTitle(), new ImageIcon(GeneralFetcher.this.fetcher.getIcon()));
            this.putValue("AcceleratorKey", Globals.prefs.getKey(GeneralFetcher.this.fetcher.getKeyName()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = GeneralFetcher.this.fetcher.getTitle();
            if (!GeneralFetcher.this.sidePaneManager.hasComponent(string)) {
                GeneralFetcher.this.sidePaneManager.register(string, GeneralFetcher.this);
            }
            if (GeneralFetcher.this.frame.getTabbedPane().getTabCount() > 0) {
                GeneralFetcher.this.sidePaneManager.toggle(string);
                if (GeneralFetcher.this.sidePaneManager.isComponentVisible(string)) {
                    new FocusRequester(GeneralFetcher.this.getTextField());
                }
            }
        }
    }
}

