/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.imports.ImportFileFilter;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportMenuItem;

public class ImportFormats {
    public static JFileChooser createImportFileChooser(String string) {
        SortedSet sortedSet = Globals.importFormatReader.getBuiltInInputFormats();
        SortedSet sortedSet2 = Globals.importFormatReader.getCustomImportFormats();
        TreeSet treeSet = new TreeSet();
        Object object = sortedSet.iterator();
        while (object.hasNext()) {
            treeSet.add(object.next());
        }
        object = sortedSet2.iterator();
        while (object.hasNext()) {
            treeSet.add(object.next());
        }
        object = Globals.prefs.get("lastUsedImport");
        ImportFileFilter importFileFilter = null;
        JFileChooser jFileChooser = new JFileChooser(string);
        TreeSet<ImportFileFilter> treeSet2 = new TreeSet<ImportFileFilter>();
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            ImportFormat importFormat = (ImportFormat)iterator.next();
            ImportFileFilter importFileFilter2 = new ImportFileFilter(importFormat);
            treeSet2.add(importFileFilter2);
            if (!importFormat.getFormatName().equals(object)) continue;
            importFileFilter = importFileFilter2;
        }
        iterator = treeSet2.iterator();
        while (iterator.hasNext()) {
            jFileChooser.addChoosableFileFilter((ImportFileFilter)iterator.next());
        }
        if (importFileFilter != null) {
            jFileChooser.setFileFilter(importFileFilter);
        } else {
            jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
        }
        return jFileChooser;
    }

    public static AbstractAction getImportAction(JabRefFrame jabRefFrame, boolean bl) {
        class ImportAction
        extends MnemonicAwareAction {
            private JabRefFrame frame;
            private boolean openInNew;

            public ImportAction(JabRefFrame jabRefFrame, boolean bl) {
                this.frame = jabRefFrame;
                this.openInNew = bl;
                this.putValue("Name", bl ? "Import into new database" : "Import into current database");
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooser jFileChooser = ImportFormats.createImportFileChooser(Globals.prefs.get("importWorkingDirectory"));
                jFileChooser.showOpenDialog(this.frame);
                File file = jFileChooser.getSelectedFile();
                if (file == null) {
                    return;
                }
                FileFilter fileFilter = jFileChooser.getFileFilter();
                Object var5_5 = null;
                ImportFormat importFormat = null;
                if (fileFilter instanceof ImportFileFilter) {
                    importFormat = ((ImportFileFilter)fileFilter).getImportFormat();
                }
                try {
                    String string = file.getPath();
                    if (!file.exists()) {
                        JOptionPane.showMessageDialog(this.frame, Globals.lang("File not found") + ": '" + file.getName() + "'.", Globals.lang("Import"), 0);
                        return;
                    }
                    ImportMenuItem importMenuItem = new ImportMenuItem(this.frame, this.openInNew, importFormat);
                    importMenuItem.automatedImport(new String[]{file.getAbsolutePath()});
                    if (importFormat != null) {
                        Globals.prefs.put("lastUsedImport", importFormat.getFormatName());
                    } else {
                        Globals.prefs.put("lastUsedImport", "__all");
                    }
                    Globals.prefs.put("importWorkingDirectory", file.getParent());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return new ImportAction(jabRefFrame, bl);
    }
}

