/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.imports;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.Util;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormatReader;

public class JstorImporter
extends ImportFormat {
    public String getFormatName() {
        return "JStor (tab delimited)";
    }

    public String getCLIId() {
        return "jstor";
    }

    public boolean isRecognizedFormat(InputStream inputStream) throws IOException {
        return true;
    }

    public List importEntries(InputStream inputStream) throws IOException {
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>();
        String string = "";
        BufferedReader bufferedReader = new BufferedReader(ImportFormatReader.getReaderDefaultEncoding(inputStream));
        while (string != null && !string.startsWith("Item Type")) {
            string = bufferedReader.readLine();
        }
        while ((string = bufferedReader.readLine()) != null) {
            if (string.equals("")) continue;
            if (string.startsWith("-----------------------------")) break;
            String[] stringArray = string.split("\t");
            BibtexEntry bibtexEntry = new BibtexEntry(Util.createNeutralId());
            try {
                if (stringArray[0].equals("FLA")) {
                    bibtexEntry.setType(BibtexEntryType.getType("article"));
                }
                ImportFormatReader.setIfNecessary(bibtexEntry, "title", stringArray[2]);
                ImportFormatReader.setIfNecessary(bibtexEntry, "author", AuthorList.fixAuthor_lastNameFirst(stringArray[4].replaceAll("; ", " and ")));
                ImportFormatReader.setIfNecessary(bibtexEntry, "journal", stringArray[7]);
                ImportFormatReader.setIfNecessary(bibtexEntry, "volume", stringArray[9]);
                ImportFormatReader.setIfNecessary(bibtexEntry, "number", stringArray[10]);
                String[] stringArray2 = stringArray[12].split(" ");
                ImportFormatReader.setIfNecessary(bibtexEntry, "year", stringArray2[stringArray2.length - 1]);
                if (stringArray2.length > 1) {
                    if (stringArray2[0].endsWith(",")) {
                        stringArray2[0] = stringArray2[0].substring(0, stringArray2[0].length() - 1);
                    }
                    ImportFormatReader.setIfNecessary(bibtexEntry, "month", stringArray2[0]);
                }
                ImportFormatReader.setIfNecessary(bibtexEntry, "pages", stringArray[13].replaceAll("-", "--"));
                ImportFormatReader.setIfNecessary(bibtexEntry, "url", stringArray[14]);
                ImportFormatReader.setIfNecessary(bibtexEntry, "issn", stringArray[15]);
                ImportFormatReader.setIfNecessary(bibtexEntry, "abstract", stringArray[16]);
                ImportFormatReader.setIfNecessary(bibtexEntry, "keywords", stringArray[17]);
                ImportFormatReader.setIfNecessary(bibtexEntry, "copyright", stringArray[21]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            arrayList.add(bibtexEntry);
        }
        return arrayList;
    }
}

